# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[str],
                 access_config: Optional[pulumi.Input['ProviderAccessConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] protocol: Specifies the protocol of the identity provider.
               Valid values are *saml* and *oidc*.
               Changing this creates a new resource.
        :param pulumi.Input['ProviderAccessConfigArgs'] access_config: Specifies the description of the identity provider.
               This field is required only if the protocol is set to *oidc*.
        :param pulumi.Input[str] description: Specifies the description of the identity provider.
        :param pulumi.Input[str] metadata: Specifies the metadata of the IDP(Identity Provider) server.
               To obtain the metadata file of your enterprise IDP, contact the enterprise administrator.
               This field is used to import a metadata file to IAM to implement federated identity authentication.
               This field is required only if the protocol is set to *saml*.
               The maximum length is 30,000 characters and it stores in the state with SHA1 algorithm.
        :param pulumi.Input[str] name: Specifies the name of the identity provider to be registered.
               The maximum length is 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
               The name is unique, it is recommended to include domain name information.
               Changing this creates a new resource.
        :param pulumi.Input[bool] status: Enabled status for the identity provider. Defaults to true.
        """
        pulumi.set(__self__, "protocol", protocol)
        if access_config is not None:
            pulumi.set(__self__, "access_config", access_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Specifies the protocol of the identity provider.
        Valid values are *saml* and *oidc*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> Optional[pulumi.Input['ProviderAccessConfigArgs']]:
        """
        Specifies the description of the identity provider.
        This field is required only if the protocol is set to *oidc*.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: Optional[pulumi.Input['ProviderAccessConfigArgs']]):
        pulumi.set(self, "access_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the identity provider.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the metadata of the IDP(Identity Provider) server.
        To obtain the metadata file of your enterprise IDP, contact the enterprise administrator.
        This field is used to import a metadata file to IAM to implement federated identity authentication.
        This field is required only if the protocol is set to *saml*.
        The maximum length is 30,000 characters and it stores in the state with SHA1 algorithm.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the identity provider to be registered.
        The maximum length is 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
        The name is unique, it is recommended to include domain name information.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled status for the identity provider. Defaults to true.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ProviderState:
    def __init__(__self__, *,
                 access_config: Optional[pulumi.Input['ProviderAccessConfigArgs']] = None,
                 conversion_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 login_link: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 sso_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Provider resources.
        :param pulumi.Input['ProviderAccessConfigArgs'] access_config: Specifies the description of the identity provider.
               This field is required only if the protocol is set to *oidc*.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleArgs']]] conversion_rules: The identity conversion rules of the identity provider.
               The object structure is documented below
        :param pulumi.Input[str] description: Specifies the description of the identity provider.
        :param pulumi.Input[str] login_link: The login link of the identity provider.
        :param pulumi.Input[str] metadata: Specifies the metadata of the IDP(Identity Provider) server.
               To obtain the metadata file of your enterprise IDP, contact the enterprise administrator.
               This field is used to import a metadata file to IAM to implement federated identity authentication.
               This field is required only if the protocol is set to *saml*.
               The maximum length is 30,000 characters and it stores in the state with SHA1 algorithm.
        :param pulumi.Input[str] name: Specifies the name of the identity provider to be registered.
               The maximum length is 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
               The name is unique, it is recommended to include domain name information.
               Changing this creates a new resource.
        :param pulumi.Input[str] protocol: Specifies the protocol of the identity provider.
               Valid values are *saml* and *oidc*.
               Changing this creates a new resource.
        :param pulumi.Input[str] sso_type: The single sign-on type of the identity provider.
        :param pulumi.Input[bool] status: Enabled status for the identity provider. Defaults to true.
        """
        if access_config is not None:
            pulumi.set(__self__, "access_config", access_config)
        if conversion_rules is not None:
            pulumi.set(__self__, "conversion_rules", conversion_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if login_link is not None:
            pulumi.set(__self__, "login_link", login_link)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if sso_type is not None:
            pulumi.set(__self__, "sso_type", sso_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> Optional[pulumi.Input['ProviderAccessConfigArgs']]:
        """
        Specifies the description of the identity provider.
        This field is required only if the protocol is set to *oidc*.
        """
        return pulumi.get(self, "access_config")

    @access_config.setter
    def access_config(self, value: Optional[pulumi.Input['ProviderAccessConfigArgs']]):
        pulumi.set(self, "access_config", value)

    @property
    @pulumi.getter(name="conversionRules")
    def conversion_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleArgs']]]]:
        """
        The identity conversion rules of the identity provider.
        The object structure is documented below
        """
        return pulumi.get(self, "conversion_rules")

    @conversion_rules.setter
    def conversion_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderConversionRuleArgs']]]]):
        pulumi.set(self, "conversion_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the identity provider.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="loginLink")
    def login_link(self) -> Optional[pulumi.Input[str]]:
        """
        The login link of the identity provider.
        """
        return pulumi.get(self, "login_link")

    @login_link.setter
    def login_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_link", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the metadata of the IDP(Identity Provider) server.
        To obtain the metadata file of your enterprise IDP, contact the enterprise administrator.
        This field is used to import a metadata file to IAM to implement federated identity authentication.
        This field is required only if the protocol is set to *saml*.
        The maximum length is 30,000 characters and it stores in the state with SHA1 algorithm.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the identity provider to be registered.
        The maximum length is 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
        The name is unique, it is recommended to include domain name information.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol of the identity provider.
        Valid values are *saml* and *oidc*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="ssoType")
    def sso_type(self) -> Optional[pulumi.Input[str]]:
        """
        The single sign-on type of the identity provider.
        """
        return pulumi.get(self, "sso_type")

    @sso_type.setter
    def sso_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sso_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled status for the identity provider. Defaults to true.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "status", value)


class Provider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_config: Optional[pulumi.Input[pulumi.InputType['ProviderAccessConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Manages the identity providers within HuaweiCloud IAM service.

        > **NOTE:** You can create up to 10 identity providers.

        ## Example Usage
        ### Create a SAML protocol provider

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        provider1 = huaweicloud.iam.Provider("provider1", protocol="saml")
        ```
        ### Create a OpenID Connect protocol provider

        ```python
        import pulumi
        import json
        import pulumi_huaweicloud as huaweicloud

        provider2 = huaweicloud.iam.Provider("provider2",
            protocol="oidc",
            access_config=huaweicloud.iam.ProviderAccessConfigArgs(
                access_type="program_console",
                provider_url="https://accounts.example.com",
                client_id="your_client_id",
                authorization_endpoint="https://accounts.example.com/o/oauth2/v2/auth",
                scopes=["openid"],
                signing_key=json.dumps({
                    "keys": [{
                        "alg": "RS256",
                        "e": "AQAB",
                        "kid": "...",
                        "kty": "RSA",
                        "n": "...",
                        "use": "sig",
                    }],
                }),
            ))
        ```

        <!--markdownlint-disable MD033-->

        ## Import

        Identity provider can be imported using the `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iam/provider:Provider provider_1 example_com_provider_saml
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ProviderAccessConfigArgs']] access_config: Specifies the description of the identity provider.
               This field is required only if the protocol is set to *oidc*.
        :param pulumi.Input[str] description: Specifies the description of the identity provider.
        :param pulumi.Input[str] metadata: Specifies the metadata of the IDP(Identity Provider) server.
               To obtain the metadata file of your enterprise IDP, contact the enterprise administrator.
               This field is used to import a metadata file to IAM to implement federated identity authentication.
               This field is required only if the protocol is set to *saml*.
               The maximum length is 30,000 characters and it stores in the state with SHA1 algorithm.
        :param pulumi.Input[str] name: Specifies the name of the identity provider to be registered.
               The maximum length is 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
               The name is unique, it is recommended to include domain name information.
               Changing this creates a new resource.
        :param pulumi.Input[str] protocol: Specifies the protocol of the identity provider.
               Valid values are *saml* and *oidc*.
               Changing this creates a new resource.
        :param pulumi.Input[bool] status: Enabled status for the identity provider. Defaults to true.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the identity providers within HuaweiCloud IAM service.

        > **NOTE:** You can create up to 10 identity providers.

        ## Example Usage
        ### Create a SAML protocol provider

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        provider1 = huaweicloud.iam.Provider("provider1", protocol="saml")
        ```
        ### Create a OpenID Connect protocol provider

        ```python
        import pulumi
        import json
        import pulumi_huaweicloud as huaweicloud

        provider2 = huaweicloud.iam.Provider("provider2",
            protocol="oidc",
            access_config=huaweicloud.iam.ProviderAccessConfigArgs(
                access_type="program_console",
                provider_url="https://accounts.example.com",
                client_id="your_client_id",
                authorization_endpoint="https://accounts.example.com/o/oauth2/v2/auth",
                scopes=["openid"],
                signing_key=json.dumps({
                    "keys": [{
                        "alg": "RS256",
                        "e": "AQAB",
                        "kid": "...",
                        "kty": "RSA",
                        "n": "...",
                        "use": "sig",
                    }],
                }),
            ))
        ```

        <!--markdownlint-disable MD033-->

        ## Import

        Identity provider can be imported using the `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iam/provider:Provider provider_1 example_com_provider_saml
        ```

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_config: Optional[pulumi.Input[pulumi.InputType['ProviderAccessConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["access_config"] = access_config
            __props__.__dict__["description"] = description
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["status"] = status
            __props__.__dict__["conversion_rules"] = None
            __props__.__dict__["login_link"] = None
            __props__.__dict__["sso_type"] = None
        super(Provider, __self__).__init__(
            'huaweicloud:Iam/provider:Provider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_config: Optional[pulumi.Input[pulumi.InputType['ProviderAccessConfigArgs']]] = None,
            conversion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderConversionRuleArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            login_link: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            sso_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[bool]] = None) -> 'Provider':
        """
        Get an existing Provider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ProviderAccessConfigArgs']] access_config: Specifies the description of the identity provider.
               This field is required only if the protocol is set to *oidc*.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderConversionRuleArgs']]]] conversion_rules: The identity conversion rules of the identity provider.
               The object structure is documented below
        :param pulumi.Input[str] description: Specifies the description of the identity provider.
        :param pulumi.Input[str] login_link: The login link of the identity provider.
        :param pulumi.Input[str] metadata: Specifies the metadata of the IDP(Identity Provider) server.
               To obtain the metadata file of your enterprise IDP, contact the enterprise administrator.
               This field is used to import a metadata file to IAM to implement federated identity authentication.
               This field is required only if the protocol is set to *saml*.
               The maximum length is 30,000 characters and it stores in the state with SHA1 algorithm.
        :param pulumi.Input[str] name: Specifies the name of the identity provider to be registered.
               The maximum length is 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
               The name is unique, it is recommended to include domain name information.
               Changing this creates a new resource.
        :param pulumi.Input[str] protocol: Specifies the protocol of the identity provider.
               Valid values are *saml* and *oidc*.
               Changing this creates a new resource.
        :param pulumi.Input[str] sso_type: The single sign-on type of the identity provider.
        :param pulumi.Input[bool] status: Enabled status for the identity provider. Defaults to true.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProviderState.__new__(_ProviderState)

        __props__.__dict__["access_config"] = access_config
        __props__.__dict__["conversion_rules"] = conversion_rules
        __props__.__dict__["description"] = description
        __props__.__dict__["login_link"] = login_link
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["sso_type"] = sso_type
        __props__.__dict__["status"] = status
        return Provider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> pulumi.Output[Optional['outputs.ProviderAccessConfig']]:
        """
        Specifies the description of the identity provider.
        This field is required only if the protocol is set to *oidc*.
        """
        return pulumi.get(self, "access_config")

    @property
    @pulumi.getter(name="conversionRules")
    def conversion_rules(self) -> pulumi.Output[Sequence['outputs.ProviderConversionRule']]:
        """
        The identity conversion rules of the identity provider.
        The object structure is documented below
        """
        return pulumi.get(self, "conversion_rules")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the identity provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="loginLink")
    def login_link(self) -> pulumi.Output[str]:
        """
        The login link of the identity provider.
        """
        return pulumi.get(self, "login_link")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the metadata of the IDP(Identity Provider) server.
        To obtain the metadata file of your enterprise IDP, contact the enterprise administrator.
        This field is used to import a metadata file to IAM to implement federated identity authentication.
        This field is required only if the protocol is set to *saml*.
        The maximum length is 30,000 characters and it stores in the state with SHA1 algorithm.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the identity provider to be registered.
        The maximum length is 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
        The name is unique, it is recommended to include domain name information.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Specifies the protocol of the identity provider.
        Valid values are *saml* and *oidc*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="ssoType")
    def sso_type(self) -> pulumi.Output[str]:
        """
        The single sign-on type of the identity provider.
        """
        return pulumi.get(self, "sso_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[bool]]:
        """
        Enabled status for the identity provider. Defaults to true.
        """
        return pulumi.get(self, "status")

