# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'OpengaussInstanceBackupStrategy',
    'OpengaussInstanceDatastore',
    'OpengaussInstanceHa',
    'OpengaussInstanceNode',
    'OpengaussInstanceVolume',
    'GetOpengaussInstanceBackupStrategyResult',
    'GetOpengaussInstanceDatastoreResult',
    'GetOpengaussInstanceHaResult',
    'GetOpengaussInstanceNodeResult',
    'GetOpengaussInstanceVolumeResult',
    'GetOpengaussInstancesInstanceResult',
    'GetOpengaussInstancesInstanceBackupStrategyResult',
    'GetOpengaussInstancesInstanceDatastoreResult',
    'GetOpengaussInstancesInstanceHaResult',
    'GetOpengaussInstancesInstanceNodeResult',
    'GetOpengaussInstancesInstanceVolumeResult',
]

@pulumi.output_type
class OpengaussInstanceBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpengaussInstanceBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpengaussInstanceBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpengaussInstanceBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 keep_days: Optional[int] = None):
        """
        :param str start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the **hh:mm-HH:MM** format. The current time is in the UTC format. The
               **HH** value must be `1` greater than the **hh** value. The values of mm and MM must be the same and must be set to
               **00**. Example value: **08:00-09:00**, **23:00-00:00**.
        :param int keep_days: Specifies the number of days to retain the generated backup files. The value ranges from
               `0` to `732`. If this parameter is set to `0`, the automated backup policy is not set.
               If this parameter is not transferred, the automated backup policy is enabled by default.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the **hh:mm-HH:MM** format. The current time is in the UTC format. The
        **HH** value must be `1` greater than the **hh** value. The values of mm and MM must be the same and must be set to
        **00**. Example value: **08:00-09:00**, **23:00-00:00**.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[int]:
        """
        Specifies the number of days to retain the generated backup files. The value ranges from
        `0` to `732`. If this parameter is set to `0`, the automated backup policy is not set.
        If this parameter is not transferred, the automated backup policy is enabled by default.
        """
        return pulumi.get(self, "keep_days")


@pulumi.output_type
class OpengaussInstanceDatastore(dict):
    def __init__(__self__, *,
                 engine: str,
                 version: Optional[str] = None):
        """
        :param str engine: Specifies the database engine. Only **GaussDB(for openGauss)** is supported
               now. Changing this parameter will create a new resource.
        :param str version: Specifies the database version. Defaults to the latest version. Please
               reference to the API docs for valid options. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "engine", engine)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Specifies the database engine. Only **GaussDB(for openGauss)** is supported
        now. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the database version. Defaults to the latest version. Please
        reference to the API docs for valid options. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class OpengaussInstanceHa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationMode":
            suggest = "replication_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpengaussInstanceHa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpengaussInstanceHa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpengaussInstanceHa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: str,
                 replication_mode: str,
                 consistency: Optional[str] = None):
        """
        :param str mode: Specifies the database mode.
               The valid values are **enterprise** and **centralization_standard**.
               Changing this parameter will create a new resource.
        :param str replication_mode: Specifies the database replication mode.
               Only **sync** is supported now. Changing this parameter will create a new resource.
        :param str consistency: Specifies the database consistency mode.
               The valid values are **strong** and **eventual**, not case sensitive.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "replication_mode", replication_mode)
        if consistency is not None:
            pulumi.set(__self__, "consistency", consistency)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Specifies the database mode.
        The valid values are **enterprise** and **centralization_standard**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> str:
        """
        Specifies the database replication mode.
        Only **sync** is supported now. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "replication_mode")

    @property
    @pulumi.getter
    def consistency(self) -> Optional[str]:
        """
        Specifies the database consistency mode.
        The valid values are **strong** and **eventual**, not case sensitive.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "consistency")


@pulumi.output_type
class OpengaussInstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpengaussInstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpengaussInstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpengaussInstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 role: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str availability_zone: Specifies the availability zone information, can be three same or
               different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        :param str id: Indicates the node ID.
        :param str name: Specifies the instance name, which can be the same as an existing instance name.
               The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param str role: Indicates the node role.
               + **master**.
               + **slave**.
        :param str status: Indicates the node status.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        Specifies the availability zone information, can be three same or
        different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name.
        The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Indicates the node role.
        + **master**.
        + **slave**.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class OpengaussInstanceVolume(dict):
    def __init__(__self__, *,
                 size: int,
                 type: str):
        """
        :param int size: Specifies the volume size (in gigabytes). The valid value is range form `40` to `4,000`.
        :param str type: Specifies the volume type. Only **ULTRAHIGH** is supported now.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size (in gigabytes). The valid value is range form `40` to `4,000`.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the volume type. Only **ULTRAHIGH** is supported now.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetOpengaussInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: int,
                 start_time: str):
        """
        :param int keep_days: Indicates the number of days to retain the generated
        :param str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> int:
        """
        Indicates the number of days to retain the generated
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetOpengaussInstanceDatastoreResult(dict):
    def __init__(__self__, *,
                 engine: str,
                 version: str):
        """
        :param str engine: Indicates the database engine.
        :param str version: Indicates the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Indicates the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetOpengaussInstanceHaResult(dict):
    def __init__(__self__, *,
                 replication_mode: str):
        """
        :param str replication_mode: Indicates the replication mode.
        """
        pulumi.set(__self__, "replication_mode", replication_mode)

    @property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> str:
        """
        Indicates the replication mode.
        """
        return pulumi.get(self, "replication_mode")


@pulumi.output_type
class GetOpengaussInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 id: str,
                 name: str,
                 role: str,
                 status: str):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param str role: Indicates whether the node support reduce.
        :param str status: Indicates the node status.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Indicates whether the node support reduce.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetOpengaussInstanceVolumeResult(dict):
    def __init__(__self__, *,
                 size: int,
                 type: str):
        """
        :param int size: Indicates the volume size.
        :param str type: Indicates the volume type.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Indicates the volume size.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the volume type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetOpengaussInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 backup_strategies: Sequence['outputs.GetOpengaussInstancesInstanceBackupStrategyResult'],
                 coordinator_num: int,
                 datastores: Sequence['outputs.GetOpengaussInstancesInstanceDatastoreResult'],
                 db_user_name: str,
                 enterprise_project_id: str,
                 flavor: str,
                 has: Sequence['outputs.GetOpengaussInstancesInstanceHaResult'],
                 id: str,
                 maintenance_window: str,
                 name: str,
                 nodes: Sequence['outputs.GetOpengaussInstancesInstanceNodeResult'],
                 port: int,
                 private_ips: Sequence[str],
                 region: str,
                 security_group_id: str,
                 sharding_num: int,
                 status: str,
                 subnet_id: str,
                 switch_strategy: str,
                 time_zone: str,
                 type: str,
                 volumes: Sequence['outputs.GetOpengaussInstancesInstanceVolumeResult'],
                 vpc_id: str):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param Sequence['GetOpengaussInstancesInstanceBackupStrategyArgs'] backup_strategies: Indicates the advanced backup policy. Structure is documented below.
        :param int coordinator_num: Indicates the count of coordinator node.
        :param Sequence['GetOpengaussInstancesInstanceDatastoreArgs'] datastores: Indicates the database information. Structure is documented below.
        :param str db_user_name: Indicates the default username.
        :param str enterprise_project_id: Indicates the enterprise project id.
        :param str flavor: Indicates the instance specifications.
        :param Sequence['GetOpengaussInstancesInstanceHaArgs'] has: Indicates the instance ha information. Structure is documented below.
        :param str id: Indicates the node ID.
        :param str maintenance_window: Indicates the maintenance window.
        :param str name: Specifies the name of the instance.
        :param Sequence['GetOpengaussInstancesInstanceNodeArgs'] nodes: Indicates the instance nodes information. Structure is documented below.
        :param int port: Indicates the database port.
        :param Sequence[str] private_ips: Indicates the list of private IP address of the nodes.
        :param str region: The region in which to obtain the instance. If omitted, the provider-level region will
               be used.
        :param str security_group_id: Indicates the security group ID.
        :param int sharding_num: Indicates the sharding num.
        :param str status: Indicates the node status.
        :param str subnet_id: Specifies the network ID of a subnet.
        :param str switch_strategy: Indicates the switch strategy.
        :param str time_zone: Indicates the default username.
        :param str type: Indicates the volume type.
        :param Sequence['GetOpengaussInstancesInstanceVolumeArgs'] volumes: Indicates the volume information. Structure is documented below.
        :param str vpc_id: Specifies the VPC ID.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "backup_strategies", backup_strategies)
        pulumi.set(__self__, "coordinator_num", coordinator_num)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "db_user_name", db_user_name)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "has", has)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "sharding_num", sharding_num)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "switch_strategy", switch_strategy)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupStrategies")
    def backup_strategies(self) -> Sequence['outputs.GetOpengaussInstancesInstanceBackupStrategyResult']:
        """
        Indicates the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategies")

    @property
    @pulumi.getter(name="coordinatorNum")
    def coordinator_num(self) -> int:
        """
        Indicates the count of coordinator node.
        """
        return pulumi.get(self, "coordinator_num")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetOpengaussInstancesInstanceDatastoreResult']:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> str:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Indicates the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Indicates the instance specifications.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def has(self) -> Sequence['outputs.GetOpengaussInstancesInstanceHaResult']:
        """
        Indicates the instance ha information. Structure is documented below.
        """
        return pulumi.get(self, "has")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> str:
        """
        Indicates the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetOpengaussInstancesInstanceNodeResult']:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[str]:
        """
        Indicates the list of private IP address of the nodes.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to obtain the instance. If omitted, the provider-level region will
        be used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Indicates the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="shardingNum")
    def sharding_num(self) -> int:
        """
        Indicates the sharding num.
        """
        return pulumi.get(self, "sharding_num")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Specifies the network ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="switchStrategy")
    def switch_strategy(self) -> str:
        """
        Indicates the switch strategy.
        """
        return pulumi.get(self, "switch_strategy")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the volume type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetOpengaussInstancesInstanceVolumeResult']:
        """
        Indicates the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Specifies the VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetOpengaussInstancesInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: int,
                 start_time: str):
        """
        :param int keep_days: Indicates the number of days to retain the generated
        :param str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> int:
        """
        Indicates the number of days to retain the generated
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetOpengaussInstancesInstanceDatastoreResult(dict):
    def __init__(__self__, *,
                 engine: str,
                 version: str):
        """
        :param str engine: Indicates the database engine.
        :param str version: Indicates the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Indicates the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetOpengaussInstancesInstanceHaResult(dict):
    def __init__(__self__, *,
                 replication_mode: str):
        """
        :param str replication_mode: Indicates the replication mode.
        """
        pulumi.set(__self__, "replication_mode", replication_mode)

    @property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> str:
        """
        Indicates the replication mode.
        """
        return pulumi.get(self, "replication_mode")


@pulumi.output_type
class GetOpengaussInstancesInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 id: str,
                 name: str,
                 role: str,
                 status: str):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param str role: Indicates whether the node support reduce.
        :param str status: Indicates the node status.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Indicates whether the node support reduce.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetOpengaussInstancesInstanceVolumeResult(dict):
    def __init__(__self__, *,
                 size: int,
                 type: str):
        """
        :param int size: Indicates the volume size.
        :param str type: Indicates the volume type.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Indicates the volume size.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the volume type.
        """
        return pulumi.get(self, "type")


