# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNosqlFlavorsResult',
    'AwaitableGetNosqlFlavorsResult',
    'get_nosql_flavors',
    'get_nosql_flavors_output',
]

@pulumi.output_type
class GetNosqlFlavorsResult:
    """
    A collection of values returned by getNosqlFlavors.
    """
    def __init__(__self__, availability_zone=None, engine=None, engine_version=None, flavors=None, id=None, memory=None, region=None, vcpus=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def engine(self) -> Optional[str]:
        """
        The type of the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[str]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetNosqlFlavorsFlavorResult']:
        """
        The information of the GaussDB specifications. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memory(self) -> Optional[int]:
        """
        The memory size, in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[int]:
        """
        The number of vCPUs.
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetNosqlFlavorsResult(GetNosqlFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNosqlFlavorsResult(
            availability_zone=self.availability_zone,
            engine=self.engine,
            engine_version=self.engine_version,
            flavors=self.flavors,
            id=self.id,
            memory=self.memory,
            region=self.region,
            vcpus=self.vcpus)


def get_nosql_flavors(availability_zone: Optional[str] = None,
                      engine: Optional[str] = None,
                      engine_version: Optional[str] = None,
                      memory: Optional[int] = None,
                      region: Optional[str] = None,
                      vcpus: Optional[int] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNosqlFlavorsResult:
    """
    Use this data source to get available HuaweiCloud GaussDB (for NoSQL) flavors.
    This is an alternative to `_gauss_d_bfor_no_sq_l.get_cassandra_flavors`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.GaussDBforNoSQL.get_nosql_flavors(memory=8,
        vcpus=4)
    ```


    :param str availability_zone: Specifies the availability zone (AZ) of the GaussDB specifications.
    :param str engine: Specifies the type of the database engine. The valid values are as follows:
           + **cassandra**: The default value and means to query GaussDB (for Cassandra) instance specifications.
           + **redis**: Means to query GaussDB (for Redis) instance specifications.
           + **mongodb**: Means to query GaussDB (for Mongo) instance specifications.
           + **influxdb**: Means to query GaussDB (for Influx) instance specifications.
    :param str engine_version: Specifies the version of the database engine.
    :param int memory: Specifies the memory size in gigabytes (GB).
    :param str region: Specifies the region in which to obtain the GaussDB specifications.
           If omitted, the provider-level region will be used.
    :param int vcpus: Specifies the number of vCPUs.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:GaussDBforNoSQL/getNosqlFlavors:getNosqlFlavors', __args__, opts=opts, typ=GetNosqlFlavorsResult).value

    return AwaitableGetNosqlFlavorsResult(
        availability_zone=__ret__.availability_zone,
        engine=__ret__.engine,
        engine_version=__ret__.engine_version,
        flavors=__ret__.flavors,
        id=__ret__.id,
        memory=__ret__.memory,
        region=__ret__.region,
        vcpus=__ret__.vcpus)


@_utilities.lift_output_func(get_nosql_flavors)
def get_nosql_flavors_output(availability_zone: Optional[pulumi.Input[Optional[str]]] = None,
                             engine: Optional[pulumi.Input[Optional[str]]] = None,
                             engine_version: Optional[pulumi.Input[Optional[str]]] = None,
                             memory: Optional[pulumi.Input[Optional[int]]] = None,
                             region: Optional[pulumi.Input[Optional[str]]] = None,
                             vcpus: Optional[pulumi.Input[Optional[int]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNosqlFlavorsResult]:
    """
    Use this data source to get available HuaweiCloud GaussDB (for NoSQL) flavors.
    This is an alternative to `_gauss_d_bfor_no_sq_l.get_cassandra_flavors`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.GaussDBforNoSQL.get_nosql_flavors(memory=8,
        vcpus=4)
    ```


    :param str availability_zone: Specifies the availability zone (AZ) of the GaussDB specifications.
    :param str engine: Specifies the type of the database engine. The valid values are as follows:
           + **cassandra**: The default value and means to query GaussDB (for Cassandra) instance specifications.
           + **redis**: Means to query GaussDB (for Redis) instance specifications.
           + **mongodb**: Means to query GaussDB (for Mongo) instance specifications.
           + **influxdb**: Means to query GaussDB (for Influx) instance specifications.
    :param str engine_version: Specifies the version of the database engine.
    :param int memory: Specifies the memory size in gigabytes (GB).
    :param str region: Specifies the region in which to obtain the GaussDB specifications.
           If omitted, the provider-level region will be used.
    :param int vcpus: Specifies the number of vCPUs.
    """
    ...
