# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDependenciesResult',
    'AwaitableGetDependenciesResult',
    'get_dependencies',
    'get_dependencies_output',
]

@pulumi.output_type
class GetDependenciesResult:
    """
    A collection of values returned by getDependencies.
    """
    def __init__(__self__, id=None, name=None, packages=None, region=None, runtime=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if runtime and not isinstance(runtime, str):
            raise TypeError("Expected argument 'runtime' to be a str")
        pulumi.set(__self__, "runtime", runtime)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Dependent package name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def packages(self) -> Sequence['outputs.GetDependenciesPackageResult']:
        """
        All dependent packages that match.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtime(self) -> Optional[str]:
        """
        Dependent package runtime.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


class AwaitableGetDependenciesResult(GetDependenciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDependenciesResult(
            id=self.id,
            name=self.name,
            packages=self.packages,
            region=self.region,
            runtime=self.runtime,
            type=self.type)


def get_dependencies(name: Optional[str] = None,
                     region: Optional[str] = None,
                     runtime: Optional[str] = None,
                     type: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDependenciesResult:
    """
    Use this data source to filter dependent packages of FGS from HuaweiCloud.

    ## Example Usage
    ### Obtain all public dependent packages

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.FunctionGraph.get_dependencies()
    ```
    ### Obtain specific public dependent package by name

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.FunctionGraph.get_dependencies(name="obssdk-3.0.2",
        type="public")
    ```
    ### Obtain all public Python2.7 dependent packages

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.FunctionGraph.get_dependencies(runtime="Python2.7",
        type="public")
    ```


    :param str name: Specifies the dependent package runtime to match.
    :param str region: Specifies the region in which to obtain the dependent packages. If omitted, the
           provider-level region will be used.
    :param str runtime: Specifies the dependent package runtime to match. Valid values: **Java8**,
           **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**, **Python3.6**, **Go1.8**,
           **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and **PHP7.3**.
    :param str type: Specifies the dependent package type to match. Valid values: **public** and **private**.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['runtime'] = runtime
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:FunctionGraph/getDependencies:getDependencies', __args__, opts=opts, typ=GetDependenciesResult).value

    return AwaitableGetDependenciesResult(
        id=__ret__.id,
        name=__ret__.name,
        packages=__ret__.packages,
        region=__ret__.region,
        runtime=__ret__.runtime,
        type=__ret__.type)


@_utilities.lift_output_func(get_dependencies)
def get_dependencies_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                            region: Optional[pulumi.Input[Optional[str]]] = None,
                            runtime: Optional[pulumi.Input[Optional[str]]] = None,
                            type: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDependenciesResult]:
    """
    Use this data source to filter dependent packages of FGS from HuaweiCloud.

    ## Example Usage
    ### Obtain all public dependent packages

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.FunctionGraph.get_dependencies()
    ```
    ### Obtain specific public dependent package by name

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.FunctionGraph.get_dependencies(name="obssdk-3.0.2",
        type="public")
    ```
    ### Obtain all public Python2.7 dependent packages

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.FunctionGraph.get_dependencies(runtime="Python2.7",
        type="public")
    ```


    :param str name: Specifies the dependent package runtime to match.
    :param str region: Specifies the region in which to obtain the dependent packages. If omitted, the
           provider-level region will be used.
    :param str runtime: Specifies the dependent package runtime to match. Valid values: **Java8**,
           **Node.js6.10**, **Node.js8.10**, **Node.js10.16**, **Node.js12.13**, **Python2.7**, **Python3.6**, **Go1.8**,
           **Go1.x**, **C#(.NET Core 2.0)**, **C#(.NET Core 2.1)**, **C#(.NET Core 3.1)** and **PHP7.3**.
    :param str type: Specifies the dependent package type to match. Valid values: **public** and **private**.
    """
    ...
