# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 memory_size: pulumi.Input[int],
                 runtime: pulumi.Input[str],
                 timeout: pulumi.Input[int],
                 agency: Optional[pulumi.Input[str]] = None,
                 app: Optional[pulumi.Input[str]] = None,
                 app_agency: Optional[pulumi.Input[str]] = None,
                 code_filename: Optional[pulumi.Input[str]] = None,
                 code_type: Optional[pulumi.Input[str]] = None,
                 code_url: Optional[pulumi.Input[str]] = None,
                 custom_image: Optional[pulumi.Input['FunctionCustomImageArgs']] = None,
                 depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_user_data: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 func_code: Optional[pulumi.Input[str]] = None,
                 func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]] = None,
                 functiongraph_version: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 initializer_handler: Optional[pulumi.Input[str]] = None,
                 initializer_timeout: Optional[pulumi.Input[int]] = None,
                 mount_user_group_id: Optional[pulumi.Input[int]] = None,
                 mount_user_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 xrole: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[int] memory_size: Specifies the memory size(MB) allocated to the function.
        :param pulumi.Input[str] runtime: Specifies the environment for executing the function.
               If the function is created using a SWR image, set this parameter to `Custom Image`.
               Changing this will create a new resource.
        :param pulumi.Input[int] timeout: Specifies the timeout interval of the function, ranges from 3s to 900s.
        :param pulumi.Input[str] agency: Specifies the agency. This parameter is mandatory if the function needs to access other
               cloud services.
        :param pulumi.Input[str] app: Specifies the group to which the function belongs.
        :param pulumi.Input[str] app_agency: Specifies An execution agency enables you to obtain a token or an AK/SK for
               accessing other cloud services.
        :param pulumi.Input[str] code_filename: Specifies the name of a function file, This field is mandatory only when coe_type
               is set to jar or zip.
        :param pulumi.Input[str] code_type: Specifies the function code type, which can be:
               + **inline**: inline code.
               + **zip**: ZIP file.
               + **jar**: JAR file or java functions.
               + **obs**: function code stored in an OBS bucket.
        :param pulumi.Input[str] code_url: Specifies the code url. This parameter is mandatory when code_type is set to obs.
        :param pulumi.Input['FunctionCustomImageArgs'] custom_image: Specifies the custom image configuration for creating function.
               The object structure is documented below.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] depend_lists: Specifies the ID list of the dependencies.
        :param pulumi.Input[str] description: Specifies the description of the function.
        :param pulumi.Input[str] encrypted_user_data: Specifies the key/value information defined to be encrypted for the
               function. The format is the same as `user_data`.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the function.
               Changing this will create a new resource.
        :param pulumi.Input[str] func_code: Specifies the function code. When code_type is set to inline, zip, or jar, this
               parameter is mandatory, and the code can be encoded using Base64 or just with the text code.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]] func_mounts: Specifies the file system list. The `func_mounts` object structure is documented
               below.
        :param pulumi.Input[str] functiongraph_version: Specifies the FunctionGraph version, defaults to **v1**.
               + **v1**: Hosts event-driven functions in a serverless context.
               + **v2**: Next-generation function hosting service powered by Huawei YuanRong architecture.
        :param pulumi.Input[str] handler: Specifies the entry point of the function.
        :param pulumi.Input[str] initializer_handler: Specifies the initializer of the function.
        :param pulumi.Input[int] initializer_timeout: Specifies the maximum duration the function can be initialized. Value range:
               1s to 300s.
        :param pulumi.Input[int] mount_user_group_id: Specifies the user group ID, a non-0 integer from –1 to 65534. Default to
               -1.
        :param pulumi.Input[int] mount_user_id: Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[str] name: Specifies the name of the function.
               Changing this will create a new resource.
        :param pulumi.Input[str] network_id: Specifies the network ID of subnet.
        :param pulumi.Input[str] region: Specifies the region in which to create the Function resource. If omitted, the
               provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of VPC.
        """
        pulumi.set(__self__, "memory_size", memory_size)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "timeout", timeout)
        if agency is not None:
            pulumi.set(__self__, "agency", agency)
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_agency is not None:
            pulumi.set(__self__, "app_agency", app_agency)
        if code_filename is not None:
            pulumi.set(__self__, "code_filename", code_filename)
        if code_type is not None:
            pulumi.set(__self__, "code_type", code_type)
        if code_url is not None:
            pulumi.set(__self__, "code_url", code_url)
        if custom_image is not None:
            pulumi.set(__self__, "custom_image", custom_image)
        if depend_lists is not None:
            pulumi.set(__self__, "depend_lists", depend_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_user_data is not None:
            pulumi.set(__self__, "encrypted_user_data", encrypted_user_data)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if func_code is not None:
            pulumi.set(__self__, "func_code", func_code)
        if func_mounts is not None:
            pulumi.set(__self__, "func_mounts", func_mounts)
        if functiongraph_version is not None:
            pulumi.set(__self__, "functiongraph_version", functiongraph_version)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if initializer_handler is not None:
            pulumi.set(__self__, "initializer_handler", initializer_handler)
        if initializer_timeout is not None:
            pulumi.set(__self__, "initializer_timeout", initializer_timeout)
        if mount_user_group_id is not None:
            pulumi.set(__self__, "mount_user_group_id", mount_user_group_id)
        if mount_user_id is not None:
            pulumi.set(__self__, "mount_user_id", mount_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if package is not None:
            warnings.warn("""use app instead""", DeprecationWarning)
            pulumi.log.warn("""package is deprecated: use app instead""")
        if package is not None:
            pulumi.set(__self__, "package", package)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if xrole is not None:
            warnings.warn("""use agency instead""", DeprecationWarning)
            pulumi.log.warn("""xrole is deprecated: use agency instead""")
        if xrole is not None:
            pulumi.set(__self__, "xrole", xrole)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Input[int]:
        """
        Specifies the memory size(MB) allocated to the function.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[str]:
        """
        Specifies the environment for executing the function.
        If the function is created using a SWR image, set this parameter to `Custom Image`.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[int]:
        """
        Specifies the timeout interval of the function, ranges from 3s to 900s.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[int]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def agency(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the agency. This parameter is mandatory if the function needs to access other
        cloud services.
        """
        return pulumi.get(self, "agency")

    @agency.setter
    def agency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agency", value)

    @property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the group to which the function belongs.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter(name="appAgency")
    def app_agency(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies An execution agency enables you to obtain a token or an AK/SK for
        accessing other cloud services.
        """
        return pulumi.get(self, "app_agency")

    @app_agency.setter
    def app_agency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_agency", value)

    @property
    @pulumi.getter(name="codeFilename")
    def code_filename(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a function file, This field is mandatory only when coe_type
        is set to jar or zip.
        """
        return pulumi.get(self, "code_filename")

    @code_filename.setter
    def code_filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_filename", value)

    @property
    @pulumi.getter(name="codeType")
    def code_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the function code type, which can be:
        + **inline**: inline code.
        + **zip**: ZIP file.
        + **jar**: JAR file or java functions.
        + **obs**: function code stored in an OBS bucket.
        """
        return pulumi.get(self, "code_type")

    @code_type.setter
    def code_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_type", value)

    @property
    @pulumi.getter(name="codeUrl")
    def code_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the code url. This parameter is mandatory when code_type is set to obs.
        """
        return pulumi.get(self, "code_url")

    @code_url.setter
    def code_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_url", value)

    @property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> Optional[pulumi.Input['FunctionCustomImageArgs']]:
        """
        Specifies the custom image configuration for creating function.
        The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "custom_image")

    @custom_image.setter
    def custom_image(self, value: Optional[pulumi.Input['FunctionCustomImageArgs']]):
        pulumi.set(self, "custom_image", value)

    @property
    @pulumi.getter(name="dependLists")
    def depend_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the ID list of the dependencies.
        """
        return pulumi.get(self, "depend_lists")

    @depend_lists.setter
    def depend_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "depend_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedUserData")
    def encrypted_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key/value information defined to be encrypted for the
        function. The format is the same as `user_data`.
        """
        return pulumi.get(self, "encrypted_user_data")

    @encrypted_user_data.setter
    def encrypted_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_user_data", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="funcCode")
    def func_code(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the function code. When code_type is set to inline, zip, or jar, this
        parameter is mandatory, and the code can be encoded using Base64 or just with the text code.
        """
        return pulumi.get(self, "func_code")

    @func_code.setter
    def func_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "func_code", value)

    @property
    @pulumi.getter(name="funcMounts")
    def func_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]]:
        """
        Specifies the file system list. The `func_mounts` object structure is documented
        below.
        """
        return pulumi.get(self, "func_mounts")

    @func_mounts.setter
    def func_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]]):
        pulumi.set(self, "func_mounts", value)

    @property
    @pulumi.getter(name="functiongraphVersion")
    def functiongraph_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the FunctionGraph version, defaults to **v1**.
        + **v1**: Hosts event-driven functions in a serverless context.
        + **v2**: Next-generation function hosting service powered by Huawei YuanRong architecture.
        """
        return pulumi.get(self, "functiongraph_version")

    @functiongraph_version.setter
    def functiongraph_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "functiongraph_version", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the entry point of the function.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="initializerHandler")
    def initializer_handler(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the initializer of the function.
        """
        return pulumi.get(self, "initializer_handler")

    @initializer_handler.setter
    def initializer_handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initializer_handler", value)

    @property
    @pulumi.getter(name="initializerTimeout")
    def initializer_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum duration the function can be initialized. Value range:
        1s to 300s.
        """
        return pulumi.get(self, "initializer_timeout")

    @initializer_timeout.setter
    def initializer_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initializer_timeout", value)

    @property
    @pulumi.getter(name="mountUserGroupId")
    def mount_user_group_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the user group ID, a non-0 integer from –1 to 65534. Default to
        -1.
        """
        return pulumi.get(self, "mount_user_group_id")

    @mount_user_group_id.setter
    def mount_user_group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mount_user_group_id", value)

    @property
    @pulumi.getter(name="mountUserId")
    def mount_user_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_id")

    @mount_user_id.setter
    def mount_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mount_user_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ID of subnet.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the Function resource. If omitted, the
        provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def xrole(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "xrole")

    @xrole.setter
    def xrole(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xrole", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 agency: Optional[pulumi.Input[str]] = None,
                 app: Optional[pulumi.Input[str]] = None,
                 app_agency: Optional[pulumi.Input[str]] = None,
                 code_filename: Optional[pulumi.Input[str]] = None,
                 code_type: Optional[pulumi.Input[str]] = None,
                 code_url: Optional[pulumi.Input[str]] = None,
                 custom_image: Optional[pulumi.Input['FunctionCustomImageArgs']] = None,
                 depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_user_data: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 func_code: Optional[pulumi.Input[str]] = None,
                 func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]] = None,
                 functiongraph_version: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 initializer_handler: Optional[pulumi.Input[str]] = None,
                 initializer_timeout: Optional[pulumi.Input[int]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 mount_user_group_id: Optional[pulumi.Input[int]] = None,
                 mount_user_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 urn: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 xrole: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[str] agency: Specifies the agency. This parameter is mandatory if the function needs to access other
               cloud services.
        :param pulumi.Input[str] app: Specifies the group to which the function belongs.
        :param pulumi.Input[str] app_agency: Specifies An execution agency enables you to obtain a token or an AK/SK for
               accessing other cloud services.
        :param pulumi.Input[str] code_filename: Specifies the name of a function file, This field is mandatory only when coe_type
               is set to jar or zip.
        :param pulumi.Input[str] code_type: Specifies the function code type, which can be:
               + **inline**: inline code.
               + **zip**: ZIP file.
               + **jar**: JAR file or java functions.
               + **obs**: function code stored in an OBS bucket.
        :param pulumi.Input[str] code_url: Specifies the code url. This parameter is mandatory when code_type is set to obs.
        :param pulumi.Input['FunctionCustomImageArgs'] custom_image: Specifies the custom image configuration for creating function.
               The object structure is documented below.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] depend_lists: Specifies the ID list of the dependencies.
        :param pulumi.Input[str] description: Specifies the description of the function.
        :param pulumi.Input[str] encrypted_user_data: Specifies the key/value information defined to be encrypted for the
               function. The format is the same as `user_data`.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the function.
               Changing this will create a new resource.
        :param pulumi.Input[str] func_code: Specifies the function code. When code_type is set to inline, zip, or jar, this
               parameter is mandatory, and the code can be encoded using Base64 or just with the text code.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]] func_mounts: Specifies the file system list. The `func_mounts` object structure is documented
               below.
        :param pulumi.Input[str] functiongraph_version: Specifies the FunctionGraph version, defaults to **v1**.
               + **v1**: Hosts event-driven functions in a serverless context.
               + **v2**: Next-generation function hosting service powered by Huawei YuanRong architecture.
        :param pulumi.Input[str] handler: Specifies the entry point of the function.
        :param pulumi.Input[str] initializer_handler: Specifies the initializer of the function.
        :param pulumi.Input[int] initializer_timeout: Specifies the maximum duration the function can be initialized. Value range:
               1s to 300s.
        :param pulumi.Input[int] memory_size: Specifies the memory size(MB) allocated to the function.
        :param pulumi.Input[int] mount_user_group_id: Specifies the user group ID, a non-0 integer from –1 to 65534. Default to
               -1.
        :param pulumi.Input[int] mount_user_id: Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[str] name: Specifies the name of the function.
               Changing this will create a new resource.
        :param pulumi.Input[str] network_id: Specifies the network ID of subnet.
        :param pulumi.Input[str] region: Specifies the region in which to create the Function resource. If omitted, the
               provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the environment for executing the function.
               If the function is created using a SWR image, set this parameter to `Custom Image`.
               Changing this will create a new resource.
        :param pulumi.Input[int] timeout: Specifies the timeout interval of the function, ranges from 3s to 900s.
        :param pulumi.Input[str] urn: Uniform Resource Name
        :param pulumi.Input[str] version: The version of the function
        :param pulumi.Input[str] vpc_id: Specifies the ID of VPC.
        """
        if agency is not None:
            pulumi.set(__self__, "agency", agency)
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_agency is not None:
            pulumi.set(__self__, "app_agency", app_agency)
        if code_filename is not None:
            pulumi.set(__self__, "code_filename", code_filename)
        if code_type is not None:
            pulumi.set(__self__, "code_type", code_type)
        if code_url is not None:
            pulumi.set(__self__, "code_url", code_url)
        if custom_image is not None:
            pulumi.set(__self__, "custom_image", custom_image)
        if depend_lists is not None:
            pulumi.set(__self__, "depend_lists", depend_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted_user_data is not None:
            pulumi.set(__self__, "encrypted_user_data", encrypted_user_data)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if func_code is not None:
            pulumi.set(__self__, "func_code", func_code)
        if func_mounts is not None:
            pulumi.set(__self__, "func_mounts", func_mounts)
        if functiongraph_version is not None:
            pulumi.set(__self__, "functiongraph_version", functiongraph_version)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if initializer_handler is not None:
            pulumi.set(__self__, "initializer_handler", initializer_handler)
        if initializer_timeout is not None:
            pulumi.set(__self__, "initializer_timeout", initializer_timeout)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if mount_user_group_id is not None:
            pulumi.set(__self__, "mount_user_group_id", mount_user_group_id)
        if mount_user_id is not None:
            pulumi.set(__self__, "mount_user_id", mount_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if package is not None:
            warnings.warn("""use app instead""", DeprecationWarning)
            pulumi.log.warn("""package is deprecated: use app instead""")
        if package is not None:
            pulumi.set(__self__, "package", package)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if xrole is not None:
            warnings.warn("""use agency instead""", DeprecationWarning)
            pulumi.log.warn("""xrole is deprecated: use agency instead""")
        if xrole is not None:
            pulumi.set(__self__, "xrole", xrole)

    @property
    @pulumi.getter
    def agency(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the agency. This parameter is mandatory if the function needs to access other
        cloud services.
        """
        return pulumi.get(self, "agency")

    @agency.setter
    def agency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agency", value)

    @property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the group to which the function belongs.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter(name="appAgency")
    def app_agency(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies An execution agency enables you to obtain a token or an AK/SK for
        accessing other cloud services.
        """
        return pulumi.get(self, "app_agency")

    @app_agency.setter
    def app_agency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_agency", value)

    @property
    @pulumi.getter(name="codeFilename")
    def code_filename(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a function file, This field is mandatory only when coe_type
        is set to jar or zip.
        """
        return pulumi.get(self, "code_filename")

    @code_filename.setter
    def code_filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_filename", value)

    @property
    @pulumi.getter(name="codeType")
    def code_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the function code type, which can be:
        + **inline**: inline code.
        + **zip**: ZIP file.
        + **jar**: JAR file or java functions.
        + **obs**: function code stored in an OBS bucket.
        """
        return pulumi.get(self, "code_type")

    @code_type.setter
    def code_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_type", value)

    @property
    @pulumi.getter(name="codeUrl")
    def code_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the code url. This parameter is mandatory when code_type is set to obs.
        """
        return pulumi.get(self, "code_url")

    @code_url.setter
    def code_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_url", value)

    @property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> Optional[pulumi.Input['FunctionCustomImageArgs']]:
        """
        Specifies the custom image configuration for creating function.
        The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "custom_image")

    @custom_image.setter
    def custom_image(self, value: Optional[pulumi.Input['FunctionCustomImageArgs']]):
        pulumi.set(self, "custom_image", value)

    @property
    @pulumi.getter(name="dependLists")
    def depend_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the ID list of the dependencies.
        """
        return pulumi.get(self, "depend_lists")

    @depend_lists.setter
    def depend_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "depend_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptedUserData")
    def encrypted_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key/value information defined to be encrypted for the
        function. The format is the same as `user_data`.
        """
        return pulumi.get(self, "encrypted_user_data")

    @encrypted_user_data.setter
    def encrypted_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted_user_data", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="funcCode")
    def func_code(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the function code. When code_type is set to inline, zip, or jar, this
        parameter is mandatory, and the code can be encoded using Base64 or just with the text code.
        """
        return pulumi.get(self, "func_code")

    @func_code.setter
    def func_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "func_code", value)

    @property
    @pulumi.getter(name="funcMounts")
    def func_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]]:
        """
        Specifies the file system list. The `func_mounts` object structure is documented
        below.
        """
        return pulumi.get(self, "func_mounts")

    @func_mounts.setter
    def func_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFuncMountArgs']]]]):
        pulumi.set(self, "func_mounts", value)

    @property
    @pulumi.getter(name="functiongraphVersion")
    def functiongraph_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the FunctionGraph version, defaults to **v1**.
        + **v1**: Hosts event-driven functions in a serverless context.
        + **v2**: Next-generation function hosting service powered by Huawei YuanRong architecture.
        """
        return pulumi.get(self, "functiongraph_version")

    @functiongraph_version.setter
    def functiongraph_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "functiongraph_version", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the entry point of the function.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="initializerHandler")
    def initializer_handler(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the initializer of the function.
        """
        return pulumi.get(self, "initializer_handler")

    @initializer_handler.setter
    def initializer_handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initializer_handler", value)

    @property
    @pulumi.getter(name="initializerTimeout")
    def initializer_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum duration the function can be initialized. Value range:
        1s to 300s.
        """
        return pulumi.get(self, "initializer_timeout")

    @initializer_timeout.setter
    def initializer_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initializer_timeout", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the memory size(MB) allocated to the function.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter(name="mountUserGroupId")
    def mount_user_group_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the user group ID, a non-0 integer from –1 to 65534. Default to
        -1.
        """
        return pulumi.get(self, "mount_user_group_id")

    @mount_user_group_id.setter
    def mount_user_group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mount_user_group_id", value)

    @property
    @pulumi.getter(name="mountUserId")
    def mount_user_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_id")

    @mount_user_id.setter
    def mount_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mount_user_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ID of subnet.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the Function resource. If omitted, the
        provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the environment for executing the function.
        If the function is created using a SWR image, set this parameter to `Custom Image`.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the timeout interval of the function, ranges from 3s to 900s.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def urn(self) -> Optional[pulumi.Input[str]]:
        """
        Uniform Resource Name
        """
        return pulumi.get(self, "urn")

    @urn.setter
    def urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "urn", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the function
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def xrole(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "xrole")

    @xrole.setter
    def xrole(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xrole", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency: Optional[pulumi.Input[str]] = None,
                 app: Optional[pulumi.Input[str]] = None,
                 app_agency: Optional[pulumi.Input[str]] = None,
                 code_filename: Optional[pulumi.Input[str]] = None,
                 code_type: Optional[pulumi.Input[str]] = None,
                 code_url: Optional[pulumi.Input[str]] = None,
                 custom_image: Optional[pulumi.Input[pulumi.InputType['FunctionCustomImageArgs']]] = None,
                 depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_user_data: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 func_code: Optional[pulumi.Input[str]] = None,
                 func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionFuncMountArgs']]]]] = None,
                 functiongraph_version: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 initializer_handler: Optional[pulumi.Input[str]] = None,
                 initializer_timeout: Optional[pulumi.Input[int]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 mount_user_group_id: Optional[pulumi.Input[int]] = None,
                 mount_user_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 xrole: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Function resource within HuaweiCloud.

        ## Example Usage
        ### With base64 func code

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        f1 = huaweicloud.function_graph.Function("f1",
            agency="test",
            app="default",
            code_type="inline",
            description="fuction test",
            func_code="aW1wb3J0IGpzb24KZGVmIGhhbmRsZXIgKGV2ZW50LCBjb250ZXh0KToKICAgIG91dHB1dCA9ICdIZWxsbyBtZXNzYWdlOiAnICsganNvbi5kdW1wcyhldmVudCkKICAgIHJldHVybiBvdXRwdXQ=",
            handler="test.handler",
            memory_size=128,
            runtime="Python2.7",
            timeout=3)
        ```
        ### With text code

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        f1 = huaweicloud.function_graph.Function("f1",
            agency="test",
            app="default",
            code_type="inline",
            description="fuction test",
            func_code=\"\"\"# -*- coding:utf-8 -*-
        import json
        def handler (event, context):
            return {
                "statusCode": 200,
                "isBase64Encoded": False,
                "body": json.dumps(event),
                "headers": {
                    "Content-Type": "application/json"
                }
            }

        \"\"\",
            handler="test.handler",
            memory_size=128,
            runtime="Python2.7",
            timeout=3)
        ```
        ### Create function using SWR image

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_name = config.require_object("functionName")
        agency_name = config.require_object("agencyName")
        image_url = config.require_object("imageUrl")
        by_swr_image = huaweicloud.function_graph.Function("bySwrImage",
            agency=agency_name,
            app="default",
            runtime="Custom Image",
            memory_size=128,
            timeout=3,
            custom_image=huaweicloud.function_graph.FunctionCustomImageArgs(
                url=image_url,
            ))
        ```

        ## Import

        Functions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:FunctionGraph/function:Function my-func 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] agency: Specifies the agency. This parameter is mandatory if the function needs to access other
               cloud services.
        :param pulumi.Input[str] app: Specifies the group to which the function belongs.
        :param pulumi.Input[str] app_agency: Specifies An execution agency enables you to obtain a token or an AK/SK for
               accessing other cloud services.
        :param pulumi.Input[str] code_filename: Specifies the name of a function file, This field is mandatory only when coe_type
               is set to jar or zip.
        :param pulumi.Input[str] code_type: Specifies the function code type, which can be:
               + **inline**: inline code.
               + **zip**: ZIP file.
               + **jar**: JAR file or java functions.
               + **obs**: function code stored in an OBS bucket.
        :param pulumi.Input[str] code_url: Specifies the code url. This parameter is mandatory when code_type is set to obs.
        :param pulumi.Input[pulumi.InputType['FunctionCustomImageArgs']] custom_image: Specifies the custom image configuration for creating function.
               The object structure is documented below.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] depend_lists: Specifies the ID list of the dependencies.
        :param pulumi.Input[str] description: Specifies the description of the function.
        :param pulumi.Input[str] encrypted_user_data: Specifies the key/value information defined to be encrypted for the
               function. The format is the same as `user_data`.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the function.
               Changing this will create a new resource.
        :param pulumi.Input[str] func_code: Specifies the function code. When code_type is set to inline, zip, or jar, this
               parameter is mandatory, and the code can be encoded using Base64 or just with the text code.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionFuncMountArgs']]]] func_mounts: Specifies the file system list. The `func_mounts` object structure is documented
               below.
        :param pulumi.Input[str] functiongraph_version: Specifies the FunctionGraph version, defaults to **v1**.
               + **v1**: Hosts event-driven functions in a serverless context.
               + **v2**: Next-generation function hosting service powered by Huawei YuanRong architecture.
        :param pulumi.Input[str] handler: Specifies the entry point of the function.
        :param pulumi.Input[str] initializer_handler: Specifies the initializer of the function.
        :param pulumi.Input[int] initializer_timeout: Specifies the maximum duration the function can be initialized. Value range:
               1s to 300s.
        :param pulumi.Input[int] memory_size: Specifies the memory size(MB) allocated to the function.
        :param pulumi.Input[int] mount_user_group_id: Specifies the user group ID, a non-0 integer from –1 to 65534. Default to
               -1.
        :param pulumi.Input[int] mount_user_id: Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[str] name: Specifies the name of the function.
               Changing this will create a new resource.
        :param pulumi.Input[str] network_id: Specifies the network ID of subnet.
        :param pulumi.Input[str] region: Specifies the region in which to create the Function resource. If omitted, the
               provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the environment for executing the function.
               If the function is created using a SWR image, set this parameter to `Custom Image`.
               Changing this will create a new resource.
        :param pulumi.Input[int] timeout: Specifies the timeout interval of the function, ranges from 3s to 900s.
        :param pulumi.Input[str] vpc_id: Specifies the ID of VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Function resource within HuaweiCloud.

        ## Example Usage
        ### With base64 func code

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        f1 = huaweicloud.function_graph.Function("f1",
            agency="test",
            app="default",
            code_type="inline",
            description="fuction test",
            func_code="aW1wb3J0IGpzb24KZGVmIGhhbmRsZXIgKGV2ZW50LCBjb250ZXh0KToKICAgIG91dHB1dCA9ICdIZWxsbyBtZXNzYWdlOiAnICsganNvbi5kdW1wcyhldmVudCkKICAgIHJldHVybiBvdXRwdXQ=",
            handler="test.handler",
            memory_size=128,
            runtime="Python2.7",
            timeout=3)
        ```
        ### With text code

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        f1 = huaweicloud.function_graph.Function("f1",
            agency="test",
            app="default",
            code_type="inline",
            description="fuction test",
            func_code=\"\"\"# -*- coding:utf-8 -*-
        import json
        def handler (event, context):
            return {
                "statusCode": 200,
                "isBase64Encoded": False,
                "body": json.dumps(event),
                "headers": {
                    "Content-Type": "application/json"
                }
            }

        \"\"\",
            handler="test.handler",
            memory_size=128,
            runtime="Python2.7",
            timeout=3)
        ```
        ### Create function using SWR image

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_name = config.require_object("functionName")
        agency_name = config.require_object("agencyName")
        image_url = config.require_object("imageUrl")
        by_swr_image = huaweicloud.function_graph.Function("bySwrImage",
            agency=agency_name,
            app="default",
            runtime="Custom Image",
            memory_size=128,
            timeout=3,
            custom_image=huaweicloud.function_graph.FunctionCustomImageArgs(
                url=image_url,
            ))
        ```

        ## Import

        Functions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:FunctionGraph/function:Function my-func 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency: Optional[pulumi.Input[str]] = None,
                 app: Optional[pulumi.Input[str]] = None,
                 app_agency: Optional[pulumi.Input[str]] = None,
                 code_filename: Optional[pulumi.Input[str]] = None,
                 code_type: Optional[pulumi.Input[str]] = None,
                 code_url: Optional[pulumi.Input[str]] = None,
                 custom_image: Optional[pulumi.Input[pulumi.InputType['FunctionCustomImageArgs']]] = None,
                 depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encrypted_user_data: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 func_code: Optional[pulumi.Input[str]] = None,
                 func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionFuncMountArgs']]]]] = None,
                 functiongraph_version: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 initializer_handler: Optional[pulumi.Input[str]] = None,
                 initializer_timeout: Optional[pulumi.Input[int]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 mount_user_group_id: Optional[pulumi.Input[int]] = None,
                 mount_user_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 xrole: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["agency"] = agency
            __props__.__dict__["app"] = app
            __props__.__dict__["app_agency"] = app_agency
            __props__.__dict__["code_filename"] = code_filename
            __props__.__dict__["code_type"] = code_type
            __props__.__dict__["code_url"] = code_url
            __props__.__dict__["custom_image"] = custom_image
            __props__.__dict__["depend_lists"] = depend_lists
            __props__.__dict__["description"] = description
            __props__.__dict__["encrypted_user_data"] = encrypted_user_data
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["func_code"] = func_code
            __props__.__dict__["func_mounts"] = func_mounts
            __props__.__dict__["functiongraph_version"] = functiongraph_version
            __props__.__dict__["handler"] = handler
            __props__.__dict__["initializer_handler"] = initializer_handler
            __props__.__dict__["initializer_timeout"] = initializer_timeout
            if memory_size is None and not opts.urn:
                raise TypeError("Missing required property 'memory_size'")
            __props__.__dict__["memory_size"] = memory_size
            __props__.__dict__["mount_user_group_id"] = mount_user_group_id
            __props__.__dict__["mount_user_id"] = mount_user_id
            __props__.__dict__["name"] = name
            __props__.__dict__["network_id"] = network_id
            if package is not None and not opts.urn:
                warnings.warn("""use app instead""", DeprecationWarning)
                pulumi.log.warn("""package is deprecated: use app instead""")
            __props__.__dict__["package"] = package
            __props__.__dict__["region"] = region
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            if timeout is None and not opts.urn:
                raise TypeError("Missing required property 'timeout'")
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["vpc_id"] = vpc_id
            if xrole is not None and not opts.urn:
                warnings.warn("""use agency instead""", DeprecationWarning)
                pulumi.log.warn("""xrole is deprecated: use agency instead""")
            __props__.__dict__["xrole"] = xrole
            __props__.__dict__["urn"] = None
            __props__.__dict__["version"] = None
        super(Function, __self__).__init__(
            'huaweicloud:FunctionGraph/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agency: Optional[pulumi.Input[str]] = None,
            app: Optional[pulumi.Input[str]] = None,
            app_agency: Optional[pulumi.Input[str]] = None,
            code_filename: Optional[pulumi.Input[str]] = None,
            code_type: Optional[pulumi.Input[str]] = None,
            code_url: Optional[pulumi.Input[str]] = None,
            custom_image: Optional[pulumi.Input[pulumi.InputType['FunctionCustomImageArgs']]] = None,
            depend_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            encrypted_user_data: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            func_code: Optional[pulumi.Input[str]] = None,
            func_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionFuncMountArgs']]]]] = None,
            functiongraph_version: Optional[pulumi.Input[str]] = None,
            handler: Optional[pulumi.Input[str]] = None,
            initializer_handler: Optional[pulumi.Input[str]] = None,
            initializer_timeout: Optional[pulumi.Input[int]] = None,
            memory_size: Optional[pulumi.Input[int]] = None,
            mount_user_group_id: Optional[pulumi.Input[int]] = None,
            mount_user_id: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            package: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            urn: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            xrole: Optional[pulumi.Input[str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] agency: Specifies the agency. This parameter is mandatory if the function needs to access other
               cloud services.
        :param pulumi.Input[str] app: Specifies the group to which the function belongs.
        :param pulumi.Input[str] app_agency: Specifies An execution agency enables you to obtain a token or an AK/SK for
               accessing other cloud services.
        :param pulumi.Input[str] code_filename: Specifies the name of a function file, This field is mandatory only when coe_type
               is set to jar or zip.
        :param pulumi.Input[str] code_type: Specifies the function code type, which can be:
               + **inline**: inline code.
               + **zip**: ZIP file.
               + **jar**: JAR file or java functions.
               + **obs**: function code stored in an OBS bucket.
        :param pulumi.Input[str] code_url: Specifies the code url. This parameter is mandatory when code_type is set to obs.
        :param pulumi.Input[pulumi.InputType['FunctionCustomImageArgs']] custom_image: Specifies the custom image configuration for creating function.
               The object structure is documented below.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] depend_lists: Specifies the ID list of the dependencies.
        :param pulumi.Input[str] description: Specifies the description of the function.
        :param pulumi.Input[str] encrypted_user_data: Specifies the key/value information defined to be encrypted for the
               function. The format is the same as `user_data`.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the function.
               Changing this will create a new resource.
        :param pulumi.Input[str] func_code: Specifies the function code. When code_type is set to inline, zip, or jar, this
               parameter is mandatory, and the code can be encoded using Base64 or just with the text code.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FunctionFuncMountArgs']]]] func_mounts: Specifies the file system list. The `func_mounts` object structure is documented
               below.
        :param pulumi.Input[str] functiongraph_version: Specifies the FunctionGraph version, defaults to **v1**.
               + **v1**: Hosts event-driven functions in a serverless context.
               + **v2**: Next-generation function hosting service powered by Huawei YuanRong architecture.
        :param pulumi.Input[str] handler: Specifies the entry point of the function.
        :param pulumi.Input[str] initializer_handler: Specifies the initializer of the function.
        :param pulumi.Input[int] initializer_timeout: Specifies the maximum duration the function can be initialized. Value range:
               1s to 300s.
        :param pulumi.Input[int] memory_size: Specifies the memory size(MB) allocated to the function.
        :param pulumi.Input[int] mount_user_group_id: Specifies the user group ID, a non-0 integer from –1 to 65534. Default to
               -1.
        :param pulumi.Input[int] mount_user_id: Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        :param pulumi.Input[str] name: Specifies the name of the function.
               Changing this will create a new resource.
        :param pulumi.Input[str] network_id: Specifies the network ID of subnet.
        :param pulumi.Input[str] region: Specifies the region in which to create the Function resource. If omitted, the
               provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the environment for executing the function.
               If the function is created using a SWR image, set this parameter to `Custom Image`.
               Changing this will create a new resource.
        :param pulumi.Input[int] timeout: Specifies the timeout interval of the function, ranges from 3s to 900s.
        :param pulumi.Input[str] urn: Uniform Resource Name
        :param pulumi.Input[str] version: The version of the function
        :param pulumi.Input[str] vpc_id: Specifies the ID of VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["agency"] = agency
        __props__.__dict__["app"] = app
        __props__.__dict__["app_agency"] = app_agency
        __props__.__dict__["code_filename"] = code_filename
        __props__.__dict__["code_type"] = code_type
        __props__.__dict__["code_url"] = code_url
        __props__.__dict__["custom_image"] = custom_image
        __props__.__dict__["depend_lists"] = depend_lists
        __props__.__dict__["description"] = description
        __props__.__dict__["encrypted_user_data"] = encrypted_user_data
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["func_code"] = func_code
        __props__.__dict__["func_mounts"] = func_mounts
        __props__.__dict__["functiongraph_version"] = functiongraph_version
        __props__.__dict__["handler"] = handler
        __props__.__dict__["initializer_handler"] = initializer_handler
        __props__.__dict__["initializer_timeout"] = initializer_timeout
        __props__.__dict__["memory_size"] = memory_size
        __props__.__dict__["mount_user_group_id"] = mount_user_group_id
        __props__.__dict__["mount_user_id"] = mount_user_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["package"] = package
        __props__.__dict__["region"] = region
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["urn"] = urn
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["xrole"] = xrole
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def agency(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the agency. This parameter is mandatory if the function needs to access other
        cloud services.
        """
        return pulumi.get(self, "agency")

    @property
    @pulumi.getter
    def app(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the group to which the function belongs.
        """
        return pulumi.get(self, "app")

    @property
    @pulumi.getter(name="appAgency")
    def app_agency(self) -> pulumi.Output[str]:
        """
        Specifies An execution agency enables you to obtain a token or an AK/SK for
        accessing other cloud services.
        """
        return pulumi.get(self, "app_agency")

    @property
    @pulumi.getter(name="codeFilename")
    def code_filename(self) -> pulumi.Output[str]:
        """
        Specifies the name of a function file, This field is mandatory only when coe_type
        is set to jar or zip.
        """
        return pulumi.get(self, "code_filename")

    @property
    @pulumi.getter(name="codeType")
    def code_type(self) -> pulumi.Output[str]:
        """
        Specifies the function code type, which can be:
        + **inline**: inline code.
        + **zip**: ZIP file.
        + **jar**: JAR file or java functions.
        + **obs**: function code stored in an OBS bucket.
        """
        return pulumi.get(self, "code_type")

    @property
    @pulumi.getter(name="codeUrl")
    def code_url(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the code url. This parameter is mandatory when code_type is set to obs.
        """
        return pulumi.get(self, "code_url")

    @property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> pulumi.Output['outputs.FunctionCustomImage']:
        """
        Specifies the custom image configuration for creating function.
        The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "custom_image")

    @property
    @pulumi.getter(name="dependLists")
    def depend_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the ID list of the dependencies.
        """
        return pulumi.get(self, "depend_lists")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptedUserData")
    def encrypted_user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the key/value information defined to be encrypted for the
        function. The format is the same as `user_data`.
        """
        return pulumi.get(self, "encrypted_user_data")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="funcCode")
    def func_code(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the function code. When code_type is set to inline, zip, or jar, this
        parameter is mandatory, and the code can be encoded using Base64 or just with the text code.
        """
        return pulumi.get(self, "func_code")

    @property
    @pulumi.getter(name="funcMounts")
    def func_mounts(self) -> pulumi.Output[Sequence['outputs.FunctionFuncMount']]:
        """
        Specifies the file system list. The `func_mounts` object structure is documented
        below.
        """
        return pulumi.get(self, "func_mounts")

    @property
    @pulumi.getter(name="functiongraphVersion")
    def functiongraph_version(self) -> pulumi.Output[str]:
        """
        Specifies the FunctionGraph version, defaults to **v1**.
        + **v1**: Hosts event-driven functions in a serverless context.
        + **v2**: Next-generation function hosting service powered by Huawei YuanRong architecture.
        """
        return pulumi.get(self, "functiongraph_version")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[str]:
        """
        Specifies the entry point of the function.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="initializerHandler")
    def initializer_handler(self) -> pulumi.Output[str]:
        """
        Specifies the initializer of the function.
        """
        return pulumi.get(self, "initializer_handler")

    @property
    @pulumi.getter(name="initializerTimeout")
    def initializer_timeout(self) -> pulumi.Output[int]:
        """
        Specifies the maximum duration the function can be initialized. Value range:
        1s to 300s.
        """
        return pulumi.get(self, "initializer_timeout")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[int]:
        """
        Specifies the memory size(MB) allocated to the function.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter(name="mountUserGroupId")
    def mount_user_group_id(self) -> pulumi.Output[int]:
        """
        Specifies the user group ID, a non-0 integer from –1 to 65534. Default to
        -1.
        """
        return pulumi.get(self, "mount_user_group_id")

    @property
    @pulumi.getter(name="mountUserId")
    def mount_user_id(self) -> pulumi.Output[int]:
        """
        Specifies the user ID, a non-0 integer from –1 to 65534. Default to -1.
        """
        return pulumi.get(self, "mount_user_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the network ID of subnet.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def package(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the Function resource. If omitted, the
        provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        Specifies the environment for executing the function.
        If the function is created using a SWR image, set this parameter to `Custom Image`.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[int]:
        """
        Specifies the timeout interval of the function, ranges from 3s to 900s.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def urn(self) -> pulumi.Output[str]:
        """
        Uniform Resource Name
        """
        return pulumi.get(self, "urn")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version of the function
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter
    def xrole(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "xrole")

