# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'FunctionCustomImageArgs',
    'FunctionFuncMountArgs',
    'TriggerApigArgs',
    'TriggerDisArgs',
    'TriggerKafkaArgs',
    'TriggerLtsArgs',
    'TriggerObsArgs',
    'TriggerSmnArgs',
    'TriggerTimerArgs',
]

@pulumi.input_type
class FunctionCustomImageArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] url: Specifies the URL of SWR image, the URL must start with `swr.`.
               Changing this will create a new resource.
        """
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Specifies the URL of SWR image, the URL must start with `swr.`.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class FunctionFuncMountArgs:
    def __init__(__self__, *,
                 local_mount_path: pulumi.Input[str],
                 mount_resource: pulumi.Input[str],
                 mount_share_path: pulumi.Input[str],
                 mount_type: pulumi.Input[str],
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] local_mount_path: Specifies the function access path.
        :param pulumi.Input[str] mount_resource: Specifies the ID of the mounted resource (corresponding cloud service).
        :param pulumi.Input[str] mount_share_path: Specifies the remote mount path. Example: 192.168.0.12:/data.
        :param pulumi.Input[str] mount_type: Specifies the mount type. Options: sfs, sfsTurbo, and ecs.
        """
        pulumi.set(__self__, "local_mount_path", local_mount_path)
        pulumi.set(__self__, "mount_resource", mount_resource)
        pulumi.set(__self__, "mount_share_path", mount_share_path)
        pulumi.set(__self__, "mount_type", mount_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="localMountPath")
    def local_mount_path(self) -> pulumi.Input[str]:
        """
        Specifies the function access path.
        """
        return pulumi.get(self, "local_mount_path")

    @local_mount_path.setter
    def local_mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_mount_path", value)

    @property
    @pulumi.getter(name="mountResource")
    def mount_resource(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the mounted resource (corresponding cloud service).
        """
        return pulumi.get(self, "mount_resource")

    @mount_resource.setter
    def mount_resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_resource", value)

    @property
    @pulumi.getter(name="mountSharePath")
    def mount_share_path(self) -> pulumi.Input[str]:
        """
        Specifies the remote mount path. Example: 192.168.0.12:/data.
        """
        return pulumi.get(self, "mount_share_path")

    @mount_share_path.setter
    def mount_share_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_share_path", value)

    @property
    @pulumi.getter(name="mountType")
    def mount_type(self) -> pulumi.Input[str]:
        """
        Specifies the mount type. Options: sfs, sfsTurbo, and ecs.
        """
        return pulumi.get(self, "mount_type")

    @mount_type.setter
    def mount_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class TriggerApigArgs:
    def __init__(__self__, *,
                 api_name: pulumi.Input[str],
                 env_name: pulumi.Input[str],
                 group_id: pulumi.Input[str],
                 instance_id: Optional[pulumi.Input[str]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 security_authentication: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] api_name: Specifies the API name. Changing this will create a new trigger resource.
        :param pulumi.Input[str] env_name: Specifies the API environment name.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] group_id: Specifies the ID of the APIG group to which the API belongs.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] instance_id: Specifies the ID of the APIG dedicated instance to which the API belongs.
               Required if the `type` is `DEDICATEDGATEWAY`. Changing this will create a new trigger resource.
        :param pulumi.Input[str] request_protocol: Specifies the request protocol of the API. The valid value are
               **HTTP** and **HTTPS**. Default to **HTTPS**. Changing this will create a new trigger resource.
        :param pulumi.Input[str] security_authentication: Specifies the security authentication mode. The valid values
               are **NONE**, **APP** and **IAM**, default to **IAM**. Changing this will create a new trigger resource.
        :param pulumi.Input[int] timeout: Specifies the timeout for request sending. The valid value is range form
               `1` to `60,000`, default to `5,000`. Changing this will create a new trigger resource.
        """
        pulumi.set(__self__, "api_name", api_name)
        pulumi.set(__self__, "env_name", env_name)
        pulumi.set(__self__, "group_id", group_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if security_authentication is not None:
            pulumi.set(__self__, "security_authentication", security_authentication)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="apiName")
    def api_name(self) -> pulumi.Input[str]:
        """
        Specifies the API name. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "api_name")

    @api_name.setter
    def api_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_name", value)

    @property
    @pulumi.getter(name="envName")
    def env_name(self) -> pulumi.Input[str]:
        """
        Specifies the API environment name.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "env_name")

    @env_name.setter
    def env_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "env_name", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the APIG group to which the API belongs.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the APIG dedicated instance to which the API belongs.
        Required if the `type` is `DEDICATEDGATEWAY`. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request protocol of the API. The valid value are
        **HTTP** and **HTTPS**. Default to **HTTPS**. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_protocol", value)

    @property
    @pulumi.getter(name="securityAuthentication")
    def security_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security authentication mode. The valid values
        are **NONE**, **APP** and **IAM**, default to **IAM**. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "security_authentication")

    @security_authentication.setter
    def security_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_authentication", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the timeout for request sending. The valid value is range form
        `1` to `60,000`, default to `5,000`. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class TriggerDisArgs:
    def __init__(__self__, *,
                 max_fetch_bytes: pulumi.Input[int],
                 pull_period: pulumi.Input[int],
                 serial_enable: pulumi.Input[bool],
                 starting_position: pulumi.Input[str],
                 stream_name: pulumi.Input[str]):
        """
        :param pulumi.Input[int] max_fetch_bytes: Specifies the maximum volume of data that can be obtained for a single
               request, in Byte. Only the records with a size smaller than this value can be obtained.
               The valid value is range from `1,024` to `4,194,304`.
               Changing this will create a new trigger resource.
        :param pulumi.Input[int] pull_period: Specifies the interval at which data is pulled from the specified stream.
               The valid value is range from `2` to `60,000`.
               Changing this will create a new trigger resource.
        :param pulumi.Input[bool] serial_enable: Specifies the determines whether to pull data only after the data pulled
               in the last period has been processed.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] starting_position: Specifies the type of starting position for DIS queue.
               The valid values are as follows:
               + **TRIM_HORIZON**: Starts reading from the earliest data stored in the partitions.
               + **LATEST**: Starts reading from the latest data stored in the partitions.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] stream_name: Specifies the name of the DIS stream resource.
               Changing this will create a new trigger resource.
        """
        pulumi.set(__self__, "max_fetch_bytes", max_fetch_bytes)
        pulumi.set(__self__, "pull_period", pull_period)
        pulumi.set(__self__, "serial_enable", serial_enable)
        pulumi.set(__self__, "starting_position", starting_position)
        pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter(name="maxFetchBytes")
    def max_fetch_bytes(self) -> pulumi.Input[int]:
        """
        Specifies the maximum volume of data that can be obtained for a single
        request, in Byte. Only the records with a size smaller than this value can be obtained.
        The valid value is range from `1,024` to `4,194,304`.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "max_fetch_bytes")

    @max_fetch_bytes.setter
    def max_fetch_bytes(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_fetch_bytes", value)

    @property
    @pulumi.getter(name="pullPeriod")
    def pull_period(self) -> pulumi.Input[int]:
        """
        Specifies the interval at which data is pulled from the specified stream.
        The valid value is range from `2` to `60,000`.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "pull_period")

    @pull_period.setter
    def pull_period(self, value: pulumi.Input[int]):
        pulumi.set(self, "pull_period", value)

    @property
    @pulumi.getter(name="serialEnable")
    def serial_enable(self) -> pulumi.Input[bool]:
        """
        Specifies the determines whether to pull data only after the data pulled
        in the last period has been processed.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "serial_enable")

    @serial_enable.setter
    def serial_enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "serial_enable", value)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> pulumi.Input[str]:
        """
        Specifies the type of starting position for DIS queue.
        The valid values are as follows:
        + **TRIM_HORIZON**: Starts reading from the earliest data stored in the partitions.
        + **LATEST**: Starts reading from the latest data stored in the partitions.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "starting_position")

    @starting_position.setter
    def starting_position(self, value: pulumi.Input[str]):
        pulumi.set(self, "starting_position", value)

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the DIS stream resource.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "stream_name", value)


@pulumi.input_type
class TriggerKafkaArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 topic_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 batch_size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] instance_id: Specifies the ID of the APIG dedicated instance to which the API belongs.
               Required if the `type` is `DEDICATEDGATEWAY`. Changing this will create a new trigger resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topic_ids: Specifies one or more topic IDs of DMS kafka instance.
               Changing this will create a new trigger resource.
        :param pulumi.Input[int] batch_size: Specifies the The number of messages consumed from the topic each time.
               The valid value is range from `1` to `1,000`. Defaults to `100`.
               Changing this will create a new trigger resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "topic_ids", topic_ids)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the APIG dedicated instance to which the API belongs.
        Required if the `type` is `DEDICATEDGATEWAY`. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="topicIds")
    def topic_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies one or more topic IDs of DMS kafka instance.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "topic_ids")

    @topic_ids.setter
    def topic_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "topic_ids", value)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the The number of messages consumed from the topic each time.
        The valid value is range from `1` to `1,000`. Defaults to `100`.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size", value)


@pulumi.input_type
class TriggerLtsArgs:
    def __init__(__self__, *,
                 log_group_id: pulumi.Input[str],
                 log_topic_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] log_group_id: Specifies the log group ID.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] log_topic_id: Specifies the log stream ID.
               Changing this will create a new trigger resource.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_topic_id", log_topic_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the log group ID.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logTopicId")
    def log_topic_id(self) -> pulumi.Input[str]:
        """
        Specifies the log stream ID.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "log_topic_id")

    @log_topic_id.setter
    def log_topic_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_topic_id", value)


@pulumi.input_type
class TriggerObsArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 event_notification_name: pulumi.Input[str],
                 events: pulumi.Input[Sequence[pulumi.Input[str]]],
                 prefix: Optional[pulumi.Input[str]] = None,
                 suffix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: Specifies the OBS bucket name.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] event_notification_name: Specifies the event notification name.
               Changing this will create a new trigger resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: Specifies the events that can trigger functions.
               Changing this will create a new trigger resource.
               The valid values are as follows:
               + **ObjectCreated**, **Put**, **Post**, **Copy** and **CompleteMultipartUpload**.
               + **ObjectRemoved**, **Delete** and **DeleteMarkerCreated**.
        :param pulumi.Input[str] prefix: Specifies the prefix to limit notifications to objects beginning with this keyword.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] suffix: Specifies the suffix to limit notifications to objects ending with this keyword.
               Changing this will create a new trigger resource.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "event_notification_name", event_notification_name)
        pulumi.set(__self__, "events", events)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        Specifies the OBS bucket name.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="eventNotificationName")
    def event_notification_name(self) -> pulumi.Input[str]:
        """
        Specifies the event notification name.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "event_notification_name")

    @event_notification_name.setter
    def event_notification_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_notification_name", value)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the events that can trigger functions.
        Changing this will create a new trigger resource.
        The valid values are as follows:
        + **ObjectCreated**, **Put**, **Post**, **Copy** and **CompleteMultipartUpload**.
        + **ObjectRemoved**, **Delete** and **DeleteMarkerCreated**.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the prefix to limit notifications to objects beginning with this keyword.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the suffix to limit notifications to objects ending with this keyword.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "suffix")

    @suffix.setter
    def suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suffix", value)


@pulumi.input_type
class TriggerSmnArgs:
    def __init__(__self__, *,
                 topic_urn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] topic_urn: Specifies the Uniform Resource Name (URN) for SMN topic.
               Changing this will create a new trigger resource.
        """
        pulumi.set(__self__, "topic_urn", topic_urn)

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Input[str]:
        """
        Specifies the Uniform Resource Name (URN) for SMN topic.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_urn", value)


@pulumi.input_type
class TriggerTimerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 schedule: pulumi.Input[str],
                 schedule_type: pulumi.Input[str],
                 additional_information: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the trigger name, which can contains of 1 to 64 characters.
               The name must start with a letter, only letters, digits, hyphens (-) and underscores (_) are allowed.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] schedule: Specifies the time schedule.
               For the rate type, schedule is composed of time and time unit.
               The time unit supports minutes (m), hours (h) and days (d).
               For the corn expression, please refer to the HuaweiCloud
               [document](https://support.huaweicloud.com/en-us/usermanual-functiongraph/functiongraph_01_0908.html).
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] schedule_type: Specifies the type of the time schedule.
               The valid values are **Rate** and **Cron**.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] additional_information: Specifies the event used by the timer to trigger the function.
               Changing this will create a new trigger resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "schedule_type", schedule_type)
        if additional_information is not None:
            pulumi.set(__self__, "additional_information", additional_information)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the trigger name, which can contains of 1 to 64 characters.
        The name must start with a letter, only letters, digits, hyphens (-) and underscores (_) are allowed.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[str]:
        """
        Specifies the time schedule.
        For the rate type, schedule is composed of time and time unit.
        The time unit supports minutes (m), hours (h) and days (d).
        For the corn expression, please refer to the HuaweiCloud
        [document](https://support.huaweicloud.com/en-us/usermanual-functiongraph/functiongraph_01_0908.html).
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the time schedule.
        The valid values are **Rate** and **Cron**.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_type", value)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the event used by the timer to trigger the function.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "additional_information")

    @additional_information.setter
    def additional_information(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_information", value)


