# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceBandwidth',
    'InstanceBlockDevice',
    'InstanceDataDisk',
    'InstanceNetwork',
    'InstanceSchedulerHint',
    'InstanceVolumeAttached',
    'GetInstanceNetworkResult',
    'GetInstanceSchedulerHintResult',
    'GetInstanceVolumeAttachedResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceSchedulerHintResult',
    'GetInstancesInstanceVolumeAttachedResult',
]

@pulumi.output_type
class InstanceBandwidth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareType":
            suggest = "share_type"
        elif key == "chargeMode":
            suggest = "charge_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBandwidth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBandwidth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBandwidth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_type: str,
                 charge_mode: Optional[str] = None,
                 id: Optional[str] = None,
                 size: Optional[int] = None):
        """
        :param str share_type: Specifies the bandwidth sharing type. Changing this creates a new instance.
               Possible values are as follows:
               + **PER**: Dedicated bandwidth
               + **WHOLE**: Shared bandwidth
        :param str charge_mode: Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
               Changing this creates a new instance.
        :param str id: Specifies the **shared** bandwidth id. This parameter is mandatory when
               `share_type` is set to **WHOLE**. Changing this creates a new instance.
        :param int size: Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
               This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        pulumi.set(__self__, "share_type", share_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> str:
        """
        Specifies the bandwidth sharing type. Changing this creates a new instance.
        Possible values are as follows:
        + **PER**: Dedicated bandwidth
        + **WHOLE**: Shared bandwidth
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[str]:
        """
        Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charge_mode")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Specifies the **shared** bandwidth id. This parameter is mandatory when
        `share_type` is set to **WHOLE**. Changing this creates a new instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class InstanceBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "bootIndex":
            suggest = "boot_index"
        elif key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "destinationType":
            suggest = "destination_type"
        elif key == "guestFormat":
            suggest = "guest_format"
        elif key == "volumeSize":
            suggest = "volume_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: str,
                 boot_index: Optional[int] = None,
                 delete_on_termination: Optional[bool] = None,
                 destination_type: Optional[str] = None,
                 guest_format: Optional[str] = None,
                 uuid: Optional[str] = None,
                 volume_size: Optional[int] = None):
        """
        :param str uuid: Specifies the network UUID to attach to the instance.
               Changing this creates a new instance.
        """
        pulumi.set(__self__, "source_type", source_type)
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if guest_format is not None:
            pulumi.set(__self__, "guest_format", guest_format)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[int]:
        return pulumi.get(self, "boot_index")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[str]:
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter(name="guestFormat")
    def guest_format(self) -> Optional[str]:
        return pulumi.get(self, "guest_format")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Specifies the network UUID to attach to the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        return pulumi.get(self, "volume_size")


@pulumi.output_type
class InstanceDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 snapshot_id: Optional[str] = None):
        """
        :param int size: Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
               This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        :param str type: Specifies the ECS data disk type, which must be one of available disk types,
               contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the ECS data disk type, which must be one of available disk types,
        contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class InstanceNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessNetwork":
            suggest = "access_network"
        elif key == "fixedIpV4":
            suggest = "fixed_ip_v4"
        elif key == "fixedIpV6":
            suggest = "fixed_ip_v6"
        elif key == "ipv6Enable":
            suggest = "ipv6_enable"
        elif key == "sourceDestCheck":
            suggest = "source_dest_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_network: Optional[bool] = None,
                 fixed_ip_v4: Optional[str] = None,
                 fixed_ip_v6: Optional[str] = None,
                 ipv6_enable: Optional[bool] = None,
                 mac: Optional[str] = None,
                 port: Optional[str] = None,
                 source_dest_check: Optional[bool] = None,
                 uuid: Optional[str] = None):
        """
        :param bool access_network: Specifies if this network should be used for provisioning access.
               Accepts true or false. Defaults to false.
        :param str fixed_ip_v4: Specifies a fixed IPv4 address to be used on this network.
               Changing this creates a new instance.
        :param bool ipv6_enable: Specifies whether the IPv6 function is enabled for the nic.
               Defaults to false. Changing this creates a new instance.
        :param bool source_dest_check: Specifies whether the ECS processes only traffic that is destined specifically
               for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
               virtual IP address bound to it.
        :param str uuid: Specifies the network UUID to attach to the instance.
               Changing this creates a new instance.
        """
        if access_network is not None:
            pulumi.set(__self__, "access_network", access_network)
        if fixed_ip_v4 is not None:
            pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        if fixed_ip_v6 is not None:
            pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="accessNetwork")
    def access_network(self) -> Optional[bool]:
        """
        Specifies if this network should be used for provisioning access.
        Accepts true or false. Defaults to false.
        """
        return pulumi.get(self, "access_network")

    @property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> Optional[str]:
        """
        Specifies a fixed IPv4 address to be used on this network.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> Optional[str]:
        return pulumi.get(self, "fixed_ip_v6")

    @property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[bool]:
        """
        Specifies whether the IPv6 function is enabled for the nic.
        Defaults to false. Changing this creates a new instance.
        """
        return pulumi.get(self, "ipv6_enable")

    @property
    @pulumi.getter
    def mac(self) -> Optional[str]:
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[bool]:
        """
        Specifies whether the ECS processes only traffic that is destined specifically
        for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
        virtual IP address bound to it.
        """
        return pulumi.get(self, "source_dest_check")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Specifies the network UUID to attach to the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class InstanceSchedulerHint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dehId":
            suggest = "deh_id"
        elif key == "faultDomain":
            suggest = "fault_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSchedulerHint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSchedulerHint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSchedulerHint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deh_id: Optional[str] = None,
                 fault_domain: Optional[str] = None,
                 group: Optional[str] = None,
                 tenancy: Optional[str] = None):
        """
        :param str deh_id: Specifies the ID of DeH.
               This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        :param str group: Specifies a UUID of a Server Group.
               The instance will be placed into that group. Changing this creates a new instance.
        :param str tenancy: Specifies the tenancy specifies whether the ECS is to be created on a
               Dedicated Host
               (DeH) or in a shared pool. Changing this creates a new instance.
        """
        if deh_id is not None:
            pulumi.set(__self__, "deh_id", deh_id)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)

    @property
    @pulumi.getter(name="dehId")
    def deh_id(self) -> Optional[str]:
        """
        Specifies the ID of DeH.
        This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        """
        return pulumi.get(self, "deh_id")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[str]:
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        """
        Specifies a UUID of a Server Group.
        The instance will be placed into that group. Changing this creates a new instance.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[str]:
        """
        Specifies the tenancy specifies whether the ECS is to be created on a
        Dedicated Host
        (DeH) or in a shared pool. Changing this creates a new instance.
        """
        return pulumi.get(self, "tenancy")


@pulumi.output_type
class InstanceVolumeAttached(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootIndex":
            suggest = "boot_index"
        elif key == "pciAddress":
            suggest = "pci_address"
        elif key == "volumeId":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceVolumeAttached. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceVolumeAttached.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceVolumeAttached.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_index: Optional[int] = None,
                 pci_address: Optional[str] = None,
                 size: Optional[int] = None,
                 type: Optional[str] = None,
                 volume_id: Optional[str] = None):
        """
        :param int size: Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
               This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        :param str type: Specifies the ECS data disk type, which must be one of available disk types,
               contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if pci_address is not None:
            pulumi.set(__self__, "pci_address", pci_address)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[int]:
        return pulumi.get(self, "boot_index")

    @property
    @pulumi.getter(name="pciAddress")
    def pci_address(self) -> Optional[str]:
        return pulumi.get(self, "pci_address")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the ECS data disk type, which must be one of available disk types,
        contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[str]:
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class GetInstanceNetworkResult(dict):
    def __init__(__self__, *,
                 fixed_ip_v4: str,
                 fixed_ip_v6: str,
                 mac: str,
                 port: str,
                 uuid: str):
        """
        :param str fixed_ip_v4: Specifies the IPv4 addresses of the ECS.
        :param str fixed_ip_v6: The Fixed IPv6 address of the instance on that network.
        :param str mac: The MAC address of the NIC on that network.
        :param str port: The port ID corresponding to the IP address on that network.
        :param str uuid: The network UUID to attach to the server.
        """
        pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> str:
        """
        Specifies the IPv4 addresses of the ECS.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> str:
        """
        The Fixed IPv6 address of the instance on that network.
        """
        return pulumi.get(self, "fixed_ip_v6")

    @property
    @pulumi.getter
    def mac(self) -> str:
        """
        The MAC address of the NIC on that network.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        The port ID corresponding to the IP address on that network.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        The network UUID to attach to the server.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetInstanceSchedulerHintResult(dict):
    def __init__(__self__, *,
                 group: str):
        """
        :param str group: The UUID of a Server Group where the instance will be placed into.
        """
        pulumi.set(__self__, "group", group)

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The UUID of a Server Group where the instance will be placed into.
        """
        return pulumi.get(self, "group")


@pulumi.output_type
class GetInstanceVolumeAttachedResult(dict):
    def __init__(__self__, *,
                 boot_index: int,
                 pci_address: str,
                 size: int,
                 type: str,
                 volume_id: str):
        """
        :param int boot_index: The volume boot index on that attachment.
        :param str pci_address: The volume pci address on that attachment.
        :param int size: The volume size on that attachment.
        :param str type: The volume type on that attachment.
        :param str volume_id: The volume id on that attachment.
        """
        pulumi.set(__self__, "boot_index", boot_index)
        pulumi.set(__self__, "pci_address", pci_address)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> int:
        """
        The volume boot index on that attachment.
        """
        return pulumi.get(self, "boot_index")

    @property
    @pulumi.getter(name="pciAddress")
    def pci_address(self) -> str:
        """
        The volume pci address on that attachment.
        """
        return pulumi.get(self, "pci_address")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The volume size on that attachment.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The volume type on that attachment.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> str:
        """
        The volume id on that attachment.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 enterprise_project_id: str,
                 flavor_id: str,
                 flavor_name: str,
                 id: str,
                 image_id: str,
                 key_pair: str,
                 name: str,
                 security_group_ids: Sequence[str],
                 status: str,
                 tags: Mapping[str, str],
                 user_data: str,
                 volume_attacheds: Sequence['outputs.GetInstancesInstanceVolumeAttachedResult'],
                 scheduler_hints: Optional[Sequence['outputs.GetInstancesInstanceSchedulerHintResult']] = None):
        """
        :param str availability_zone: Specifies the availability zone where the instance is located.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?ECS) for this argument.
        :param str enterprise_project_id: Specifies the enterprise project ID.
        :param str flavor_id: Specifies the flavor ID.
        :param str flavor_name: Specifies the flavor name of the instance.
        :param str id: The instance ID in UUID format.
        :param str image_id: Specifies the image ID of the instance.
        :param str key_pair: Specifies the key pair that is used to authenticate the instance.
        :param str name: Specifies the instance name, which can be queried with a regular expression.
               The instance name supports fuzzy matching query too.
        :param Sequence[str] security_group_ids: An array of one or more security group IDs to associate with the instance.
        :param str status: Specifies the status of the instance. The valid values are as follows:
               + **ACTIVE**: The instance is running properly.
               + **SHUTOFF**: The instance has been properly stopped.
               + **ERROR**: An error has occurred on the instance.
        :param Mapping[str, str] tags: The key/value pairs to associate with the instance.
        :param str user_data: The user data (information after encoding) configured during instance creation.
        :param Sequence['GetInstancesInstanceVolumeAttachedArgs'] volume_attacheds: An array of one or more disks to attach to the instance. The object structure is documented below.
        :param Sequence['GetInstancesInstanceSchedulerHintArgs'] scheduler_hints: The scheduler with hints on how the instance should be launched.
               The object structure is documented below.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "flavor_name", flavor_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "key_pair", key_pair)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_data", user_data)
        pulumi.set(__self__, "volume_attacheds", volume_attacheds)
        if scheduler_hints is not None:
            pulumi.set(__self__, "scheduler_hints", scheduler_hints)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Specifies the availability zone where the instance is located.
        Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?ECS) for this argument.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Specifies the enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> str:
        """
        Specifies the flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> str:
        """
        Specifies the flavor name of the instance.
        """
        return pulumi.get(self, "flavor_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The instance ID in UUID format.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        Specifies the image ID of the instance.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> str:
        """
        Specifies the key pair that is used to authenticate the instance.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the instance name, which can be queried with a regular expression.
        The instance name supports fuzzy matching query too.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        An array of one or more security group IDs to associate with the instance.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Specifies the status of the instance. The valid values are as follows:
        + **ACTIVE**: The instance is running properly.
        + **SHUTOFF**: The instance has been properly stopped.
        + **ERROR**: An error has occurred on the instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        The key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> str:
        """
        The user data (information after encoding) configured during instance creation.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="volumeAttacheds")
    def volume_attacheds(self) -> Sequence['outputs.GetInstancesInstanceVolumeAttachedResult']:
        """
        An array of one or more disks to attach to the instance. The object structure is documented below.
        """
        return pulumi.get(self, "volume_attacheds")

    @property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> Optional[Sequence['outputs.GetInstancesInstanceSchedulerHintResult']]:
        """
        The scheduler with hints on how the instance should be launched.
        The object structure is documented below.
        """
        return pulumi.get(self, "scheduler_hints")


@pulumi.output_type
class GetInstancesInstanceSchedulerHintResult(dict):
    def __init__(__self__, *,
                 group: str):
        """
        :param str group: The UUID of a server group where the instance will be placed into.
        """
        pulumi.set(__self__, "group", group)

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The UUID of a server group where the instance will be placed into.
        """
        return pulumi.get(self, "group")


@pulumi.output_type
class GetInstancesInstanceVolumeAttachedResult(dict):
    def __init__(__self__, *,
                 is_sys_volume: bool,
                 volume_id: str):
        """
        :param bool is_sys_volume: Whether the volume is the system disk.
        :param str volume_id: The volume id on that attachment.
        """
        pulumi.set(__self__, "is_sys_volume", is_sys_volume)
        pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="isSysVolume")
    def is_sys_volume(self) -> bool:
        """
        Whether the volume is the system disk.
        """
        return pulumi.get(self, "is_sys_volume")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> str:
        """
        The volume id on that attachment.
        """
        return pulumi.get(self, "volume_id")


