# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, availability_zone=None, enterprise_project_id=None, flavor_id=None, flavor_name=None, id=None, image_id=None, instances=None, key_pair=None, name=None, region=None, status=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name and not isinstance(flavor_name, str):
            raise TypeError("Expected argument 'flavor_name' to be a str")
        pulumi.set(__self__, "flavor_name", flavor_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if key_pair and not isinstance(key_pair, str):
            raise TypeError("Expected argument 'key_pair' to be a str")
        pulumi.set(__self__, "key_pair", key_pair)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        The availability zone where the instance is located.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[str]:
        """
        The flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[str]:
        """
        The flavor name of the instance.
        """
        return pulumi.get(self, "flavor_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[str]:
        """
        The image ID of the instance.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        List of ECS instance details. The object structure of each ECS instance is documented below.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[str]:
        """
        The key pair that is used to authenticate the instance.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The instance status.
        """
        return pulumi.get(self, "status")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            availability_zone=self.availability_zone,
            enterprise_project_id=self.enterprise_project_id,
            flavor_id=self.flavor_id,
            flavor_name=self.flavor_name,
            id=self.id,
            image_id=self.image_id,
            instances=self.instances,
            key_pair=self.key_pair,
            name=self.name,
            region=self.region,
            status=self.status)


def get_instances(availability_zone: Optional[str] = None,
                  enterprise_project_id: Optional[str] = None,
                  flavor_id: Optional[str] = None,
                  flavor_name: Optional[str] = None,
                  image_id: Optional[str] = None,
                  key_pair: Optional[str] = None,
                  name: Optional[str] = None,
                  region: Optional[str] = None,
                  status: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to get the list of the compute instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    name_regex = config.require_object("nameRegex")
    test = huaweicloud.Ecs.get_instances(name=name_regex)
    ```


    :param str availability_zone: Specifies the availability zone where the instance is located.
           Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?ECS) for this argument.
    :param str enterprise_project_id: Specifies the enterprise project ID.
    :param str flavor_id: Specifies the flavor ID.
    :param str flavor_name: Specifies the flavor name of the instance.
    :param str image_id: Specifies the image ID of the instance.
    :param str key_pair: Specifies the key pair that is used to authenticate the instance.
    :param str name: Specifies the instance name, which can be queried with a regular expression.
           The instance name supports fuzzy matching query too.
    :param str region: Specifies the region in which to obtain the instances.
           If omitted, the provider-level region will be used.
    :param str status: Specifies the status of the instance. The valid values are as follows:
           + **ACTIVE**: The instance is running properly.
           + **SHUTOFF**: The instance has been properly stopped.
           + **ERROR**: An error has occurred on the instance.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['flavorId'] = flavor_id
    __args__['flavorName'] = flavor_name
    __args__['imageId'] = image_id
    __args__['keyPair'] = key_pair
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Ecs/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        availability_zone=__ret__.availability_zone,
        enterprise_project_id=__ret__.enterprise_project_id,
        flavor_id=__ret__.flavor_id,
        flavor_name=__ret__.flavor_name,
        id=__ret__.id,
        image_id=__ret__.image_id,
        instances=__ret__.instances,
        key_pair=__ret__.key_pair,
        name=__ret__.name,
        region=__ret__.region,
        status=__ret__.status)


@_utilities.lift_output_func(get_instances)
def get_instances_output(availability_zone: Optional[pulumi.Input[Optional[str]]] = None,
                         enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                         flavor_id: Optional[pulumi.Input[Optional[str]]] = None,
                         flavor_name: Optional[pulumi.Input[Optional[str]]] = None,
                         image_id: Optional[pulumi.Input[Optional[str]]] = None,
                         key_pair: Optional[pulumi.Input[Optional[str]]] = None,
                         name: Optional[pulumi.Input[Optional[str]]] = None,
                         region: Optional[pulumi.Input[Optional[str]]] = None,
                         status: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to get the list of the compute instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    name_regex = config.require_object("nameRegex")
    test = huaweicloud.Ecs.get_instances(name=name_regex)
    ```


    :param str availability_zone: Specifies the availability zone where the instance is located.
           Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?ECS) for this argument.
    :param str enterprise_project_id: Specifies the enterprise project ID.
    :param str flavor_id: Specifies the flavor ID.
    :param str flavor_name: Specifies the flavor name of the instance.
    :param str image_id: Specifies the image ID of the instance.
    :param str key_pair: Specifies the key pair that is used to authenticate the instance.
    :param str name: Specifies the instance name, which can be queried with a regular expression.
           The instance name supports fuzzy matching query too.
    :param str region: Specifies the region in which to obtain the instances.
           If omitted, the provider-level region will be used.
    :param str status: Specifies the status of the instance. The valid values are as follows:
           + **ACTIVE**: The instance is running properly.
           + **SHUTOFF**: The instance has been properly stopped.
           + **ERROR**: An error has occurred on the instance.
    """
    ...
