# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 node_type: pulumi.Input[str],
                 number_of_node: pulumi.Input[int],
                 security_group_id: pulumi.Input[str],
                 user_name: pulumi.Input[str],
                 user_pwd: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_cn: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 public_ip: Optional[pulumi.Input['ClusterPublicIpArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] network_id: Network ID, which is used for configuring cluster network.
        :param pulumi.Input[str] node_type: Node type.
        :param pulumi.Input[int] number_of_node: Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
               add at least 3 nodes.
        :param pulumi.Input[str] security_group_id: ID of a security group. The ID is used for configuring cluster
               network.
        :param pulumi.Input[str] user_name: Administrator username for logging in to a data warehouse cluster The
               administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
               an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        :param pulumi.Input[str] user_pwd: Administrator password for logging in to a data warehouse cluster A password
               must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
               written in reverse order. Contains three types of the following:
               Lowercase letters Uppercase letters Digits Special characters
               ~!@#%^&*()-_=+|[{}];:,<.>/?
        :param pulumi.Input[str] vpc_id: VPC ID, which is used for configuring cluster network.
        :param pulumi.Input[str] availability_zone: AZ in a cluster.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the dws cluster,
               Value 0 indicates the default enterprise project.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        :param pulumi.Input[int] number_of_cn: Specifies the number of CN. If you use a large-scale cluster, deploy
               multiple CNs.
        :param pulumi.Input[int] port: Service port of a cluster (8000 to 10000). The default value is 8000.
        :param pulumi.Input['ClusterPublicIpArgs'] public_ip: A nested object resource Structure is documented below.
        :param pulumi.Input[str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the cluster.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "number_of_node", number_of_node)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_pwd", user_pwd)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_cn is not None:
            pulumi.set(__self__, "number_of_cn", number_of_cn)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        Network ID, which is used for configuring cluster network.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[str]:
        """
        Node type.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="numberOfNode")
    def number_of_node(self) -> pulumi.Input[int]:
        """
        Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
        add at least 3 nodes.
        """
        return pulumi.get(self, "number_of_node")

    @number_of_node.setter
    def number_of_node(self, value: pulumi.Input[int]):
        pulumi.set(self, "number_of_node", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        ID of a security group. The ID is used for configuring cluster
        network.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        Administrator username for logging in to a data warehouse cluster The
        administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
        an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="userPwd")
    def user_pwd(self) -> pulumi.Input[str]:
        """
        Administrator password for logging in to a data warehouse cluster A password
        must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
        written in reverse order. Contains three types of the following:
        Lowercase letters Uppercase letters Digits Special characters
        ~!@#%^&*()-_=+|[{}];:,<.>/?
        """
        return pulumi.get(self, "user_pwd")

    @user_pwd.setter
    def user_pwd(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pwd", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID, which is used for configuring cluster network.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        AZ in a cluster.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the dws cluster,
        Value 0 indicates the default enterprise project.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfCn")
    def number_of_cn(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of CN. If you use a large-scale cluster, deploy
        multiple CNs.
        """
        return pulumi.get(self, "number_of_cn")

    @number_of_cn.setter
    def number_of_cn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_cn", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Service port of a cluster (8000 to 10000). The default value is 8000.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['ClusterPublicIpArgs']]:
        """
        A nested object resource Structure is documented below.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['ClusterPublicIpArgs']]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 created: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 number_of_cn: Optional[pulumi.Input[int]] = None,
                 number_of_node: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPublicEndpointArgs']]]] = None,
                 public_ip: Optional[pulumi.Input['ClusterPublicIpArgs']] = None,
                 recent_event: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sub_status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 task_status: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 user_pwd: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] availability_zone: AZ in a cluster.
        :param pulumi.Input[str] created: Cluster creation time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]] endpoints: View the private network connection information about the cluster. Structure is documented below.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the dws cluster,
               Value 0 indicates the default enterprise project.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        :param pulumi.Input[str] network_id: Network ID, which is used for configuring cluster network.
        :param pulumi.Input[str] node_type: Node type.
        :param pulumi.Input[int] number_of_cn: Specifies the number of CN. If you use a large-scale cluster, deploy
               multiple CNs.
        :param pulumi.Input[int] number_of_node: Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
               add at least 3 nodes.
        :param pulumi.Input[int] port: Service port of a cluster (8000 to 10000). The default value is 8000.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: List of private network IP address.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPublicEndpointArgs']]] public_endpoints: Public network connection information about the cluster. If the value is not specified, the
               public network connection information is not used by default Structure is documented below.
        :param pulumi.Input['ClusterPublicIpArgs'] public_ip: A nested object resource Structure is documented below.
        :param pulumi.Input[int] recent_event: The recent event number.
        :param pulumi.Input[str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[str] security_group_id: ID of a security group. The ID is used for configuring cluster
               network.
        :param pulumi.Input[str] status: Cluster status, which can be one of the following:  CREATING AVAILABLE UNAVAILABLE CREATION FAILED.
        :param pulumi.Input[str] sub_status: Sub-status of clusters in the AVAILABLE state. The value can be one of the following:  NORMAL READONLY
               REDISTRIBUTING REDISTRIBUTION-FAILURE UNBALANCED UNBALANCED | READONLY DEGRADED DEGRADED | READONLY DEGRADED |
               UNBALANCED UNBALANCED | REDISTRIBUTING UNBALANCED | REDISTRIBUTION-FAILURE READONLY | REDISTRIBUTION-FAILURE
               UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED |
               REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the cluster.
        :param pulumi.Input[str] task_status: Cluster management task. The value can be one of the following:
               RESTORING SNAPSHOTTING GROWING REBOOTING SETTING_CONFIGURATION CONFIGURING_EXT_DATASOURCE DELETING_EXT_DATASOURCE
               REBOOT_FAILURE RESIZE_FAILURE
        :param pulumi.Input[str] updated: Last modification time of a cluster. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[str] user_name: Administrator username for logging in to a data warehouse cluster The
               administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
               an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        :param pulumi.Input[str] user_pwd: Administrator password for logging in to a data warehouse cluster A password
               must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
               written in reverse order. Contains three types of the following:
               Lowercase letters Uppercase letters Digits Special characters
               ~!@#%^&*()-_=+|[{}];:,<.>/?
        :param pulumi.Input[str] version: Data warehouse version.
        :param pulumi.Input[str] vpc_id: VPC ID, which is used for configuring cluster network.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if number_of_cn is not None:
            pulumi.set(__self__, "number_of_cn", number_of_cn)
        if number_of_node is not None:
            pulumi.set(__self__, "number_of_node", number_of_node)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_endpoints is not None:
            pulumi.set(__self__, "public_endpoints", public_endpoints)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if recent_event is not None:
            pulumi.set(__self__, "recent_event", recent_event)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_status is not None:
            pulumi.set(__self__, "sub_status", sub_status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_status is not None:
            pulumi.set(__self__, "task_status", task_status)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_pwd is not None:
            pulumi.set(__self__, "user_pwd", user_pwd)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        AZ in a cluster.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster creation time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]]:
        """
        View the private network connection information about the cluster. Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the dws cluster,
        Value 0 indicates the default enterprise project.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Network ID, which is used for configuring cluster network.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        Node type.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="numberOfCn")
    def number_of_cn(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of CN. If you use a large-scale cluster, deploy
        multiple CNs.
        """
        return pulumi.get(self, "number_of_cn")

    @number_of_cn.setter
    def number_of_cn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_cn", value)

    @property
    @pulumi.getter(name="numberOfNode")
    def number_of_node(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
        add at least 3 nodes.
        """
        return pulumi.get(self, "number_of_node")

    @number_of_node.setter
    def number_of_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_node", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Service port of a cluster (8000 to 10000). The default value is 8000.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of private network IP address.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="publicEndpoints")
    def public_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPublicEndpointArgs']]]]:
        """
        Public network connection information about the cluster. If the value is not specified, the
        public network connection information is not used by default Structure is documented below.
        """
        return pulumi.get(self, "public_endpoints")

    @public_endpoints.setter
    def public_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPublicEndpointArgs']]]]):
        pulumi.set(self, "public_endpoints", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['ClusterPublicIpArgs']]:
        """
        A nested object resource Structure is documented below.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['ClusterPublicIpArgs']]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="recentEvent")
    def recent_event(self) -> Optional[pulumi.Input[int]]:
        """
        The recent event number.
        """
        return pulumi.get(self, "recent_event")

    @recent_event.setter
    def recent_event(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recent_event", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of a security group. The ID is used for configuring cluster
        network.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster status, which can be one of the following:  CREATING AVAILABLE UNAVAILABLE CREATION FAILED.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> Optional[pulumi.Input[str]]:
        """
        Sub-status of clusters in the AVAILABLE state. The value can be one of the following:  NORMAL READONLY
        REDISTRIBUTING REDISTRIBUTION-FAILURE UNBALANCED UNBALANCED | READONLY DEGRADED DEGRADED | READONLY DEGRADED |
        UNBALANCED UNBALANCED | REDISTRIBUTING UNBALANCED | REDISTRIBUTION-FAILURE READONLY | REDISTRIBUTION-FAILURE
        UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED |
        REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY
        """
        return pulumi.get(self, "sub_status")

    @sub_status.setter
    def sub_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskStatus")
    def task_status(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster management task. The value can be one of the following:
        RESTORING SNAPSHOTTING GROWING REBOOTING SETTING_CONFIGURATION CONFIGURING_EXT_DATASOURCE DELETING_EXT_DATASOURCE
        REBOOT_FAILURE RESIZE_FAILURE
        """
        return pulumi.get(self, "task_status")

    @task_status.setter
    def task_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_status", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[str]]:
        """
        Last modification time of a cluster. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Administrator username for logging in to a data warehouse cluster The
        administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
        an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="userPwd")
    def user_pwd(self) -> Optional[pulumi.Input[str]]:
        """
        Administrator password for logging in to a data warehouse cluster A password
        must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
        written in reverse order. Contains three types of the following:
        Lowercase letters Uppercase letters Digits Special characters
        ~!@#%^&*()-_=+|[{}];:,<.>/?
        """
        return pulumi.get(self, "user_pwd")

    @user_pwd.setter
    def user_pwd(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_pwd", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Data warehouse version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC ID, which is used for configuring cluster network.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 number_of_cn: Optional[pulumi.Input[int]] = None,
                 number_of_node: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 public_ip: Optional[pulumi.Input[pulumi.InputType['ClusterPublicIpArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 user_pwd: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages Cluster in the Data Warehouse Service.

        ## Example Usage
        ### Dws Cluster Example

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        network_id = config.require_object("networkId")
        vpc_id = config.require_object("vpcId")
        user_name = config.require_object("userName")
        user_pwd = config.require_object("userPwd")
        dws_cluster_name = config.require_object("dwsClusterName")
        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="terraform security group")
        cluster = huaweicloud.dws.Cluster("cluster",
            node_type="dws.m3.xlarge",
            number_of_node=3,
            network_id=network_id,
            vpc_id=vpc_id,
            security_group_id=secgroup.id,
            availability_zone=availability_zone,
            user_name=user_name,
            user_pwd=user_pwd)
        ```

        ## Import

        Cluster can be imported using the following format

        ```sh
         $ pulumi import huaweicloud:Dws/cluster:Cluster test 47ad727e-9dcc-4833-bde0-bb298607c719
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`user_pwd`, `number_of_cn`. It is generally recommended running `terraform plan` after importing a cluster. You can then decide if changes should be applied to the cluster, or the resource definition should be updated to align with the cluster. Also you can ignore changes as below. resource "huaweicloud_dws_cluster" "test" {

         ...

         lifecycle {

         ignore_changes = [

         user_pwd, number_of_cn,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: AZ in a cluster.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the dws cluster,
               Value 0 indicates the default enterprise project.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        :param pulumi.Input[str] network_id: Network ID, which is used for configuring cluster network.
        :param pulumi.Input[str] node_type: Node type.
        :param pulumi.Input[int] number_of_cn: Specifies the number of CN. If you use a large-scale cluster, deploy
               multiple CNs.
        :param pulumi.Input[int] number_of_node: Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
               add at least 3 nodes.
        :param pulumi.Input[int] port: Service port of a cluster (8000 to 10000). The default value is 8000.
        :param pulumi.Input[pulumi.InputType['ClusterPublicIpArgs']] public_ip: A nested object resource Structure is documented below.
        :param pulumi.Input[str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[str] security_group_id: ID of a security group. The ID is used for configuring cluster
               network.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the cluster.
        :param pulumi.Input[str] user_name: Administrator username for logging in to a data warehouse cluster The
               administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
               an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        :param pulumi.Input[str] user_pwd: Administrator password for logging in to a data warehouse cluster A password
               must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
               written in reverse order. Contains three types of the following:
               Lowercase letters Uppercase letters Digits Special characters
               ~!@#%^&*()-_=+|[{}];:,<.>/?
        :param pulumi.Input[str] vpc_id: VPC ID, which is used for configuring cluster network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Cluster in the Data Warehouse Service.

        ## Example Usage
        ### Dws Cluster Example

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        network_id = config.require_object("networkId")
        vpc_id = config.require_object("vpcId")
        user_name = config.require_object("userName")
        user_pwd = config.require_object("userPwd")
        dws_cluster_name = config.require_object("dwsClusterName")
        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="terraform security group")
        cluster = huaweicloud.dws.Cluster("cluster",
            node_type="dws.m3.xlarge",
            number_of_node=3,
            network_id=network_id,
            vpc_id=vpc_id,
            security_group_id=secgroup.id,
            availability_zone=availability_zone,
            user_name=user_name,
            user_pwd=user_pwd)
        ```

        ## Import

        Cluster can be imported using the following format

        ```sh
         $ pulumi import huaweicloud:Dws/cluster:Cluster test 47ad727e-9dcc-4833-bde0-bb298607c719
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`user_pwd`, `number_of_cn`. It is generally recommended running `terraform plan` after importing a cluster. You can then decide if changes should be applied to the cluster, or the resource definition should be updated to align with the cluster. Also you can ignore changes as below. resource "huaweicloud_dws_cluster" "test" {

         ...

         lifecycle {

         ignore_changes = [

         user_pwd, number_of_cn,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 number_of_cn: Optional[pulumi.Input[int]] = None,
                 number_of_node: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 public_ip: Optional[pulumi.Input[pulumi.InputType['ClusterPublicIpArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 user_pwd: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["number_of_cn"] = number_of_cn
            if number_of_node is None and not opts.urn:
                raise TypeError("Missing required property 'number_of_node'")
            __props__.__dict__["number_of_node"] = number_of_node
            __props__.__dict__["port"] = port
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["tags"] = tags
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            if user_pwd is None and not opts.urn:
                raise TypeError("Missing required property 'user_pwd'")
            __props__.__dict__["user_pwd"] = user_pwd
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["public_endpoints"] = None
            __props__.__dict__["recent_event"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["sub_status"] = None
            __props__.__dict__["task_status"] = None
            __props__.__dict__["updated"] = None
            __props__.__dict__["version"] = None
        super(Cluster, __self__).__init__(
            'huaweicloud:Dws/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            created: Optional[pulumi.Input[str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterEndpointArgs']]]]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            number_of_cn: Optional[pulumi.Input[int]] = None,
            number_of_node: Optional[pulumi.Input[int]] = None,
            port: Optional[pulumi.Input[int]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            public_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterPublicEndpointArgs']]]]] = None,
            public_ip: Optional[pulumi.Input[pulumi.InputType['ClusterPublicIpArgs']]] = None,
            recent_event: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sub_status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            task_status: Optional[pulumi.Input[str]] = None,
            updated: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            user_pwd: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: AZ in a cluster.
        :param pulumi.Input[str] created: Cluster creation time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterEndpointArgs']]]] endpoints: View the private network connection information about the cluster. Structure is documented below.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the dws cluster,
               Value 0 indicates the default enterprise project.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        :param pulumi.Input[str] network_id: Network ID, which is used for configuring cluster network.
        :param pulumi.Input[str] node_type: Node type.
        :param pulumi.Input[int] number_of_cn: Specifies the number of CN. If you use a large-scale cluster, deploy
               multiple CNs.
        :param pulumi.Input[int] number_of_node: Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
               add at least 3 nodes.
        :param pulumi.Input[int] port: Service port of a cluster (8000 to 10000). The default value is 8000.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: List of private network IP address.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterPublicEndpointArgs']]]] public_endpoints: Public network connection information about the cluster. If the value is not specified, the
               public network connection information is not used by default Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterPublicIpArgs']] public_ip: A nested object resource Structure is documented below.
        :param pulumi.Input[int] recent_event: The recent event number.
        :param pulumi.Input[str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[str] security_group_id: ID of a security group. The ID is used for configuring cluster
               network.
        :param pulumi.Input[str] status: Cluster status, which can be one of the following:  CREATING AVAILABLE UNAVAILABLE CREATION FAILED.
        :param pulumi.Input[str] sub_status: Sub-status of clusters in the AVAILABLE state. The value can be one of the following:  NORMAL READONLY
               REDISTRIBUTING REDISTRIBUTION-FAILURE UNBALANCED UNBALANCED | READONLY DEGRADED DEGRADED | READONLY DEGRADED |
               UNBALANCED UNBALANCED | REDISTRIBUTING UNBALANCED | REDISTRIBUTION-FAILURE READONLY | REDISTRIBUTION-FAILURE
               UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED |
               REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the cluster.
        :param pulumi.Input[str] task_status: Cluster management task. The value can be one of the following:
               RESTORING SNAPSHOTTING GROWING REBOOTING SETTING_CONFIGURATION CONFIGURING_EXT_DATASOURCE DELETING_EXT_DATASOURCE
               REBOOT_FAILURE RESIZE_FAILURE
        :param pulumi.Input[str] updated: Last modification time of a cluster. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[str] user_name: Administrator username for logging in to a data warehouse cluster The
               administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
               an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        :param pulumi.Input[str] user_pwd: Administrator password for logging in to a data warehouse cluster A password
               must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
               written in reverse order. Contains three types of the following:
               Lowercase letters Uppercase letters Digits Special characters
               ~!@#%^&*()-_=+|[{}];:,<.>/?
        :param pulumi.Input[str] version: Data warehouse version.
        :param pulumi.Input[str] vpc_id: VPC ID, which is used for configuring cluster network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["created"] = created
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["number_of_cn"] = number_of_cn
        __props__.__dict__["number_of_node"] = number_of_node
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["public_endpoints"] = public_endpoints
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["recent_event"] = recent_event
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["sub_status"] = sub_status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["task_status"] = task_status
        __props__.__dict__["updated"] = updated
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["user_pwd"] = user_pwd
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        AZ in a cluster.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        Cluster creation time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterEndpoint']]:
        """
        View the private network connection information about the cluster. Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the dws cluster,
        Value 0 indicates the default enterprise project.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        Network ID, which is used for configuring cluster network.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        Node type.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numberOfCn")
    def number_of_cn(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the number of CN. If you use a large-scale cluster, deploy
        multiple CNs.
        """
        return pulumi.get(self, "number_of_cn")

    @property
    @pulumi.getter(name="numberOfNode")
    def number_of_node(self) -> pulumi.Output[int]:
        """
        Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
        add at least 3 nodes.
        """
        return pulumi.get(self, "number_of_node")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Service port of a cluster (8000 to 10000). The default value is 8000.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        List of private network IP address.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="publicEndpoints")
    def public_endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterPublicEndpoint']]:
        """
        Public network connection information about the cluster. If the value is not specified, the
        public network connection information is not used by default Structure is documented below.
        """
        return pulumi.get(self, "public_endpoints")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output['outputs.ClusterPublicIp']:
        """
        A nested object resource Structure is documented below.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="recentEvent")
    def recent_event(self) -> pulumi.Output[int]:
        """
        The recent event number.
        """
        return pulumi.get(self, "recent_event")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        ID of a security group. The ID is used for configuring cluster
        network.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Cluster status, which can be one of the following:  CREATING AVAILABLE UNAVAILABLE CREATION FAILED.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> pulumi.Output[str]:
        """
        Sub-status of clusters in the AVAILABLE state. The value can be one of the following:  NORMAL READONLY
        REDISTRIBUTING REDISTRIBUTION-FAILURE UNBALANCED UNBALANCED | READONLY DEGRADED DEGRADED | READONLY DEGRADED |
        UNBALANCED UNBALANCED | REDISTRIBUTING UNBALANCED | REDISTRIBUTION-FAILURE READONLY | REDISTRIBUTION-FAILURE
        UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED |
        REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY
        """
        return pulumi.get(self, "sub_status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskStatus")
    def task_status(self) -> pulumi.Output[str]:
        """
        Cluster management task. The value can be one of the following:
        RESTORING SNAPSHOTTING GROWING REBOOTING SETTING_CONFIGURATION CONFIGURING_EXT_DATASOURCE DELETING_EXT_DATASOURCE
        REBOOT_FAILURE RESIZE_FAILURE
        """
        return pulumi.get(self, "task_status")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        Last modification time of a cluster. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        Administrator username for logging in to a data warehouse cluster The
        administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
        an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userPwd")
    def user_pwd(self) -> pulumi.Output[str]:
        """
        Administrator password for logging in to a data warehouse cluster A password
        must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
        written in reverse order. Contains three types of the following:
        Lowercase letters Uppercase letters Digits Special characters
        ~!@#%^&*()-_=+|[{}];:,<.>/?
        """
        return pulumi.get(self, "user_pwd")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Data warehouse version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC ID, which is used for configuring cluster network.
        """
        return pulumi.get(self, "vpc_id")

