# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[str] description: A description of the zone.
        :param pulumi.Input[str] email: The email address of the administrator managing the zone.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the zone. Changing this creates a
               new zone.
        :param pulumi.Input[str] name: The name of the zone. Note the `.` at the end of the name. Changing this creates
               a new DNS zone.
        :param pulumi.Input[str] region: The region in which to create the DNS zone. If omitted, the `region` argument
               of the provider will be used. Changing this creates a new DNS zone.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]] routers: Router configuration block which is required if zone_type is private. The router
               structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the zone.
        :param pulumi.Input[int] ttl: The time to live (TTL) of the zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value_specs: Map of additional options. Changing this creates a new DNS zone.
        :param pulumi.Input[str] zone_type: The type of zone. Can either be `public` or `private`. Changing this
               creates a new DNS zone.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routers is not None:
            pulumi.set(__self__, "routers", routers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if value_specs is not None:
            pulumi.set(__self__, "value_specs", value_specs)
        if zone_type is not None:
            pulumi.set(__self__, "zone_type", zone_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the zone.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the administrator managing the zone.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the zone. Changing this creates a
        new zone.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the zone. Note the `.` at the end of the name. Changing this creates
        a new DNS zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DNS zone. If omitted, the `region` argument
        of the provider will be used. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def routers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]]:
        """
        Router configuration block which is required if zone_type is private. The router
        structure is documented below.
        """
        return pulumi.get(self, "routers")

    @routers.setter
    def routers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]]):
        pulumi.set(self, "routers", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the zone.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The time to live (TTL) of the zone.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of additional options. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "value_specs")

    @value_specs.setter
    def value_specs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "value_specs", value)

    @property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of zone. Can either be `public` or `private`. Changing this
        creates a new DNS zone.
        """
        return pulumi.get(self, "zone_type")

    @zone_type.setter
    def zone_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_type", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 masters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input[str] description: A description of the zone.
        :param pulumi.Input[str] email: The email address of the administrator managing the zone.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the zone. Changing this creates a
               new zone.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] masters: An array of master DNS servers.
        :param pulumi.Input[str] name: The name of the zone. Note the `.` at the end of the name. Changing this creates
               a new DNS zone.
        :param pulumi.Input[str] region: The region in which to create the DNS zone. If omitted, the `region` argument
               of the provider will be used. Changing this creates a new DNS zone.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]] routers: Router configuration block which is required if zone_type is private. The router
               structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the zone.
        :param pulumi.Input[int] ttl: The time to live (TTL) of the zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value_specs: Map of additional options. Changing this creates a new DNS zone.
        :param pulumi.Input[str] zone_type: The type of zone. Can either be `public` or `private`. Changing this
               creates a new DNS zone.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if masters is not None:
            pulumi.set(__self__, "masters", masters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routers is not None:
            pulumi.set(__self__, "routers", routers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if value_specs is not None:
            pulumi.set(__self__, "value_specs", value_specs)
        if zone_type is not None:
            pulumi.set(__self__, "zone_type", zone_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the zone.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the administrator managing the zone.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the zone. Changing this creates a
        new zone.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def masters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of master DNS servers.
        """
        return pulumi.get(self, "masters")

    @masters.setter
    def masters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "masters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the zone. Note the `.` at the end of the name. Changing this creates
        a new DNS zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DNS zone. If omitted, the `region` argument
        of the provider will be used. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def routers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]]:
        """
        Router configuration block which is required if zone_type is private. The router
        structure is documented below.
        """
        return pulumi.get(self, "routers")

    @routers.setter
    def routers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]]):
        pulumi.set(self, "routers", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the zone.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The time to live (TTL) of the zone.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of additional options. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "value_specs")

    @value_specs.setter
    def value_specs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "value_specs", value)

    @property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of zone. Can either be `public` or `private`. Changing this
        creates a new DNS zone.
        """
        return pulumi.get(self, "zone_type")

    @zone_type.setter
    def zone_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_type", value)


class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ZoneRouterArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a DNS zone in the HuaweiCloud DNS Service.

        ## Example Usage
        ### Create a public DNS zone

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_public_zone = huaweicloud.dns.Zone("myPublicZone",
            description="An example zone",
            email="jdoe@example.com",
            ttl=3000,
            zone_type="public")
        ```
        ### Create a private DNS zone

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_private_zone = huaweicloud.dns.Zone("myPrivateZone",
            description="An example zone",
            email="jdoe@example.com",
            routers=[huaweicloud.dns.ZoneRouterArgs(
                router_id="2c1fe4bd-ebad-44ca-ae9d-e94e63847b75",
            )],
            ttl=3000,
            zone_type="private")
        ```

        ## Import

        This resource can be imported by specifying the zone ID

        ```sh
         $ pulumi import huaweicloud:Dns/zone:Zone zone_1 <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the zone.
        :param pulumi.Input[str] email: The email address of the administrator managing the zone.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the zone. Changing this creates a
               new zone.
        :param pulumi.Input[str] name: The name of the zone. Note the `.` at the end of the name. Changing this creates
               a new DNS zone.
        :param pulumi.Input[str] region: The region in which to create the DNS zone. If omitted, the `region` argument
               of the provider will be used. Changing this creates a new DNS zone.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ZoneRouterArgs']]]] routers: Router configuration block which is required if zone_type is private. The router
               structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the zone.
        :param pulumi.Input[int] ttl: The time to live (TTL) of the zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value_specs: Map of additional options. Changing this creates a new DNS zone.
        :param pulumi.Input[str] zone_type: The type of zone. Can either be `public` or `private`. Changing this
               creates a new DNS zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ZoneArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DNS zone in the HuaweiCloud DNS Service.

        ## Example Usage
        ### Create a public DNS zone

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_public_zone = huaweicloud.dns.Zone("myPublicZone",
            description="An example zone",
            email="jdoe@example.com",
            ttl=3000,
            zone_type="public")
        ```
        ### Create a private DNS zone

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_private_zone = huaweicloud.dns.Zone("myPrivateZone",
            description="An example zone",
            email="jdoe@example.com",
            routers=[huaweicloud.dns.ZoneRouterArgs(
                router_id="2c1fe4bd-ebad-44ca-ae9d-e94e63847b75",
            )],
            ttl=3000,
            zone_type="private")
        ```

        ## Import

        This resource can be imported by specifying the zone ID

        ```sh
         $ pulumi import huaweicloud:Dns/zone:Zone zone_1 <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ZoneRouterArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["email"] = email
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["routers"] = routers
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["value_specs"] = value_specs
            __props__.__dict__["zone_type"] = zone_type
            __props__.__dict__["masters"] = None
        super(Zone, __self__).__init__(
            'huaweicloud:Dns/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            masters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            routers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ZoneRouterArgs']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ttl: Optional[pulumi.Input[int]] = None,
            value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            zone_type: Optional[pulumi.Input[str]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the zone.
        :param pulumi.Input[str] email: The email address of the administrator managing the zone.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the zone. Changing this creates a
               new zone.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] masters: An array of master DNS servers.
        :param pulumi.Input[str] name: The name of the zone. Note the `.` at the end of the name. Changing this creates
               a new DNS zone.
        :param pulumi.Input[str] region: The region in which to create the DNS zone. If omitted, the `region` argument
               of the provider will be used. Changing this creates a new DNS zone.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ZoneRouterArgs']]]] routers: Router configuration block which is required if zone_type is private. The router
               structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the zone.
        :param pulumi.Input[int] ttl: The time to live (TTL) of the zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value_specs: Map of additional options. Changing this creates a new DNS zone.
        :param pulumi.Input[str] zone_type: The type of zone. Can either be `public` or `private`. Changing this
               creates a new DNS zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["masters"] = masters
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["routers"] = routers
        __props__.__dict__["tags"] = tags
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["value_specs"] = value_specs
        __props__.__dict__["zone_type"] = zone_type
        return Zone(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the zone.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The email address of the administrator managing the zone.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the zone. Changing this creates a
        new zone.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def masters(self) -> pulumi.Output[Sequence[str]]:
        """
        An array of master DNS servers.
        """
        return pulumi.get(self, "masters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the zone. Note the `.` at the end of the name. Changing this creates
        a new DNS zone.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the DNS zone. If omitted, the `region` argument
        of the provider will be used. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def routers(self) -> pulumi.Output[Optional[Sequence['outputs.ZoneRouter']]]:
        """
        Router configuration block which is required if zone_type is private. The router
        structure is documented below.
        """
        return pulumi.get(self, "routers")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the zone.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The time to live (TTL) of the zone.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of additional options. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "value_specs")

    @property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of zone. Can either be `public` or `private`. Changing this
        creates a new DNS zone.
        """
        return pulumi.get(self, "zone_type")

