# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PtrrecordArgs', 'Ptrrecord']

@pulumi.input_type
class PtrrecordArgs:
    def __init__(__self__, *,
                 floatingip_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Ptrrecord resource.
        :param pulumi.Input[str] floatingip_id: The ID of the FloatingIP/EIP.
        :param pulumi.Input[str] description: Description of the PTR record.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the PTR record. Changing this
               creates a new PTR record.
        :param pulumi.Input[str] name: Domain name of the PTR record. A domain name is case insensitive. Uppercase letters will
               also be converted into lowercase letters.
        :param pulumi.Input[str] region: The region in which to create the PTR record. If omitted, the `region`
               argument of the provider will be used. Changing this creates a new PTR record.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags key/value pairs to associate with the PTR record.
        :param pulumi.Input[int] ttl: The time to live (TTL) of the record set (in seconds). The value range is 300–2147483647. The
               default value is 300.
        """
        pulumi.set(__self__, "floatingip_id", floatingip_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="floatingipId")
    def floatingip_id(self) -> pulumi.Input[str]:
        """
        The ID of the FloatingIP/EIP.
        """
        return pulumi.get(self, "floatingip_id")

    @floatingip_id.setter
    def floatingip_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "floatingip_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the PTR record.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the PTR record. Changing this
        creates a new PTR record.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of the PTR record. A domain name is case insensitive. Uppercase letters will
        also be converted into lowercase letters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the PTR record. If omitted, the `region`
        argument of the provider will be used. Changing this creates a new PTR record.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags key/value pairs to associate with the PTR record.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The time to live (TTL) of the record set (in seconds). The value range is 300–2147483647. The
        default value is 300.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _PtrrecordState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 floatingip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Ptrrecord resources.
        :param pulumi.Input[str] address: The address of the FloatingIP/EIP.
        :param pulumi.Input[str] description: Description of the PTR record.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the PTR record. Changing this
               creates a new PTR record.
        :param pulumi.Input[str] floatingip_id: The ID of the FloatingIP/EIP.
        :param pulumi.Input[str] name: Domain name of the PTR record. A domain name is case insensitive. Uppercase letters will
               also be converted into lowercase letters.
        :param pulumi.Input[str] region: The region in which to create the PTR record. If omitted, the `region`
               argument of the provider will be used. Changing this creates a new PTR record.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags key/value pairs to associate with the PTR record.
        :param pulumi.Input[int] ttl: The time to live (TTL) of the record set (in seconds). The value range is 300–2147483647. The
               default value is 300.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if floatingip_id is not None:
            pulumi.set(__self__, "floatingip_id", floatingip_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the FloatingIP/EIP.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the PTR record.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the PTR record. Changing this
        creates a new PTR record.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="floatingipId")
    def floatingip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the FloatingIP/EIP.
        """
        return pulumi.get(self, "floatingip_id")

    @floatingip_id.setter
    def floatingip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "floatingip_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of the PTR record. A domain name is case insensitive. Uppercase letters will
        also be converted into lowercase letters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the PTR record. If omitted, the `region`
        argument of the provider will be used. Changing this creates a new PTR record.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags key/value pairs to associate with the PTR record.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The time to live (TTL) of the record set (in seconds). The value range is 300–2147483647. The
        default value is 300.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


class Ptrrecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 floatingip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a DNS PTR record in the HuaweiCloud DNS Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        eip1 = huaweicloud.vpc.Eip("eip1",
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ),
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                name="test",
                size=5,
                share_type="PER",
                charge_mode="traffic",
            ))
        ptr1 = huaweicloud.dns.Ptrrecord("ptr1",
            description="An example PTR record",
            floatingip_id=eip1.id,
            ttl=3000,
            tags={
                "foo": "bar",
            })
        ```

        ## Import

        PTR records can be imported using region and floatingip/eip ID, separated by a colon(:), e.g.

        ```sh
         $ pulumi import huaweicloud:Dns/ptrrecord:Ptrrecord ptr_1 cn-north-1:d90ce693-5ccf-4136-a0ed-152ce412b6b9
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the PTR record.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the PTR record. Changing this
               creates a new PTR record.
        :param pulumi.Input[str] floatingip_id: The ID of the FloatingIP/EIP.
        :param pulumi.Input[str] name: Domain name of the PTR record. A domain name is case insensitive. Uppercase letters will
               also be converted into lowercase letters.
        :param pulumi.Input[str] region: The region in which to create the PTR record. If omitted, the `region`
               argument of the provider will be used. Changing this creates a new PTR record.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags key/value pairs to associate with the PTR record.
        :param pulumi.Input[int] ttl: The time to live (TTL) of the record set (in seconds). The value range is 300–2147483647. The
               default value is 300.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PtrrecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DNS PTR record in the HuaweiCloud DNS Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        eip1 = huaweicloud.vpc.Eip("eip1",
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ),
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                name="test",
                size=5,
                share_type="PER",
                charge_mode="traffic",
            ))
        ptr1 = huaweicloud.dns.Ptrrecord("ptr1",
            description="An example PTR record",
            floatingip_id=eip1.id,
            ttl=3000,
            tags={
                "foo": "bar",
            })
        ```

        ## Import

        PTR records can be imported using region and floatingip/eip ID, separated by a colon(:), e.g.

        ```sh
         $ pulumi import huaweicloud:Dns/ptrrecord:Ptrrecord ptr_1 cn-north-1:d90ce693-5ccf-4136-a0ed-152ce412b6b9
        ```

        :param str resource_name: The name of the resource.
        :param PtrrecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PtrrecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 floatingip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PtrrecordArgs.__new__(PtrrecordArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if floatingip_id is None and not opts.urn:
                raise TypeError("Missing required property 'floatingip_id'")
            __props__.__dict__["floatingip_id"] = floatingip_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["address"] = None
        super(Ptrrecord, __self__).__init__(
            'huaweicloud:Dns/ptrrecord:Ptrrecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            floatingip_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ttl: Optional[pulumi.Input[int]] = None) -> 'Ptrrecord':
        """
        Get an existing Ptrrecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The address of the FloatingIP/EIP.
        :param pulumi.Input[str] description: Description of the PTR record.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the PTR record. Changing this
               creates a new PTR record.
        :param pulumi.Input[str] floatingip_id: The ID of the FloatingIP/EIP.
        :param pulumi.Input[str] name: Domain name of the PTR record. A domain name is case insensitive. Uppercase letters will
               also be converted into lowercase letters.
        :param pulumi.Input[str] region: The region in which to create the PTR record. If omitted, the `region`
               argument of the provider will be used. Changing this creates a new PTR record.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags key/value pairs to associate with the PTR record.
        :param pulumi.Input[int] ttl: The time to live (TTL) of the record set (in seconds). The value range is 300–2147483647. The
               default value is 300.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PtrrecordState.__new__(_PtrrecordState)

        __props__.__dict__["address"] = address
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["floatingip_id"] = floatingip_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["ttl"] = ttl
        return Ptrrecord(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The address of the FloatingIP/EIP.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the PTR record.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the PTR record. Changing this
        creates a new PTR record.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="floatingipId")
    def floatingip_id(self) -> pulumi.Output[str]:
        """
        The ID of the FloatingIP/EIP.
        """
        return pulumi.get(self, "floatingip_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Domain name of the PTR record. A domain name is case insensitive. Uppercase letters will
        also be converted into lowercase letters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the PTR record. If omitted, the `region`
        argument of the provider will be used. Changing this creates a new PTR record.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Tags key/value pairs to associate with the PTR record.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The time to live (TTL) of the record set (in seconds). The value range is 300–2147483647. The
        default value is 300.
        """
        return pulumi.get(self, "ttl")

