# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlJobArgs', 'SqlJob']

@pulumi.input_type
class SqlJobArgs:
    def __init__(__self__, *,
                 sql: pulumi.Input[str],
                 conf: Optional[pulumi.Input['SqlJobConfArgs']] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SqlJob resource.
        :param pulumi.Input[str] sql: Specifies SQL statement that you want to execute.
               Changing this parameter will create a new resource.
        :param pulumi.Input['SqlJobConfArgs'] conf: Specifies the configuration parameters for the SQL job. Changing this parameter
               will create a new resource. Structure is documented below.
        :param pulumi.Input[str] database_name: Specifies the database where the SQL is executed. This argument does
               not need to be configured during database creation. Changing this parameter will create a new resource.
        :param pulumi.Input[str] queue_name: Specifies queue which this job to be submitted belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the DLI table resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies label of a Job. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "sql", sql)
        if conf is not None:
            pulumi.set(__self__, "conf", conf)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Input[str]:
        """
        Specifies SQL statement that you want to execute.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: pulumi.Input[str]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter
    def conf(self) -> Optional[pulumi.Input['SqlJobConfArgs']]:
        """
        Specifies the configuration parameters for the SQL job. Changing this parameter
        will create a new resource. Structure is documented below.
        """
        return pulumi.get(self, "conf")

    @conf.setter
    def conf(self, value: Optional[pulumi.Input['SqlJobConfArgs']]):
        pulumi.set(self, "conf", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database where the SQL is executed. This argument does
        not need to be configured during database creation. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies queue which this job to be submitted belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the DLI table resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies label of a Job. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SqlJobState:
    def __init__(__self__, *,
                 conf: Optional[pulumi.Input['SqlJobConfArgs']] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 job_type: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rows: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering SqlJob resources.
        :param pulumi.Input['SqlJobConfArgs'] conf: Specifies the configuration parameters for the SQL job. Changing this parameter
               will create a new resource. Structure is documented below.
        :param pulumi.Input[str] database_name: Specifies the database where the SQL is executed. This argument does
               not need to be configured during database creation. Changing this parameter will create a new resource.
        :param pulumi.Input[int] duration: Job running duration (unit: millisecond).
        :param pulumi.Input[str] job_type: Type of a job, Includes **DDL**, **DCL**, **IMPORT**, **EXPORT**, **QUERY**, **INSERT**,
               **DATA_MIGRATION**, **UPDATE**, **DELETE**, **RESTART_QUEUE** and **SCALE_QUEUE**.
        :param pulumi.Input[str] owner: User who submits a job.
        :param pulumi.Input[str] queue_name: Specifies queue which this job to be submitted belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the DLI table resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] rows: When the statement type is DDL, results of the DDL are displayed.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] schemas: When the statement type is DDL, the column name and type of DDL are displayed.
        :param pulumi.Input[str] sql: Specifies SQL statement that you want to execute.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] start_time: Time when a job is started, in RFC-3339 format. e.g. `2019-10-12T07:20:50.52Z`
        :param pulumi.Input[str] status: Status of a job, including **RUNNING**, **SCALING**, **LAUNCHING**, **FINISHED**, **FAILED**,
               and **CANCELLED.**
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies label of a Job. Changing this parameter will create a new resource.
        """
        if conf is not None:
            pulumi.set(__self__, "conf", conf)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rows is not None:
            pulumi.set(__self__, "rows", rows)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def conf(self) -> Optional[pulumi.Input['SqlJobConfArgs']]:
        """
        Specifies the configuration parameters for the SQL job. Changing this parameter
        will create a new resource. Structure is documented below.
        """
        return pulumi.get(self, "conf")

    @conf.setter
    def conf(self, value: Optional[pulumi.Input['SqlJobConfArgs']]):
        pulumi.set(self, "conf", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database where the SQL is executed. This argument does
        not need to be configured during database creation. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        """
        Job running duration (unit: millisecond).
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of a job, Includes **DDL**, **DCL**, **IMPORT**, **EXPORT**, **QUERY**, **INSERT**,
        **DATA_MIGRATION**, **UPDATE**, **DELETE**, **RESTART_QUEUE** and **SCALE_QUEUE**.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        User who submits a job.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies queue which this job to be submitted belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the DLI table resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def rows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        When the statement type is DDL, results of the DDL are displayed.
        """
        return pulumi.get(self, "rows")

    @rows.setter
    def rows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "rows", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        When the statement type is DDL, the column name and type of DDL are displayed.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies SQL statement that you want to execute.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when a job is started, in RFC-3339 format. e.g. `2019-10-12T07:20:50.52Z`
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of a job, including **RUNNING**, **SCALING**, **LAUNCHING**, **FINISHED**, **FAILED**,
        and **CANCELLED.**
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies label of a Job. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class SqlJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conf: Optional[pulumi.Input[pulumi.InputType['SqlJobConfArgs']]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages DLI SQL job resource within HuaweiCloud

        ## Example Usage
        ### Create a Sql job

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        database_name = config.require_object("databaseName")
        queue_name = config.require_object("queueName")
        sql = config.require_object("sql")
        test = huaweicloud.dli.SqlJob("test",
            sql=sql,
            database_name=database_name,
            queue_name=queue_name)
        ```

        ## Import

        DLI SQL job can be imported by `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/sqlJob:SqlJob example 7f803d70-c533-469f-8431-e378f3e97123
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`conf`, `rows` and `schema`. It is generally recommended running `terraform plan` after importing a resource. You can then decide if changes should be applied to the resource, or the resource definition should be updated to align with the resource. Also you can ignore changes as below. resource "huaweicloud_dli_sql_job" "test" {

         ...

         lifecycle {

         ignore_changes = [

         conf, rows, schema

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SqlJobConfArgs']] conf: Specifies the configuration parameters for the SQL job. Changing this parameter
               will create a new resource. Structure is documented below.
        :param pulumi.Input[str] database_name: Specifies the database where the SQL is executed. This argument does
               not need to be configured during database creation. Changing this parameter will create a new resource.
        :param pulumi.Input[str] queue_name: Specifies queue which this job to be submitted belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the DLI table resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] sql: Specifies SQL statement that you want to execute.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies label of a Job. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DLI SQL job resource within HuaweiCloud

        ## Example Usage
        ### Create a Sql job

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        database_name = config.require_object("databaseName")
        queue_name = config.require_object("queueName")
        sql = config.require_object("sql")
        test = huaweicloud.dli.SqlJob("test",
            sql=sql,
            database_name=database_name,
            queue_name=queue_name)
        ```

        ## Import

        DLI SQL job can be imported by `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/sqlJob:SqlJob example 7f803d70-c533-469f-8431-e378f3e97123
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`conf`, `rows` and `schema`. It is generally recommended running `terraform plan` after importing a resource. You can then decide if changes should be applied to the resource, or the resource definition should be updated to align with the resource. Also you can ignore changes as below. resource "huaweicloud_dli_sql_job" "test" {

         ...

         lifecycle {

         ignore_changes = [

         conf, rows, schema

         ]

         } }

        :param str resource_name: The name of the resource.
        :param SqlJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conf: Optional[pulumi.Input[pulumi.InputType['SqlJobConfArgs']]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlJobArgs.__new__(SqlJobArgs)

            __props__.__dict__["conf"] = conf
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["queue_name"] = queue_name
            __props__.__dict__["region"] = region
            if sql is None and not opts.urn:
                raise TypeError("Missing required property 'sql'")
            __props__.__dict__["sql"] = sql
            __props__.__dict__["tags"] = tags
            __props__.__dict__["duration"] = None
            __props__.__dict__["job_type"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["rows"] = None
            __props__.__dict__["schemas"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["status"] = None
        super(SqlJob, __self__).__init__(
            'huaweicloud:Dli/sqlJob:SqlJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conf: Optional[pulumi.Input[pulumi.InputType['SqlJobConfArgs']]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            duration: Optional[pulumi.Input[int]] = None,
            job_type: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            queue_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rows: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
            sql: Optional[pulumi.Input[str]] = None,
            start_time: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'SqlJob':
        """
        Get an existing SqlJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['SqlJobConfArgs']] conf: Specifies the configuration parameters for the SQL job. Changing this parameter
               will create a new resource. Structure is documented below.
        :param pulumi.Input[str] database_name: Specifies the database where the SQL is executed. This argument does
               not need to be configured during database creation. Changing this parameter will create a new resource.
        :param pulumi.Input[int] duration: Job running duration (unit: millisecond).
        :param pulumi.Input[str] job_type: Type of a job, Includes **DDL**, **DCL**, **IMPORT**, **EXPORT**, **QUERY**, **INSERT**,
               **DATA_MIGRATION**, **UPDATE**, **DELETE**, **RESTART_QUEUE** and **SCALE_QUEUE**.
        :param pulumi.Input[str] owner: User who submits a job.
        :param pulumi.Input[str] queue_name: Specifies queue which this job to be submitted belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the DLI table resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] rows: When the statement type is DDL, results of the DDL are displayed.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] schemas: When the statement type is DDL, the column name and type of DDL are displayed.
        :param pulumi.Input[str] sql: Specifies SQL statement that you want to execute.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] start_time: Time when a job is started, in RFC-3339 format. e.g. `2019-10-12T07:20:50.52Z`
        :param pulumi.Input[str] status: Status of a job, including **RUNNING**, **SCALING**, **LAUNCHING**, **FINISHED**, **FAILED**,
               and **CANCELLED.**
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies label of a Job. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlJobState.__new__(_SqlJobState)

        __props__.__dict__["conf"] = conf
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["duration"] = duration
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["owner"] = owner
        __props__.__dict__["queue_name"] = queue_name
        __props__.__dict__["region"] = region
        __props__.__dict__["rows"] = rows
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["sql"] = sql
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return SqlJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def conf(self) -> pulumi.Output[Optional['outputs.SqlJobConf']]:
        """
        Specifies the configuration parameters for the SQL job. Changing this parameter
        will create a new resource. Structure is documented below.
        """
        return pulumi.get(self, "conf")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the database where the SQL is executed. This argument does
        not need to be configured during database creation. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Output[int]:
        """
        Job running duration (unit: millisecond).
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[str]:
        """
        Type of a job, Includes **DDL**, **DCL**, **IMPORT**, **EXPORT**, **QUERY**, **INSERT**,
        **DATA_MIGRATION**, **UPDATE**, **DELETE**, **RESTART_QUEUE** and **SCALE_QUEUE**.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        """
        User who submits a job.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[str]:
        """
        Specifies queue which this job to be submitted belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the DLI table resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def rows(self) -> pulumi.Output[Sequence[Sequence[str]]]:
        """
        When the statement type is DDL, results of the DDL are displayed.
        """
        return pulumi.get(self, "rows")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[Mapping[str, str]]]:
        """
        When the statement type is DDL, the column name and type of DDL are displayed.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Output[str]:
        """
        Specifies SQL statement that you want to execute.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sql")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        Time when a job is started, in RFC-3339 format. e.g. `2019-10-12T07:20:50.52Z`
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of a job, including **RUNNING**, **SCALING**, **LAUNCHING**, **FINISHED**, **FAILED**,
        and **CANCELLED.**
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies label of a Job. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

