# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['FlinkjarJobArgs', 'FlinkjarJob']

@pulumi.input_type
class FlinkjarJobArgs:
    def __init__(__self__, *,
                 checkpoint_path: Optional[pulumi.Input[str]] = None,
                 cu_num: Optional[pulumi.Input[int]] = None,
                 dependency_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dependency_jars: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 entrypoint_args: Optional[pulumi.Input[str]] = None,
                 feature: Optional[pulumi.Input[str]] = None,
                 flink_version: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 manager_cu_num: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obs_bucket: Optional[pulumi.Input[str]] = None,
                 parallel_num: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restart_when_exception: Optional[pulumi.Input[bool]] = None,
                 resume_checkpoint: Optional[pulumi.Input[bool]] = None,
                 resume_max_num: Optional[pulumi.Input[int]] = None,
                 runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tm_cu_num: Optional[pulumi.Input[int]] = None,
                 tm_slot_num: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a FlinkjarJob resource.
        :param pulumi.Input[str] checkpoint_path: Specifies storage address of the checkpoint in the JAR file of the user.
               The path must be unique.
        :param pulumi.Input[int] cu_num: Specifies number of CUs selected for a job. The default value is `2`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dependency_files: Specifies dependency files. It is the name of the package that has been
               uploaded to the DLI.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dependency_jars: Specifies other dependency jars. It is the name of the package that
               has been uploaded to the DLI.
        :param pulumi.Input[str] description: Specifies job description. Length range: 1 to 512 characters.
        :param pulumi.Input[str] entrypoint: Specifies the JAR file where the job main class is located. It is the name of the
               package that has been uploaded to the DLI.
        :param pulumi.Input[str] entrypoint_args: Specifies job entry arguments. Multiple arguments are separated by spaces.
               The arguments are keys followed by values. Keys have to start with '-' or '--'.
        :param pulumi.Input[str] feature: Specifies job feature. Type of the Flink image used by a job.
               + **basic**: indicates that the basic Flink image provided by DLI is used.
               + **custom**: indicates that the user-defined Flink image is used.
        :param pulumi.Input[str] flink_version: Specifies flink version. This parameter is valid only when feature is set
               to basic. You can use this parameter with the feature parameter to specify the version of the DLI basic Flink image
               used for job running. The options are as follows: `1.10` and `1.7`.
        :param pulumi.Input[str] image: Specifies custom image. The format is Organization name/Image name:Image version.
               This parameter is valid only when feature is set to `custom`. You can use this parameter with the feature parameter
               to specify a user-defined Flink image for job running. For details about how to use custom images, see the
               Data Lake Insight User Guide <https://support.huaweicloud.com/en-us/usermanual-dli/dli_01_0494.html>.
        :param pulumi.Input[bool] log_enabled: Specifies whether to enable the function of uploading job logs to users' OBS buckets.
               The default value is `false`.
        :param pulumi.Input[str] main_class: Specifies job entry class. Default main class is specified by the Manifest file
               of the application.
        :param pulumi.Input[int] manager_cu_num: Specifies number of CUs in the JobManager selected for a job.
               The default value is `1`.
        :param pulumi.Input[str] name: Specifies the name of the job. Length range: 1 to 57 characters.
               Which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] obs_bucket: Specifies OBS path. OBS path where users are authorized to save the log.
               This parameter is valid only when `log_enabled` is set to `true`.
        :param pulumi.Input[int] parallel_num: Specifies number of parallel for a job. The default value is `1`.
        :param pulumi.Input[str] queue_name: Specifies the name of DLI queue which this job run in. The type of queue
               must be `general`.
        :param pulumi.Input[str] region: The region in which to create the DLI flink job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] restart_when_exception: Specifies whether to enable the function of restart upon exceptions.
               The default value is `false`.
        :param pulumi.Input[bool] resume_checkpoint: Specifies whether the abnormal restart is recovered from the checkpoint.
        :param pulumi.Input[int] resume_max_num: Specifies maximum number of retry times upon exceptions. The unit is
               `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
               unlimited.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] runtime_config: Specifies customizes optimization parameters when a Flink job is running.
        :param pulumi.Input[str] smn_topic: Specifies SMN topic. If a job fails, the system will send a message to users
               subscribed to the SMN topic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the resource.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] tm_cu_num: Specifies number of CUs for each TaskManager. The default value is `1`.
        :param pulumi.Input[int] tm_slot_num: Specifies number of slots in each TaskManager.
               The default value is `(parallel_num * tm_cu_num) / (cu_num - manager_cu_num)`.
        """
        if checkpoint_path is not None:
            pulumi.set(__self__, "checkpoint_path", checkpoint_path)
        if cu_num is not None:
            pulumi.set(__self__, "cu_num", cu_num)
        if dependency_files is not None:
            pulumi.set(__self__, "dependency_files", dependency_files)
        if dependency_jars is not None:
            pulumi.set(__self__, "dependency_jars", dependency_jars)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if entrypoint_args is not None:
            pulumi.set(__self__, "entrypoint_args", entrypoint_args)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if flink_version is not None:
            pulumi.set(__self__, "flink_version", flink_version)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if manager_cu_num is not None:
            pulumi.set(__self__, "manager_cu_num", manager_cu_num)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if obs_bucket is not None:
            pulumi.set(__self__, "obs_bucket", obs_bucket)
        if parallel_num is not None:
            pulumi.set(__self__, "parallel_num", parallel_num)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restart_when_exception is not None:
            pulumi.set(__self__, "restart_when_exception", restart_when_exception)
        if resume_checkpoint is not None:
            pulumi.set(__self__, "resume_checkpoint", resume_checkpoint)
        if resume_max_num is not None:
            pulumi.set(__self__, "resume_max_num", resume_max_num)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if smn_topic is not None:
            pulumi.set(__self__, "smn_topic", smn_topic)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tm_cu_num is not None:
            pulumi.set(__self__, "tm_cu_num", tm_cu_num)
        if tm_slot_num is not None:
            pulumi.set(__self__, "tm_slot_num", tm_slot_num)

    @property
    @pulumi.getter(name="checkpointPath")
    def checkpoint_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies storage address of the checkpoint in the JAR file of the user.
        The path must be unique.
        """
        return pulumi.get(self, "checkpoint_path")

    @checkpoint_path.setter
    def checkpoint_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint_path", value)

    @property
    @pulumi.getter(name="cuNum")
    def cu_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs selected for a job. The default value is `2`.
        """
        return pulumi.get(self, "cu_num")

    @cu_num.setter
    def cu_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cu_num", value)

    @property
    @pulumi.getter(name="dependencyFiles")
    def dependency_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies dependency files. It is the name of the package that has been
        uploaded to the DLI.
        """
        return pulumi.get(self, "dependency_files")

    @dependency_files.setter
    def dependency_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dependency_files", value)

    @property
    @pulumi.getter(name="dependencyJars")
    def dependency_jars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies other dependency jars. It is the name of the package that
        has been uploaded to the DLI.
        """
        return pulumi.get(self, "dependency_jars")

    @dependency_jars.setter
    def dependency_jars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dependency_jars", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job description. Length range: 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the JAR file where the job main class is located. It is the name of the
        package that has been uploaded to the DLI.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="entrypointArgs")
    def entrypoint_args(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job entry arguments. Multiple arguments are separated by spaces.
        The arguments are keys followed by values. Keys have to start with '-' or '--'.
        """
        return pulumi.get(self, "entrypoint_args")

    @entrypoint_args.setter
    def entrypoint_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint_args", value)

    @property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job feature. Type of the Flink image used by a job.
        + **basic**: indicates that the basic Flink image provided by DLI is used.
        + **custom**: indicates that the user-defined Flink image is used.
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature", value)

    @property
    @pulumi.getter(name="flinkVersion")
    def flink_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies flink version. This parameter is valid only when feature is set
        to basic. You can use this parameter with the feature parameter to specify the version of the DLI basic Flink image
        used for job running. The options are as follows: `1.10` and `1.7`.
        """
        return pulumi.get(self, "flink_version")

    @flink_version.setter
    def flink_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flink_version", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies custom image. The format is Organization name/Image name:Image version.
        This parameter is valid only when feature is set to `custom`. You can use this parameter with the feature parameter
        to specify a user-defined Flink image for job running. For details about how to use custom images, see the
        Data Lake Insight User Guide <https://support.huaweicloud.com/en-us/usermanual-dli/dli_01_0494.html>.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the function of uploading job logs to users' OBS buckets.
        The default value is `false`.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job entry class. Default main class is specified by the Manifest file
        of the application.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="managerCuNum")
    def manager_cu_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs in the JobManager selected for a job.
        The default value is `1`.
        """
        return pulumi.get(self, "manager_cu_num")

    @manager_cu_num.setter
    def manager_cu_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manager_cu_num", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the job. Length range: 1 to 57 characters.
        Which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="obsBucket")
    def obs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies OBS path. OBS path where users are authorized to save the log.
        This parameter is valid only when `log_enabled` is set to `true`.
        """
        return pulumi.get(self, "obs_bucket")

    @obs_bucket.setter
    def obs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "obs_bucket", value)

    @property
    @pulumi.getter(name="parallelNum")
    def parallel_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of parallel for a job. The default value is `1`.
        """
        return pulumi.get(self, "parallel_num")

    @parallel_num.setter
    def parallel_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallel_num", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of DLI queue which this job run in. The type of queue
        must be `general`.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DLI flink job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restartWhenException")
    def restart_when_exception(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the function of restart upon exceptions.
        The default value is `false`.
        """
        return pulumi.get(self, "restart_when_exception")

    @restart_when_exception.setter
    def restart_when_exception(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restart_when_exception", value)

    @property
    @pulumi.getter(name="resumeCheckpoint")
    def resume_checkpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the abnormal restart is recovered from the checkpoint.
        """
        return pulumi.get(self, "resume_checkpoint")

    @resume_checkpoint.setter
    def resume_checkpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resume_checkpoint", value)

    @property
    @pulumi.getter(name="resumeMaxNum")
    def resume_max_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies maximum number of retry times upon exceptions. The unit is
        `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
        unlimited.
        """
        return pulumi.get(self, "resume_max_num")

    @resume_max_num.setter
    def resume_max_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resume_max_num", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies customizes optimization parameters when a Flink job is running.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies SMN topic. If a job fails, the system will send a message to users
        subscribed to the SMN topic.
        """
        return pulumi.get(self, "smn_topic")

    @smn_topic.setter
    def smn_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smn_topic", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the resource.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tmCuNum")
    def tm_cu_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs for each TaskManager. The default value is `1`.
        """
        return pulumi.get(self, "tm_cu_num")

    @tm_cu_num.setter
    def tm_cu_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tm_cu_num", value)

    @property
    @pulumi.getter(name="tmSlotNum")
    def tm_slot_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of slots in each TaskManager.
        The default value is `(parallel_num * tm_cu_num) / (cu_num - manager_cu_num)`.
        """
        return pulumi.get(self, "tm_slot_num")

    @tm_slot_num.setter
    def tm_slot_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tm_slot_num", value)


@pulumi.input_type
class _FlinkjarJobState:
    def __init__(__self__, *,
                 checkpoint_path: Optional[pulumi.Input[str]] = None,
                 cu_num: Optional[pulumi.Input[int]] = None,
                 dependency_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dependency_jars: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 entrypoint_args: Optional[pulumi.Input[str]] = None,
                 feature: Optional[pulumi.Input[str]] = None,
                 flink_version: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 manager_cu_num: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obs_bucket: Optional[pulumi.Input[str]] = None,
                 parallel_num: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restart_when_exception: Optional[pulumi.Input[bool]] = None,
                 resume_checkpoint: Optional[pulumi.Input[bool]] = None,
                 resume_max_num: Optional[pulumi.Input[int]] = None,
                 runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tm_cu_num: Optional[pulumi.Input[int]] = None,
                 tm_slot_num: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering FlinkjarJob resources.
        :param pulumi.Input[str] checkpoint_path: Specifies storage address of the checkpoint in the JAR file of the user.
               The path must be unique.
        :param pulumi.Input[int] cu_num: Specifies number of CUs selected for a job. The default value is `2`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dependency_files: Specifies dependency files. It is the name of the package that has been
               uploaded to the DLI.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dependency_jars: Specifies other dependency jars. It is the name of the package that
               has been uploaded to the DLI.
        :param pulumi.Input[str] description: Specifies job description. Length range: 1 to 512 characters.
        :param pulumi.Input[str] entrypoint: Specifies the JAR file where the job main class is located. It is the name of the
               package that has been uploaded to the DLI.
        :param pulumi.Input[str] entrypoint_args: Specifies job entry arguments. Multiple arguments are separated by spaces.
               The arguments are keys followed by values. Keys have to start with '-' or '--'.
        :param pulumi.Input[str] feature: Specifies job feature. Type of the Flink image used by a job.
               + **basic**: indicates that the basic Flink image provided by DLI is used.
               + **custom**: indicates that the user-defined Flink image is used.
        :param pulumi.Input[str] flink_version: Specifies flink version. This parameter is valid only when feature is set
               to basic. You can use this parameter with the feature parameter to specify the version of the DLI basic Flink image
               used for job running. The options are as follows: `1.10` and `1.7`.
        :param pulumi.Input[str] image: Specifies custom image. The format is Organization name/Image name:Image version.
               This parameter is valid only when feature is set to `custom`. You can use this parameter with the feature parameter
               to specify a user-defined Flink image for job running. For details about how to use custom images, see the
               Data Lake Insight User Guide <https://support.huaweicloud.com/en-us/usermanual-dli/dli_01_0494.html>.
        :param pulumi.Input[bool] log_enabled: Specifies whether to enable the function of uploading job logs to users' OBS buckets.
               The default value is `false`.
        :param pulumi.Input[str] main_class: Specifies job entry class. Default main class is specified by the Manifest file
               of the application.
        :param pulumi.Input[int] manager_cu_num: Specifies number of CUs in the JobManager selected for a job.
               The default value is `1`.
        :param pulumi.Input[str] name: Specifies the name of the job. Length range: 1 to 57 characters.
               Which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] obs_bucket: Specifies OBS path. OBS path where users are authorized to save the log.
               This parameter is valid only when `log_enabled` is set to `true`.
        :param pulumi.Input[int] parallel_num: Specifies number of parallel for a job. The default value is `1`.
        :param pulumi.Input[str] queue_name: Specifies the name of DLI queue which this job run in. The type of queue
               must be `general`.
        :param pulumi.Input[str] region: The region in which to create the DLI flink job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] restart_when_exception: Specifies whether to enable the function of restart upon exceptions.
               The default value is `false`.
        :param pulumi.Input[bool] resume_checkpoint: Specifies whether the abnormal restart is recovered from the checkpoint.
        :param pulumi.Input[int] resume_max_num: Specifies maximum number of retry times upon exceptions. The unit is
               `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
               unlimited.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] runtime_config: Specifies customizes optimization parameters when a Flink job is running.
        :param pulumi.Input[str] smn_topic: Specifies SMN topic. If a job fails, the system will send a message to users
               subscribed to the SMN topic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the resource.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] tm_cu_num: Specifies number of CUs for each TaskManager. The default value is `1`.
        :param pulumi.Input[int] tm_slot_num: Specifies number of slots in each TaskManager.
               The default value is `(parallel_num * tm_cu_num) / (cu_num - manager_cu_num)`.
        """
        if checkpoint_path is not None:
            pulumi.set(__self__, "checkpoint_path", checkpoint_path)
        if cu_num is not None:
            pulumi.set(__self__, "cu_num", cu_num)
        if dependency_files is not None:
            pulumi.set(__self__, "dependency_files", dependency_files)
        if dependency_jars is not None:
            pulumi.set(__self__, "dependency_jars", dependency_jars)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if entrypoint_args is not None:
            pulumi.set(__self__, "entrypoint_args", entrypoint_args)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if flink_version is not None:
            pulumi.set(__self__, "flink_version", flink_version)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if manager_cu_num is not None:
            pulumi.set(__self__, "manager_cu_num", manager_cu_num)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if obs_bucket is not None:
            pulumi.set(__self__, "obs_bucket", obs_bucket)
        if parallel_num is not None:
            pulumi.set(__self__, "parallel_num", parallel_num)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restart_when_exception is not None:
            pulumi.set(__self__, "restart_when_exception", restart_when_exception)
        if resume_checkpoint is not None:
            pulumi.set(__self__, "resume_checkpoint", resume_checkpoint)
        if resume_max_num is not None:
            pulumi.set(__self__, "resume_max_num", resume_max_num)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if smn_topic is not None:
            pulumi.set(__self__, "smn_topic", smn_topic)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tm_cu_num is not None:
            pulumi.set(__self__, "tm_cu_num", tm_cu_num)
        if tm_slot_num is not None:
            pulumi.set(__self__, "tm_slot_num", tm_slot_num)

    @property
    @pulumi.getter(name="checkpointPath")
    def checkpoint_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies storage address of the checkpoint in the JAR file of the user.
        The path must be unique.
        """
        return pulumi.get(self, "checkpoint_path")

    @checkpoint_path.setter
    def checkpoint_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint_path", value)

    @property
    @pulumi.getter(name="cuNum")
    def cu_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs selected for a job. The default value is `2`.
        """
        return pulumi.get(self, "cu_num")

    @cu_num.setter
    def cu_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cu_num", value)

    @property
    @pulumi.getter(name="dependencyFiles")
    def dependency_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies dependency files. It is the name of the package that has been
        uploaded to the DLI.
        """
        return pulumi.get(self, "dependency_files")

    @dependency_files.setter
    def dependency_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dependency_files", value)

    @property
    @pulumi.getter(name="dependencyJars")
    def dependency_jars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies other dependency jars. It is the name of the package that
        has been uploaded to the DLI.
        """
        return pulumi.get(self, "dependency_jars")

    @dependency_jars.setter
    def dependency_jars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dependency_jars", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job description. Length range: 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the JAR file where the job main class is located. It is the name of the
        package that has been uploaded to the DLI.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="entrypointArgs")
    def entrypoint_args(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job entry arguments. Multiple arguments are separated by spaces.
        The arguments are keys followed by values. Keys have to start with '-' or '--'.
        """
        return pulumi.get(self, "entrypoint_args")

    @entrypoint_args.setter
    def entrypoint_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint_args", value)

    @property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job feature. Type of the Flink image used by a job.
        + **basic**: indicates that the basic Flink image provided by DLI is used.
        + **custom**: indicates that the user-defined Flink image is used.
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature", value)

    @property
    @pulumi.getter(name="flinkVersion")
    def flink_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies flink version. This parameter is valid only when feature is set
        to basic. You can use this parameter with the feature parameter to specify the version of the DLI basic Flink image
        used for job running. The options are as follows: `1.10` and `1.7`.
        """
        return pulumi.get(self, "flink_version")

    @flink_version.setter
    def flink_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flink_version", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies custom image. The format is Organization name/Image name:Image version.
        This parameter is valid only when feature is set to `custom`. You can use this parameter with the feature parameter
        to specify a user-defined Flink image for job running. For details about how to use custom images, see the
        Data Lake Insight User Guide <https://support.huaweicloud.com/en-us/usermanual-dli/dli_01_0494.html>.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the function of uploading job logs to users' OBS buckets.
        The default value is `false`.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job entry class. Default main class is specified by the Manifest file
        of the application.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="managerCuNum")
    def manager_cu_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs in the JobManager selected for a job.
        The default value is `1`.
        """
        return pulumi.get(self, "manager_cu_num")

    @manager_cu_num.setter
    def manager_cu_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manager_cu_num", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the job. Length range: 1 to 57 characters.
        Which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="obsBucket")
    def obs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies OBS path. OBS path where users are authorized to save the log.
        This parameter is valid only when `log_enabled` is set to `true`.
        """
        return pulumi.get(self, "obs_bucket")

    @obs_bucket.setter
    def obs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "obs_bucket", value)

    @property
    @pulumi.getter(name="parallelNum")
    def parallel_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of parallel for a job. The default value is `1`.
        """
        return pulumi.get(self, "parallel_num")

    @parallel_num.setter
    def parallel_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallel_num", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of DLI queue which this job run in. The type of queue
        must be `general`.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DLI flink job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restartWhenException")
    def restart_when_exception(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the function of restart upon exceptions.
        The default value is `false`.
        """
        return pulumi.get(self, "restart_when_exception")

    @restart_when_exception.setter
    def restart_when_exception(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restart_when_exception", value)

    @property
    @pulumi.getter(name="resumeCheckpoint")
    def resume_checkpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the abnormal restart is recovered from the checkpoint.
        """
        return pulumi.get(self, "resume_checkpoint")

    @resume_checkpoint.setter
    def resume_checkpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resume_checkpoint", value)

    @property
    @pulumi.getter(name="resumeMaxNum")
    def resume_max_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies maximum number of retry times upon exceptions. The unit is
        `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
        unlimited.
        """
        return pulumi.get(self, "resume_max_num")

    @resume_max_num.setter
    def resume_max_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resume_max_num", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies customizes optimization parameters when a Flink job is running.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies SMN topic. If a job fails, the system will send a message to users
        subscribed to the SMN topic.
        """
        return pulumi.get(self, "smn_topic")

    @smn_topic.setter
    def smn_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smn_topic", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the resource.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tmCuNum")
    def tm_cu_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs for each TaskManager. The default value is `1`.
        """
        return pulumi.get(self, "tm_cu_num")

    @tm_cu_num.setter
    def tm_cu_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tm_cu_num", value)

    @property
    @pulumi.getter(name="tmSlotNum")
    def tm_slot_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of slots in each TaskManager.
        The default value is `(parallel_num * tm_cu_num) / (cu_num - manager_cu_num)`.
        """
        return pulumi.get(self, "tm_slot_num")

    @tm_slot_num.setter
    def tm_slot_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tm_slot_num", value)


class FlinkjarJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint_path: Optional[pulumi.Input[str]] = None,
                 cu_num: Optional[pulumi.Input[int]] = None,
                 dependency_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dependency_jars: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 entrypoint_args: Optional[pulumi.Input[str]] = None,
                 feature: Optional[pulumi.Input[str]] = None,
                 flink_version: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 manager_cu_num: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obs_bucket: Optional[pulumi.Input[str]] = None,
                 parallel_num: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restart_when_exception: Optional[pulumi.Input[bool]] = None,
                 resume_checkpoint: Optional[pulumi.Input[bool]] = None,
                 resume_max_num: Optional[pulumi.Input[int]] = None,
                 runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tm_cu_num: Optional[pulumi.Input[int]] = None,
                 tm_slot_num: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a flink job resource which type is `Flink Jar` within HuaweiCloud DLI.

        ## Example Usage
        ### Create a flink job

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        name = config.require_object("name")
        queue_name = config.require_object("queueName")
        jar_obs_path = config.require_object("jarObsPath")
        entrypoint_args = config.require_object("entrypointArgs")
        test_package = huaweicloud.dli.Package("testPackage",
            group_name="jarPackage",
            type="jar",
            object_path=jar_obs_path)
        test_flinkjar_job = huaweicloud.dli.FlinkjarJob("testFlinkjarJob",
            queue_name=queue_name,
            entrypoint=pulumi.Output.all(test_package.group_name, test_package.object_name).apply(lambda group_name, object_name: f"{group_name}/{object_name}"),
            entrypoint_args=entrypoint_args,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        The job can be imported by `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/flinkjarJob:FlinkjarJob test 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] checkpoint_path: Specifies storage address of the checkpoint in the JAR file of the user.
               The path must be unique.
        :param pulumi.Input[int] cu_num: Specifies number of CUs selected for a job. The default value is `2`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dependency_files: Specifies dependency files. It is the name of the package that has been
               uploaded to the DLI.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dependency_jars: Specifies other dependency jars. It is the name of the package that
               has been uploaded to the DLI.
        :param pulumi.Input[str] description: Specifies job description. Length range: 1 to 512 characters.
        :param pulumi.Input[str] entrypoint: Specifies the JAR file where the job main class is located. It is the name of the
               package that has been uploaded to the DLI.
        :param pulumi.Input[str] entrypoint_args: Specifies job entry arguments. Multiple arguments are separated by spaces.
               The arguments are keys followed by values. Keys have to start with '-' or '--'.
        :param pulumi.Input[str] feature: Specifies job feature. Type of the Flink image used by a job.
               + **basic**: indicates that the basic Flink image provided by DLI is used.
               + **custom**: indicates that the user-defined Flink image is used.
        :param pulumi.Input[str] flink_version: Specifies flink version. This parameter is valid only when feature is set
               to basic. You can use this parameter with the feature parameter to specify the version of the DLI basic Flink image
               used for job running. The options are as follows: `1.10` and `1.7`.
        :param pulumi.Input[str] image: Specifies custom image. The format is Organization name/Image name:Image version.
               This parameter is valid only when feature is set to `custom`. You can use this parameter with the feature parameter
               to specify a user-defined Flink image for job running. For details about how to use custom images, see the
               Data Lake Insight User Guide <https://support.huaweicloud.com/en-us/usermanual-dli/dli_01_0494.html>.
        :param pulumi.Input[bool] log_enabled: Specifies whether to enable the function of uploading job logs to users' OBS buckets.
               The default value is `false`.
        :param pulumi.Input[str] main_class: Specifies job entry class. Default main class is specified by the Manifest file
               of the application.
        :param pulumi.Input[int] manager_cu_num: Specifies number of CUs in the JobManager selected for a job.
               The default value is `1`.
        :param pulumi.Input[str] name: Specifies the name of the job. Length range: 1 to 57 characters.
               Which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] obs_bucket: Specifies OBS path. OBS path where users are authorized to save the log.
               This parameter is valid only when `log_enabled` is set to `true`.
        :param pulumi.Input[int] parallel_num: Specifies number of parallel for a job. The default value is `1`.
        :param pulumi.Input[str] queue_name: Specifies the name of DLI queue which this job run in. The type of queue
               must be `general`.
        :param pulumi.Input[str] region: The region in which to create the DLI flink job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] restart_when_exception: Specifies whether to enable the function of restart upon exceptions.
               The default value is `false`.
        :param pulumi.Input[bool] resume_checkpoint: Specifies whether the abnormal restart is recovered from the checkpoint.
        :param pulumi.Input[int] resume_max_num: Specifies maximum number of retry times upon exceptions. The unit is
               `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
               unlimited.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] runtime_config: Specifies customizes optimization parameters when a Flink job is running.
        :param pulumi.Input[str] smn_topic: Specifies SMN topic. If a job fails, the system will send a message to users
               subscribed to the SMN topic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the resource.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] tm_cu_num: Specifies number of CUs for each TaskManager. The default value is `1`.
        :param pulumi.Input[int] tm_slot_num: Specifies number of slots in each TaskManager.
               The default value is `(parallel_num * tm_cu_num) / (cu_num - manager_cu_num)`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FlinkjarJobArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a flink job resource which type is `Flink Jar` within HuaweiCloud DLI.

        ## Example Usage
        ### Create a flink job

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        name = config.require_object("name")
        queue_name = config.require_object("queueName")
        jar_obs_path = config.require_object("jarObsPath")
        entrypoint_args = config.require_object("entrypointArgs")
        test_package = huaweicloud.dli.Package("testPackage",
            group_name="jarPackage",
            type="jar",
            object_path=jar_obs_path)
        test_flinkjar_job = huaweicloud.dli.FlinkjarJob("testFlinkjarJob",
            queue_name=queue_name,
            entrypoint=pulumi.Output.all(test_package.group_name, test_package.object_name).apply(lambda group_name, object_name: f"{group_name}/{object_name}"),
            entrypoint_args=entrypoint_args,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        The job can be imported by `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/flinkjarJob:FlinkjarJob test 12345
        ```

        :param str resource_name: The name of the resource.
        :param FlinkjarJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkjarJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint_path: Optional[pulumi.Input[str]] = None,
                 cu_num: Optional[pulumi.Input[int]] = None,
                 dependency_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dependency_jars: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 entrypoint_args: Optional[pulumi.Input[str]] = None,
                 feature: Optional[pulumi.Input[str]] = None,
                 flink_version: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 manager_cu_num: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obs_bucket: Optional[pulumi.Input[str]] = None,
                 parallel_num: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restart_when_exception: Optional[pulumi.Input[bool]] = None,
                 resume_checkpoint: Optional[pulumi.Input[bool]] = None,
                 resume_max_num: Optional[pulumi.Input[int]] = None,
                 runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tm_cu_num: Optional[pulumi.Input[int]] = None,
                 tm_slot_num: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkjarJobArgs.__new__(FlinkjarJobArgs)

            __props__.__dict__["checkpoint_path"] = checkpoint_path
            __props__.__dict__["cu_num"] = cu_num
            __props__.__dict__["dependency_files"] = dependency_files
            __props__.__dict__["dependency_jars"] = dependency_jars
            __props__.__dict__["description"] = description
            __props__.__dict__["entrypoint"] = entrypoint
            __props__.__dict__["entrypoint_args"] = entrypoint_args
            __props__.__dict__["feature"] = feature
            __props__.__dict__["flink_version"] = flink_version
            __props__.__dict__["image"] = image
            __props__.__dict__["log_enabled"] = log_enabled
            __props__.__dict__["main_class"] = main_class
            __props__.__dict__["manager_cu_num"] = manager_cu_num
            __props__.__dict__["name"] = name
            __props__.__dict__["obs_bucket"] = obs_bucket
            __props__.__dict__["parallel_num"] = parallel_num
            __props__.__dict__["queue_name"] = queue_name
            __props__.__dict__["region"] = region
            __props__.__dict__["restart_when_exception"] = restart_when_exception
            __props__.__dict__["resume_checkpoint"] = resume_checkpoint
            __props__.__dict__["resume_max_num"] = resume_max_num
            __props__.__dict__["runtime_config"] = runtime_config
            __props__.__dict__["smn_topic"] = smn_topic
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tm_cu_num"] = tm_cu_num
            __props__.__dict__["tm_slot_num"] = tm_slot_num
            __props__.__dict__["status"] = None
        super(FlinkjarJob, __self__).__init__(
            'huaweicloud:Dli/flinkjarJob:FlinkjarJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checkpoint_path: Optional[pulumi.Input[str]] = None,
            cu_num: Optional[pulumi.Input[int]] = None,
            dependency_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dependency_jars: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            entrypoint: Optional[pulumi.Input[str]] = None,
            entrypoint_args: Optional[pulumi.Input[str]] = None,
            feature: Optional[pulumi.Input[str]] = None,
            flink_version: Optional[pulumi.Input[str]] = None,
            image: Optional[pulumi.Input[str]] = None,
            log_enabled: Optional[pulumi.Input[bool]] = None,
            main_class: Optional[pulumi.Input[str]] = None,
            manager_cu_num: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            obs_bucket: Optional[pulumi.Input[str]] = None,
            parallel_num: Optional[pulumi.Input[int]] = None,
            queue_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            restart_when_exception: Optional[pulumi.Input[bool]] = None,
            resume_checkpoint: Optional[pulumi.Input[bool]] = None,
            resume_max_num: Optional[pulumi.Input[int]] = None,
            runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            smn_topic: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tm_cu_num: Optional[pulumi.Input[int]] = None,
            tm_slot_num: Optional[pulumi.Input[int]] = None) -> 'FlinkjarJob':
        """
        Get an existing FlinkjarJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] checkpoint_path: Specifies storage address of the checkpoint in the JAR file of the user.
               The path must be unique.
        :param pulumi.Input[int] cu_num: Specifies number of CUs selected for a job. The default value is `2`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dependency_files: Specifies dependency files. It is the name of the package that has been
               uploaded to the DLI.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dependency_jars: Specifies other dependency jars. It is the name of the package that
               has been uploaded to the DLI.
        :param pulumi.Input[str] description: Specifies job description. Length range: 1 to 512 characters.
        :param pulumi.Input[str] entrypoint: Specifies the JAR file where the job main class is located. It is the name of the
               package that has been uploaded to the DLI.
        :param pulumi.Input[str] entrypoint_args: Specifies job entry arguments. Multiple arguments are separated by spaces.
               The arguments are keys followed by values. Keys have to start with '-' or '--'.
        :param pulumi.Input[str] feature: Specifies job feature. Type of the Flink image used by a job.
               + **basic**: indicates that the basic Flink image provided by DLI is used.
               + **custom**: indicates that the user-defined Flink image is used.
        :param pulumi.Input[str] flink_version: Specifies flink version. This parameter is valid only when feature is set
               to basic. You can use this parameter with the feature parameter to specify the version of the DLI basic Flink image
               used for job running. The options are as follows: `1.10` and `1.7`.
        :param pulumi.Input[str] image: Specifies custom image. The format is Organization name/Image name:Image version.
               This parameter is valid only when feature is set to `custom`. You can use this parameter with the feature parameter
               to specify a user-defined Flink image for job running. For details about how to use custom images, see the
               Data Lake Insight User Guide <https://support.huaweicloud.com/en-us/usermanual-dli/dli_01_0494.html>.
        :param pulumi.Input[bool] log_enabled: Specifies whether to enable the function of uploading job logs to users' OBS buckets.
               The default value is `false`.
        :param pulumi.Input[str] main_class: Specifies job entry class. Default main class is specified by the Manifest file
               of the application.
        :param pulumi.Input[int] manager_cu_num: Specifies number of CUs in the JobManager selected for a job.
               The default value is `1`.
        :param pulumi.Input[str] name: Specifies the name of the job. Length range: 1 to 57 characters.
               Which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] obs_bucket: Specifies OBS path. OBS path where users are authorized to save the log.
               This parameter is valid only when `log_enabled` is set to `true`.
        :param pulumi.Input[int] parallel_num: Specifies number of parallel for a job. The default value is `1`.
        :param pulumi.Input[str] queue_name: Specifies the name of DLI queue which this job run in. The type of queue
               must be `general`.
        :param pulumi.Input[str] region: The region in which to create the DLI flink job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] restart_when_exception: Specifies whether to enable the function of restart upon exceptions.
               The default value is `false`.
        :param pulumi.Input[bool] resume_checkpoint: Specifies whether the abnormal restart is recovered from the checkpoint.
        :param pulumi.Input[int] resume_max_num: Specifies maximum number of retry times upon exceptions. The unit is
               `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
               unlimited.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] runtime_config: Specifies customizes optimization parameters when a Flink job is running.
        :param pulumi.Input[str] smn_topic: Specifies SMN topic. If a job fails, the system will send a message to users
               subscribed to the SMN topic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the resource.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] tm_cu_num: Specifies number of CUs for each TaskManager. The default value is `1`.
        :param pulumi.Input[int] tm_slot_num: Specifies number of slots in each TaskManager.
               The default value is `(parallel_num * tm_cu_num) / (cu_num - manager_cu_num)`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkjarJobState.__new__(_FlinkjarJobState)

        __props__.__dict__["checkpoint_path"] = checkpoint_path
        __props__.__dict__["cu_num"] = cu_num
        __props__.__dict__["dependency_files"] = dependency_files
        __props__.__dict__["dependency_jars"] = dependency_jars
        __props__.__dict__["description"] = description
        __props__.__dict__["entrypoint"] = entrypoint
        __props__.__dict__["entrypoint_args"] = entrypoint_args
        __props__.__dict__["feature"] = feature
        __props__.__dict__["flink_version"] = flink_version
        __props__.__dict__["image"] = image
        __props__.__dict__["log_enabled"] = log_enabled
        __props__.__dict__["main_class"] = main_class
        __props__.__dict__["manager_cu_num"] = manager_cu_num
        __props__.__dict__["name"] = name
        __props__.__dict__["obs_bucket"] = obs_bucket
        __props__.__dict__["parallel_num"] = parallel_num
        __props__.__dict__["queue_name"] = queue_name
        __props__.__dict__["region"] = region
        __props__.__dict__["restart_when_exception"] = restart_when_exception
        __props__.__dict__["resume_checkpoint"] = resume_checkpoint
        __props__.__dict__["resume_max_num"] = resume_max_num
        __props__.__dict__["runtime_config"] = runtime_config
        __props__.__dict__["smn_topic"] = smn_topic
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tm_cu_num"] = tm_cu_num
        __props__.__dict__["tm_slot_num"] = tm_slot_num
        return FlinkjarJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="checkpointPath")
    def checkpoint_path(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies storage address of the checkpoint in the JAR file of the user.
        The path must be unique.
        """
        return pulumi.get(self, "checkpoint_path")

    @property
    @pulumi.getter(name="cuNum")
    def cu_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies number of CUs selected for a job. The default value is `2`.
        """
        return pulumi.get(self, "cu_num")

    @property
    @pulumi.getter(name="dependencyFiles")
    def dependency_files(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies dependency files. It is the name of the package that has been
        uploaded to the DLI.
        """
        return pulumi.get(self, "dependency_files")

    @property
    @pulumi.getter(name="dependencyJars")
    def dependency_jars(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies other dependency jars. It is the name of the package that
        has been uploaded to the DLI.
        """
        return pulumi.get(self, "dependency_jars")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies job description. Length range: 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def entrypoint(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the JAR file where the job main class is located. It is the name of the
        package that has been uploaded to the DLI.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter(name="entrypointArgs")
    def entrypoint_args(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies job entry arguments. Multiple arguments are separated by spaces.
        The arguments are keys followed by values. Keys have to start with '-' or '--'.
        """
        return pulumi.get(self, "entrypoint_args")

    @property
    @pulumi.getter
    def feature(self) -> pulumi.Output[str]:
        """
        Specifies job feature. Type of the Flink image used by a job.
        + **basic**: indicates that the basic Flink image provided by DLI is used.
        + **custom**: indicates that the user-defined Flink image is used.
        """
        return pulumi.get(self, "feature")

    @property
    @pulumi.getter(name="flinkVersion")
    def flink_version(self) -> pulumi.Output[str]:
        """
        Specifies flink version. This parameter is valid only when feature is set
        to basic. You can use this parameter with the feature parameter to specify the version of the DLI basic Flink image
        used for job running. The options are as follows: `1.10` and `1.7`.
        """
        return pulumi.get(self, "flink_version")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies custom image. The format is Organization name/Image name:Image version.
        This parameter is valid only when feature is set to `custom`. You can use this parameter with the feature parameter
        to specify a user-defined Flink image for job running. For details about how to use custom images, see the
        Data Lake Insight User Guide <https://support.huaweicloud.com/en-us/usermanual-dli/dli_01_0494.html>.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the function of uploading job logs to users' OBS buckets.
        The default value is `false`.
        """
        return pulumi.get(self, "log_enabled")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies job entry class. Default main class is specified by the Manifest file
        of the application.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="managerCuNum")
    def manager_cu_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies number of CUs in the JobManager selected for a job.
        The default value is `1`.
        """
        return pulumi.get(self, "manager_cu_num")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the job. Length range: 1 to 57 characters.
        Which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="obsBucket")
    def obs_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies OBS path. OBS path where users are authorized to save the log.
        This parameter is valid only when `log_enabled` is set to `true`.
        """
        return pulumi.get(self, "obs_bucket")

    @property
    @pulumi.getter(name="parallelNum")
    def parallel_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies number of parallel for a job. The default value is `1`.
        """
        return pulumi.get(self, "parallel_num")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of DLI queue which this job run in. The type of queue
        must be `general`.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the DLI flink job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restartWhenException")
    def restart_when_exception(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the function of restart upon exceptions.
        The default value is `false`.
        """
        return pulumi.get(self, "restart_when_exception")

    @property
    @pulumi.getter(name="resumeCheckpoint")
    def resume_checkpoint(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the abnormal restart is recovered from the checkpoint.
        """
        return pulumi.get(self, "resume_checkpoint")

    @property
    @pulumi.getter(name="resumeMaxNum")
    def resume_max_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies maximum number of retry times upon exceptions. The unit is
        `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
        unlimited.
        """
        return pulumi.get(self, "resume_max_num")

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies customizes optimization parameters when a Flink job is running.
        """
        return pulumi.get(self, "runtime_config")

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies SMN topic. If a job fails, the system will send a message to users
        subscribed to the SMN topic.
        """
        return pulumi.get(self, "smn_topic")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the resource.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tmCuNum")
    def tm_cu_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies number of CUs for each TaskManager. The default value is `1`.
        """
        return pulumi.get(self, "tm_cu_num")

    @property
    @pulumi.getter(name="tmSlotNum")
    def tm_slot_num(self) -> pulumi.Output[int]:
        """
        Specifies number of slots in each TaskManager.
        The default value is `(parallel_num * tm_cu_num) / (cu_num - manager_cu_num)`.
        """
        return pulumi.get(self, "tm_slot_num")

