# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretArgs', 'Secret']

@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 secret_text: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Secret resource.
        :param pulumi.Input[str] secret_text: The plaintext of a secret in text format. The maximum size is 32 KB.
        :param pulumi.Input[str] description: The description of a secret.
        :param pulumi.Input[str] name: The secret name. The maximum length is 64 characters.
               Only digits, letters, underscores(_), hyphens(-) and dots(.) are allowed.
        :param pulumi.Input[str] region: The region in which to create the CSMS secrets.
               If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of a CSMS secrets, key/value pair format.
        """
        pulumi.set(__self__, "secret_text", secret_text)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="secretText")
    def secret_text(self) -> pulumi.Input[str]:
        """
        The plaintext of a secret in text format. The maximum size is 32 KB.
        """
        return pulumi.get(self, "secret_text")

    @secret_text.setter
    def secret_text(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_text", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of a secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The secret name. The maximum length is 64 characters.
        Only digits, letters, underscores(_), hyphens(-) and dots(.) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the CSMS secrets.
        If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags of a CSMS secrets, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SecretState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 latest_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_text: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Secret resources.
        :param pulumi.Input[str] create_time: Time when the CSMS secrets created, in UTC format.
        :param pulumi.Input[str] description: The description of a secret.
        :param pulumi.Input[str] latest_version: The latest version id.
        :param pulumi.Input[str] name: The secret name. The maximum length is 64 characters.
               Only digits, letters, underscores(_), hyphens(-) and dots(.) are allowed.
        :param pulumi.Input[str] region: The region in which to create the CSMS secrets.
               If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        :param pulumi.Input[str] secret_id: The secret ID in UUID format.
        :param pulumi.Input[str] secret_text: The plaintext of a secret in text format. The maximum size is 32 KB.
        :param pulumi.Input[str] status: The CSMS secret status. Values can be: ENABLED, DISABLED, PENDING_DELETE and FROZEN.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of a CSMS secrets, key/value pair format.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_text is not None:
            pulumi.set(__self__, "secret_text", secret_text)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the CSMS secrets created, in UTC format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of a secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[str]]:
        """
        The latest version id.
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The secret name. The maximum length is 64 characters.
        Only digits, letters, underscores(_), hyphens(-) and dots(.) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the CSMS secrets.
        If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The secret ID in UUID format.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="secretText")
    def secret_text(self) -> Optional[pulumi.Input[str]]:
        """
        The plaintext of a secret in text format. The maximum size is 32 KB.
        """
        return pulumi.get(self, "secret_text")

    @secret_text.setter
    def secret_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_text", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The CSMS secret status. Values can be: ENABLED, DISABLED, PENDING_DELETE and FROZEN.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags of a CSMS secrets, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Secret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_text: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages CSMS(Cloud Secret Management Service) secrets within HuaweiCloud.

        ## Example Usage
        ### Encrypt Plaintext

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test1 = huaweicloud.dew.Secret("test1", secret_text="this is a password")
        ```
        ### Encrypt JSON Data

        ```python
        import pulumi
        import json
        import pulumi_huaweicloud as huaweicloud

        test2 = huaweicloud.dew.Secret("test2", secret_text=json.dumps({
            "username": "admin",
            "password": "123456",
        }))
        ```

        ## Import

        CSMS secret can be imported using the ID and the name of secret, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Dew/secret:Secret test 93cba7f5-550b-45dc-912e-277b3296fb27/test_secret
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of a secret.
        :param pulumi.Input[str] name: The secret name. The maximum length is 64 characters.
               Only digits, letters, underscores(_), hyphens(-) and dots(.) are allowed.
        :param pulumi.Input[str] region: The region in which to create the CSMS secrets.
               If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        :param pulumi.Input[str] secret_text: The plaintext of a secret in text format. The maximum size is 32 KB.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of a CSMS secrets, key/value pair format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CSMS(Cloud Secret Management Service) secrets within HuaweiCloud.

        ## Example Usage
        ### Encrypt Plaintext

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test1 = huaweicloud.dew.Secret("test1", secret_text="this is a password")
        ```
        ### Encrypt JSON Data

        ```python
        import pulumi
        import json
        import pulumi_huaweicloud as huaweicloud

        test2 = huaweicloud.dew.Secret("test2", secret_text=json.dumps({
            "username": "admin",
            "password": "123456",
        }))
        ```

        ## Import

        CSMS secret can be imported using the ID and the name of secret, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Dew/secret:Secret test 93cba7f5-550b-45dc-912e-277b3296fb27/test_secret
        ```

        :param str resource_name: The name of the resource.
        :param SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_text: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretArgs.__new__(SecretArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if secret_text is None and not opts.urn:
                raise TypeError("Missing required property 'secret_text'")
            __props__.__dict__["secret_text"] = secret_text
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["secret_id"] = None
            __props__.__dict__["status"] = None
        super(Secret, __self__).__init__(
            'huaweicloud:Dew/secret:Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            latest_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            secret_id: Optional[pulumi.Input[str]] = None,
            secret_text: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Secret':
        """
        Get an existing Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Time when the CSMS secrets created, in UTC format.
        :param pulumi.Input[str] description: The description of a secret.
        :param pulumi.Input[str] latest_version: The latest version id.
        :param pulumi.Input[str] name: The secret name. The maximum length is 64 characters.
               Only digits, letters, underscores(_), hyphens(-) and dots(.) are allowed.
        :param pulumi.Input[str] region: The region in which to create the CSMS secrets.
               If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        :param pulumi.Input[str] secret_id: The secret ID in UUID format.
        :param pulumi.Input[str] secret_text: The plaintext of a secret in text format. The maximum size is 32 KB.
        :param pulumi.Input[str] status: The CSMS secret status. Values can be: ENABLED, DISABLED, PENDING_DELETE and FROZEN.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of a CSMS secrets, key/value pair format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretState.__new__(_SecretState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["secret_text"] = secret_text
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Secret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the CSMS secrets created, in UTC format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of a secret.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[str]:
        """
        The latest version id.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The secret name. The maximum length is 64 characters.
        Only digits, letters, underscores(_), hyphens(-) and dots(.) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the CSMS secrets.
        If omitted, the provider-level region will be used. Changing this setting will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[str]:
        """
        The secret ID in UUID format.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretText")
    def secret_text(self) -> pulumi.Output[str]:
        """
        The plaintext of a secret in text format. The maximum size is 32 KB.
        """
        return pulumi.get(self, "secret_text")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The CSMS secret status. Values can be: ENABLED, DISABLED, PENDING_DELETE and FROZEN.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The tags of a CSMS secrets, key/value pair format.
        """
        return pulumi.get(self, "tags")

