# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCsmsSecretVersionResult',
    'AwaitableGetCsmsSecretVersionResult',
    'get_csms_secret_version',
    'get_csms_secret_version_output',
]

@pulumi.output_type
class GetCsmsSecretVersionResult:
    """
    A collection of values returned by getCsmsSecretVersion.
    """
    def __init__(__self__, created_at=None, id=None, kms_key_id=None, region=None, secret_name=None, secret_text=None, statuses=None, version=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secret_name and not isinstance(secret_name, str):
            raise TypeError("Expected argument 'secret_name' to be a str")
        pulumi.set(__self__, "secret_name", secret_name)
        if secret_text and not isinstance(secret_text, str):
            raise TypeError("Expected argument 'secret_text' to be a str")
        pulumi.set(__self__, "secret_text", secret_text)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Time when the CSMS secret version created, in UTC format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The ID of the KMS CMK used for secret encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretText")
    def secret_text(self) -> str:
        """
        The plaintext of a secret in text format.
        """
        return pulumi.get(self, "secret_text")

    @property
    @pulumi.getter
    def statuses(self) -> Sequence[str]:
        """
        The status of the CSMS secret version.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


class AwaitableGetCsmsSecretVersionResult(GetCsmsSecretVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCsmsSecretVersionResult(
            created_at=self.created_at,
            id=self.id,
            kms_key_id=self.kms_key_id,
            region=self.region,
            secret_name=self.secret_name,
            secret_text=self.secret_text,
            statuses=self.statuses,
            version=self.version)


def get_csms_secret_version(region: Optional[str] = None,
                            secret_name: Optional[str] = None,
                            version: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCsmsSecretVersionResult:
    """
    Use this data source to query the version and plaintext of the CSMS(Cloud Secret Management Service) secret.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    version1 = huaweicloud.Dew.get_csms_secret_version(secret_name="your_secret_name")
    ```


    :param str region: Specifies the region in which to obtain the CSMS secrets.
           If omitted, the provider-level region will be used.
    :param str secret_name: The name of the CSMS secret to query.
    :param str version: The version ID of the CSMS secret version to query.
           If omitted, the latest version will be used.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['secretName'] = secret_name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Dew/getCsmsSecretVersion:getCsmsSecretVersion', __args__, opts=opts, typ=GetCsmsSecretVersionResult).value

    return AwaitableGetCsmsSecretVersionResult(
        created_at=__ret__.created_at,
        id=__ret__.id,
        kms_key_id=__ret__.kms_key_id,
        region=__ret__.region,
        secret_name=__ret__.secret_name,
        secret_text=__ret__.secret_text,
        statuses=__ret__.statuses,
        version=__ret__.version)


@_utilities.lift_output_func(get_csms_secret_version)
def get_csms_secret_version_output(region: Optional[pulumi.Input[Optional[str]]] = None,
                                   secret_name: Optional[pulumi.Input[str]] = None,
                                   version: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCsmsSecretVersionResult]:
    """
    Use this data source to query the version and plaintext of the CSMS(Cloud Secret Management Service) secret.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    version1 = huaweicloud.Dew.get_csms_secret_version(secret_name="your_secret_name")
    ```


    :param str region: Specifies the region in which to obtain the CSMS secrets.
           If omitted, the provider-level region will be used.
    :param str secret_name: The name of the CSMS secret to query.
    :param str version: The version ID of the CSMS secret version to query.
           If omitted, the latest version will be used.
    """
    ...
