# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'IpgroupIpList',
    'PoolPersistence',
    'GetFlavorsFlavorResult',
    'GetPoolsPoolResult',
    'GetPoolsPoolListenerResult',
    'GetPoolsPoolLoadbalancerResult',
    'GetPoolsPoolMemberResult',
    'GetPoolsPoolPersistenceResult',
]

@pulumi.output_type
class IpgroupIpList(dict):
    def __init__(__self__, *,
                 ip: str,
                 description: Optional[str] = None):
        """
        :param str ip: IP address or CIDR block.
        :param str description: Human-readable description for the ip.
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        IP address or CIDR block.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Human-readable description for the ip.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PoolPersistence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPersistence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPersistence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPersistence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 cookie_name: Optional[str] = None):
        """
        :param str type: The type of persistence mode. The current specification supports SOURCE_IP,
               HTTP_COOKIE, and APP_COOKIE.
        :param str cookie_name: The name of the cookie if persistence mode is set appropriately. Required
               if `type = APP_COOKIE`.
        """
        pulumi.set(__self__, "type", type)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of persistence mode. The current specification supports SOURCE_IP,
        HTTP_COOKIE, and APP_COOKIE.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[str]:
        """
        The name of the cookie if persistence mode is set appropriately. Required
        if `type = APP_COOKIE`.
        """
        return pulumi.get(self, "cookie_name")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 bandwidth: int,
                 cps: int,
                 id: str,
                 max_connections: int,
                 name: str,
                 qps: int,
                 type: str):
        """
        :param int bandwidth: Specifies the bandwidth size(Mbit/s) in the flavor.
        :param int cps: Specifies the cps in the flavor.
        :param str id: ID of the flavor.
        :param int max_connections: Specifies the maximum connections in the flavor.
        :param str name: Name of the flavor.
        :param int qps: Specifies the qps in the L7 flavor.
        :param str type: Specifies the flavor type. Valid values are L4 and L7.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "cps", cps)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "qps", qps)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        Specifies the bandwidth size(Mbit/s) in the flavor.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter
    def cps(self) -> int:
        """
        Specifies the cps in the flavor.
        """
        return pulumi.get(self, "cps")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the flavor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> int:
        """
        Specifies the maximum connections in the flavor.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the flavor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def qps(self) -> int:
        """
        Specifies the qps in the L7 flavor.
        """
        return pulumi.get(self, "qps")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the flavor type. Valid values are L4 and L7.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPoolsPoolResult(dict):
    def __init__(__self__, *,
                 description: str,
                 healthmonitor_id: str,
                 id: str,
                 ip_version: str,
                 lb_method: str,
                 listeners: Sequence['outputs.GetPoolsPoolListenerResult'],
                 loadbalancers: Sequence['outputs.GetPoolsPoolLoadbalancerResult'],
                 members: Sequence['outputs.GetPoolsPoolMemberResult'],
                 name: str,
                 persistences: Sequence['outputs.GetPoolsPoolPersistenceResult'],
                 protocol: str):
        """
        :param str description: Specifies the description of the ELB pool.
        :param str healthmonitor_id: Specifies the health monitor ID of the ELB pool.
        :param str id: The listener, loadbalancer or member ID.
        :param str ip_version: The IP version of the LB pool.
        :param str lb_method: Specifies the method of the ELB pool. Must be one of ROUND_ROBIN, LEAST_CONNECTIONS,
               or SOURCE_IP.
        :param Sequence['GetPoolsPoolListenerArgs'] listeners: The listener list. The object structure is documented below.
        :param Sequence['GetPoolsPoolLoadbalancerArgs'] loadbalancers: The loadbalancer list. The object structure is documented below.
        :param Sequence['GetPoolsPoolMemberArgs'] members: The member list. The object structure is documented below.
        :param str name: Specifies the name of the ELB pool.
        :param Sequence['GetPoolsPoolPersistenceArgs'] persistences: Indicates whether connections in the same session will be processed by the same pool member or not.
               The object structure is documented below.
        :param str protocol: Specifies the protocol of the ELB pool. This can either be TCP, UDP or HTTP.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "healthmonitor_id", healthmonitor_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "lb_method", lb_method)
        pulumi.set(__self__, "listeners", listeners)
        pulumi.set(__self__, "loadbalancers", loadbalancers)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "persistences", persistences)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Specifies the description of the ELB pool.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="healthmonitorId")
    def healthmonitor_id(self) -> str:
        """
        Specifies the health monitor ID of the ELB pool.
        """
        return pulumi.get(self, "healthmonitor_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The listener, loadbalancer or member ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        """
        The IP version of the LB pool.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> str:
        """
        Specifies the method of the ELB pool. Must be one of ROUND_ROBIN, LEAST_CONNECTIONS,
        or SOURCE_IP.
        """
        return pulumi.get(self, "lb_method")

    @property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetPoolsPoolListenerResult']:
        """
        The listener list. The object structure is documented below.
        """
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter
    def loadbalancers(self) -> Sequence['outputs.GetPoolsPoolLoadbalancerResult']:
        """
        The loadbalancer list. The object structure is documented below.
        """
        return pulumi.get(self, "loadbalancers")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetPoolsPoolMemberResult']:
        """
        The member list. The object structure is documented below.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the ELB pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def persistences(self) -> Sequence['outputs.GetPoolsPoolPersistenceResult']:
        """
        Indicates whether connections in the same session will be processed by the same pool member or not.
        The object structure is documented below.
        """
        return pulumi.get(self, "persistences")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Specifies the protocol of the ELB pool. This can either be TCP, UDP or HTTP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetPoolsPoolListenerResult(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: The listener, loadbalancer or member ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The listener, loadbalancer or member ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolsPoolLoadbalancerResult(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: The listener, loadbalancer or member ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The listener, loadbalancer or member ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolsPoolMemberResult(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: The listener, loadbalancer or member ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The listener, loadbalancer or member ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolsPoolPersistenceResult(dict):
    def __init__(__self__, *,
                 cookie_name: str,
                 type: str):
        """
        :param str cookie_name: The name of the cookie if persistence mode is set appropriately.
        :param str type: The type of persistence mode.
        """
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> str:
        """
        The name of the cookie if persistence mode is set appropriately.
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of persistence mode.
        """
        return pulumi.get(self, "type")


