# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IpgroupArgs', 'Ipgroup']

@pulumi.input_type
class IpgroupArgs:
    def __init__(__self__, *,
                 ip_lists: pulumi.Input[Sequence[pulumi.Input['IpgroupIpListArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Ipgroup resource.
        :param pulumi.Input[Sequence[pulumi.Input['IpgroupIpListArgs']]] ip_lists: Specifies an array of one or more ip addresses. The ip_list object structure is
               documented below.
        :param pulumi.Input[str] description: Human-readable description for the ip.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the ip group. Changing this
               creates a new ip group.
        :param pulumi.Input[str] name: Human-readable name for the ip group.
        :param pulumi.Input[str] region: The region in which to create the ip group resource. If omitted, the
               provider-level region will be used. Changing this creates a new ip group.
        """
        pulumi.set(__self__, "ip_lists", ip_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> pulumi.Input[Sequence[pulumi.Input['IpgroupIpListArgs']]]:
        """
        Specifies an array of one or more ip addresses. The ip_list object structure is
        documented below.
        """
        return pulumi.get(self, "ip_lists")

    @ip_lists.setter
    def ip_lists(self, value: pulumi.Input[Sequence[pulumi.Input['IpgroupIpListArgs']]]):
        pulumi.set(self, "ip_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the ip.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the ip group. Changing this
        creates a new ip group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the ip group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the ip group resource. If omitted, the
        provider-level region will be used. Changing this creates a new ip group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _IpgroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input['IpgroupIpListArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Ipgroup resources.
        :param pulumi.Input[str] description: Human-readable description for the ip.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the ip group. Changing this
               creates a new ip group.
        :param pulumi.Input[Sequence[pulumi.Input['IpgroupIpListArgs']]] ip_lists: Specifies an array of one or more ip addresses. The ip_list object structure is
               documented below.
        :param pulumi.Input[str] name: Human-readable name for the ip group.
        :param pulumi.Input[str] region: The region in which to create the ip group resource. If omitted, the
               provider-level region will be used. Changing this creates a new ip group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ip_lists is not None:
            pulumi.set(__self__, "ip_lists", ip_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the ip.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the ip group. Changing this
        creates a new ip group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpgroupIpListArgs']]]]:
        """
        Specifies an array of one or more ip addresses. The ip_list object structure is
        documented below.
        """
        return pulumi.get(self, "ip_lists")

    @ip_lists.setter
    def ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpgroupIpListArgs']]]]):
        pulumi.set(self, "ip_lists", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the ip group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the ip group resource. If omitted, the
        provider-level region will be used. Changing this creates a new ip group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class Ipgroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpgroupIpListArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Dedicated ELB Ip Group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        basic = huaweicloud.dedicated_elb.Ipgroup("basic",
            description="basic example",
            ip_lists=[huaweicloud.dedicated_elb.IpgroupIpListArgs(
                description="ECS01",
                ip="192.168.10.10",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Human-readable description for the ip.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the ip group. Changing this
               creates a new ip group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpgroupIpListArgs']]]] ip_lists: Specifies an array of one or more ip addresses. The ip_list object structure is
               documented below.
        :param pulumi.Input[str] name: Human-readable name for the ip group.
        :param pulumi.Input[str] region: The region in which to create the ip group resource. If omitted, the
               provider-level region will be used. Changing this creates a new ip group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpgroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dedicated ELB Ip Group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        basic = huaweicloud.dedicated_elb.Ipgroup("basic",
            description="basic example",
            ip_lists=[huaweicloud.dedicated_elb.IpgroupIpListArgs(
                description="ECS01",
                ip="192.168.10.10",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param IpgroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpgroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpgroupIpListArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpgroupArgs.__new__(IpgroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if ip_lists is None and not opts.urn:
                raise TypeError("Missing required property 'ip_lists'")
            __props__.__dict__["ip_lists"] = ip_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
        super(Ipgroup, __self__).__init__(
            'huaweicloud:DedicatedElb/ipgroup:Ipgroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpgroupIpListArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Ipgroup':
        """
        Get an existing Ipgroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Human-readable description for the ip.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the ip group. Changing this
               creates a new ip group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpgroupIpListArgs']]]] ip_lists: Specifies an array of one or more ip addresses. The ip_list object structure is
               documented below.
        :param pulumi.Input[str] name: Human-readable name for the ip group.
        :param pulumi.Input[str] region: The region in which to create the ip group resource. If omitted, the
               provider-level region will be used. Changing this creates a new ip group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpgroupState.__new__(_IpgroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ip_lists"] = ip_lists
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return Ipgroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description for the ip.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the ip group. Changing this
        creates a new ip group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> pulumi.Output[Sequence['outputs.IpgroupIpList']]:
        """
        Specifies an array of one or more ip addresses. The ip_list object structure is
        documented below.
        """
        return pulumi.get(self, "ip_lists")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the ip group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the ip group resource. If omitted, the
        provider-level region will be used. Changing this creates a new ip group.
        """
        return pulumi.get(self, "region")

