# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, bandwidth=None, cps=None, flavors=None, id=None, ids=None, max_connections=None, qps=None, region=None, type=None):
        if bandwidth and not isinstance(bandwidth, int):
            raise TypeError("Expected argument 'bandwidth' to be a int")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if cps and not isinstance(cps, int):
            raise TypeError("Expected argument 'cps' to be a int")
        pulumi.set(__self__, "cps", cps)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if max_connections and not isinstance(max_connections, int):
            raise TypeError("Expected argument 'max_connections' to be a int")
        pulumi.set(__self__, "max_connections", max_connections)
        if qps and not isinstance(qps, int):
            raise TypeError("Expected argument 'qps' to be a int")
        pulumi.set(__self__, "qps", qps)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[int]:
        """
        Bandwidth size(Mbit/s) of the flavor.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter
    def cps(self) -> Optional[int]:
        """
        Cps of the flavor.
        """
        return pulumi.get(self, "cps")

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        A list of flavors. Each element contains the following attributes:
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of flavor IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[int]:
        """
        Maximum connections of the flavor.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter
    def qps(self) -> Optional[int]:
        """
        Qps of the L7 flavor.
        """
        return pulumi.get(self, "qps")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the flavor.
        """
        return pulumi.get(self, "type")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            bandwidth=self.bandwidth,
            cps=self.cps,
            flavors=self.flavors,
            id=self.id,
            ids=self.ids,
            max_connections=self.max_connections,
            qps=self.qps,
            region=self.region,
            type=self.type)


def get_flavors(bandwidth: Optional[int] = None,
                cps: Optional[int] = None,
                max_connections: Optional[int] = None,
                qps: Optional[int] = None,
                region: Optional[str] = None,
                type: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get the available ELB Flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.DedicatedElb.get_flavors(type="L7",
        max_connections=200000,
        cps=2000,
        bandwidth=50)
    lb = huaweicloud.dedicated_elb.Loadbalancer("lb", l7_flavor_id=flavors.ids[0])
    # Other properties...
    ```


    :param int bandwidth: Specifies the bandwidth size(Mbit/s) in the flavor.
    :param int cps: Specifies the cps in the flavor.
    :param int max_connections: Specifies the maximum connections in the flavor.
    :param int qps: Specifies the qps in the L7 flavor.
    :param str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param str type: Specifies the flavor type. Valid values are L4 and L7.
    """
    __args__ = dict()
    __args__['bandwidth'] = bandwidth
    __args__['cps'] = cps
    __args__['maxConnections'] = max_connections
    __args__['qps'] = qps
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:DedicatedElb/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        bandwidth=__ret__.bandwidth,
        cps=__ret__.cps,
        flavors=__ret__.flavors,
        id=__ret__.id,
        ids=__ret__.ids,
        max_connections=__ret__.max_connections,
        qps=__ret__.qps,
        region=__ret__.region,
        type=__ret__.type)


@_utilities.lift_output_func(get_flavors)
def get_flavors_output(bandwidth: Optional[pulumi.Input[Optional[int]]] = None,
                       cps: Optional[pulumi.Input[Optional[int]]] = None,
                       max_connections: Optional[pulumi.Input[Optional[int]]] = None,
                       qps: Optional[pulumi.Input[Optional[int]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       type: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get the available ELB Flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.DedicatedElb.get_flavors(type="L7",
        max_connections=200000,
        cps=2000,
        bandwidth=50)
    lb = huaweicloud.dedicated_elb.Loadbalancer("lb", l7_flavor_id=flavors.ids[0])
    # Other properties...
    ```


    :param int bandwidth: Specifies the bandwidth size(Mbit/s) in the flavor.
    :param int cps: Specifies the cps in the flavor.
    :param int max_connections: Specifies the maximum connections in the flavor.
    :param int qps: Specifies the qps in the L7 flavor.
    :param str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param str type: Specifies the flavor type. Valid values are L4 and L7.
    """
    ...
