# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ThrottlingPolicyArgs', 'ThrottlingPolicy']

@pulumi.input_type
class ThrottlingPolicyArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 max_api_requests: pulumi.Input[int],
                 period: pulumi.Input[int],
                 app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 max_app_requests: Optional[pulumi.Input[int]] = None,
                 max_ip_requests: Optional[pulumi.Input[int]] = None,
                 max_user_requests: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]] = None):
        """
        The set of arguments for constructing a ThrottlingPolicy resource.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API
               throttling policy belongs to. Changing this will create a new API throttling policy resource.
        :param pulumi.Input[int] max_api_requests: Specifies the maximum number of times an API can be accessed within a specified
               period.
        :param pulumi.Input[int] period: Specifies the period of time for limiting the number of API calls.
               This parameter applies with each of the API call limits: `max_api_requests`, `max_app_requests`, `max_ip_requests`
               and `max_user_requests`.
        :param pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]] app_throttles: Specifies an array of one or more special throttling policies for APP limit.
               The `throttle` object of the `user_throttles` structure is documented below.
        :param pulumi.Input[str] description: Specifies the description about the API throttling policy.
               The description contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
               Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[int] max_app_requests: Specifies the maximum number of times the API can be accessed by an app within
               the same period. The value of this parameter must be less than or equal to the value of `max_user_requests`.
        :param pulumi.Input[int] max_ip_requests: Specifies the maximum number of times the API can be accessed by an IP address
               within the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        :param pulumi.Input[int] max_user_requests: Specifies the maximum number of times the API can be accessed by a user within
               the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        :param pulumi.Input[str] name: Specifies the name of the API throttling policy.
               The policy name consists of 3 to 64 characters, starting with a letter.
               Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[str] period_unit: Specifies the time unit for limiting the number of API calls.
               The valid values are *SECOND*, *MINUTE*, *HOUR* and *DAY*, default to *MINUTE*.
        :param pulumi.Input[str] region: Specifies the region in which to create the API throttling policy resource.
               If omitted, the provider-level region will be used. Changing this will create a new API throttling policy resource.
        :param pulumi.Input[str] type: Specifies the type of the request throttling policy.
               The valid values are as follows:
               + API-based: limiting the maximum number of times a single API bound to the policy can be called within the
               specified period.
               + API-shared: limiting the maximum number of times all APIs bound to the policy can be called within the specified
               period.
        :param pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]] user_throttles: Specifies an array of one or more special throttling policies for IAM user limit.
               The `throttle` object of the `user_throttles` structure is documented below.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "max_api_requests", max_api_requests)
        pulumi.set(__self__, "period", period)
        if app_throttles is not None:
            pulumi.set(__self__, "app_throttles", app_throttles)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if max_app_requests is not None:
            pulumi.set(__self__, "max_app_requests", max_app_requests)
        if max_ip_requests is not None:
            pulumi.set(__self__, "max_ip_requests", max_ip_requests)
        if max_user_requests is not None:
            pulumi.set(__self__, "max_user_requests", max_user_requests)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_throttles is not None:
            pulumi.set(__self__, "user_throttles", user_throttles)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the API
        throttling policy belongs to. Changing this will create a new API throttling policy resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> pulumi.Input[int]:
        """
        Specifies the maximum number of times an API can be accessed within a specified
        period.
        """
        return pulumi.get(self, "max_api_requests")

    @max_api_requests.setter
    def max_api_requests(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_api_requests", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[int]:
        """
        Specifies the period of time for limiting the number of API calls.
        This parameter applies with each of the API call limits: `max_api_requests`, `max_app_requests`, `max_ip_requests`
        and `max_user_requests`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[int]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="appThrottles")
    def app_throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]]:
        """
        Specifies an array of one or more special throttling policies for APP limit.
        The `throttle` object of the `user_throttles` structure is documented below.
        """
        return pulumi.get(self, "app_throttles")

    @app_throttles.setter
    def app_throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]]):
        pulumi.set(self, "app_throttles", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description about the API throttling policy.
        The description contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="maxAppRequests")
    def max_app_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of times the API can be accessed by an app within
        the same period. The value of this parameter must be less than or equal to the value of `max_user_requests`.
        """
        return pulumi.get(self, "max_app_requests")

    @max_app_requests.setter
    def max_app_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_app_requests", value)

    @property
    @pulumi.getter(name="maxIpRequests")
    def max_ip_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of times the API can be accessed by an IP address
        within the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        """
        return pulumi.get(self, "max_ip_requests")

    @max_ip_requests.setter
    def max_ip_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ip_requests", value)

    @property
    @pulumi.getter(name="maxUserRequests")
    def max_user_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of times the API can be accessed by a user within
        the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        """
        return pulumi.get(self, "max_user_requests")

    @max_user_requests.setter
    def max_user_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_user_requests", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the API throttling policy.
        The policy name consists of 3 to 64 characters, starting with a letter.
        Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time unit for limiting the number of API calls.
        The valid values are *SECOND*, *MINUTE*, *HOUR* and *DAY*, default to *MINUTE*.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the API throttling policy resource.
        If omitted, the provider-level region will be used. Changing this will create a new API throttling policy resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the request throttling policy.
        The valid values are as follows:
        + API-based: limiting the maximum number of times a single API bound to the policy can be called within the
        specified period.
        + API-shared: limiting the maximum number of times all APIs bound to the policy can be called within the specified
        period.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userThrottles")
    def user_throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]]:
        """
        Specifies an array of one or more special throttling policies for IAM user limit.
        The `throttle` object of the `user_throttles` structure is documented below.
        """
        return pulumi.get(self, "user_throttles")

    @user_throttles.setter
    def user_throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]]):
        pulumi.set(self, "user_throttles", value)


@pulumi.input_type
class _ThrottlingPolicyState:
    def __init__(__self__, *,
                 app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 max_api_requests: Optional[pulumi.Input[int]] = None,
                 max_app_requests: Optional[pulumi.Input[int]] = None,
                 max_ip_requests: Optional[pulumi.Input[int]] = None,
                 max_user_requests: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]] = None):
        """
        Input properties used for looking up and filtering ThrottlingPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]] app_throttles: Specifies an array of one or more special throttling policies for APP limit.
               The `throttle` object of the `user_throttles` structure is documented below.
        :param pulumi.Input[str] create_time: Time when the API throttling policy was created.
        :param pulumi.Input[str] description: Specifies the description about the API throttling policy.
               The description contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
               Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API
               throttling policy belongs to. Changing this will create a new API throttling policy resource.
        :param pulumi.Input[int] max_api_requests: Specifies the maximum number of times an API can be accessed within a specified
               period.
        :param pulumi.Input[int] max_app_requests: Specifies the maximum number of times the API can be accessed by an app within
               the same period. The value of this parameter must be less than or equal to the value of `max_user_requests`.
        :param pulumi.Input[int] max_ip_requests: Specifies the maximum number of times the API can be accessed by an IP address
               within the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        :param pulumi.Input[int] max_user_requests: Specifies the maximum number of times the API can be accessed by a user within
               the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        :param pulumi.Input[str] name: Specifies the name of the API throttling policy.
               The policy name consists of 3 to 64 characters, starting with a letter.
               Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[int] period: Specifies the period of time for limiting the number of API calls.
               This parameter applies with each of the API call limits: `max_api_requests`, `max_app_requests`, `max_ip_requests`
               and `max_user_requests`.
        :param pulumi.Input[str] period_unit: Specifies the time unit for limiting the number of API calls.
               The valid values are *SECOND*, *MINUTE*, *HOUR* and *DAY*, default to *MINUTE*.
        :param pulumi.Input[str] region: Specifies the region in which to create the API throttling policy resource.
               If omitted, the provider-level region will be used. Changing this will create a new API throttling policy resource.
        :param pulumi.Input[str] type: Specifies the type of the request throttling policy.
               The valid values are as follows:
               + API-based: limiting the maximum number of times a single API bound to the policy can be called within the
               specified period.
               + API-shared: limiting the maximum number of times all APIs bound to the policy can be called within the specified
               period.
        :param pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]] user_throttles: Specifies an array of one or more special throttling policies for IAM user limit.
               The `throttle` object of the `user_throttles` structure is documented below.
        """
        if app_throttles is not None:
            pulumi.set(__self__, "app_throttles", app_throttles)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_api_requests is not None:
            pulumi.set(__self__, "max_api_requests", max_api_requests)
        if max_app_requests is not None:
            pulumi.set(__self__, "max_app_requests", max_app_requests)
        if max_ip_requests is not None:
            pulumi.set(__self__, "max_ip_requests", max_ip_requests)
        if max_user_requests is not None:
            pulumi.set(__self__, "max_user_requests", max_user_requests)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_throttles is not None:
            pulumi.set(__self__, "user_throttles", user_throttles)

    @property
    @pulumi.getter(name="appThrottles")
    def app_throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]]:
        """
        Specifies an array of one or more special throttling policies for APP limit.
        The `throttle` object of the `user_throttles` structure is documented below.
        """
        return pulumi.get(self, "app_throttles")

    @app_throttles.setter
    def app_throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]]):
        pulumi.set(self, "app_throttles", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the API throttling policy was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description about the API throttling policy.
        The description contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the APIG dedicated instance to which the API
        throttling policy belongs to. Changing this will create a new API throttling policy resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of times an API can be accessed within a specified
        period.
        """
        return pulumi.get(self, "max_api_requests")

    @max_api_requests.setter
    def max_api_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_api_requests", value)

    @property
    @pulumi.getter(name="maxAppRequests")
    def max_app_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of times the API can be accessed by an app within
        the same period. The value of this parameter must be less than or equal to the value of `max_user_requests`.
        """
        return pulumi.get(self, "max_app_requests")

    @max_app_requests.setter
    def max_app_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_app_requests", value)

    @property
    @pulumi.getter(name="maxIpRequests")
    def max_ip_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of times the API can be accessed by an IP address
        within the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        """
        return pulumi.get(self, "max_ip_requests")

    @max_ip_requests.setter
    def max_ip_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ip_requests", value)

    @property
    @pulumi.getter(name="maxUserRequests")
    def max_user_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of times the API can be accessed by a user within
        the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        """
        return pulumi.get(self, "max_user_requests")

    @max_user_requests.setter
    def max_user_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_user_requests", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the API throttling policy.
        The policy name consists of 3 to 64 characters, starting with a letter.
        Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the period of time for limiting the number of API calls.
        This parameter applies with each of the API call limits: `max_api_requests`, `max_app_requests`, `max_ip_requests`
        and `max_user_requests`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time unit for limiting the number of API calls.
        The valid values are *SECOND*, *MINUTE*, *HOUR* and *DAY*, default to *MINUTE*.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the API throttling policy resource.
        If omitted, the provider-level region will be used. Changing this will create a new API throttling policy resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the request throttling policy.
        The valid values are as follows:
        + API-based: limiting the maximum number of times a single API bound to the policy can be called within the
        specified period.
        + API-shared: limiting the maximum number of times all APIs bound to the policy can be called within the specified
        period.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userThrottles")
    def user_throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]]:
        """
        Specifies an array of one or more special throttling policies for IAM user limit.
        The `throttle` object of the `user_throttles` structure is documented below.
        """
        return pulumi.get(self, "user_throttles")

    @user_throttles.setter
    def user_throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]]):
        pulumi.set(self, "user_throttles", value)


class ThrottlingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyAppThrottleArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 max_api_requests: Optional[pulumi.Input[int]] = None,
                 max_app_requests: Optional[pulumi.Input[int]] = None,
                 max_ip_requests: Optional[pulumi.Input[int]] = None,
                 max_user_requests: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyUserThrottleArgs']]]]] = None,
                 __props__=None):
        """
        Manages an APIG (API) throttling policy resource within HuaweiCloud.

        ## Example Usage
        ### Create a basic throttling policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        policy_name = config.require_object("policyName")
        description = config.require_object("description")
        test = huaweicloud.dedicated_apig.ThrottlingPolicy("test",
            instance_id=instance_id,
            description=description,
            type="API-based",
            period=10,
            period_unit="MINUTE",
            max_api_requests=70,
            max_user_requests=45,
            max_app_requests=45,
            max_ip_requests=45)
        ```
        ### Create a throttling policy with a special throttle

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        policy_name = config.require_object("policyName")
        description = config.require_object("description")
        application_id = config.require_object("applicationId")
        test = huaweicloud.dedicated_apig.ThrottlingPolicy("test",
            instance_id=instance_id,
            description=description,
            type="API-based",
            period=10,
            period_unit="MINUTE",
            max_api_requests=70,
            max_user_requests=45,
            max_app_requests=45,
            max_ip_requests=45,
            app_throttles=[huaweicloud.dedicated_apig.ThrottlingPolicyAppThrottleArgs(
                max_api_requests=40,
                throttling_object_id=application_id,
            )])
        ```

        ## Import

        API Throttling Policies of APIG can be imported using their `name` and the ID of the APIG instances to which the environment belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/throttlingPolicy:ThrottlingPolicy test <instance ID>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyAppThrottleArgs']]]] app_throttles: Specifies an array of one or more special throttling policies for APP limit.
               The `throttle` object of the `user_throttles` structure is documented below.
        :param pulumi.Input[str] description: Specifies the description about the API throttling policy.
               The description contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
               Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API
               throttling policy belongs to. Changing this will create a new API throttling policy resource.
        :param pulumi.Input[int] max_api_requests: Specifies the maximum number of times an API can be accessed within a specified
               period.
        :param pulumi.Input[int] max_app_requests: Specifies the maximum number of times the API can be accessed by an app within
               the same period. The value of this parameter must be less than or equal to the value of `max_user_requests`.
        :param pulumi.Input[int] max_ip_requests: Specifies the maximum number of times the API can be accessed by an IP address
               within the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        :param pulumi.Input[int] max_user_requests: Specifies the maximum number of times the API can be accessed by a user within
               the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        :param pulumi.Input[str] name: Specifies the name of the API throttling policy.
               The policy name consists of 3 to 64 characters, starting with a letter.
               Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[int] period: Specifies the period of time for limiting the number of API calls.
               This parameter applies with each of the API call limits: `max_api_requests`, `max_app_requests`, `max_ip_requests`
               and `max_user_requests`.
        :param pulumi.Input[str] period_unit: Specifies the time unit for limiting the number of API calls.
               The valid values are *SECOND*, *MINUTE*, *HOUR* and *DAY*, default to *MINUTE*.
        :param pulumi.Input[str] region: Specifies the region in which to create the API throttling policy resource.
               If omitted, the provider-level region will be used. Changing this will create a new API throttling policy resource.
        :param pulumi.Input[str] type: Specifies the type of the request throttling policy.
               The valid values are as follows:
               + API-based: limiting the maximum number of times a single API bound to the policy can be called within the
               specified period.
               + API-shared: limiting the maximum number of times all APIs bound to the policy can be called within the specified
               period.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyUserThrottleArgs']]]] user_throttles: Specifies an array of one or more special throttling policies for IAM user limit.
               The `throttle` object of the `user_throttles` structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThrottlingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an APIG (API) throttling policy resource within HuaweiCloud.

        ## Example Usage
        ### Create a basic throttling policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        policy_name = config.require_object("policyName")
        description = config.require_object("description")
        test = huaweicloud.dedicated_apig.ThrottlingPolicy("test",
            instance_id=instance_id,
            description=description,
            type="API-based",
            period=10,
            period_unit="MINUTE",
            max_api_requests=70,
            max_user_requests=45,
            max_app_requests=45,
            max_ip_requests=45)
        ```
        ### Create a throttling policy with a special throttle

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        policy_name = config.require_object("policyName")
        description = config.require_object("description")
        application_id = config.require_object("applicationId")
        test = huaweicloud.dedicated_apig.ThrottlingPolicy("test",
            instance_id=instance_id,
            description=description,
            type="API-based",
            period=10,
            period_unit="MINUTE",
            max_api_requests=70,
            max_user_requests=45,
            max_app_requests=45,
            max_ip_requests=45,
            app_throttles=[huaweicloud.dedicated_apig.ThrottlingPolicyAppThrottleArgs(
                max_api_requests=40,
                throttling_object_id=application_id,
            )])
        ```

        ## Import

        API Throttling Policies of APIG can be imported using their `name` and the ID of the APIG instances to which the environment belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/throttlingPolicy:ThrottlingPolicy test <instance ID>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param ThrottlingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThrottlingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyAppThrottleArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 max_api_requests: Optional[pulumi.Input[int]] = None,
                 max_app_requests: Optional[pulumi.Input[int]] = None,
                 max_ip_requests: Optional[pulumi.Input[int]] = None,
                 max_user_requests: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyUserThrottleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThrottlingPolicyArgs.__new__(ThrottlingPolicyArgs)

            __props__.__dict__["app_throttles"] = app_throttles
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if max_api_requests is None and not opts.urn:
                raise TypeError("Missing required property 'max_api_requests'")
            __props__.__dict__["max_api_requests"] = max_api_requests
            __props__.__dict__["max_app_requests"] = max_app_requests
            __props__.__dict__["max_ip_requests"] = max_ip_requests
            __props__.__dict__["max_user_requests"] = max_user_requests
            __props__.__dict__["name"] = name
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["type"] = type
            __props__.__dict__["user_throttles"] = user_throttles
            __props__.__dict__["create_time"] = None
        super(ThrottlingPolicy, __self__).__init__(
            'huaweicloud:DedicatedApig/throttlingPolicy:ThrottlingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyAppThrottleArgs']]]]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            max_api_requests: Optional[pulumi.Input[int]] = None,
            max_app_requests: Optional[pulumi.Input[int]] = None,
            max_ip_requests: Optional[pulumi.Input[int]] = None,
            max_user_requests: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyUserThrottleArgs']]]]] = None) -> 'ThrottlingPolicy':
        """
        Get an existing ThrottlingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyAppThrottleArgs']]]] app_throttles: Specifies an array of one or more special throttling policies for APP limit.
               The `throttle` object of the `user_throttles` structure is documented below.
        :param pulumi.Input[str] create_time: Time when the API throttling policy was created.
        :param pulumi.Input[str] description: Specifies the description about the API throttling policy.
               The description contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
               Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API
               throttling policy belongs to. Changing this will create a new API throttling policy resource.
        :param pulumi.Input[int] max_api_requests: Specifies the maximum number of times an API can be accessed within a specified
               period.
        :param pulumi.Input[int] max_app_requests: Specifies the maximum number of times the API can be accessed by an app within
               the same period. The value of this parameter must be less than or equal to the value of `max_user_requests`.
        :param pulumi.Input[int] max_ip_requests: Specifies the maximum number of times the API can be accessed by an IP address
               within the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        :param pulumi.Input[int] max_user_requests: Specifies the maximum number of times the API can be accessed by a user within
               the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        :param pulumi.Input[str] name: Specifies the name of the API throttling policy.
               The policy name consists of 3 to 64 characters, starting with a letter.
               Only letters, digits and underscores (_) are allowed.
        :param pulumi.Input[int] period: Specifies the period of time for limiting the number of API calls.
               This parameter applies with each of the API call limits: `max_api_requests`, `max_app_requests`, `max_ip_requests`
               and `max_user_requests`.
        :param pulumi.Input[str] period_unit: Specifies the time unit for limiting the number of API calls.
               The valid values are *SECOND*, *MINUTE*, *HOUR* and *DAY*, default to *MINUTE*.
        :param pulumi.Input[str] region: Specifies the region in which to create the API throttling policy resource.
               If omitted, the provider-level region will be used. Changing this will create a new API throttling policy resource.
        :param pulumi.Input[str] type: Specifies the type of the request throttling policy.
               The valid values are as follows:
               + API-based: limiting the maximum number of times a single API bound to the policy can be called within the
               specified period.
               + API-shared: limiting the maximum number of times all APIs bound to the policy can be called within the specified
               period.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ThrottlingPolicyUserThrottleArgs']]]] user_throttles: Specifies an array of one or more special throttling policies for IAM user limit.
               The `throttle` object of the `user_throttles` structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThrottlingPolicyState.__new__(_ThrottlingPolicyState)

        __props__.__dict__["app_throttles"] = app_throttles
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["max_api_requests"] = max_api_requests
        __props__.__dict__["max_app_requests"] = max_app_requests
        __props__.__dict__["max_ip_requests"] = max_ip_requests
        __props__.__dict__["max_user_requests"] = max_user_requests
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["user_throttles"] = user_throttles
        return ThrottlingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appThrottles")
    def app_throttles(self) -> pulumi.Output[Optional[Sequence['outputs.ThrottlingPolicyAppThrottle']]]:
        """
        Specifies an array of one or more special throttling policies for APP limit.
        The `throttle` object of the `user_throttles` structure is documented below.
        """
        return pulumi.get(self, "app_throttles")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the API throttling policy was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description about the API throttling policy.
        The description contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the API
        throttling policy belongs to. Changing this will create a new API throttling policy resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> pulumi.Output[int]:
        """
        Specifies the maximum number of times an API can be accessed within a specified
        period.
        """
        return pulumi.get(self, "max_api_requests")

    @property
    @pulumi.getter(name="maxAppRequests")
    def max_app_requests(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum number of times the API can be accessed by an app within
        the same period. The value of this parameter must be less than or equal to the value of `max_user_requests`.
        """
        return pulumi.get(self, "max_app_requests")

    @property
    @pulumi.getter(name="maxIpRequests")
    def max_ip_requests(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum number of times the API can be accessed by an IP address
        within the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        """
        return pulumi.get(self, "max_ip_requests")

    @property
    @pulumi.getter(name="maxUserRequests")
    def max_user_requests(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum number of times the API can be accessed by a user within
        the same period. The value of this parameter must be less than or equal to the value of `max_api_requests`.
        """
        return pulumi.get(self, "max_user_requests")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the API throttling policy.
        The policy name consists of 3 to 64 characters, starting with a letter.
        Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[int]:
        """
        Specifies the period of time for limiting the number of API calls.
        This parameter applies with each of the API call limits: `max_api_requests`, `max_app_requests`, `max_ip_requests`
        and `max_user_requests`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the time unit for limiting the number of API calls.
        The valid values are *SECOND*, *MINUTE*, *HOUR* and *DAY*, default to *MINUTE*.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the API throttling policy resource.
        If omitted, the provider-level region will be used. Changing this will create a new API throttling policy resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the request throttling policy.
        The valid values are as follows:
        + API-based: limiting the maximum number of times a single API bound to the policy can be called within the
        specified period.
        + API-shared: limiting the maximum number of times all APIs bound to the policy can be called within the specified
        period.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userThrottles")
    def user_throttles(self) -> pulumi.Output[Optional[Sequence['outputs.ThrottlingPolicyUserThrottle']]]:
        """
        Specifies an array of one or more special throttling policies for IAM user limit.
        The `throttle` object of the `user_throttles` structure is documented below.
        """
        return pulumi.get(self, "user_throttles")

