# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ApiBackendParam',
    'ApiFuncGraph',
    'ApiFuncGraphPolicy',
    'ApiFuncGraphPolicyBackendParam',
    'ApiFuncGraphPolicyCondition',
    'ApiMock',
    'ApiMockPolicy',
    'ApiMockPolicyBackendParam',
    'ApiMockPolicyCondition',
    'ApiPublishmentHistory',
    'ApiRequestParam',
    'ApiWeb',
    'ApiWebPolicy',
    'ApiWebPolicyBackendParam',
    'ApiWebPolicyCondition',
    'CustomAuthorizerIdentity',
    'GroupEnvironment',
    'GroupEnvironmentVariable',
    'ResponseRule',
    'ThrottlingPolicyAppThrottle',
    'ThrottlingPolicyUserThrottle',
    'VpcChannelMember',
    'GetEnvironmentsEnvironmentResult',
]

@pulumi.output_type
class ApiBackendParam(dict):
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 type: str,
                 value: str,
                 description: Optional[str] = None):
        """
        :param str location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param str name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param str type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param str value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param str description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApiFuncGraph(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionUrn":
            suggest = "function_urn"
        elif key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "invocationType":
            suggest = "invocation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFuncGraph. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFuncGraph.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFuncGraph.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_urn: str,
                 authorizer_id: Optional[str] = None,
                 invocation_type: Optional[str] = None,
                 timeout: Optional[int] = None,
                 version: Optional[str] = None):
        """
        :param str function_urn: Specifies the URN of the function graph.
        :param str authorizer_id: Specifies the ID of the backend custom authorization.
        :param str invocation_type: Specifies the invocation mode. The valid values are **async** and **sync**,
               default to **sync**.
        :param int timeout: Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
               valid value is range from 1 to 600,000, default to 5,000.
        :param str version: Specifies the version of the function graph.
        """
        pulumi.set(__self__, "function_urn", function_urn)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if invocation_type is not None:
            pulumi.set(__self__, "invocation_type", invocation_type)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> str:
        """
        Specifies the URN of the function graph.
        """
        return pulumi.get(self, "function_urn")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[str]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> Optional[str]:
        """
        Specifies the invocation mode. The valid values are **async** and **sync**,
        default to **sync**.
        """
        return pulumi.get(self, "invocation_type")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
        valid value is range from 1 to 600,000, default to 5,000.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version of the function graph.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ApiFuncGraphPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionUrn":
            suggest = "function_urn"
        elif key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "backendParams":
            suggest = "backend_params"
        elif key == "effectiveMode":
            suggest = "effective_mode"
        elif key == "invocationMode":
            suggest = "invocation_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFuncGraphPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFuncGraphPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFuncGraphPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.ApiFuncGraphPolicyCondition'],
                 function_urn: str,
                 name: str,
                 authorizer_id: Optional[str] = None,
                 backend_params: Optional[Sequence['outputs.ApiFuncGraphPolicyBackendParam']] = None,
                 effective_mode: Optional[str] = None,
                 invocation_mode: Optional[str] = None,
                 timeout: Optional[int] = None,
                 version: Optional[str] = None):
        """
        :param Sequence['ApiFuncGraphPolicyConditionArgs'] conditions: Specifies an array of one or more policy conditions. Up to five conditions can be set.
               The object structure is documented below.
        :param str function_urn: Specifies the URN of the function graph.
        :param str name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param str authorizer_id: Specifies the ID of the backend custom authorization.
        :param Sequence['ApiFuncGraphPolicyBackendParamArgs'] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param str effective_mode: Specifies the effective mode of the backend policy. The valid values are **ALL**
               and **ANY**, default to **ANY**.
        :param str invocation_mode: Specifies the invocation mode of the function graph. The valid values are
               **async** and **sync**, default to **sync**.
        :param int timeout: Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
               valid value is range from 1 to 600,000, default to 5,000.
        :param str version: Specifies the version of the function graph.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "name", name)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if invocation_mode is not None:
            pulumi.set(__self__, "invocation_mode", invocation_mode)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ApiFuncGraphPolicyCondition']:
        """
        Specifies an array of one or more policy conditions. Up to five conditions can be set.
        The object structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> str:
        """
        Specifies the URN of the function graph.
        """
        return pulumi.get(self, "function_urn")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[str]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[Sequence['outputs.ApiFuncGraphPolicyBackendParam']]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[str]:
        """
        Specifies the effective mode of the backend policy. The valid values are **ALL**
        and **ANY**, default to **ANY**.
        """
        return pulumi.get(self, "effective_mode")

    @property
    @pulumi.getter(name="invocationMode")
    def invocation_mode(self) -> Optional[str]:
        """
        Specifies the invocation mode of the function graph. The valid values are
        **async** and **sync**, default to **sync**.
        """
        return pulumi.get(self, "invocation_mode")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
        valid value is range from 1 to 600,000, default to 5,000.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version of the function graph.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ApiFuncGraphPolicyBackendParam(dict):
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 type: str,
                 value: str,
                 description: Optional[str] = None):
        """
        :param str location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param str name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param str type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param str value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param str description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApiFuncGraphPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paramName":
            suggest = "param_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFuncGraphPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFuncGraphPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFuncGraphPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 param_name: Optional[str] = None,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param str param_name: Specifies the request parameter name. This parameter is required if the policy type
               is param.
        :param str source: Specifies the policy type. The valid values are **param** and **source**, default to
               **source**.
        :param str type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        """
        pulumi.set(__self__, "value", value)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[str]:
        """
        Specifies the request parameter name. This parameter is required if the policy type
        is param.
        """
        return pulumi.get(self, "param_name")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Specifies the policy type. The valid values are **param** and **source**, default to
        **source**.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApiMock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerId":
            suggest = "authorizer_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_id: Optional[str] = None,
                 response: Optional[str] = None):
        """
        :param str authorizer_id: Specifies the ID of the backend custom authorization.
        :param str response: Specifies the response of the backend policy, which contain a maximum of 2,048
               characters, and the angle brackets (< and >) are not allowed.
        """
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[str]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter
    def response(self) -> Optional[str]:
        """
        Specifies the response of the backend policy, which contain a maximum of 2,048
        characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class ApiMockPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "backendParams":
            suggest = "backend_params"
        elif key == "effectiveMode":
            suggest = "effective_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMockPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMockPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMockPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.ApiMockPolicyCondition'],
                 name: str,
                 authorizer_id: Optional[str] = None,
                 backend_params: Optional[Sequence['outputs.ApiMockPolicyBackendParam']] = None,
                 effective_mode: Optional[str] = None,
                 response: Optional[str] = None):
        """
        :param Sequence['ApiMockPolicyConditionArgs'] conditions: Specifies an array of one or more policy conditions. Up to five conditions can be set.
               The object structure is documented below.
        :param str name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param str authorizer_id: Specifies the ID of the backend custom authorization.
        :param Sequence['ApiMockPolicyBackendParamArgs'] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param str effective_mode: Specifies the effective mode of the backend policy. The valid values are **ALL**
               and **ANY**, default to **ANY**.
        :param str response: Specifies the response of the backend policy, which contain a maximum of 2,048
               characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "name", name)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ApiMockPolicyCondition']:
        """
        Specifies an array of one or more policy conditions. Up to five conditions can be set.
        The object structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[str]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[Sequence['outputs.ApiMockPolicyBackendParam']]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[str]:
        """
        Specifies the effective mode of the backend policy. The valid values are **ALL**
        and **ANY**, default to **ANY**.
        """
        return pulumi.get(self, "effective_mode")

    @property
    @pulumi.getter
    def response(self) -> Optional[str]:
        """
        Specifies the response of the backend policy, which contain a maximum of 2,048
        characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class ApiMockPolicyBackendParam(dict):
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 type: str,
                 value: str,
                 description: Optional[str] = None):
        """
        :param str location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param str name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param str type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param str value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param str description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApiMockPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paramName":
            suggest = "param_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMockPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMockPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMockPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 param_name: Optional[str] = None,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param str param_name: Specifies the request parameter name. This parameter is required if the policy type
               is param.
        :param str source: Specifies the policy type. The valid values are **param** and **source**, default to
               **source**.
        :param str type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        """
        pulumi.set(__self__, "value", value)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[str]:
        """
        Specifies the request parameter name. This parameter is required if the policy type
        is param.
        """
        return pulumi.get(self, "param_name")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Specifies the policy type. The valid values are **param** and **source**, default to
        **source**.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApiPublishmentHistory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionId":
            suggest = "version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiPublishmentHistory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiPublishmentHistory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiPublishmentHistory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 version_id: Optional[str] = None):
        """
        :param str description: Specifies the description of the current publishment.
        :param str version_id: Specifies the version ID of the current publishment.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the current publishment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[str]:
        """
        Specifies the version ID of the current publishment.
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class ApiRequestParam(dict):
    def __init__(__self__, *,
                 name: str,
                 required: bool,
                 default: Optional[str] = None,
                 description: Optional[str] = None,
                 example: Optional[str] = None,
                 location: Optional[str] = None,
                 maximum: Optional[int] = None,
                 minimum: Optional[int] = None,
                 type: Optional[str] = None):
        """
        :param str name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param bool required: Specifies whether the request parameter is required.
        :param str default: Specifies the default value of the request parameter, which contain a maximum of 255
               characters, and the angle brackets (< and >) are not allowed.
        :param str description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        :param str example: Specifies the example value of the request parameter, which contain a maximum of 255
               characters, and the angle brackets (< and >) are not allowed.
        :param str location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param int maximum: Specifies the maximum value or size of the request parameter.
        :param int minimum: Specifies the minimum value or size of the request parameter. For string type,
               The `maximum` and `minimum` means size. For number type, they means value.
        :param str type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if example is not None:
            pulumi.set(__self__, "example", example)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> bool:
        """
        Specifies whether the request parameter is required.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def default(self) -> Optional[str]:
        """
        Specifies the default value of the request parameter, which contain a maximum of 255
        characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def example(self) -> Optional[str]:
        """
        Specifies the example value of the request parameter, which contain a maximum of 255
        characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "example")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[int]:
        """
        Specifies the maximum value or size of the request parameter.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[int]:
        """
        Specifies the minimum value or size of the request parameter. For string type,
        The `maximum` and `minimum` means size. For number type, they means value.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApiWeb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "backendAddress":
            suggest = "backend_address"
        elif key == "hostHeader":
            suggest = "host_header"
        elif key == "requestMethod":
            suggest = "request_method"
        elif key == "requestProtocol":
            suggest = "request_protocol"
        elif key == "sslEnable":
            suggest = "ssl_enable"
        elif key == "vpcChannelId":
            suggest = "vpc_channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiWeb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiWeb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiWeb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 authorizer_id: Optional[str] = None,
                 backend_address: Optional[str] = None,
                 host_header: Optional[str] = None,
                 request_method: Optional[str] = None,
                 request_protocol: Optional[str] = None,
                 ssl_enable: Optional[bool] = None,
                 timeout: Optional[int] = None,
                 vpc_channel_id: Optional[str] = None):
        """
        :param str path: Specifies the backend request address, which can contain a maximum of 512 characters and
               must comply with URI specifications.
               + The request address can contain request parameters enclosed with brackets ({}).
               + The request address can contain special characters, such as asterisks (*), percent signs (%), hyphens (-) and
               underscores (_) and must comply with URI specifications.
               + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        :param str authorizer_id: Specifies the ID of the backend custom authorization.
        :param str backend_address: Specifies the backend service address, which consists of a domain name or IP
               address, and a port number, with not more than 255 characters. The backend service address must be in the format "Host
               name:Port number", for example, apig.example.com:7443. If the port number is not specified, the default HTTPS port 443
               or the default HTTP port 80 is used. The backend service address can contain environment variables, each starting with
               a letter and consisting of 3 to 32 characters. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        :param str host_header: Specifies the proxy host header. The host header can be customized for requests to
               be forwarded to cloud servers through the VPC channel. By default, the original host header of the request is used.
        :param str request_method: Specifies the backend request method of the API. The valid types are **GET**,
               **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        :param str request_protocol: Specifies the backend request protocol. The valid values are **HTTP** and
               **HTTPS**, default to **HTTPS**.
        :param bool ssl_enable: Specifies the indicates whether to enable two-way authentication, default to false.
        :param int timeout: Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
               valid value is range from 1 to 600,000, default to 5,000.
        :param str vpc_channel_id: Specifies the VPC channel ID. This parameter and `backend_address` are
               alternative.
        """
        pulumi.set(__self__, "path", path)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_address is not None:
            pulumi.set(__self__, "backend_address", backend_address)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_channel_id is not None:
            pulumi.set(__self__, "vpc_channel_id", vpc_channel_id)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the backend request address, which can contain a maximum of 512 characters and
        must comply with URI specifications.
        + The request address can contain request parameters enclosed with brackets ({}).
        + The request address can contain special characters, such as asterisks (*), percent signs (%), hyphens (-) and
        underscores (_) and must comply with URI specifications.
        + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[str]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="backendAddress")
    def backend_address(self) -> Optional[str]:
        """
        Specifies the backend service address, which consists of a domain name or IP
        address, and a port number, with not more than 255 characters. The backend service address must be in the format "Host
        name:Port number", for example, apig.example.com:7443. If the port number is not specified, the default HTTPS port 443
        or the default HTTP port 80 is used. The backend service address can contain environment variables, each starting with
        a letter and consisting of 3 to 32 characters. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "backend_address")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[str]:
        """
        Specifies the proxy host header. The host header can be customized for requests to
        be forwarded to cloud servers through the VPC channel. By default, the original host header of the request is used.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[str]:
        """
        Specifies the backend request method of the API. The valid types are **GET**,
        **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        """
        return pulumi.get(self, "request_method")

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[str]:
        """
        Specifies the backend request protocol. The valid values are **HTTP** and
        **HTTPS**, default to **HTTPS**.
        """
        return pulumi.get(self, "request_protocol")

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[bool]:
        """
        Specifies the indicates whether to enable two-way authentication, default to false.
        """
        return pulumi.get(self, "ssl_enable")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
        valid value is range from 1 to 600,000, default to 5,000.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="vpcChannelId")
    def vpc_channel_id(self) -> Optional[str]:
        """
        Specifies the VPC channel ID. This parameter and `backend_address` are
        alternative.
        """
        return pulumi.get(self, "vpc_channel_id")


@pulumi.output_type
class ApiWebPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestMethod":
            suggest = "request_method"
        elif key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "backendAddress":
            suggest = "backend_address"
        elif key == "backendParams":
            suggest = "backend_params"
        elif key == "effectiveMode":
            suggest = "effective_mode"
        elif key == "hostHeader":
            suggest = "host_header"
        elif key == "requestProtocol":
            suggest = "request_protocol"
        elif key == "vpcChannelId":
            suggest = "vpc_channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiWebPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiWebPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiWebPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.ApiWebPolicyCondition'],
                 name: str,
                 path: str,
                 request_method: str,
                 authorizer_id: Optional[str] = None,
                 backend_address: Optional[str] = None,
                 backend_params: Optional[Sequence['outputs.ApiWebPolicyBackendParam']] = None,
                 effective_mode: Optional[str] = None,
                 host_header: Optional[str] = None,
                 request_protocol: Optional[str] = None,
                 timeout: Optional[int] = None,
                 vpc_channel_id: Optional[str] = None):
        """
        :param Sequence['ApiWebPolicyConditionArgs'] conditions: Specifies an array of one or more policy conditions. Up to five conditions can be set.
               The object structure is documented below.
        :param str name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param str path: Specifies the backend request address, which can contain a maximum of 512 characters and
               must comply with URI specifications.
               + The request address can contain request parameters enclosed with brackets ({}).
               + The request address can contain special characters, such as asterisks (*), percent signs (%), hyphens (-) and
               underscores (_) and must comply with URI specifications.
               + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        :param str request_method: Specifies the backend request method of the API. The valid types are **GET**,
               **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        :param str authorizer_id: Specifies the ID of the backend custom authorization.
        :param str backend_address: Specifies the backend service address, which consists of a domain name or IP
               address, and a port number, with not more than 255 characters. The backend service address must be in the format "Host
               name:Port number", for example, apig.example.com:7443. If the port number is not specified, the default HTTPS port 443
               or the default HTTP port 80 is used. The backend service address can contain environment variables, each starting with
               a letter and consisting of 3 to 32 characters. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        :param Sequence['ApiWebPolicyBackendParamArgs'] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param str effective_mode: Specifies the effective mode of the backend policy. The valid values are **ALL**
               and **ANY**, default to **ANY**.
        :param str host_header: Specifies the proxy host header. The host header can be customized for requests to
               be forwarded to cloud servers through the VPC channel. By default, the original host header of the request is used.
        :param str request_protocol: Specifies the backend request protocol. The valid values are **HTTP** and
               **HTTPS**, default to **HTTPS**.
        :param int timeout: Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
               valid value is range from 1 to 600,000, default to 5,000.
        :param str vpc_channel_id: Specifies the VPC channel ID. This parameter and `backend_address` are
               alternative.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "request_method", request_method)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_address is not None:
            pulumi.set(__self__, "backend_address", backend_address)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_channel_id is not None:
            pulumi.set(__self__, "vpc_channel_id", vpc_channel_id)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ApiWebPolicyCondition']:
        """
        Specifies an array of one or more policy conditions. Up to five conditions can be set.
        The object structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Specifies the backend request address, which can contain a maximum of 512 characters and
        must comply with URI specifications.
        + The request address can contain request parameters enclosed with brackets ({}).
        + The request address can contain special characters, such as asterisks (*), percent signs (%), hyphens (-) and
        underscores (_) and must comply with URI specifications.
        + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> str:
        """
        Specifies the backend request method of the API. The valid types are **GET**,
        **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        """
        return pulumi.get(self, "request_method")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[str]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="backendAddress")
    def backend_address(self) -> Optional[str]:
        """
        Specifies the backend service address, which consists of a domain name or IP
        address, and a port number, with not more than 255 characters. The backend service address must be in the format "Host
        name:Port number", for example, apig.example.com:7443. If the port number is not specified, the default HTTPS port 443
        or the default HTTP port 80 is used. The backend service address can contain environment variables, each starting with
        a letter and consisting of 3 to 32 characters. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "backend_address")

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[Sequence['outputs.ApiWebPolicyBackendParam']]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[str]:
        """
        Specifies the effective mode of the backend policy. The valid values are **ALL**
        and **ANY**, default to **ANY**.
        """
        return pulumi.get(self, "effective_mode")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[str]:
        """
        Specifies the proxy host header. The host header can be customized for requests to
        be forwarded to cloud servers through the VPC channel. By default, the original host header of the request is used.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[str]:
        """
        Specifies the backend request protocol. The valid values are **HTTP** and
        **HTTPS**, default to **HTTPS**.
        """
        return pulumi.get(self, "request_protocol")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
        valid value is range from 1 to 600,000, default to 5,000.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="vpcChannelId")
    def vpc_channel_id(self) -> Optional[str]:
        """
        Specifies the VPC channel ID. This parameter and `backend_address` are
        alternative.
        """
        return pulumi.get(self, "vpc_channel_id")


@pulumi.output_type
class ApiWebPolicyBackendParam(dict):
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 type: str,
                 value: str,
                 description: Optional[str] = None):
        """
        :param str location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param str name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param str type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param str value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param str description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApiWebPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paramName":
            suggest = "param_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiWebPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiWebPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiWebPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 param_name: Optional[str] = None,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param str param_name: Specifies the request parameter name. This parameter is required if the policy type
               is param.
        :param str source: Specifies the policy type. The valid values are **param** and **source**, default to
               **source**.
        :param str type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        """
        pulumi.set(__self__, "value", value)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[str]:
        """
        Specifies the request parameter name. This parameter is required if the policy type
        is param.
        """
        return pulumi.get(self, "param_name")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Specifies the policy type. The valid values are **param** and **source**, default to
        **source**.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomAuthorizerIdentity(dict):
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 validation: Optional[str] = None):
        """
        :param str location: Specifies the parameter location, which support 'HEADER' and 'QUERY'.
               Changing this will create a new custom authorizer resource.
        :param str name: Specifies the name of the parameter to be verified.
               The parameter includes front-end and back-end parameters.
               Changing this will create a new custom authorizer resource.
        :param str validation: Specifies the parameter verification expression.
               If omitted, the custom authorizer will not perform verification.
               The valid value is range form 1 to 2,048.
               Changing this will create a new custom authorizer resource.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies the parameter location, which support 'HEADER' and 'QUERY'.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the parameter to be verified.
        The parameter includes front-end and back-end parameters.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def validation(self) -> Optional[str]:
        """
        Specifies the parameter verification expression.
        If omitted, the custom authorizer will not perform verification.
        The valid value is range form 1 to 2,048.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "validation")


@pulumi.output_type
class GroupEnvironment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentId":
            suggest = "environment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_id: str,
                 variables: Sequence['outputs.GroupEnvironmentVariable']):
        """
        :param str environment_id: Specifies the APIG environment ID of the associated APIG group.
        :param Sequence['GroupEnvironmentVariableArgs'] variables: Specifies an array of one or more APIG environment variables. The object structure is
               documented below. The environment variables of different groups are isolated in the same environment.
        """
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> str:
        """
        Specifies the APIG environment ID of the associated APIG group.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GroupEnvironmentVariable']:
        """
        Specifies an array of one or more APIG environment variables. The object structure is
        documented below. The environment variables of different groups are isolated in the same environment.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class GroupEnvironmentVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variableId":
            suggest = "variable_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupEnvironmentVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupEnvironmentVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupEnvironmentVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 variable_id: Optional[str] = None):
        """
        :param str name: Specifies the variable name, which can contains of 3 to 32 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
               case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
               an environment. The variable names are not allowed to be repeated for an API group.
        :param str value: Specifies the environment ariable value, which can contains of 1 to 255 characters. Only
               letters, digits and special characters (_-/.:) are allowed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if variable_id is not None:
            pulumi.set(__self__, "variable_id", variable_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the variable name, which can contains of 3 to 32 characters, starting with a
        letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
        case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
        an environment. The variable names are not allowed to be repeated for an API group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the environment ariable value, which can contains of 1 to 255 characters. Only
        letters, digits and special characters (_-/.:) are allowed.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="variableId")
    def variable_id(self) -> Optional[str]:
        return pulumi.get(self, "variable_id")


@pulumi.output_type
class ResponseRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorType":
            suggest = "error_type"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body: str,
                 error_type: str,
                 status_code: Optional[int] = None):
        """
        :param str body: Specifies the body template of the API response rule, e.g.
               `{\\"code\\":\\"$context.authorizer.frontend.code\\",\\"message\\":\\"$context.authorizer.frontend.message\\"}`
        :param str error_type: Specifies the type of the API custom response rule.
               + **AUTH_FAILURE**: Authentication failed.
               + **AUTH_HEADER_MISSING**: The identity source is missing.
               + **AUTHORIZER_FAILURE**: Custom authentication failed.
               + **AUTHORIZER_CONF_FAILURE**: There has been a custom authorizer error.
               + **AUTHORIZER_IDENTITIES_FAILURE**: The identity source of the custom authorizer is invalid.
               + **BACKEND_UNAVAILABLE**: The backend service is unavailable.
               + **BACKEND_TIMEOUT**: Communication with the backend service timed out.
               + **THROTTLED**: The request was rejected due to request throttling.
               + **UNAUTHORIZED**: The app you are using has not been authorized to call the API.
               + **ACCESS_DENIED**: Access denied.
               + **NOT_FOUND**: No API is found.
               + **REQUEST_PARAMETERS_FAILURE**: The request parameters are incorrect.
               + **DEFAULT_4XX**: Another 4XX error occurred.
               + **DEFAULT_5XX**: Another 5XX error occurred.
        :param int status_code: Specifies the HTTP status code of the API response rule.
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "error_type", error_type)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        Specifies the body template of the API response rule, e.g.
        `{\\"code\\":\\"$context.authorizer.frontend.code\\",\\"message\\":\\"$context.authorizer.frontend.message\\"}`
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="errorType")
    def error_type(self) -> str:
        """
        Specifies the type of the API custom response rule.
        + **AUTH_FAILURE**: Authentication failed.
        + **AUTH_HEADER_MISSING**: The identity source is missing.
        + **AUTHORIZER_FAILURE**: Custom authentication failed.
        + **AUTHORIZER_CONF_FAILURE**: There has been a custom authorizer error.
        + **AUTHORIZER_IDENTITIES_FAILURE**: The identity source of the custom authorizer is invalid.
        + **BACKEND_UNAVAILABLE**: The backend service is unavailable.
        + **BACKEND_TIMEOUT**: Communication with the backend service timed out.
        + **THROTTLED**: The request was rejected due to request throttling.
        + **UNAUTHORIZED**: The app you are using has not been authorized to call the API.
        + **ACCESS_DENIED**: Access denied.
        + **NOT_FOUND**: No API is found.
        + **REQUEST_PARAMETERS_FAILURE**: The request parameters are incorrect.
        + **DEFAULT_4XX**: Another 4XX error occurred.
        + **DEFAULT_5XX**: Another 5XX error occurred.
        """
        return pulumi.get(self, "error_type")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[int]:
        """
        Specifies the HTTP status code of the API response rule.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ThrottlingPolicyAppThrottle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxApiRequests":
            suggest = "max_api_requests"
        elif key == "throttlingObjectId":
            suggest = "throttling_object_id"
        elif key == "throttlingObjectName":
            suggest = "throttling_object_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThrottlingPolicyAppThrottle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThrottlingPolicyAppThrottle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThrottlingPolicyAppThrottle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_api_requests: int,
                 throttling_object_id: str,
                 id: Optional[str] = None,
                 throttling_object_name: Optional[str] = None):
        """
        :param int max_api_requests: Specifies the maximum number of times an API can be accessed within a specified
               period.
        :param str throttling_object_id: Specifies the object ID which the special throttling policy belongs.
        :param str id: ID of the special application throttling policy.
        :param str throttling_object_name: The object name which the special application throttling policy belongs.
        """
        pulumi.set(__self__, "max_api_requests", max_api_requests)
        pulumi.set(__self__, "throttling_object_id", throttling_object_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if throttling_object_name is not None:
            pulumi.set(__self__, "throttling_object_name", throttling_object_name)

    @property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> int:
        """
        Specifies the maximum number of times an API can be accessed within a specified
        period.
        """
        return pulumi.get(self, "max_api_requests")

    @property
    @pulumi.getter(name="throttlingObjectId")
    def throttling_object_id(self) -> str:
        """
        Specifies the object ID which the special throttling policy belongs.
        """
        return pulumi.get(self, "throttling_object_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the special application throttling policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="throttlingObjectName")
    def throttling_object_name(self) -> Optional[str]:
        """
        The object name which the special application throttling policy belongs.
        """
        return pulumi.get(self, "throttling_object_name")


@pulumi.output_type
class ThrottlingPolicyUserThrottle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxApiRequests":
            suggest = "max_api_requests"
        elif key == "throttlingObjectId":
            suggest = "throttling_object_id"
        elif key == "throttlingObjectName":
            suggest = "throttling_object_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThrottlingPolicyUserThrottle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThrottlingPolicyUserThrottle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThrottlingPolicyUserThrottle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_api_requests: int,
                 throttling_object_id: str,
                 id: Optional[str] = None,
                 throttling_object_name: Optional[str] = None):
        """
        :param int max_api_requests: Specifies the maximum number of times an API can be accessed within a specified
               period.
        :param str throttling_object_id: Specifies the object ID which the special throttling policy belongs.
        :param str id: ID of the special application throttling policy.
        :param str throttling_object_name: The object name which the special application throttling policy belongs.
        """
        pulumi.set(__self__, "max_api_requests", max_api_requests)
        pulumi.set(__self__, "throttling_object_id", throttling_object_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if throttling_object_name is not None:
            pulumi.set(__self__, "throttling_object_name", throttling_object_name)

    @property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> int:
        """
        Specifies the maximum number of times an API can be accessed within a specified
        period.
        """
        return pulumi.get(self, "max_api_requests")

    @property
    @pulumi.getter(name="throttlingObjectId")
    def throttling_object_id(self) -> str:
        """
        Specifies the object ID which the special throttling policy belongs.
        """
        return pulumi.get(self, "throttling_object_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the special application throttling policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="throttlingObjectName")
    def throttling_object_name(self) -> Optional[str]:
        """
        The object name which the special application throttling policy belongs.
        """
        return pulumi.get(self, "throttling_object_name")


@pulumi.output_type
class VpcChannelMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcChannelMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcChannelMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcChannelMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        :param str id: Specifies the ECS ID for each backend servers.
               Required if `member_type` is *ECS*.
               This parameter and `ip_address` are alternative.
        :param str ip_address: Specifies the IP address each backend servers.
               Required if `member_type` is *EIP*.
        :param int weight: Specifies the backend server weight.
               The valid values are range from 1 to 100, default to 1.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Specifies the ECS ID for each backend servers.
        Required if `member_type` is *ECS*.
        This parameter and `ip_address` are alternative.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Specifies the IP address each backend servers.
        Required if `member_type` is *EIP*.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Specifies the backend server weight.
        The valid values are range from 1 to 100, default to 1.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetEnvironmentsEnvironmentResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 id: str,
                 name: str):
        """
        :param str create_time: Time when the APIG environment was created, in RFC-3339 format.
        :param str description: The description about the API environment.
        :param str id: ID of the APIG environment.
        :param str name: Specifies the name of the API environment. The API environment name consists of 3 to 64
               characters, starting with a letter. Only letters, digits and underscores (_) are allowed.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time when the APIG environment was created, in RFC-3339 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description about the API environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the APIG environment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the API environment. The API environment name consists of 3 to 64
        characters, starting with a letter. Only letters, digits and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")


