# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetEnvironmentsResult',
    'AwaitableGetEnvironmentsResult',
    'get_environments',
    'get_environments_output',
]

@pulumi.output_type
class GetEnvironmentsResult:
    """
    A collection of values returned by getEnvironments.
    """
    def __init__(__self__, environments=None, id=None, instance_id=None, name=None, region=None):
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetEnvironmentsEnvironmentResult']:
        """
        List of APIG environment details. The structure is documented below.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The environment name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


class AwaitableGetEnvironmentsResult(GetEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentsResult(
            environments=self.environments,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            region=self.region)


def get_environments(instance_id: Optional[str] = None,
                     name: Optional[str] = None,
                     region: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentsResult:
    """
    Use this data source to query the environment list under the APIG instance within Huaweicloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    environment_name = config.require_object("environmentName")
    test = huaweicloud.DedicatedApig.get_environments(instance_id=instance_id,
        name=environment_name)
    ```


    :param str instance_id: Specifies an ID of the APIG dedicated instance to which the API
           environment belongs.
    :param str name: Specifies the name of the API environment. The API environment name consists of 3 to 64
           characters, starting with a letter. Only letters, digits and underscores (_) are allowed.
    :param str region: Specifies the region in which to query the APIG environment list.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:DedicatedApig/getEnvironments:getEnvironments', __args__, opts=opts, typ=GetEnvironmentsResult).value

    return AwaitableGetEnvironmentsResult(
        environments=__ret__.environments,
        id=__ret__.id,
        instance_id=__ret__.instance_id,
        name=__ret__.name,
        region=__ret__.region)


@_utilities.lift_output_func(get_environments)
def get_environments_output(instance_id: Optional[pulumi.Input[str]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            region: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentsResult]:
    """
    Use this data source to query the environment list under the APIG instance within Huaweicloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    environment_name = config.require_object("environmentName")
    test = huaweicloud.DedicatedApig.get_environments(instance_id=instance_id,
        name=environment_name)
    ```


    :param str instance_id: Specifies an ID of the APIG dedicated instance to which the API
           environment belongs.
    :param str name: Specifies the name of the API environment. The API environment name consists of 3 to 64
           characters, starting with a letter. Only letters, digits and underscores (_) are allowed.
    :param str region: Specifies the region in which to query the APIG environment list.
           If omitted, the provider-level region will be used.
    """
    ...
