# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomAuthorizerArgs', 'CustomAuthorizer']

@pulumi.input_type
class CustomAuthorizerArgs:
    def __init__(__self__, *,
                 function_urn: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 cache_age: Optional[pulumi.Input[int]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]] = None,
                 is_body_send: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomAuthorizer resource.
        :param pulumi.Input[str] function_urn: Specifies the uniform function URN of the function graph resource.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the
               custom authorizer belongs to.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[int] cache_age: Specifies the maximum cache age.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]] identities: Specifies an array of one or more parameter identities of the custom authorizer.
               The object structure is documented below.
        :param pulumi.Input[bool] is_body_send: Specifies whether to send the body.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] name: Specifies the name of the parameter to be verified.
               The parameter includes front-end and back-end parameters.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the custom authorizer resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] type: Specifies the custom authoriz type.
               The valid values are *FRONTEND* and *BACKEND*.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] user_data: Specifies the user data, which can contain a maximum of 2,048 characters.
               The user data is used by APIG to invoke the specified authentication function when accessing the backend service.
               Changing this will create a new custom authorizer resource.
        """
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "instance_id", instance_id)
        if cache_age is not None:
            pulumi.set(__self__, "cache_age", cache_age)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if is_body_send is not None:
            pulumi.set(__self__, "is_body_send", is_body_send)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[str]:
        """
        Specifies the uniform function URN of the function graph resource.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_urn", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the
        custom authorizer belongs to.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="cacheAge")
    def cache_age(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum cache age.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "cache_age")

    @cache_age.setter
    def cache_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_age", value)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]]:
        """
        Specifies an array of one or more parameter identities of the custom authorizer.
        The object structure is documented below.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter(name="isBodySend")
    def is_body_send(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send the body.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "is_body_send")

    @is_body_send.setter
    def is_body_send(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_body_send", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the parameter to be verified.
        The parameter includes front-end and back-end parameters.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the custom authorizer resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the custom authoriz type.
        The valid values are *FRONTEND* and *BACKEND*.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user data, which can contain a maximum of 2,048 characters.
        The user data is used by APIG to invoke the specified authentication function when accessing the backend service.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _CustomAuthorizerState:
    def __init__(__self__, *,
                 cache_age: Optional[pulumi.Input[int]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 function_urn: Optional[pulumi.Input[str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_body_send: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomAuthorizer resources.
        :param pulumi.Input[int] cache_age: Specifies the maximum cache age.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] create_time: Time when the APIG custom authorizer was created.
        :param pulumi.Input[str] function_urn: Specifies the uniform function URN of the function graph resource.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]] identities: Specifies an array of one or more parameter identities of the custom authorizer.
               The object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the
               custom authorizer belongs to.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[bool] is_body_send: Specifies whether to send the body.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] name: Specifies the name of the parameter to be verified.
               The parameter includes front-end and back-end parameters.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the custom authorizer resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] type: Specifies the custom authoriz type.
               The valid values are *FRONTEND* and *BACKEND*.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] user_data: Specifies the user data, which can contain a maximum of 2,048 characters.
               The user data is used by APIG to invoke the specified authentication function when accessing the backend service.
               Changing this will create a new custom authorizer resource.
        """
        if cache_age is not None:
            pulumi.set(__self__, "cache_age", cache_age)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if function_urn is not None:
            pulumi.set(__self__, "function_urn", function_urn)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_body_send is not None:
            pulumi.set(__self__, "is_body_send", is_body_send)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="cacheAge")
    def cache_age(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum cache age.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "cache_age")

    @cache_age.setter
    def cache_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cache_age", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the APIG custom authorizer was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the uniform function URN of the function graph resource.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_urn", value)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]]:
        """
        Specifies an array of one or more parameter identities of the custom authorizer.
        The object structure is documented below.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the APIG dedicated instance to which the
        custom authorizer belongs to.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="isBodySend")
    def is_body_send(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send the body.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "is_body_send")

    @is_body_send.setter
    def is_body_send(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_body_send", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the parameter to be verified.
        The parameter includes front-end and back-end parameters.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the custom authorizer resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the custom authoriz type.
        The valid values are *FRONTEND* and *BACKEND*.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user data, which can contain a maximum of 2,048 characters.
        The user data is used by APIG to invoke the specified authentication function when accessing the backend service.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


class CustomAuthorizer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_age: Optional[pulumi.Input[int]] = None,
                 function_urn: Optional[pulumi.Input[str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomAuthorizerIdentityArgs']]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_body_send: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an APIG custom authorizer resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        authorizer_name = config.require_object("authorizerName")
        function_urn = config.require_object("functionUrn")
        test = huaweicloud.dedicated_apig.CustomAuthorizer("test",
            instance_id=instance_id,
            function_urn=function_urn,
            type="FRONTEND",
            cache_age=60,
            identities=[huaweicloud.dedicated_apig.CustomAuthorizerIdentityArgs(
                name="user_name",
                location="QUERY",
            )])
        ```

        ## Import

        Custom Authorizers of the APIG can be imported using their `name` and the ID of the APIG instance to which the group belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/customAuthorizer:CustomAuthorizer test <instance id>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cache_age: Specifies the maximum cache age.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] function_urn: Specifies the uniform function URN of the function graph resource.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomAuthorizerIdentityArgs']]]] identities: Specifies an array of one or more parameter identities of the custom authorizer.
               The object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the
               custom authorizer belongs to.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[bool] is_body_send: Specifies whether to send the body.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] name: Specifies the name of the parameter to be verified.
               The parameter includes front-end and back-end parameters.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the custom authorizer resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] type: Specifies the custom authoriz type.
               The valid values are *FRONTEND* and *BACKEND*.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] user_data: Specifies the user data, which can contain a maximum of 2,048 characters.
               The user data is used by APIG to invoke the specified authentication function when accessing the backend service.
               Changing this will create a new custom authorizer resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomAuthorizerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an APIG custom authorizer resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        authorizer_name = config.require_object("authorizerName")
        function_urn = config.require_object("functionUrn")
        test = huaweicloud.dedicated_apig.CustomAuthorizer("test",
            instance_id=instance_id,
            function_urn=function_urn,
            type="FRONTEND",
            cache_age=60,
            identities=[huaweicloud.dedicated_apig.CustomAuthorizerIdentityArgs(
                name="user_name",
                location="QUERY",
            )])
        ```

        ## Import

        Custom Authorizers of the APIG can be imported using their `name` and the ID of the APIG instance to which the group belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/customAuthorizer:CustomAuthorizer test <instance id>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param CustomAuthorizerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomAuthorizerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_age: Optional[pulumi.Input[int]] = None,
                 function_urn: Optional[pulumi.Input[str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomAuthorizerIdentityArgs']]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_body_send: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomAuthorizerArgs.__new__(CustomAuthorizerArgs)

            __props__.__dict__["cache_age"] = cache_age
            if function_urn is None and not opts.urn:
                raise TypeError("Missing required property 'function_urn'")
            __props__.__dict__["function_urn"] = function_urn
            __props__.__dict__["identities"] = identities
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["is_body_send"] = is_body_send
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["type"] = type
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["create_time"] = None
        super(CustomAuthorizer, __self__).__init__(
            'huaweicloud:DedicatedApig/customAuthorizer:CustomAuthorizer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_age: Optional[pulumi.Input[int]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            function_urn: Optional[pulumi.Input[str]] = None,
            identities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomAuthorizerIdentityArgs']]]]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            is_body_send: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[str]] = None) -> 'CustomAuthorizer':
        """
        Get an existing CustomAuthorizer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cache_age: Specifies the maximum cache age.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] create_time: Time when the APIG custom authorizer was created.
        :param pulumi.Input[str] function_urn: Specifies the uniform function URN of the function graph resource.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomAuthorizerIdentityArgs']]]] identities: Specifies an array of one or more parameter identities of the custom authorizer.
               The object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the
               custom authorizer belongs to.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[bool] is_body_send: Specifies whether to send the body.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] name: Specifies the name of the parameter to be verified.
               The parameter includes front-end and back-end parameters.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the custom authorizer resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] type: Specifies the custom authoriz type.
               The valid values are *FRONTEND* and *BACKEND*.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] user_data: Specifies the user data, which can contain a maximum of 2,048 characters.
               The user data is used by APIG to invoke the specified authentication function when accessing the backend service.
               Changing this will create a new custom authorizer resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomAuthorizerState.__new__(_CustomAuthorizerState)

        __props__.__dict__["cache_age"] = cache_age
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["function_urn"] = function_urn
        __props__.__dict__["identities"] = identities
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_body_send"] = is_body_send
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["user_data"] = user_data
        return CustomAuthorizer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cacheAge")
    def cache_age(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum cache age.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "cache_age")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the APIG custom authorizer was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Output[str]:
        """
        Specifies the uniform function URN of the function graph resource.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "function_urn")

    @property
    @pulumi.getter
    def identities(self) -> pulumi.Output[Optional[Sequence['outputs.CustomAuthorizerIdentity']]]:
        """
        Specifies an array of one or more parameter identities of the custom authorizer.
        The object structure is documented below.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the
        custom authorizer belongs to.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isBodySend")
    def is_body_send(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to send the body.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "is_body_send")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the parameter to be verified.
        The parameter includes front-end and back-end parameters.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the custom authorizer resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the custom authoriz type.
        The valid values are *FRONTEND* and *BACKEND*.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the user data, which can contain a maximum of 2,048 characters.
        The user data is used by APIG to invoke the specified authentication function when accessing the backend service.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "user_data")

