# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 request_method: pulumi.Input[str],
                 request_path: pulumi.Input[str],
                 request_protocol: pulumi.Input[str],
                 type: pulumi.Input[str],
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]] = None,
                 body_description: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failure_response: Optional[pulumi.Input[str]] = None,
                 func_graph: Optional[pulumi.Input['ApiFuncGraphArgs']] = None,
                 func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]] = None,
                 matching: Optional[pulumi.Input[str]] = None,
                 mock: Optional[pulumi.Input['ApiMockArgs']] = None,
                 mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]] = None,
                 response_id: Optional[pulumi.Input[str]] = None,
                 security_authentication: Optional[pulumi.Input[str]] = None,
                 simple_authentication: Optional[pulumi.Input[bool]] = None,
                 success_response: Optional[pulumi.Input[str]] = None,
                 web: Optional[pulumi.Input['ApiWebArgs']] = None,
                 web_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input[str] group_id: Specifies an ID of the APIG group to which the API belongs to.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API belongs
               to. Changing this will create a new API resource.
        :param pulumi.Input[str] request_method: Specifies the backend request method of the API. The valid types are **GET**,
               **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        :param pulumi.Input[str] request_path: Specifies the request address, which can contain a maximum of 512 characters
               request parameters enclosed with brackets ({}).
               + The address can contain special characters, such as asterisks (), percent signs (%), hyphens (-), and
               underscores (_) and must comply with URI specifications.
               + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        :param pulumi.Input[str] request_protocol: Specifies the backend request protocol. The valid values are **HTTP** and
               **HTTPS**, default to **HTTPS**.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param pulumi.Input[str] body_description: Specifies the description of the API request body, which can be an example
               request body, media type or parameters. The request body does not exceed 20,480 characters. Chinese characters must be
               in UTF-8 or Unicode format.
        :param pulumi.Input[bool] cors: Specifies whether CORS is supported, default to false.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] failure_response: Specifies the example response for a successful request. Ensure that the
               response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input['ApiFuncGraphArgs'] func_graph: Specifies the function graph backend details. The object
               structure is documented below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]] func_graph_policies: Specifies the Mock policy backends. The maximum of the policy is 5.
               The object structure is documented below.
        :param pulumi.Input[str] matching: Specifies the route matching mode. The valid value are **Exact** and **Prefix**,
               default to **Exact**.
        :param pulumi.Input['ApiMockArgs'] mock: Specifies the mock backend details. The object structure is documented
               below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]] mock_policies: Specifies the Mock policy backends. The maximum of the policy is 5.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create the API resource. If omitted, the
               provider-level region will be used. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]] request_params: Specifies an array of one or more request parameters of the front-end. The maximum
               of request parameters is 50. The object structure is documented below.
        :param pulumi.Input[str] response_id: Specifies the APIG group response ID.
        :param pulumi.Input[str] security_authentication: Specifies the security authentication mode. The valid values are
               **NONE**, **APP** and **IAM**, default to **NONE**.
        :param pulumi.Input[bool] simple_authentication: Specifies whether AppCode authentication is enabled. The applicaiton code
               must located in the header when `simple_authentication` is true.
        :param pulumi.Input[str] success_response: Specifies the example response for a successful request. Ensure that the
               response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input['ApiWebArgs'] web: Specifies the web backend details. The object structure is documented
               below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]] web_policies: Specifies the example response for a failed request. The maximum of the policy is 5.
               The object structure is documented below.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "request_method", request_method)
        pulumi.set(__self__, "request_path", request_path)
        pulumi.set(__self__, "request_protocol", request_protocol)
        pulumi.set(__self__, "type", type)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if body_description is not None:
            pulumi.set(__self__, "body_description", body_description)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failure_response is not None:
            pulumi.set(__self__, "failure_response", failure_response)
        if func_graph is not None:
            pulumi.set(__self__, "func_graph", func_graph)
        if func_graph_policies is not None:
            pulumi.set(__self__, "func_graph_policies", func_graph_policies)
        if matching is not None:
            pulumi.set(__self__, "matching", matching)
        if mock is not None:
            pulumi.set(__self__, "mock", mock)
        if mock_policies is not None:
            pulumi.set(__self__, "mock_policies", mock_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_params is not None:
            pulumi.set(__self__, "request_params", request_params)
        if response_id is not None:
            pulumi.set(__self__, "response_id", response_id)
        if security_authentication is not None:
            pulumi.set(__self__, "security_authentication", security_authentication)
        if simple_authentication is not None:
            pulumi.set(__self__, "simple_authentication", simple_authentication)
        if success_response is not None:
            pulumi.set(__self__, "success_response", success_response)
        if web is not None:
            pulumi.set(__self__, "web", web)
        if web_policies is not None:
            pulumi.set(__self__, "web_policies", web_policies)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the APIG group to which the API belongs to.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the API belongs
        to. Changing this will create a new API resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> pulumi.Input[str]:
        """
        Specifies the backend request method of the API. The valid types are **GET**,
        **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: pulumi.Input[str]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> pulumi.Input[str]:
        """
        Specifies the request address, which can contain a maximum of 512 characters
        request parameters enclosed with brackets ({}).
        + The address can contain special characters, such as asterisks (), percent signs (%), hyphens (-), and
        underscores (_) and must comply with URI specifications.
        + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "request_path", value)

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> pulumi.Input[str]:
        """
        Specifies the backend request protocol. The valid values are **HTTP** and
        **HTTPS**, default to **HTTPS**.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "request_protocol", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @backend_params.setter
    def backend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]]):
        pulumi.set(self, "backend_params", value)

    @property
    @pulumi.getter(name="bodyDescription")
    def body_description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the API request body, which can be an example
        request body, media type or parameters. The request body does not exceed 20,480 characters. Chinese characters must be
        in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "body_description")

    @body_description.setter
    def body_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body_description", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether CORS is supported, default to false.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="failureResponse")
    def failure_response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the example response for a successful request. Ensure that the
        response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "failure_response")

    @failure_response.setter
    def failure_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failure_response", value)

    @property
    @pulumi.getter(name="funcGraph")
    def func_graph(self) -> Optional[pulumi.Input['ApiFuncGraphArgs']]:
        """
        Specifies the function graph backend details. The object
        structure is documented below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "func_graph")

    @func_graph.setter
    def func_graph(self, value: Optional[pulumi.Input['ApiFuncGraphArgs']]):
        pulumi.set(self, "func_graph", value)

    @property
    @pulumi.getter(name="funcGraphPolicies")
    def func_graph_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]]:
        """
        Specifies the Mock policy backends. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "func_graph_policies")

    @func_graph_policies.setter
    def func_graph_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]]):
        pulumi.set(self, "func_graph_policies", value)

    @property
    @pulumi.getter
    def matching(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the route matching mode. The valid value are **Exact** and **Prefix**,
        default to **Exact**.
        """
        return pulumi.get(self, "matching")

    @matching.setter
    def matching(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "matching", value)

    @property
    @pulumi.getter
    def mock(self) -> Optional[pulumi.Input['ApiMockArgs']]:
        """
        Specifies the mock backend details. The object structure is documented
        below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "mock")

    @mock.setter
    def mock(self, value: Optional[pulumi.Input['ApiMockArgs']]):
        pulumi.set(self, "mock", value)

    @property
    @pulumi.getter(name="mockPolicies")
    def mock_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]]:
        """
        Specifies the Mock policy backends. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "mock_policies")

    @mock_policies.setter
    def mock_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]]):
        pulumi.set(self, "mock_policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the API resource. If omitted, the
        provider-level region will be used. Changing this will create a new API resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestParams")
    def request_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]]:
        """
        Specifies an array of one or more request parameters of the front-end. The maximum
        of request parameters is 50. The object structure is documented below.
        """
        return pulumi.get(self, "request_params")

    @request_params.setter
    def request_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]]):
        pulumi.set(self, "request_params", value)

    @property
    @pulumi.getter(name="responseId")
    def response_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the APIG group response ID.
        """
        return pulumi.get(self, "response_id")

    @response_id.setter
    def response_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_id", value)

    @property
    @pulumi.getter(name="securityAuthentication")
    def security_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security authentication mode. The valid values are
        **NONE**, **APP** and **IAM**, default to **NONE**.
        """
        return pulumi.get(self, "security_authentication")

    @security_authentication.setter
    def security_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_authentication", value)

    @property
    @pulumi.getter(name="simpleAuthentication")
    def simple_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether AppCode authentication is enabled. The applicaiton code
        must located in the header when `simple_authentication` is true.
        """
        return pulumi.get(self, "simple_authentication")

    @simple_authentication.setter
    def simple_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "simple_authentication", value)

    @property
    @pulumi.getter(name="successResponse")
    def success_response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the example response for a successful request. Ensure that the
        response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "success_response")

    @success_response.setter
    def success_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "success_response", value)

    @property
    @pulumi.getter
    def web(self) -> Optional[pulumi.Input['ApiWebArgs']]:
        """
        Specifies the web backend details. The object structure is documented
        below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "web")

    @web.setter
    def web(self, value: Optional[pulumi.Input['ApiWebArgs']]):
        pulumi.set(self, "web", value)

    @property
    @pulumi.getter(name="webPolicies")
    def web_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]]:
        """
        Specifies the example response for a failed request. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "web_policies")

    @web_policies.setter
    def web_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]]):
        pulumi.set(self, "web_policies", value)


@pulumi.input_type
class _ApiState:
    def __init__(__self__, *,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]] = None,
                 body_description: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failure_response: Optional[pulumi.Input[str]] = None,
                 func_graph: Optional[pulumi.Input['ApiFuncGraphArgs']] = None,
                 func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 matching: Optional[pulumi.Input[str]] = None,
                 mock: Optional[pulumi.Input['ApiMockArgs']] = None,
                 mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 register_time: Optional[pulumi.Input[str]] = None,
                 request_method: Optional[pulumi.Input[str]] = None,
                 request_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]] = None,
                 request_path: Optional[pulumi.Input[str]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 response_id: Optional[pulumi.Input[str]] = None,
                 security_authentication: Optional[pulumi.Input[str]] = None,
                 simple_authentication: Optional[pulumi.Input[bool]] = None,
                 success_response: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 web: Optional[pulumi.Input['ApiWebArgs']] = None,
                 web_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]] = None):
        """
        Input properties used for looking up and filtering Api resources.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param pulumi.Input[str] body_description: Specifies the description of the API request body, which can be an example
               request body, media type or parameters. The request body does not exceed 20,480 characters. Chinese characters must be
               in UTF-8 or Unicode format.
        :param pulumi.Input[bool] cors: Specifies whether CORS is supported, default to false.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] failure_response: Specifies the example response for a successful request. Ensure that the
               response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input['ApiFuncGraphArgs'] func_graph: Specifies the function graph backend details. The object
               structure is documented below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]] func_graph_policies: Specifies the Mock policy backends. The maximum of the policy is 5.
               The object structure is documented below.
        :param pulumi.Input[str] group_id: Specifies an ID of the APIG group to which the API belongs to.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API belongs
               to. Changing this will create a new API resource.
        :param pulumi.Input[str] matching: Specifies the route matching mode. The valid value are **Exact** and **Prefix**,
               default to **Exact**.
        :param pulumi.Input['ApiMockArgs'] mock: Specifies the mock backend details. The object structure is documented
               below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]] mock_policies: Specifies the Mock policy backends. The maximum of the policy is 5.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create the API resource. If omitted, the
               provider-level region will be used. Changing this will create a new API resource.
        :param pulumi.Input[str] register_time: Time when the API is registered, in UTC format.
        :param pulumi.Input[str] request_method: Specifies the backend request method of the API. The valid types are **GET**,
               **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        :param pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]] request_params: Specifies an array of one or more request parameters of the front-end. The maximum
               of request parameters is 50. The object structure is documented below.
        :param pulumi.Input[str] request_path: Specifies the request address, which can contain a maximum of 512 characters
               request parameters enclosed with brackets ({}).
               + The address can contain special characters, such as asterisks (), percent signs (%), hyphens (-), and
               underscores (_) and must comply with URI specifications.
               + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        :param pulumi.Input[str] request_protocol: Specifies the backend request protocol. The valid values are **HTTP** and
               **HTTPS**, default to **HTTPS**.
        :param pulumi.Input[str] response_id: Specifies the APIG group response ID.
        :param pulumi.Input[str] security_authentication: Specifies the security authentication mode. The valid values are
               **NONE**, **APP** and **IAM**, default to **NONE**.
        :param pulumi.Input[bool] simple_authentication: Specifies whether AppCode authentication is enabled. The applicaiton code
               must located in the header when `simple_authentication` is true.
        :param pulumi.Input[str] success_response: Specifies the example response for a successful request. Ensure that the
               response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param pulumi.Input[str] update_time: Time when the API was last modified, in UTC format.
        :param pulumi.Input['ApiWebArgs'] web: Specifies the web backend details. The object structure is documented
               below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]] web_policies: Specifies the example response for a failed request. The maximum of the policy is 5.
               The object structure is documented below.
        """
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if body_description is not None:
            pulumi.set(__self__, "body_description", body_description)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failure_response is not None:
            pulumi.set(__self__, "failure_response", failure_response)
        if func_graph is not None:
            pulumi.set(__self__, "func_graph", func_graph)
        if func_graph_policies is not None:
            pulumi.set(__self__, "func_graph_policies", func_graph_policies)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if matching is not None:
            pulumi.set(__self__, "matching", matching)
        if mock is not None:
            pulumi.set(__self__, "mock", mock)
        if mock_policies is not None:
            pulumi.set(__self__, "mock_policies", mock_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if register_time is not None:
            pulumi.set(__self__, "register_time", register_time)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if request_params is not None:
            pulumi.set(__self__, "request_params", request_params)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if response_id is not None:
            pulumi.set(__self__, "response_id", response_id)
        if security_authentication is not None:
            pulumi.set(__self__, "security_authentication", security_authentication)
        if simple_authentication is not None:
            pulumi.set(__self__, "simple_authentication", simple_authentication)
        if success_response is not None:
            pulumi.set(__self__, "success_response", success_response)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if web is not None:
            pulumi.set(__self__, "web", web)
        if web_policies is not None:
            pulumi.set(__self__, "web_policies", web_policies)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @backend_params.setter
    def backend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]]):
        pulumi.set(self, "backend_params", value)

    @property
    @pulumi.getter(name="bodyDescription")
    def body_description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the API request body, which can be an example
        request body, media type or parameters. The request body does not exceed 20,480 characters. Chinese characters must be
        in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "body_description")

    @body_description.setter
    def body_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body_description", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether CORS is supported, default to false.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="failureResponse")
    def failure_response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the example response for a successful request. Ensure that the
        response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "failure_response")

    @failure_response.setter
    def failure_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failure_response", value)

    @property
    @pulumi.getter(name="funcGraph")
    def func_graph(self) -> Optional[pulumi.Input['ApiFuncGraphArgs']]:
        """
        Specifies the function graph backend details. The object
        structure is documented below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "func_graph")

    @func_graph.setter
    def func_graph(self, value: Optional[pulumi.Input['ApiFuncGraphArgs']]):
        pulumi.set(self, "func_graph", value)

    @property
    @pulumi.getter(name="funcGraphPolicies")
    def func_graph_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]]:
        """
        Specifies the Mock policy backends. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "func_graph_policies")

    @func_graph_policies.setter
    def func_graph_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]]):
        pulumi.set(self, "func_graph_policies", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the APIG group to which the API belongs to.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the APIG dedicated instance to which the API belongs
        to. Changing this will create a new API resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def matching(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the route matching mode. The valid value are **Exact** and **Prefix**,
        default to **Exact**.
        """
        return pulumi.get(self, "matching")

    @matching.setter
    def matching(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "matching", value)

    @property
    @pulumi.getter
    def mock(self) -> Optional[pulumi.Input['ApiMockArgs']]:
        """
        Specifies the mock backend details. The object structure is documented
        below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "mock")

    @mock.setter
    def mock(self, value: Optional[pulumi.Input['ApiMockArgs']]):
        pulumi.set(self, "mock", value)

    @property
    @pulumi.getter(name="mockPolicies")
    def mock_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]]:
        """
        Specifies the Mock policy backends. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "mock_policies")

    @mock_policies.setter
    def mock_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]]):
        pulumi.set(self, "mock_policies", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the API resource. If omitted, the
        provider-level region will be used. Changing this will create a new API resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registerTime")
    def register_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the API is registered, in UTC format.
        """
        return pulumi.get(self, "register_time")

    @register_time.setter
    def register_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "register_time", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend request method of the API. The valid types are **GET**,
        **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter(name="requestParams")
    def request_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]]:
        """
        Specifies an array of one or more request parameters of the front-end. The maximum
        of request parameters is 50. The object structure is documented below.
        """
        return pulumi.get(self, "request_params")

    @request_params.setter
    def request_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]]):
        pulumi.set(self, "request_params", value)

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request address, which can contain a maximum of 512 characters
        request parameters enclosed with brackets ({}).
        + The address can contain special characters, such as asterisks (), percent signs (%), hyphens (-), and
        underscores (_) and must comply with URI specifications.
        + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_path", value)

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend request protocol. The valid values are **HTTP** and
        **HTTPS**, default to **HTTPS**.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_protocol", value)

    @property
    @pulumi.getter(name="responseId")
    def response_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the APIG group response ID.
        """
        return pulumi.get(self, "response_id")

    @response_id.setter
    def response_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_id", value)

    @property
    @pulumi.getter(name="securityAuthentication")
    def security_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security authentication mode. The valid values are
        **NONE**, **APP** and **IAM**, default to **NONE**.
        """
        return pulumi.get(self, "security_authentication")

    @security_authentication.setter
    def security_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_authentication", value)

    @property
    @pulumi.getter(name="simpleAuthentication")
    def simple_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether AppCode authentication is enabled. The applicaiton code
        must located in the header when `simple_authentication` is true.
        """
        return pulumi.get(self, "simple_authentication")

    @simple_authentication.setter
    def simple_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "simple_authentication", value)

    @property
    @pulumi.getter(name="successResponse")
    def success_response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the example response for a successful request. Ensure that the
        response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "success_response")

    @success_response.setter
    def success_response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "success_response", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the API was last modified, in UTC format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def web(self) -> Optional[pulumi.Input['ApiWebArgs']]:
        """
        Specifies the web backend details. The object structure is documented
        below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "web")

    @web.setter
    def web(self, value: Optional[pulumi.Input['ApiWebArgs']]):
        pulumi.set(self, "web", value)

    @property
    @pulumi.getter(name="webPolicies")
    def web_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]]:
        """
        Specifies the example response for a failed request. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "web_policies")

    @web_policies.setter
    def web_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]]):
        pulumi.set(self, "web_policies", value)


class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParamArgs']]]]] = None,
                 body_description: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failure_response: Optional[pulumi.Input[str]] = None,
                 func_graph: Optional[pulumi.Input[pulumi.InputType['ApiFuncGraphArgs']]] = None,
                 func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiFuncGraphPolicyArgs']]]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 matching: Optional[pulumi.Input[str]] = None,
                 mock: Optional[pulumi.Input[pulumi.InputType['ApiMockArgs']]] = None,
                 mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiMockPolicyArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_method: Optional[pulumi.Input[str]] = None,
                 request_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParamArgs']]]]] = None,
                 request_path: Optional[pulumi.Input[str]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 response_id: Optional[pulumi.Input[str]] = None,
                 security_authentication: Optional[pulumi.Input[str]] = None,
                 simple_authentication: Optional[pulumi.Input[bool]] = None,
                 success_response: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 web: Optional[pulumi.Input[pulumi.InputType['ApiWebArgs']]] = None,
                 web_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiWebPolicyArgs']]]]] = None,
                 __props__=None):
        """
        Manages an APIG API resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        group_id = config.require_object("groupId")
        api_name = config.require_object("apiName")
        custom_response_id = config.require_object("customResponseId")
        custom_auth_id = config.require_object("customAuthId")
        vpc_channel_id = config.require_object("vpcChannelId")
        test = huaweicloud.dedicated_apig.Api("test",
            instance_id=instance_id,
            group_id=group_id,
            type="Public",
            request_protocol="HTTP",
            request_method="POST",
            request_path="/terraform/users",
            security_authentication="AUTHORIZER",
            matching="Exact",
            success_response="Successful",
            response_id=custom_response_id,
            authorizer_id=custom_auth_id,
            backend_params=[huaweicloud.dedicated_apig.ApiBackendParamArgs(
                type="SYSTEM",
                name="X-User-Auth",
                location="HEADER",
                value="user_name",
            )],
            web=huaweicloud.dedicated_apig.ApiWebArgs(
                path="/backend/users",
                vpc_channel_id=vpc_channel_id,
                request_method="POST",
                request_protocol="HTTP",
                timeout=5000,
            ))
        ```

        ## Import

        APIs can be imported using their `name` and ID of the APIG dedicated instance to which the API belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/api:Api test <instance_id>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParamArgs']]]] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param pulumi.Input[str] body_description: Specifies the description of the API request body, which can be an example
               request body, media type or parameters. The request body does not exceed 20,480 characters. Chinese characters must be
               in UTF-8 or Unicode format.
        :param pulumi.Input[bool] cors: Specifies whether CORS is supported, default to false.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] failure_response: Specifies the example response for a successful request. Ensure that the
               response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[pulumi.InputType['ApiFuncGraphArgs']] func_graph: Specifies the function graph backend details. The object
               structure is documented below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiFuncGraphPolicyArgs']]]] func_graph_policies: Specifies the Mock policy backends. The maximum of the policy is 5.
               The object structure is documented below.
        :param pulumi.Input[str] group_id: Specifies an ID of the APIG group to which the API belongs to.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API belongs
               to. Changing this will create a new API resource.
        :param pulumi.Input[str] matching: Specifies the route matching mode. The valid value are **Exact** and **Prefix**,
               default to **Exact**.
        :param pulumi.Input[pulumi.InputType['ApiMockArgs']] mock: Specifies the mock backend details. The object structure is documented
               below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiMockPolicyArgs']]]] mock_policies: Specifies the Mock policy backends. The maximum of the policy is 5.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create the API resource. If omitted, the
               provider-level region will be used. Changing this will create a new API resource.
        :param pulumi.Input[str] request_method: Specifies the backend request method of the API. The valid types are **GET**,
               **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParamArgs']]]] request_params: Specifies an array of one or more request parameters of the front-end. The maximum
               of request parameters is 50. The object structure is documented below.
        :param pulumi.Input[str] request_path: Specifies the request address, which can contain a maximum of 512 characters
               request parameters enclosed with brackets ({}).
               + The address can contain special characters, such as asterisks (), percent signs (%), hyphens (-), and
               underscores (_) and must comply with URI specifications.
               + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        :param pulumi.Input[str] request_protocol: Specifies the backend request protocol. The valid values are **HTTP** and
               **HTTPS**, default to **HTTPS**.
        :param pulumi.Input[str] response_id: Specifies the APIG group response ID.
        :param pulumi.Input[str] security_authentication: Specifies the security authentication mode. The valid values are
               **NONE**, **APP** and **IAM**, default to **NONE**.
        :param pulumi.Input[bool] simple_authentication: Specifies whether AppCode authentication is enabled. The applicaiton code
               must located in the header when `simple_authentication` is true.
        :param pulumi.Input[str] success_response: Specifies the example response for a successful request. Ensure that the
               response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param pulumi.Input[pulumi.InputType['ApiWebArgs']] web: Specifies the web backend details. The object structure is documented
               below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiWebPolicyArgs']]]] web_policies: Specifies the example response for a failed request. The maximum of the policy is 5.
               The object structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an APIG API resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        group_id = config.require_object("groupId")
        api_name = config.require_object("apiName")
        custom_response_id = config.require_object("customResponseId")
        custom_auth_id = config.require_object("customAuthId")
        vpc_channel_id = config.require_object("vpcChannelId")
        test = huaweicloud.dedicated_apig.Api("test",
            instance_id=instance_id,
            group_id=group_id,
            type="Public",
            request_protocol="HTTP",
            request_method="POST",
            request_path="/terraform/users",
            security_authentication="AUTHORIZER",
            matching="Exact",
            success_response="Successful",
            response_id=custom_response_id,
            authorizer_id=custom_auth_id,
            backend_params=[huaweicloud.dedicated_apig.ApiBackendParamArgs(
                type="SYSTEM",
                name="X-User-Auth",
                location="HEADER",
                value="user_name",
            )],
            web=huaweicloud.dedicated_apig.ApiWebArgs(
                path="/backend/users",
                vpc_channel_id=vpc_channel_id,
                request_method="POST",
                request_protocol="HTTP",
                timeout=5000,
            ))
        ```

        ## Import

        APIs can be imported using their `name` and ID of the APIG dedicated instance to which the API belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/api:Api test <instance_id>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParamArgs']]]]] = None,
                 body_description: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failure_response: Optional[pulumi.Input[str]] = None,
                 func_graph: Optional[pulumi.Input[pulumi.InputType['ApiFuncGraphArgs']]] = None,
                 func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiFuncGraphPolicyArgs']]]]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 matching: Optional[pulumi.Input[str]] = None,
                 mock: Optional[pulumi.Input[pulumi.InputType['ApiMockArgs']]] = None,
                 mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiMockPolicyArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_method: Optional[pulumi.Input[str]] = None,
                 request_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParamArgs']]]]] = None,
                 request_path: Optional[pulumi.Input[str]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 response_id: Optional[pulumi.Input[str]] = None,
                 security_authentication: Optional[pulumi.Input[str]] = None,
                 simple_authentication: Optional[pulumi.Input[bool]] = None,
                 success_response: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 web: Optional[pulumi.Input[pulumi.InputType['ApiWebArgs']]] = None,
                 web_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiWebPolicyArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            __props__.__dict__["authorizer_id"] = authorizer_id
            __props__.__dict__["backend_params"] = backend_params
            __props__.__dict__["body_description"] = body_description
            __props__.__dict__["cors"] = cors
            __props__.__dict__["description"] = description
            __props__.__dict__["failure_response"] = failure_response
            __props__.__dict__["func_graph"] = func_graph
            __props__.__dict__["func_graph_policies"] = func_graph_policies
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["matching"] = matching
            __props__.__dict__["mock"] = mock
            __props__.__dict__["mock_policies"] = mock_policies
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if request_method is None and not opts.urn:
                raise TypeError("Missing required property 'request_method'")
            __props__.__dict__["request_method"] = request_method
            __props__.__dict__["request_params"] = request_params
            if request_path is None and not opts.urn:
                raise TypeError("Missing required property 'request_path'")
            __props__.__dict__["request_path"] = request_path
            if request_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'request_protocol'")
            __props__.__dict__["request_protocol"] = request_protocol
            __props__.__dict__["response_id"] = response_id
            __props__.__dict__["security_authentication"] = security_authentication
            __props__.__dict__["simple_authentication"] = simple_authentication
            __props__.__dict__["success_response"] = success_response
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["web"] = web
            __props__.__dict__["web_policies"] = web_policies
            __props__.__dict__["register_time"] = None
            __props__.__dict__["update_time"] = None
        super(Api, __self__).__init__(
            'huaweicloud:DedicatedApig/api:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorizer_id: Optional[pulumi.Input[str]] = None,
            backend_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParamArgs']]]]] = None,
            body_description: Optional[pulumi.Input[str]] = None,
            cors: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            failure_response: Optional[pulumi.Input[str]] = None,
            func_graph: Optional[pulumi.Input[pulumi.InputType['ApiFuncGraphArgs']]] = None,
            func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiFuncGraphPolicyArgs']]]]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            matching: Optional[pulumi.Input[str]] = None,
            mock: Optional[pulumi.Input[pulumi.InputType['ApiMockArgs']]] = None,
            mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiMockPolicyArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            register_time: Optional[pulumi.Input[str]] = None,
            request_method: Optional[pulumi.Input[str]] = None,
            request_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParamArgs']]]]] = None,
            request_path: Optional[pulumi.Input[str]] = None,
            request_protocol: Optional[pulumi.Input[str]] = None,
            response_id: Optional[pulumi.Input[str]] = None,
            security_authentication: Optional[pulumi.Input[str]] = None,
            simple_authentication: Optional[pulumi.Input[bool]] = None,
            success_response: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            web: Optional[pulumi.Input[pulumi.InputType['ApiWebArgs']]] = None,
            web_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiWebPolicyArgs']]]]] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiBackendParamArgs']]]] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param pulumi.Input[str] body_description: Specifies the description of the API request body, which can be an example
               request body, media type or parameters. The request body does not exceed 20,480 characters. Chinese characters must be
               in UTF-8 or Unicode format.
        :param pulumi.Input[bool] cors: Specifies whether CORS is supported, default to false.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] failure_response: Specifies the example response for a successful request. Ensure that the
               response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[pulumi.InputType['ApiFuncGraphArgs']] func_graph: Specifies the function graph backend details. The object
               structure is documented below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiFuncGraphPolicyArgs']]]] func_graph_policies: Specifies the Mock policy backends. The maximum of the policy is 5.
               The object structure is documented below.
        :param pulumi.Input[str] group_id: Specifies an ID of the APIG group to which the API belongs to.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API belongs
               to. Changing this will create a new API resource.
        :param pulumi.Input[str] matching: Specifies the route matching mode. The valid value are **Exact** and **Prefix**,
               default to **Exact**.
        :param pulumi.Input[pulumi.InputType['ApiMockArgs']] mock: Specifies the mock backend details. The object structure is documented
               below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiMockPolicyArgs']]]] mock_policies: Specifies the Mock policy backends. The maximum of the policy is 5.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create the API resource. If omitted, the
               provider-level region will be used. Changing this will create a new API resource.
        :param pulumi.Input[str] register_time: Time when the API is registered, in UTC format.
        :param pulumi.Input[str] request_method: Specifies the backend request method of the API. The valid types are **GET**,
               **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiRequestParamArgs']]]] request_params: Specifies an array of one or more request parameters of the front-end. The maximum
               of request parameters is 50. The object structure is documented below.
        :param pulumi.Input[str] request_path: Specifies the request address, which can contain a maximum of 512 characters
               request parameters enclosed with brackets ({}).
               + The address can contain special characters, such as asterisks (), percent signs (%), hyphens (-), and
               underscores (_) and must comply with URI specifications.
               + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        :param pulumi.Input[str] request_protocol: Specifies the backend request protocol. The valid values are **HTTP** and
               **HTTPS**, default to **HTTPS**.
        :param pulumi.Input[str] response_id: Specifies the APIG group response ID.
        :param pulumi.Input[str] security_authentication: Specifies the security authentication mode. The valid values are
               **NONE**, **APP** and **IAM**, default to **NONE**.
        :param pulumi.Input[bool] simple_authentication: Specifies whether AppCode authentication is enabled. The applicaiton code
               must located in the header when `simple_authentication` is true.
        :param pulumi.Input[str] success_response: Specifies the example response for a successful request. Ensure that the
               response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param pulumi.Input[str] update_time: Time when the API was last modified, in UTC format.
        :param pulumi.Input[pulumi.InputType['ApiWebArgs']] web: Specifies the web backend details. The object structure is documented
               below. Changing this will create a new API resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiWebPolicyArgs']]]] web_policies: Specifies the example response for a failed request. The maximum of the policy is 5.
               The object structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiState.__new__(_ApiState)

        __props__.__dict__["authorizer_id"] = authorizer_id
        __props__.__dict__["backend_params"] = backend_params
        __props__.__dict__["body_description"] = body_description
        __props__.__dict__["cors"] = cors
        __props__.__dict__["description"] = description
        __props__.__dict__["failure_response"] = failure_response
        __props__.__dict__["func_graph"] = func_graph
        __props__.__dict__["func_graph_policies"] = func_graph_policies
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["matching"] = matching
        __props__.__dict__["mock"] = mock
        __props__.__dict__["mock_policies"] = mock_policies
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["register_time"] = register_time
        __props__.__dict__["request_method"] = request_method
        __props__.__dict__["request_params"] = request_params
        __props__.__dict__["request_path"] = request_path
        __props__.__dict__["request_protocol"] = request_protocol
        __props__.__dict__["response_id"] = response_id
        __props__.__dict__["security_authentication"] = security_authentication
        __props__.__dict__["simple_authentication"] = simple_authentication
        __props__.__dict__["success_response"] = success_response
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["web"] = web
        __props__.__dict__["web_policies"] = web_policies
        return Api(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> pulumi.Output[Optional[Sequence['outputs.ApiBackendParam']]]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @property
    @pulumi.getter(name="bodyDescription")
    def body_description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the API request body, which can be an example
        request body, media type or parameters. The request body does not exceed 20,480 characters. Chinese characters must be
        in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "body_description")

    @property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether CORS is supported, default to false.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="failureResponse")
    def failure_response(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the example response for a successful request. Ensure that the
        response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "failure_response")

    @property
    @pulumi.getter(name="funcGraph")
    def func_graph(self) -> pulumi.Output['outputs.ApiFuncGraph']:
        """
        Specifies the function graph backend details. The object
        structure is documented below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "func_graph")

    @property
    @pulumi.getter(name="funcGraphPolicies")
    def func_graph_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ApiFuncGraphPolicy']]]:
        """
        Specifies the Mock policy backends. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "func_graph_policies")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the APIG group to which the API belongs to.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the API belongs
        to. Changing this will create a new API resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def matching(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the route matching mode. The valid value are **Exact** and **Prefix**,
        default to **Exact**.
        """
        return pulumi.get(self, "matching")

    @property
    @pulumi.getter
    def mock(self) -> pulumi.Output['outputs.ApiMock']:
        """
        Specifies the mock backend details. The object structure is documented
        below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "mock")

    @property
    @pulumi.getter(name="mockPolicies")
    def mock_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ApiMockPolicy']]]:
        """
        Specifies the Mock policy backends. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "mock_policies")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the API resource. If omitted, the
        provider-level region will be used. Changing this will create a new API resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registerTime")
    def register_time(self) -> pulumi.Output[str]:
        """
        Time when the API is registered, in UTC format.
        """
        return pulumi.get(self, "register_time")

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> pulumi.Output[str]:
        """
        Specifies the backend request method of the API. The valid types are **GET**,
        **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        """
        return pulumi.get(self, "request_method")

    @property
    @pulumi.getter(name="requestParams")
    def request_params(self) -> pulumi.Output[Optional[Sequence['outputs.ApiRequestParam']]]:
        """
        Specifies an array of one or more request parameters of the front-end. The maximum
        of request parameters is 50. The object structure is documented below.
        """
        return pulumi.get(self, "request_params")

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> pulumi.Output[str]:
        """
        Specifies the request address, which can contain a maximum of 512 characters
        request parameters enclosed with brackets ({}).
        + The address can contain special characters, such as asterisks (), percent signs (%), hyphens (-), and
        underscores (_) and must comply with URI specifications.
        + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        """
        return pulumi.get(self, "request_path")

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> pulumi.Output[str]:
        """
        Specifies the backend request protocol. The valid values are **HTTP** and
        **HTTPS**, default to **HTTPS**.
        """
        return pulumi.get(self, "request_protocol")

    @property
    @pulumi.getter(name="responseId")
    def response_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the APIG group response ID.
        """
        return pulumi.get(self, "response_id")

    @property
    @pulumi.getter(name="securityAuthentication")
    def security_authentication(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the security authentication mode. The valid values are
        **NONE**, **APP** and **IAM**, default to **NONE**.
        """
        return pulumi.get(self, "security_authentication")

    @property
    @pulumi.getter(name="simpleAuthentication")
    def simple_authentication(self) -> pulumi.Output[bool]:
        """
        Specifies whether AppCode authentication is enabled. The applicaiton code
        must located in the header when `simple_authentication` is true.
        """
        return pulumi.get(self, "simple_authentication")

    @property
    @pulumi.getter(name="successResponse")
    def success_response(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the example response for a successful request. Ensure that the
        response does not exceed 20,480 characters. Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "success_response")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time when the API was last modified, in UTC format.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def web(self) -> pulumi.Output['outputs.ApiWeb']:
        """
        Specifies the web backend details. The object structure is documented
        below. Changing this will create a new API resource.
        """
        return pulumi.get(self, "web")

    @property
    @pulumi.getter(name="webPolicies")
    def web_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ApiWebPolicy']]]:
        """
        Specifies the example response for a failed request. The maximum of the policy is 5.
        The object structure is documented below.
        """
        return pulumi.get(self, "web_policies")

