# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ApiBackendParamArgs',
    'ApiFuncGraphArgs',
    'ApiFuncGraphPolicyArgs',
    'ApiFuncGraphPolicyBackendParamArgs',
    'ApiFuncGraphPolicyConditionArgs',
    'ApiMockArgs',
    'ApiMockPolicyArgs',
    'ApiMockPolicyBackendParamArgs',
    'ApiMockPolicyConditionArgs',
    'ApiPublishmentHistoryArgs',
    'ApiRequestParamArgs',
    'ApiWebArgs',
    'ApiWebPolicyArgs',
    'ApiWebPolicyBackendParamArgs',
    'ApiWebPolicyConditionArgs',
    'CustomAuthorizerIdentityArgs',
    'GroupEnvironmentArgs',
    'GroupEnvironmentVariableArgs',
    'ResponseRuleArgs',
    'ThrottlingPolicyAppThrottleArgs',
    'ThrottlingPolicyUserThrottleArgs',
    'VpcChannelMemberArgs',
]

@pulumi.input_type
class ApiBackendParamArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param pulumi.Input[str] value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ApiFuncGraphArgs:
    def __init__(__self__, *,
                 function_urn: pulumi.Input[str],
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 invocation_type: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] function_urn: Specifies the URN of the function graph.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[str] invocation_type: Specifies the invocation mode. The valid values are **async** and **sync**,
               default to **sync**.
        :param pulumi.Input[int] timeout: Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
               valid value is range from 1 to 600,000, default to 5,000.
        :param pulumi.Input[str] version: Specifies the version of the function graph.
        """
        pulumi.set(__self__, "function_urn", function_urn)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if invocation_type is not None:
            pulumi.set(__self__, "invocation_type", invocation_type)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[str]:
        """
        Specifies the URN of the function graph.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_urn", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the invocation mode. The valid values are **async** and **sync**,
        default to **sync**.
        """
        return pulumi.get(self, "invocation_type")

    @invocation_type.setter
    def invocation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_type", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
        valid value is range from 1 to 600,000, default to 5,000.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the function graph.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ApiFuncGraphPolicyArgs:
    def __init__(__self__, *,
                 conditions: pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyConditionArgs']]],
                 function_urn: pulumi.Input[str],
                 name: pulumi.Input[str],
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyBackendParamArgs']]]] = None,
                 effective_mode: Optional[pulumi.Input[str]] = None,
                 invocation_mode: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyConditionArgs']]] conditions: Specifies an array of one or more policy conditions. Up to five conditions can be set.
               The object structure is documented below.
        :param pulumi.Input[str] function_urn: Specifies the URN of the function graph.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyBackendParamArgs']]] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param pulumi.Input[str] effective_mode: Specifies the effective mode of the backend policy. The valid values are **ALL**
               and **ANY**, default to **ANY**.
        :param pulumi.Input[str] invocation_mode: Specifies the invocation mode of the function graph. The valid values are
               **async** and **sync**, default to **sync**.
        :param pulumi.Input[int] timeout: Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
               valid value is range from 1 to 600,000, default to 5,000.
        :param pulumi.Input[str] version: Specifies the version of the function graph.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "name", name)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if invocation_mode is not None:
            pulumi.set(__self__, "invocation_mode", invocation_mode)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyConditionArgs']]]:
        """
        Specifies an array of one or more policy conditions. Up to five conditions can be set.
        The object structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[str]:
        """
        Specifies the URN of the function graph.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_urn", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyBackendParamArgs']]]]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @backend_params.setter
    def backend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyBackendParamArgs']]]]):
        pulumi.set(self, "backend_params", value)

    @property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the effective mode of the backend policy. The valid values are **ALL**
        and **ANY**, default to **ANY**.
        """
        return pulumi.get(self, "effective_mode")

    @effective_mode.setter
    def effective_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_mode", value)

    @property
    @pulumi.getter(name="invocationMode")
    def invocation_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the invocation mode of the function graph. The valid values are
        **async** and **sync**, default to **sync**.
        """
        return pulumi.get(self, "invocation_mode")

    @invocation_mode.setter
    def invocation_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_mode", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
        valid value is range from 1 to 600,000, default to 5,000.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the function graph.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ApiFuncGraphPolicyBackendParamArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param pulumi.Input[str] value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ApiFuncGraphPolicyConditionArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 param_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param pulumi.Input[str] param_name: Specifies the request parameter name. This parameter is required if the policy type
               is param.
        :param pulumi.Input[str] source: Specifies the policy type. The valid values are **param** and **source**, default to
               **source**.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        """
        pulumi.set(__self__, "value", value)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request parameter name. This parameter is required if the policy type
        is param.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy type. The valid values are **param** and **source**, default to
        **source**.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ApiMockArgs:
    def __init__(__self__, *,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 response: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[str] response: Specifies the response of the backend policy, which contain a maximum of 2,048
               characters, and the angle brackets (< and >) are not allowed.
        """
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the response of the backend policy, which contain a maximum of 2,048
        characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response", value)


@pulumi.input_type
class ApiMockPolicyArgs:
    def __init__(__self__, *,
                 conditions: pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyConditionArgs']]],
                 name: pulumi.Input[str],
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyBackendParamArgs']]]] = None,
                 effective_mode: Optional[pulumi.Input[str]] = None,
                 response: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyConditionArgs']]] conditions: Specifies an array of one or more policy conditions. Up to five conditions can be set.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyBackendParamArgs']]] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param pulumi.Input[str] effective_mode: Specifies the effective mode of the backend policy. The valid values are **ALL**
               and **ANY**, default to **ANY**.
        :param pulumi.Input[str] response: Specifies the response of the backend policy, which contain a maximum of 2,048
               characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "name", name)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyConditionArgs']]]:
        """
        Specifies an array of one or more policy conditions. Up to five conditions can be set.
        The object structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyBackendParamArgs']]]]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @backend_params.setter
    def backend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyBackendParamArgs']]]]):
        pulumi.set(self, "backend_params", value)

    @property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the effective mode of the backend policy. The valid values are **ALL**
        and **ANY**, default to **ANY**.
        """
        return pulumi.get(self, "effective_mode")

    @effective_mode.setter
    def effective_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_mode", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the response of the backend policy, which contain a maximum of 2,048
        characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response", value)


@pulumi.input_type
class ApiMockPolicyBackendParamArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param pulumi.Input[str] value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ApiMockPolicyConditionArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 param_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param pulumi.Input[str] param_name: Specifies the request parameter name. This parameter is required if the policy type
               is param.
        :param pulumi.Input[str] source: Specifies the policy type. The valid values are **param** and **source**, default to
               **source**.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        """
        pulumi.set(__self__, "value", value)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request parameter name. This parameter is required if the policy type
        is param.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy type. The valid values are **param** and **source**, default to
        **source**.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ApiPublishmentHistoryArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: Specifies the description of the current publishment.
        :param pulumi.Input[str] version_id: Specifies the version ID of the current publishment.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the current publishment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version ID of the current publishment.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


@pulumi.input_type
class ApiRequestParamArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 required: pulumi.Input[bool],
                 default: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 example: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maximum: Optional[pulumi.Input[int]] = None,
                 minimum: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[bool] required: Specifies whether the request parameter is required.
        :param pulumi.Input[str] default: Specifies the default value of the request parameter, which contain a maximum of 255
               characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] example: Specifies the example value of the request parameter, which contain a maximum of 255
               characters, and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param pulumi.Input[int] maximum: Specifies the maximum value or size of the request parameter.
        :param pulumi.Input[int] minimum: Specifies the minimum value or size of the request parameter. For string type,
               The `maximum` and `minimum` means size. For number type, they means value.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if example is not None:
            pulumi.set(__self__, "example", example)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def required(self) -> pulumi.Input[bool]:
        """
        Specifies whether the request parameter is required.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: pulumi.Input[bool]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default value of the request parameter, which contain a maximum of 255
        characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def example(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the example value of the request parameter, which contain a maximum of 255
        characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "example")

    @example.setter
    def example(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "example", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def maximum(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum value or size of the request parameter.
        """
        return pulumi.get(self, "maximum")

    @maximum.setter
    def maximum(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum", value)

    @property
    @pulumi.getter
    def minimum(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum value or size of the request parameter. For string type,
        The `maximum` and `minimum` means size. For number type, they means value.
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ApiWebArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 backend_address: Optional[pulumi.Input[str]] = None,
                 host_header: Optional[pulumi.Input[str]] = None,
                 request_method: Optional[pulumi.Input[str]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 vpc_channel_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: Specifies the backend request address, which can contain a maximum of 512 characters and
               must comply with URI specifications.
               + The request address can contain request parameters enclosed with brackets ({}).
               + The request address can contain special characters, such as asterisks (*), percent signs (%), hyphens (-) and
               underscores (_) and must comply with URI specifications.
               + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[str] backend_address: Specifies the backend service address, which consists of a domain name or IP
               address, and a port number, with not more than 255 characters. The backend service address must be in the format "Host
               name:Port number", for example, apig.example.com:7443. If the port number is not specified, the default HTTPS port 443
               or the default HTTP port 80 is used. The backend service address can contain environment variables, each starting with
               a letter and consisting of 3 to 32 characters. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        :param pulumi.Input[str] host_header: Specifies the proxy host header. The host header can be customized for requests to
               be forwarded to cloud servers through the VPC channel. By default, the original host header of the request is used.
        :param pulumi.Input[str] request_method: Specifies the backend request method of the API. The valid types are **GET**,
               **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        :param pulumi.Input[str] request_protocol: Specifies the backend request protocol. The valid values are **HTTP** and
               **HTTPS**, default to **HTTPS**.
        :param pulumi.Input[bool] ssl_enable: Specifies the indicates whether to enable two-way authentication, default to false.
        :param pulumi.Input[int] timeout: Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
               valid value is range from 1 to 600,000, default to 5,000.
        :param pulumi.Input[str] vpc_channel_id: Specifies the VPC channel ID. This parameter and `backend_address` are
               alternative.
        """
        pulumi.set(__self__, "path", path)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_address is not None:
            pulumi.set(__self__, "backend_address", backend_address)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_channel_id is not None:
            pulumi.set(__self__, "vpc_channel_id", vpc_channel_id)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the backend request address, which can contain a maximum of 512 characters and
        must comply with URI specifications.
        + The request address can contain request parameters enclosed with brackets ({}).
        + The request address can contain special characters, such as asterisks (*), percent signs (%), hyphens (-) and
        underscores (_) and must comply with URI specifications.
        + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="backendAddress")
    def backend_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend service address, which consists of a domain name or IP
        address, and a port number, with not more than 255 characters. The backend service address must be in the format "Host
        name:Port number", for example, apig.example.com:7443. If the port number is not specified, the default HTTPS port 443
        or the default HTTP port 80 is used. The backend service address can contain environment variables, each starting with
        a letter and consisting of 3 to 32 characters. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "backend_address")

    @backend_address.setter
    def backend_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_address", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the proxy host header. The host header can be customized for requests to
        be forwarded to cloud servers through the VPC channel. By default, the original host header of the request is used.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend request method of the API. The valid types are **GET**,
        **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend request protocol. The valid values are **HTTP** and
        **HTTPS**, default to **HTTPS**.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_protocol", value)

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the indicates whether to enable two-way authentication, default to false.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enable", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
        valid value is range from 1 to 600,000, default to 5,000.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="vpcChannelId")
    def vpc_channel_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC channel ID. This parameter and `backend_address` are
        alternative.
        """
        return pulumi.get(self, "vpc_channel_id")

    @vpc_channel_id.setter
    def vpc_channel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_channel_id", value)


@pulumi.input_type
class ApiWebPolicyArgs:
    def __init__(__self__, *,
                 conditions: pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyConditionArgs']]],
                 name: pulumi.Input[str],
                 path: pulumi.Input[str],
                 request_method: pulumi.Input[str],
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 backend_address: Optional[pulumi.Input[str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyBackendParamArgs']]]] = None,
                 effective_mode: Optional[pulumi.Input[str]] = None,
                 host_header: Optional[pulumi.Input[str]] = None,
                 request_protocol: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 vpc_channel_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyConditionArgs']]] conditions: Specifies an array of one or more policy conditions. Up to five conditions can be set.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] path: Specifies the backend request address, which can contain a maximum of 512 characters and
               must comply with URI specifications.
               + The request address can contain request parameters enclosed with brackets ({}).
               + The request address can contain special characters, such as asterisks (*), percent signs (%), hyphens (-) and
               underscores (_) and must comply with URI specifications.
               + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        :param pulumi.Input[str] request_method: Specifies the backend request method of the API. The valid types are **GET**,
               **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        :param pulumi.Input[str] authorizer_id: Specifies the ID of the backend custom authorization.
        :param pulumi.Input[str] backend_address: Specifies the backend service address, which consists of a domain name or IP
               address, and a port number, with not more than 255 characters. The backend service address must be in the format "Host
               name:Port number", for example, apig.example.com:7443. If the port number is not specified, the default HTTPS port 443
               or the default HTTP port 80 is used. The backend service address can contain environment variables, each starting with
               a letter and consisting of 3 to 32 characters. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        :param pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyBackendParamArgs']]] backend_params: Specifies an array of one or more backend parameters. The maximum of request
               parameters is 50. The object structure is documented above.
        :param pulumi.Input[str] effective_mode: Specifies the effective mode of the backend policy. The valid values are **ALL**
               and **ANY**, default to **ANY**.
        :param pulumi.Input[str] host_header: Specifies the proxy host header. The host header can be customized for requests to
               be forwarded to cloud servers through the VPC channel. By default, the original host header of the request is used.
        :param pulumi.Input[str] request_protocol: Specifies the backend request protocol. The valid values are **HTTP** and
               **HTTPS**, default to **HTTPS**.
        :param pulumi.Input[int] timeout: Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
               valid value is range from 1 to 600,000, default to 5,000.
        :param pulumi.Input[str] vpc_channel_id: Specifies the VPC channel ID. This parameter and `backend_address` are
               alternative.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "request_method", request_method)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_address is not None:
            pulumi.set(__self__, "backend_address", backend_address)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_channel_id is not None:
            pulumi.set(__self__, "vpc_channel_id", vpc_channel_id)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyConditionArgs']]]:
        """
        Specifies an array of one or more policy conditions. Up to five conditions can be set.
        The object structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the backend request address, which can contain a maximum of 512 characters and
        must comply with URI specifications.
        + The request address can contain request parameters enclosed with brackets ({}).
        + The request address can contain special characters, such as asterisks (*), percent signs (%), hyphens (-) and
        underscores (_) and must comply with URI specifications.
        + The address can contain environment variables, each starting with a letter and consisting of 3 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed in environment variables.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> pulumi.Input[str]:
        """
        Specifies the backend request method of the API. The valid types are **GET**,
        **POST**, **PUT**, **DELETE**, **HEAD**, **PATCH**, **OPTIONS** and **ANY**.
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: pulumi.Input[str]):
        pulumi.set(self, "request_method", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter(name="backendAddress")
    def backend_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend service address, which consists of a domain name or IP
        address, and a port number, with not more than 255 characters. The backend service address must be in the format "Host
        name:Port number", for example, apig.example.com:7443. If the port number is not specified, the default HTTPS port 443
        or the default HTTP port 80 is used. The backend service address can contain environment variables, each starting with
        a letter and consisting of 3 to 32 characters. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "backend_address")

    @backend_address.setter
    def backend_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_address", value)

    @property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyBackendParamArgs']]]]:
        """
        Specifies an array of one or more backend parameters. The maximum of request
        parameters is 50. The object structure is documented above.
        """
        return pulumi.get(self, "backend_params")

    @backend_params.setter
    def backend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyBackendParamArgs']]]]):
        pulumi.set(self, "backend_params", value)

    @property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the effective mode of the backend policy. The valid values are **ALL**
        and **ANY**, default to **ANY**.
        """
        return pulumi.get(self, "effective_mode")

    @effective_mode.setter
    def effective_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_mode", value)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the proxy host header. The host header can be customized for requests to
        be forwarded to cloud servers through the VPC channel. By default, the original host header of the request is used.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backend request protocol. The valid values are **HTTP** and
        **HTTPS**, default to **HTTPS**.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_protocol", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the timeout, in ms, which allowed for APIG to request the backend service. The
        valid value is range from 1 to 600,000, default to 5,000.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="vpcChannelId")
    def vpc_channel_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC channel ID. This parameter and `backend_address` are
        alternative.
        """
        return pulumi.get(self, "vpc_channel_id")

    @vpc_channel_id.setter
    def vpc_channel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_channel_id", value)


@pulumi.input_type
class ApiWebPolicyBackendParamArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] location: Specifies the location of the backend parameter. The valid values are **PATH**,
               **QUERY** and **HEADER**.
        :param pulumi.Input[str] name: Specifies the backend policy name, which can contains of 3 to 64 characters and start with
               a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        :param pulumi.Input[str] value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param pulumi.Input[str] description: Specifies the description of the constant or system parameter, which contain a
               maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Specifies the location of the backend parameter. The valid values are **PATH**,
        **QUERY** and **HEADER**.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the backend policy name, which can contains of 3 to 64 characters and start with
        a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the constant or system parameter, which contain a
        maximum of 255 characters, and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ApiWebPolicyConditionArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 param_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: Specifies the condition type. For a condition with the input parameter source:
               + If the condition type is **Enumerated**, separate condition values with commas.
               + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        :param pulumi.Input[str] param_name: Specifies the request parameter name. This parameter is required if the policy type
               is param.
        :param pulumi.Input[str] source: Specifies the policy type. The valid values are **param** and **source**, default to
               **source**.
        :param pulumi.Input[str] type: Specifies the condition type of the backend policy. The valid values are **Equal**,
               **Enumerated** and **Matching**, default to **Equal**.
        """
        pulumi.set(__self__, "value", value)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the condition type. For a condition with the input parameter source:
        + If the condition type is **Enumerated**, separate condition values with commas.
        + If the condition type is **Matching**, enter a regular expression compatible with PERL.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request parameter name. This parameter is required if the policy type
        is param.
        """
        return pulumi.get(self, "param_name")

    @param_name.setter
    def param_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "param_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy type. The valid values are **param** and **source**, default to
        **source**.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the condition type of the backend policy. The valid values are **Equal**,
        **Enumerated** and **Matching**, default to **Equal**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class CustomAuthorizerIdentityArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 name: pulumi.Input[str],
                 validation: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] location: Specifies the parameter location, which support 'HEADER' and 'QUERY'.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] name: Specifies the name of the parameter to be verified.
               The parameter includes front-end and back-end parameters.
               Changing this will create a new custom authorizer resource.
        :param pulumi.Input[str] validation: Specifies the parameter verification expression.
               If omitted, the custom authorizer will not perform verification.
               The valid value is range form 1 to 2,048.
               Changing this will create a new custom authorizer resource.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Specifies the parameter location, which support 'HEADER' and 'QUERY'.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the parameter to be verified.
        The parameter includes front-end and back-end parameters.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def validation(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameter verification expression.
        If omitted, the custom authorizer will not perform verification.
        The valid value is range form 1 to 2,048.
        Changing this will create a new custom authorizer resource.
        """
        return pulumi.get(self, "validation")

    @validation.setter
    def validation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation", value)


@pulumi.input_type
class GroupEnvironmentArgs:
    def __init__(__self__, *,
                 environment_id: pulumi.Input[str],
                 variables: pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentVariableArgs']]]):
        """
        :param pulumi.Input[str] environment_id: Specifies the APIG environment ID of the associated APIG group.
        :param pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentVariableArgs']]] variables: Specifies an array of one or more APIG environment variables. The object structure is
               documented below. The environment variables of different groups are isolated in the same environment.
        """
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        Specifies the APIG environment ID of the associated APIG group.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentVariableArgs']]]:
        """
        Specifies an array of one or more APIG environment variables. The object structure is
        documented below. The environment variables of different groups are isolated in the same environment.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentVariableArgs']]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class GroupEnvironmentVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 variable_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the variable name, which can contains of 3 to 32 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
               case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
               an environment. The variable names are not allowed to be repeated for an API group.
        :param pulumi.Input[str] value: Specifies the environment ariable value, which can contains of 1 to 255 characters. Only
               letters, digits and special characters (_-/.:) are allowed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if variable_id is not None:
            pulumi.set(__self__, "variable_id", variable_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the variable name, which can contains of 3 to 32 characters, starting with a
        letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
        case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
        an environment. The variable names are not allowed to be repeated for an API group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the environment ariable value, which can contains of 1 to 255 characters. Only
        letters, digits and special characters (_-/.:) are allowed.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="variableId")
    def variable_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "variable_id")

    @variable_id.setter
    def variable_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "variable_id", value)


@pulumi.input_type
class ResponseRuleArgs:
    def __init__(__self__, *,
                 body: pulumi.Input[str],
                 error_type: pulumi.Input[str],
                 status_code: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] body: Specifies the body template of the API response rule, e.g.
               `{\\"code\\":\\"$context.authorizer.frontend.code\\",\\"message\\":\\"$context.authorizer.frontend.message\\"}`
        :param pulumi.Input[str] error_type: Specifies the type of the API custom response rule.
               + **AUTH_FAILURE**: Authentication failed.
               + **AUTH_HEADER_MISSING**: The identity source is missing.
               + **AUTHORIZER_FAILURE**: Custom authentication failed.
               + **AUTHORIZER_CONF_FAILURE**: There has been a custom authorizer error.
               + **AUTHORIZER_IDENTITIES_FAILURE**: The identity source of the custom authorizer is invalid.
               + **BACKEND_UNAVAILABLE**: The backend service is unavailable.
               + **BACKEND_TIMEOUT**: Communication with the backend service timed out.
               + **THROTTLED**: The request was rejected due to request throttling.
               + **UNAUTHORIZED**: The app you are using has not been authorized to call the API.
               + **ACCESS_DENIED**: Access denied.
               + **NOT_FOUND**: No API is found.
               + **REQUEST_PARAMETERS_FAILURE**: The request parameters are incorrect.
               + **DEFAULT_4XX**: Another 4XX error occurred.
               + **DEFAULT_5XX**: Another 5XX error occurred.
        :param pulumi.Input[int] status_code: Specifies the HTTP status code of the API response rule.
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "error_type", error_type)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Input[str]:
        """
        Specifies the body template of the API response rule, e.g.
        `{\\"code\\":\\"$context.authorizer.frontend.code\\",\\"message\\":\\"$context.authorizer.frontend.message\\"}`
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[str]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="errorType")
    def error_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the API custom response rule.
        + **AUTH_FAILURE**: Authentication failed.
        + **AUTH_HEADER_MISSING**: The identity source is missing.
        + **AUTHORIZER_FAILURE**: Custom authentication failed.
        + **AUTHORIZER_CONF_FAILURE**: There has been a custom authorizer error.
        + **AUTHORIZER_IDENTITIES_FAILURE**: The identity source of the custom authorizer is invalid.
        + **BACKEND_UNAVAILABLE**: The backend service is unavailable.
        + **BACKEND_TIMEOUT**: Communication with the backend service timed out.
        + **THROTTLED**: The request was rejected due to request throttling.
        + **UNAUTHORIZED**: The app you are using has not been authorized to call the API.
        + **ACCESS_DENIED**: Access denied.
        + **NOT_FOUND**: No API is found.
        + **REQUEST_PARAMETERS_FAILURE**: The request parameters are incorrect.
        + **DEFAULT_4XX**: Another 4XX error occurred.
        + **DEFAULT_5XX**: Another 5XX error occurred.
        """
        return pulumi.get(self, "error_type")

    @error_type.setter
    def error_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "error_type", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the HTTP status code of the API response rule.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status_code", value)


@pulumi.input_type
class ThrottlingPolicyAppThrottleArgs:
    def __init__(__self__, *,
                 max_api_requests: pulumi.Input[int],
                 throttling_object_id: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 throttling_object_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] max_api_requests: Specifies the maximum number of times an API can be accessed within a specified
               period.
        :param pulumi.Input[str] throttling_object_id: Specifies the object ID which the special throttling policy belongs.
        :param pulumi.Input[str] id: ID of the special application throttling policy.
        :param pulumi.Input[str] throttling_object_name: The object name which the special application throttling policy belongs.
        """
        pulumi.set(__self__, "max_api_requests", max_api_requests)
        pulumi.set(__self__, "throttling_object_id", throttling_object_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if throttling_object_name is not None:
            pulumi.set(__self__, "throttling_object_name", throttling_object_name)

    @property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> pulumi.Input[int]:
        """
        Specifies the maximum number of times an API can be accessed within a specified
        period.
        """
        return pulumi.get(self, "max_api_requests")

    @max_api_requests.setter
    def max_api_requests(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_api_requests", value)

    @property
    @pulumi.getter(name="throttlingObjectId")
    def throttling_object_id(self) -> pulumi.Input[str]:
        """
        Specifies the object ID which the special throttling policy belongs.
        """
        return pulumi.get(self, "throttling_object_id")

    @throttling_object_id.setter
    def throttling_object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "throttling_object_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the special application throttling policy.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="throttlingObjectName")
    def throttling_object_name(self) -> Optional[pulumi.Input[str]]:
        """
        The object name which the special application throttling policy belongs.
        """
        return pulumi.get(self, "throttling_object_name")

    @throttling_object_name.setter
    def throttling_object_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throttling_object_name", value)


@pulumi.input_type
class ThrottlingPolicyUserThrottleArgs:
    def __init__(__self__, *,
                 max_api_requests: pulumi.Input[int],
                 throttling_object_id: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 throttling_object_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] max_api_requests: Specifies the maximum number of times an API can be accessed within a specified
               period.
        :param pulumi.Input[str] throttling_object_id: Specifies the object ID which the special throttling policy belongs.
        :param pulumi.Input[str] id: ID of the special application throttling policy.
        :param pulumi.Input[str] throttling_object_name: The object name which the special application throttling policy belongs.
        """
        pulumi.set(__self__, "max_api_requests", max_api_requests)
        pulumi.set(__self__, "throttling_object_id", throttling_object_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if throttling_object_name is not None:
            pulumi.set(__self__, "throttling_object_name", throttling_object_name)

    @property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> pulumi.Input[int]:
        """
        Specifies the maximum number of times an API can be accessed within a specified
        period.
        """
        return pulumi.get(self, "max_api_requests")

    @max_api_requests.setter
    def max_api_requests(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_api_requests", value)

    @property
    @pulumi.getter(name="throttlingObjectId")
    def throttling_object_id(self) -> pulumi.Input[str]:
        """
        Specifies the object ID which the special throttling policy belongs.
        """
        return pulumi.get(self, "throttling_object_id")

    @throttling_object_id.setter
    def throttling_object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "throttling_object_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the special application throttling policy.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="throttlingObjectName")
    def throttling_object_name(self) -> Optional[pulumi.Input[str]]:
        """
        The object name which the special application throttling policy belongs.
        """
        return pulumi.get(self, "throttling_object_name")

    @throttling_object_name.setter
    def throttling_object_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "throttling_object_name", value)


@pulumi.input_type
class VpcChannelMemberArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] id: Specifies the ECS ID for each backend servers.
               Required if `member_type` is *ECS*.
               This parameter and `ip_address` are alternative.
        :param pulumi.Input[str] ip_address: Specifies the IP address each backend servers.
               Required if `member_type` is *EIP*.
        :param pulumi.Input[int] weight: Specifies the backend server weight.
               The valid values are range from 1 to 100, default to 1.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ECS ID for each backend servers.
        Required if `member_type` is *ECS*.
        This parameter and `ip_address` are alternative.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address each backend servers.
        Required if `member_type` is *EIP*.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the backend server weight.
        The valid values are range from 1 to 100, default to 1.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


