# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[float],
                 engine: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 access_user: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 backup_policy: Optional[pulumi.Input['InstanceBackupPolicyArgs']] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 begin_at: Optional[pulumi.Input[str]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_name: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_type: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 save_days: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 whitelist_enable: Optional[pulumi.Input[bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[float] capacity: Specifies the cache capacity. Unit: GB.
               + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`, `0.5`, `1`, `2`,
               `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
               `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param pulumi.Input[str] engine: Specifies a cache engine. Options: *Redis* and *Memcached*.
               Changing this creates a new instance.
        :param pulumi.Input[str] subnet_id: The ID of subnet which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] vpc_id: The ID of VPC which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] access_user: Specifies the username used for accessing a DCS Memcached instance.
               If the cache engine is *Redis*, you do not need to set this parameter.
               The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
               hyphens (-). Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The code of the AZ where the cache node resides.
               Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
               You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_ats: Day in a week on which backup starts, the value ranges from 1 to 7.
               Where: 1 indicates Monday; 7 indicates Sunday.
        :param pulumi.Input['InstanceBackupPolicyArgs'] backup_policy: Specifies the backup configuration to be used with the instance.
               The structure is described below.
        :param pulumi.Input[str] backup_type: Backup type. Default value is `auto`. The valid values are as follows:
               + `auto`: automatic backup.
               + `manual`: manual backup.
        :param pulumi.Input[str] begin_at: Time at which backup starts.
               Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the redis instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[str] description: Specifies the description of an instance.
               It is a string that contains a maximum of 1024 characters.
        :param pulumi.Input[str] engine_version: Specifies the version of a cache engine.
               It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, or 5.0.
               Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the dcs instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] flavor: The flavor of the cache instance, which including the total memory, available memory,
               maximum number of connections allowed, maximum/assured bandwidth and reference performance.
               It also includes the modes of Redis instances. You can query the *flavor* as follows:
               + It can be obtained through this data source `_dcs.get_flavors`.
               + Query some flavors
               in [DCS Instance Specifications](https://support.huaweicloud.com/intl/en-us/productdesc-dcs/dcs-pd-200713003.html)
               + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        :param pulumi.Input[str] maintain_begin: Time at which the maintenance time window starts.
               The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
               Default value is `02:00:00`.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               + If parameter maintain_begin is left blank, parameter maintain_end is also blank.
               In this case, the system automatically allocates the default start time 02:00:00.
        :param pulumi.Input[str] maintain_end: Time at which the maintenance time window ends.
               The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
               Default value is `06:00:00`.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The end time is four hours later than the start time.
               For example, if the start time is 22:00:00, the end time is 02:00:00.
               + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               + If parameter maintain_end is left blank, parameter maintain_begin is also blank.
               In this case, the system automatically allocates the default end time 06:00:00.
        :param pulumi.Input[str] name: Specifies the name of an instance.
               The name must be 4 to 64 characters and start with a letter.
               Only chinese, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        :param pulumi.Input[str] password: Specifies the password of a DCS instance.
               Changing this creates a new instance.
               The password of a DCS instance must meet the following complexity requirements:
               + Must be a string of 8 to 32 bits in length.
               + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
               Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
               + The new password cannot be the same as the old password.
               Redis instance defaults to 6379. Memcached instance does not use this argument.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_type: Interval at which backup is performed. Default value is `weekly`.
               Currently, only weekly backup is supported.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[int] port: Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        :param pulumi.Input[str] private_ip: The IP address of the DCS instance,
               which can only be the currently available IP address the selected subnet.
               You can specify an available IP for the Redis instance (except for the Redis Cluster type).
               If omitted, the system will automatically allocate an available IP address to the Redis instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the DCS instance resource.
               If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] rename_commands: Critical command renaming, which is supported only by Redis 4.0 and
               Redis 5.0 instances but not by Redis 3.0 instance.
               The valid commands that can be renamed are: *command*, *keys*, *flushdb*, *flushall* and *hgetall*.
        :param pulumi.Input[int] save_days: Retention time. Unit: day, the value ranges from 1 to 7.
        :param pulumi.Input[str] security_group_id: The ID of the security group which the instance belongs to.
               This parameter is mandatory for Memcached and Redis 3.0 version.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the dcs instance.
        :param pulumi.Input[bool] whitelist_enable: Enable or disable the IP address whitelists. Defaults to true.
               If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]] whitelists: Specifies the IP addresses which can access the instance.
               This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""Deprecated, please use `availability_zones` instead""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: Deprecated, please use `availability_zones` instead""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if backup_ats is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_ats is deprecated: Deprecated, please use `backup_policy` instead""")
        if backup_ats is not None:
            pulumi.set(__self__, "backup_ats", backup_ats)
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if backup_type is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_type is deprecated: Deprecated, please use `backup_policy` instead""")
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if begin_at is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""begin_at is deprecated: Deprecated, please use `backup_policy` instead""")
        if begin_at is not None:
            pulumi.set(__self__, "begin_at", begin_at)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if enterprise_project_name is not None:
            warnings.warn("""Deprecated, this is a non-public attribute.""", DeprecationWarning)
            pulumi.log.warn("""enterprise_project_name is deprecated: Deprecated, this is a non-public attribute.""")
        if enterprise_project_name is not None:
            pulumi.set(__self__, "enterprise_project_name", enterprise_project_name)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_type is not None:
            warnings.warn("""Please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""period_type is deprecated: Please use `backup_policy` instead""")
        if period_type is not None:
            pulumi.set(__self__, "period_type", period_type)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if product_id is not None:
            warnings.warn("""Deprecated, please use `flavor` instead""", DeprecationWarning)
            pulumi.log.warn("""product_id is deprecated: Deprecated, please use `flavor` instead""")
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rename_commands is not None:
            pulumi.set(__self__, "rename_commands", rename_commands)
        if save_days is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""save_days is deprecated: Deprecated, please use `backup_policy` instead""")
        if save_days is not None:
            pulumi.set(__self__, "save_days", save_days)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if whitelist_enable is not None:
            pulumi.set(__self__, "whitelist_enable", whitelist_enable)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[float]:
        """
        Specifies the cache capacity. Unit: GB.
        + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`, `0.5`, `1`, `2`,
        `4`, `8`, `16`, `32` and `64`.
        Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
        `1024`.
        + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
        + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[float]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[str]:
        """
        Specifies a cache engine. Options: *Redis* and *Memcached*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The ID of subnet which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of VPC which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the username used for accessing a DCS Memcached instance.
        If the cache engine is *Redis*, you do not need to set this parameter.
        The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
        hyphens (-). Changing this creates a new instance.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_user", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The code of the AZ where the cache node resides.
        Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
        You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter(name="backupAts")
    def backup_ats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Day in a week on which backup starts, the value ranges from 1 to 7.
        Where: 1 indicates Monday; 7 indicates Sunday.
        """
        return pulumi.get(self, "backup_ats")

    @backup_ats.setter
    def backup_ats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "backup_ats", value)

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['InstanceBackupPolicyArgs']]:
        """
        Specifies the backup configuration to be used with the instance.
        The structure is described below.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['InstanceBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[str]]:
        """
        Backup type. Default value is `auto`. The valid values are as follows:
        + `auto`: automatic backup.
        + `manual`: manual backup.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter(name="beginAt")
    def begin_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which backup starts.
        Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        """
        return pulumi.get(self, "begin_at")

    @begin_at.setter
    def begin_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "begin_at", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the redis instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of an instance.
        It is a string that contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of a cache engine.
        It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, or 5.0.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the dcs instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectName")
    def enterprise_project_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "enterprise_project_name")

    @enterprise_project_name.setter
    def enterprise_project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_name", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor of the cache instance, which including the total memory, available memory,
        maximum number of connections allowed, maximum/assured bandwidth and reference performance.
        It also includes the modes of Redis instances. You can query the *flavor* as follows:
        + It can be obtained through this data source `_dcs.get_flavors`.
        + Query some flavors
        in [DCS Instance Specifications](https://support.huaweicloud.com/intl/en-us/productdesc-dcs/dcs-pd-200713003.html)
        + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the maintenance time window starts.
        The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
        Default value is `02:00:00`.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        + If parameter maintain_begin is left blank, parameter maintain_end is also blank.
        In this case, the system automatically allocates the default start time 02:00:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_begin", value)

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the maintenance time window ends.
        The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
        Default value is `06:00:00`.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The end time is four hours later than the start time.
        For example, if the start time is 22:00:00, the end time is 02:00:00.
        + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        + If parameter maintain_end is left blank, parameter maintain_begin is also blank.
        In this case, the system automatically allocates the default end time 06:00:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of an instance.
        The name must be 4 to 64 characters and start with a letter.
        Only chinese, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of a DCS instance.
        Changing this creates a new instance.
        The password of a DCS instance must meet the following complexity requirements:
        + Must be a string of 8 to 32 bits in length.
        + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
        Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
        + The new password cannot be the same as the old password.
        Redis instance defaults to 6379. Memcached instance does not use this argument.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> Optional[pulumi.Input[str]]:
        """
        Interval at which backup is performed. Default value is `weekly`.
        Currently, only weekly backup is supported.
        """
        return pulumi.get(self, "period_type")

    @period_type.setter
    def period_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_type", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the DCS instance,
        which can only be the currently available IP address the selected subnet.
        You can specify an available IP for the Redis instance (except for the Redis Cluster type).
        If omitted, the system will automatically allocate an available IP address to the Redis instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the DCS instance resource.
        If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="renameCommands")
    def rename_commands(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Critical command renaming, which is supported only by Redis 4.0 and
        Redis 5.0 instances but not by Redis 3.0 instance.
        The valid commands that can be renamed are: *command*, *keys*, *flushdb*, *flushall* and *hgetall*.
        """
        return pulumi.get(self, "rename_commands")

    @rename_commands.setter
    def rename_commands(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "rename_commands", value)

    @property
    @pulumi.getter(name="saveDays")
    def save_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention time. Unit: day, the value ranges from 1 to 7.
        """
        return pulumi.get(self, "save_days")

    @save_days.setter
    def save_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "save_days", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group which the instance belongs to.
        This parameter is mandatory for Memcached and Redis 3.0 version.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the dcs instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="whitelistEnable")
    def whitelist_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable the IP address whitelists. Defaults to true.
        If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        """
        return pulumi.get(self, "whitelist_enable")

    @whitelist_enable.setter
    def whitelist_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "whitelist_enable", value)

    @property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]]:
        """
        Specifies the IP addresses which can access the instance.
        This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 access_user: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 backup_policy: Optional[pulumi.Input['InstanceBackupPolicyArgs']] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 begin_at: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[float]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_name: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 internal_version: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 max_memory: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_type: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 save_days: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 subnet_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 used_memory: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_name: Optional[pulumi.Input[str]] = None,
                 whitelist_enable: Optional[pulumi.Input[bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] access_user: Specifies the username used for accessing a DCS Memcached instance.
               If the cache engine is *Redis*, you do not need to set this parameter.
               The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
               hyphens (-). Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The code of the AZ where the cache node resides.
               Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
               You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_ats: Day in a week on which backup starts, the value ranges from 1 to 7.
               Where: 1 indicates Monday; 7 indicates Sunday.
        :param pulumi.Input['InstanceBackupPolicyArgs'] backup_policy: Specifies the backup configuration to be used with the instance.
               The structure is described below.
        :param pulumi.Input[str] backup_type: Backup type. Default value is `auto`. The valid values are as follows:
               + `auto`: automatic backup.
               + `manual`: manual backup.
        :param pulumi.Input[str] begin_at: Time at which backup starts.
               Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        :param pulumi.Input[float] capacity: Specifies the cache capacity. Unit: GB.
               + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`, `0.5`, `1`, `2`,
               `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
               `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the redis instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[str] description: Specifies the description of an instance.
               It is a string that contains a maximum of 1024 characters.
        :param pulumi.Input[str] domain_name: Domain name of the instance. Usually, we use domain name and port to connect to the DCS instances.
        :param pulumi.Input[str] engine: Specifies a cache engine. Options: *Redis* and *Memcached*.
               Changing this creates a new instance.
        :param pulumi.Input[str] engine_version: Specifies the version of a cache engine.
               It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, or 5.0.
               Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the dcs instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] flavor: The flavor of the cache instance, which including the total memory, available memory,
               maximum number of connections allowed, maximum/assured bandwidth and reference performance.
               It also includes the modes of Redis instances. You can query the *flavor* as follows:
               + It can be obtained through this data source `_dcs.get_flavors`.
               + Query some flavors
               in [DCS Instance Specifications](https://support.huaweicloud.com/intl/en-us/productdesc-dcs/dcs-pd-200713003.html)
               + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        :param pulumi.Input[str] maintain_begin: Time at which the maintenance time window starts.
               The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
               Default value is `02:00:00`.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               + If parameter maintain_begin is left blank, parameter maintain_end is also blank.
               In this case, the system automatically allocates the default start time 02:00:00.
        :param pulumi.Input[str] maintain_end: Time at which the maintenance time window ends.
               The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
               Default value is `06:00:00`.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The end time is four hours later than the start time.
               For example, if the start time is 22:00:00, the end time is 02:00:00.
               + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               + If parameter maintain_end is left blank, parameter maintain_begin is also blank.
               In this case, the system automatically allocates the default end time 06:00:00.
        :param pulumi.Input[int] max_memory: Total memory size. Unit: MB.
        :param pulumi.Input[str] name: Specifies the name of an instance.
               The name must be 4 to 64 characters and start with a letter.
               Only chinese, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        :param pulumi.Input[str] order_id: The ID of the order that created the instance.
        :param pulumi.Input[str] password: Specifies the password of a DCS instance.
               Changing this creates a new instance.
               The password of a DCS instance must meet the following complexity requirements:
               + Must be a string of 8 to 32 bits in length.
               + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
               Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
               + The new password cannot be the same as the old password.
               Redis instance defaults to 6379. Memcached instance does not use this argument.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_type: Interval at which backup is performed. Default value is `weekly`.
               Currently, only weekly backup is supported.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[int] port: Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        :param pulumi.Input[str] private_ip: The IP address of the DCS instance,
               which can only be the currently available IP address the selected subnet.
               You can specify an available IP for the Redis instance (except for the Redis Cluster type).
               If omitted, the system will automatically allocate an available IP address to the Redis instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the DCS instance resource.
               If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] rename_commands: Critical command renaming, which is supported only by Redis 4.0 and
               Redis 5.0 instances but not by Redis 3.0 instance.
               The valid commands that can be renamed are: *command*, *keys*, *flushdb*, *flushall* and *hgetall*.
        :param pulumi.Input[int] save_days: Retention time. Unit: day, the value ranges from 1 to 7.
        :param pulumi.Input[str] security_group_id: The ID of the security group which the instance belongs to.
               This parameter is mandatory for Memcached and Redis 3.0 version.
        :param pulumi.Input[str] security_group_name: The name of security group which the instance belongs to.
        :param pulumi.Input[str] status: Cache instance status. The valid values are as follows:
               + `RUNNING`: The instance is running properly.
               Only instances in the Running state can provide in-memory cache service.
               + `ERROR`: The instance is not running properly.
               + `RESTARTING`: The instance is being restarted.
               + `FROZEN`: The instance has been frozen due to low balance.
               You can unfreeze the instance by recharging your account in My Order.
               + `EXTENDING`: The instance is being scaled up.
               + `RESTORING`: The instance data is being restored.
               + `FLUSHING`: The DCS instance is being cleared.
        :param pulumi.Input[str] subnet_id: The ID of subnet which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] subnet_name: The name of subnet which the instance belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the dcs instance.
        :param pulumi.Input[int] used_memory: Size of the used memory. Unit: MB.
        :param pulumi.Input[str] vpc_id: The ID of VPC which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] vpc_name: The name of VPC which the instance belongs to.
        :param pulumi.Input[bool] whitelist_enable: Enable or disable the IP address whitelists. Defaults to true.
               If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]] whitelists: Specifies the IP addresses which can access the instance.
               This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""Deprecated, please use `availability_zones` instead""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: Deprecated, please use `availability_zones` instead""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if backup_ats is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_ats is deprecated: Deprecated, please use `backup_policy` instead""")
        if backup_ats is not None:
            pulumi.set(__self__, "backup_ats", backup_ats)
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if backup_type is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""backup_type is deprecated: Deprecated, please use `backup_policy` instead""")
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if begin_at is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""begin_at is deprecated: Deprecated, please use `backup_policy` instead""")
        if begin_at is not None:
            pulumi.set(__self__, "begin_at", begin_at)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if enterprise_project_name is not None:
            warnings.warn("""Deprecated, this is a non-public attribute.""", DeprecationWarning)
            pulumi.log.warn("""enterprise_project_name is deprecated: Deprecated, this is a non-public attribute.""")
        if enterprise_project_name is not None:
            pulumi.set(__self__, "enterprise_project_name", enterprise_project_name)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if internal_version is not None:
            warnings.warn("""Deprecated, please us `engine_version` instead.""", DeprecationWarning)
            pulumi.log.warn("""internal_version is deprecated: Deprecated, please us `engine_version` instead.""")
        if internal_version is not None:
            pulumi.set(__self__, "internal_version", internal_version)
        if ip is not None:
            warnings.warn("""Deprecated, please us `private_ip` instead.""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Deprecated, please us `private_ip` instead.""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if max_memory is not None:
            pulumi.set(__self__, "max_memory", max_memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_type is not None:
            warnings.warn("""Please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""period_type is deprecated: Please use `backup_policy` instead""")
        if period_type is not None:
            pulumi.set(__self__, "period_type", period_type)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if product_id is not None:
            warnings.warn("""Deprecated, please use `flavor` instead""", DeprecationWarning)
            pulumi.log.warn("""product_id is deprecated: Deprecated, please use `flavor` instead""")
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rename_commands is not None:
            pulumi.set(__self__, "rename_commands", rename_commands)
        if save_days is not None:
            warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
            pulumi.log.warn("""save_days is deprecated: Deprecated, please use `backup_policy` instead""")
        if save_days is not None:
            pulumi.set(__self__, "save_days", save_days)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_name is not None:
            pulumi.set(__self__, "security_group_name", security_group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if used_memory is not None:
            pulumi.set(__self__, "used_memory", used_memory)
        if user_id is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""user_id is deprecated: Deprecated""")
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""user_name is deprecated: Deprecated""")
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_name is not None:
            pulumi.set(__self__, "vpc_name", vpc_name)
        if whitelist_enable is not None:
            pulumi.set(__self__, "whitelist_enable", whitelist_enable)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the username used for accessing a DCS Memcached instance.
        If the cache engine is *Redis*, you do not need to set this parameter.
        The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
        hyphens (-). Changing this creates a new instance.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_user", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The code of the AZ where the cache node resides.
        Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
        You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter(name="backupAts")
    def backup_ats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Day in a week on which backup starts, the value ranges from 1 to 7.
        Where: 1 indicates Monday; 7 indicates Sunday.
        """
        return pulumi.get(self, "backup_ats")

    @backup_ats.setter
    def backup_ats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "backup_ats", value)

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['InstanceBackupPolicyArgs']]:
        """
        Specifies the backup configuration to be used with the instance.
        The structure is described below.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['InstanceBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[str]]:
        """
        Backup type. Default value is `auto`. The valid values are as follows:
        + `auto`: automatic backup.
        + `manual`: manual backup.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter(name="beginAt")
    def begin_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which backup starts.
        Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        """
        return pulumi.get(self, "begin_at")

    @begin_at.setter
    def begin_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "begin_at", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the cache capacity. Unit: GB.
        + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`, `0.5`, `1`, `2`,
        `4`, `8`, `16`, `32` and `64`.
        Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
        `1024`.
        + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
        + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the redis instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of an instance.
        It is a string that contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of the instance. Usually, we use domain name and port to connect to the DCS instances.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a cache engine. Options: *Redis* and *Memcached*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of a cache engine.
        It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, or 5.0.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the dcs instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectName")
    def enterprise_project_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "enterprise_project_name")

    @enterprise_project_name.setter
    def enterprise_project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_name", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor of the cache instance, which including the total memory, available memory,
        maximum number of connections allowed, maximum/assured bandwidth and reference performance.
        It also includes the modes of Redis instances. You can query the *flavor* as follows:
        + It can be obtained through this data source `_dcs.get_flavors`.
        + Query some flavors
        in [DCS Instance Specifications](https://support.huaweicloud.com/intl/en-us/productdesc-dcs/dcs-pd-200713003.html)
        + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="internalVersion")
    def internal_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "internal_version")

    @internal_version.setter
    def internal_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_version", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the maintenance time window starts.
        The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
        Default value is `02:00:00`.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        + If parameter maintain_begin is left blank, parameter maintain_end is also blank.
        In this case, the system automatically allocates the default start time 02:00:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_begin", value)

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the maintenance time window ends.
        The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
        Default value is `06:00:00`.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The end time is four hours later than the start time.
        For example, if the start time is 22:00:00, the end time is 02:00:00.
        + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        + If parameter maintain_end is left blank, parameter maintain_begin is also blank.
        In this case, the system automatically allocates the default end time 06:00:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end", value)

    @property
    @pulumi.getter(name="maxMemory")
    def max_memory(self) -> Optional[pulumi.Input[int]]:
        """
        Total memory size. Unit: MB.
        """
        return pulumi.get(self, "max_memory")

    @max_memory.setter
    def max_memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_memory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of an instance.
        The name must be 4 to 64 characters and start with a letter.
        Only chinese, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the order that created the instance.
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of a DCS instance.
        Changing this creates a new instance.
        The password of a DCS instance must meet the following complexity requirements:
        + Must be a string of 8 to 32 bits in length.
        + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
        Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
        + The new password cannot be the same as the old password.
        Redis instance defaults to 6379. Memcached instance does not use this argument.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> Optional[pulumi.Input[str]]:
        """
        Interval at which backup is performed. Default value is `weekly`.
        Currently, only weekly backup is supported.
        """
        return pulumi.get(self, "period_type")

    @period_type.setter
    def period_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_type", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the DCS instance,
        which can only be the currently available IP address the selected subnet.
        You can specify an available IP for the Redis instance (except for the Redis Cluster type).
        If omitted, the system will automatically allocate an available IP address to the Redis instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the DCS instance resource.
        If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="renameCommands")
    def rename_commands(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Critical command renaming, which is supported only by Redis 4.0 and
        Redis 5.0 instances but not by Redis 3.0 instance.
        The valid commands that can be renamed are: *command*, *keys*, *flushdb*, *flushall* and *hgetall*.
        """
        return pulumi.get(self, "rename_commands")

    @rename_commands.setter
    def rename_commands(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "rename_commands", value)

    @property
    @pulumi.getter(name="saveDays")
    def save_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention time. Unit: day, the value ranges from 1 to 7.
        """
        return pulumi.get(self, "save_days")

    @save_days.setter
    def save_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "save_days", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group which the instance belongs to.
        This parameter is mandatory for Memcached and Redis 3.0 version.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of security group which the instance belongs to.
        """
        return pulumi.get(self, "security_group_name")

    @security_group_name.setter
    def security_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Cache instance status. The valid values are as follows:
        + `RUNNING`: The instance is running properly.
        Only instances in the Running state can provide in-memory cache service.
        + `ERROR`: The instance is not running properly.
        + `RESTARTING`: The instance is being restarted.
        + `FROZEN`: The instance has been frozen due to low balance.
        You can unfreeze the instance by recharging your account in My Order.
        + `EXTENDING`: The instance is being scaled up.
        + `RESTORING`: The instance data is being restored.
        + `FLUSHING`: The DCS instance is being cleared.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of subnet which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of subnet which the instance belongs to.
        """
        return pulumi.get(self, "subnet_name")

    @subnet_name.setter
    def subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the dcs instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="usedMemory")
    def used_memory(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the used memory. Unit: MB.
        """
        return pulumi.get(self, "used_memory")

    @used_memory.setter
    def used_memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_memory", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of VPC which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of VPC which the instance belongs to.
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_name", value)

    @property
    @pulumi.getter(name="whitelistEnable")
    def whitelist_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable the IP address whitelists. Defaults to true.
        If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        """
        return pulumi.get(self, "whitelist_enable")

    @whitelist_enable.setter
    def whitelist_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "whitelist_enable", value)

    @property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]]:
        """
        Specifies the IP addresses which can access the instance.
        This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceWhitelistArgs']]]]):
        pulumi.set(self, "whitelists", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 backup_policy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupPolicyArgs']]] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 begin_at: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[float]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_name: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_type: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 save_days: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 whitelist_enable: Optional[pulumi.Input[bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceWhitelistArgs']]]]] = None,
                 __props__=None):
        """
        Manages a DCS instance within HuaweiCloud.

        !> **WARNING:** DCS for Memcached is about to become unavailable and is no longer sold in some regions.
        You can use DCS for Redis 4.0 or 5.0 instead. It is not possible to create Memcached instances through this resource.
        You can use this resource to manage Memcached instances that exist in HuaweiCloud.

        ## Example Usage
        ### Create a single mode Redis instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        single_flavors = huaweicloud.Dcs.get_flavors(cache_mode="single",
            capacity=0.125)
        instance1 = huaweicloud.dcs.Instance("instance1",
            engine="Redis",
            engine_version="5.0",
            capacity=single_flavors.capacity,
            flavor=single_flavors.flavors[0].name,
            availability_zones=["cn-north-1a"],
            password="YourPassword@123",
            vpc_id=vpc_id,
            subnet_id=subnet_id)
        ```
        ### Create Master/Standby mode Redis instances with backup policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        instance2 = huaweicloud.dcs.Instance("instance2",
            engine="Redis",
            engine_version="5.0",
            capacity=4,
            flavor="redis.ha.xu1.large.r2.4",
            availability_zones=[
                "cn-north-1a",
                "cn-north-1b",
            ],
            password="YourPassword@123",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            charging_mode="prePaid",
            period_unit="month",
            auto_renew="true",
            period=1,
            backup_policy=huaweicloud.dcs.InstanceBackupPolicyArgs(
                backup_type="auto",
                save_days=3,
                backup_ats=[
                    1,
                    3,
                    5,
                    7,
                ],
                begin_at="02:00-04:00",
            ),
            whitelists=[
                huaweicloud.dcs.InstanceWhitelistArgs(
                    group_name="test-group1",
                    ip_addresses=[
                        "192.168.10.100",
                        "192.168.0.0/24",
                    ],
                ),
                huaweicloud.dcs.InstanceWhitelistArgs(
                    group_name="test-group2",
                    ip_addresses=[
                        "172.16.10.100",
                        "172.16.0.0/24",
                    ],
                ),
            ])
        ```

        ## Import

        DCS instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Dcs/instance:Instance instance_1 80e373f9-872e-4046-aae9-ccd9ddc55511
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `auto_renew`, `period`, `period_unit`, `rename_commands`, `internal_version`, `save_days`, `backup_type`, `begin_at`, `period_type`, `backup_at`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dcs_instance" "instance_1" {

         ...

         lifecycle {

         ignore_changes = [

         password, rename_commands,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_user: Specifies the username used for accessing a DCS Memcached instance.
               If the cache engine is *Redis*, you do not need to set this parameter.
               The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
               hyphens (-). Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The code of the AZ where the cache node resides.
               Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
               You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_ats: Day in a week on which backup starts, the value ranges from 1 to 7.
               Where: 1 indicates Monday; 7 indicates Sunday.
        :param pulumi.Input[pulumi.InputType['InstanceBackupPolicyArgs']] backup_policy: Specifies the backup configuration to be used with the instance.
               The structure is described below.
        :param pulumi.Input[str] backup_type: Backup type. Default value is `auto`. The valid values are as follows:
               + `auto`: automatic backup.
               + `manual`: manual backup.
        :param pulumi.Input[str] begin_at: Time at which backup starts.
               Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        :param pulumi.Input[float] capacity: Specifies the cache capacity. Unit: GB.
               + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`, `0.5`, `1`, `2`,
               `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
               `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the redis instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[str] description: Specifies the description of an instance.
               It is a string that contains a maximum of 1024 characters.
        :param pulumi.Input[str] engine: Specifies a cache engine. Options: *Redis* and *Memcached*.
               Changing this creates a new instance.
        :param pulumi.Input[str] engine_version: Specifies the version of a cache engine.
               It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, or 5.0.
               Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the dcs instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] flavor: The flavor of the cache instance, which including the total memory, available memory,
               maximum number of connections allowed, maximum/assured bandwidth and reference performance.
               It also includes the modes of Redis instances. You can query the *flavor* as follows:
               + It can be obtained through this data source `_dcs.get_flavors`.
               + Query some flavors
               in [DCS Instance Specifications](https://support.huaweicloud.com/intl/en-us/productdesc-dcs/dcs-pd-200713003.html)
               + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        :param pulumi.Input[str] maintain_begin: Time at which the maintenance time window starts.
               The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
               Default value is `02:00:00`.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               + If parameter maintain_begin is left blank, parameter maintain_end is also blank.
               In this case, the system automatically allocates the default start time 02:00:00.
        :param pulumi.Input[str] maintain_end: Time at which the maintenance time window ends.
               The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
               Default value is `06:00:00`.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The end time is four hours later than the start time.
               For example, if the start time is 22:00:00, the end time is 02:00:00.
               + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               + If parameter maintain_end is left blank, parameter maintain_begin is also blank.
               In this case, the system automatically allocates the default end time 06:00:00.
        :param pulumi.Input[str] name: Specifies the name of an instance.
               The name must be 4 to 64 characters and start with a letter.
               Only chinese, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        :param pulumi.Input[str] password: Specifies the password of a DCS instance.
               Changing this creates a new instance.
               The password of a DCS instance must meet the following complexity requirements:
               + Must be a string of 8 to 32 bits in length.
               + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
               Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
               + The new password cannot be the same as the old password.
               Redis instance defaults to 6379. Memcached instance does not use this argument.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_type: Interval at which backup is performed. Default value is `weekly`.
               Currently, only weekly backup is supported.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[int] port: Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        :param pulumi.Input[str] private_ip: The IP address of the DCS instance,
               which can only be the currently available IP address the selected subnet.
               You can specify an available IP for the Redis instance (except for the Redis Cluster type).
               If omitted, the system will automatically allocate an available IP address to the Redis instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the DCS instance resource.
               If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] rename_commands: Critical command renaming, which is supported only by Redis 4.0 and
               Redis 5.0 instances but not by Redis 3.0 instance.
               The valid commands that can be renamed are: *command*, *keys*, *flushdb*, *flushall* and *hgetall*.
        :param pulumi.Input[int] save_days: Retention time. Unit: day, the value ranges from 1 to 7.
        :param pulumi.Input[str] security_group_id: The ID of the security group which the instance belongs to.
               This parameter is mandatory for Memcached and Redis 3.0 version.
        :param pulumi.Input[str] subnet_id: The ID of subnet which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the dcs instance.
        :param pulumi.Input[str] vpc_id: The ID of VPC which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[bool] whitelist_enable: Enable or disable the IP address whitelists. Defaults to true.
               If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceWhitelistArgs']]]] whitelists: Specifies the IP addresses which can access the instance.
               This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DCS instance within HuaweiCloud.

        !> **WARNING:** DCS for Memcached is about to become unavailable and is no longer sold in some regions.
        You can use DCS for Redis 4.0 or 5.0 instead. It is not possible to create Memcached instances through this resource.
        You can use this resource to manage Memcached instances that exist in HuaweiCloud.

        ## Example Usage
        ### Create a single mode Redis instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        single_flavors = huaweicloud.Dcs.get_flavors(cache_mode="single",
            capacity=0.125)
        instance1 = huaweicloud.dcs.Instance("instance1",
            engine="Redis",
            engine_version="5.0",
            capacity=single_flavors.capacity,
            flavor=single_flavors.flavors[0].name,
            availability_zones=["cn-north-1a"],
            password="YourPassword@123",
            vpc_id=vpc_id,
            subnet_id=subnet_id)
        ```
        ### Create Master/Standby mode Redis instances with backup policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        instance2 = huaweicloud.dcs.Instance("instance2",
            engine="Redis",
            engine_version="5.0",
            capacity=4,
            flavor="redis.ha.xu1.large.r2.4",
            availability_zones=[
                "cn-north-1a",
                "cn-north-1b",
            ],
            password="YourPassword@123",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            charging_mode="prePaid",
            period_unit="month",
            auto_renew="true",
            period=1,
            backup_policy=huaweicloud.dcs.InstanceBackupPolicyArgs(
                backup_type="auto",
                save_days=3,
                backup_ats=[
                    1,
                    3,
                    5,
                    7,
                ],
                begin_at="02:00-04:00",
            ),
            whitelists=[
                huaweicloud.dcs.InstanceWhitelistArgs(
                    group_name="test-group1",
                    ip_addresses=[
                        "192.168.10.100",
                        "192.168.0.0/24",
                    ],
                ),
                huaweicloud.dcs.InstanceWhitelistArgs(
                    group_name="test-group2",
                    ip_addresses=[
                        "172.16.10.100",
                        "172.16.0.0/24",
                    ],
                ),
            ])
        ```

        ## Import

        DCS instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Dcs/instance:Instance instance_1 80e373f9-872e-4046-aae9-ccd9ddc55511
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `auto_renew`, `period`, `period_unit`, `rename_commands`, `internal_version`, `save_days`, `backup_type`, `begin_at`, `period_type`, `backup_at`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dcs_instance" "instance_1" {

         ...

         lifecycle {

         ignore_changes = [

         password, rename_commands,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 backup_policy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupPolicyArgs']]] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 begin_at: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[float]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_name: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_type: Optional[pulumi.Input[str]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 save_days: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 whitelist_enable: Optional[pulumi.Input[bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceWhitelistArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["access_user"] = access_user
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["availability_zones"] = availability_zones
            if available_zones is not None and not opts.urn:
                warnings.warn("""Deprecated, please use `availability_zones` instead""", DeprecationWarning)
                pulumi.log.warn("""available_zones is deprecated: Deprecated, please use `availability_zones` instead""")
            __props__.__dict__["available_zones"] = available_zones
            if backup_ats is not None and not opts.urn:
                warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
                pulumi.log.warn("""backup_ats is deprecated: Deprecated, please use `backup_policy` instead""")
            __props__.__dict__["backup_ats"] = backup_ats
            __props__.__dict__["backup_policy"] = backup_policy
            if backup_type is not None and not opts.urn:
                warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
                pulumi.log.warn("""backup_type is deprecated: Deprecated, please use `backup_policy` instead""")
            __props__.__dict__["backup_type"] = backup_type
            if begin_at is not None and not opts.urn:
                warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
                pulumi.log.warn("""begin_at is deprecated: Deprecated, please use `backup_policy` instead""")
            __props__.__dict__["begin_at"] = begin_at
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["description"] = description
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if enterprise_project_name is not None and not opts.urn:
                warnings.warn("""Deprecated, this is a non-public attribute.""", DeprecationWarning)
                pulumi.log.warn("""enterprise_project_name is deprecated: Deprecated, this is a non-public attribute.""")
            __props__.__dict__["enterprise_project_name"] = enterprise_project_name
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = password
            __props__.__dict__["period"] = period
            if period_type is not None and not opts.urn:
                warnings.warn("""Please use `backup_policy` instead""", DeprecationWarning)
                pulumi.log.warn("""period_type is deprecated: Please use `backup_policy` instead""")
            __props__.__dict__["period_type"] = period_type
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["port"] = port
            __props__.__dict__["private_ip"] = private_ip
            if product_id is not None and not opts.urn:
                warnings.warn("""Deprecated, please use `flavor` instead""", DeprecationWarning)
                pulumi.log.warn("""product_id is deprecated: Deprecated, please use `flavor` instead""")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["region"] = region
            __props__.__dict__["rename_commands"] = rename_commands
            if save_days is not None and not opts.urn:
                warnings.warn("""Deprecated, please use `backup_policy` instead""", DeprecationWarning)
                pulumi.log.warn("""save_days is deprecated: Deprecated, please use `backup_policy` instead""")
            __props__.__dict__["save_days"] = save_days
            __props__.__dict__["security_group_id"] = security_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["whitelist_enable"] = whitelist_enable
            __props__.__dict__["whitelists"] = whitelists
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["internal_version"] = None
            __props__.__dict__["ip"] = None
            __props__.__dict__["max_memory"] = None
            __props__.__dict__["order_id"] = None
            __props__.__dict__["security_group_name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_name"] = None
            __props__.__dict__["used_memory"] = None
            __props__.__dict__["user_id"] = None
            __props__.__dict__["user_name"] = None
            __props__.__dict__["vpc_name"] = None
        super(Instance, __self__).__init__(
            'huaweicloud:Dcs/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_user: Optional[pulumi.Input[str]] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backup_ats: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            backup_policy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupPolicyArgs']]] = None,
            backup_type: Optional[pulumi.Input[str]] = None,
            begin_at: Optional[pulumi.Input[str]] = None,
            capacity: Optional[pulumi.Input[float]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            enterprise_project_name: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            internal_version: Optional[pulumi.Input[str]] = None,
            ip: Optional[pulumi.Input[str]] = None,
            maintain_begin: Optional[pulumi.Input[str]] = None,
            maintain_end: Optional[pulumi.Input[str]] = None,
            max_memory: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            order_id: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_type: Optional[pulumi.Input[str]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rename_commands: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            save_days: Optional[pulumi.Input[int]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            security_group_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            subnet_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            used_memory: Optional[pulumi.Input[int]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_name: Optional[pulumi.Input[str]] = None,
            whitelist_enable: Optional[pulumi.Input[bool]] = None,
            whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceWhitelistArgs']]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_user: Specifies the username used for accessing a DCS Memcached instance.
               If the cache engine is *Redis*, you do not need to set this parameter.
               The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
               hyphens (-). Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The code of the AZ where the cache node resides.
               Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
               You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_ats: Day in a week on which backup starts, the value ranges from 1 to 7.
               Where: 1 indicates Monday; 7 indicates Sunday.
        :param pulumi.Input[pulumi.InputType['InstanceBackupPolicyArgs']] backup_policy: Specifies the backup configuration to be used with the instance.
               The structure is described below.
        :param pulumi.Input[str] backup_type: Backup type. Default value is `auto`. The valid values are as follows:
               + `auto`: automatic backup.
               + `manual`: manual backup.
        :param pulumi.Input[str] begin_at: Time at which backup starts.
               Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        :param pulumi.Input[float] capacity: Specifies the cache capacity. Unit: GB.
               + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`, `0.5`, `1`, `2`,
               `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
               `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the redis instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[str] description: Specifies the description of an instance.
               It is a string that contains a maximum of 1024 characters.
        :param pulumi.Input[str] domain_name: Domain name of the instance. Usually, we use domain name and port to connect to the DCS instances.
        :param pulumi.Input[str] engine: Specifies a cache engine. Options: *Redis* and *Memcached*.
               Changing this creates a new instance.
        :param pulumi.Input[str] engine_version: Specifies the version of a cache engine.
               It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, or 5.0.
               Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the dcs instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] flavor: The flavor of the cache instance, which including the total memory, available memory,
               maximum number of connections allowed, maximum/assured bandwidth and reference performance.
               It also includes the modes of Redis instances. You can query the *flavor* as follows:
               + It can be obtained through this data source `_dcs.get_flavors`.
               + Query some flavors
               in [DCS Instance Specifications](https://support.huaweicloud.com/intl/en-us/productdesc-dcs/dcs-pd-200713003.html)
               + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        :param pulumi.Input[str] maintain_begin: Time at which the maintenance time window starts.
               The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
               Default value is `02:00:00`.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               + If parameter maintain_begin is left blank, parameter maintain_end is also blank.
               In this case, the system automatically allocates the default start time 02:00:00.
        :param pulumi.Input[str] maintain_end: Time at which the maintenance time window ends.
               The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
               Default value is `06:00:00`.
               + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               + The end time is four hours later than the start time.
               For example, if the start time is 22:00:00, the end time is 02:00:00.
               + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               + If parameter maintain_end is left blank, parameter maintain_begin is also blank.
               In this case, the system automatically allocates the default end time 06:00:00.
        :param pulumi.Input[int] max_memory: Total memory size. Unit: MB.
        :param pulumi.Input[str] name: Specifies the name of an instance.
               The name must be 4 to 64 characters and start with a letter.
               Only chinese, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        :param pulumi.Input[str] order_id: The ID of the order that created the instance.
        :param pulumi.Input[str] password: Specifies the password of a DCS instance.
               Changing this creates a new instance.
               The password of a DCS instance must meet the following complexity requirements:
               + Must be a string of 8 to 32 bits in length.
               + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
               Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
               + The new password cannot be the same as the old password.
               Redis instance defaults to 6379. Memcached instance does not use this argument.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_type: Interval at which backup is performed. Default value is `weekly`.
               Currently, only weekly backup is supported.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[int] port: Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        :param pulumi.Input[str] private_ip: The IP address of the DCS instance,
               which can only be the currently available IP address the selected subnet.
               You can specify an available IP for the Redis instance (except for the Redis Cluster type).
               If omitted, the system will automatically allocate an available IP address to the Redis instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the DCS instance resource.
               If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] rename_commands: Critical command renaming, which is supported only by Redis 4.0 and
               Redis 5.0 instances but not by Redis 3.0 instance.
               The valid commands that can be renamed are: *command*, *keys*, *flushdb*, *flushall* and *hgetall*.
        :param pulumi.Input[int] save_days: Retention time. Unit: day, the value ranges from 1 to 7.
        :param pulumi.Input[str] security_group_id: The ID of the security group which the instance belongs to.
               This parameter is mandatory for Memcached and Redis 3.0 version.
        :param pulumi.Input[str] security_group_name: The name of security group which the instance belongs to.
        :param pulumi.Input[str] status: Cache instance status. The valid values are as follows:
               + `RUNNING`: The instance is running properly.
               Only instances in the Running state can provide in-memory cache service.
               + `ERROR`: The instance is not running properly.
               + `RESTARTING`: The instance is being restarted.
               + `FROZEN`: The instance has been frozen due to low balance.
               You can unfreeze the instance by recharging your account in My Order.
               + `EXTENDING`: The instance is being scaled up.
               + `RESTORING`: The instance data is being restored.
               + `FLUSHING`: The DCS instance is being cleared.
        :param pulumi.Input[str] subnet_id: The ID of subnet which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] subnet_name: The name of subnet which the instance belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the dcs instance.
        :param pulumi.Input[int] used_memory: Size of the used memory. Unit: MB.
        :param pulumi.Input[str] vpc_id: The ID of VPC which the instance belongs to.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] vpc_name: The name of VPC which the instance belongs to.
        :param pulumi.Input[bool] whitelist_enable: Enable or disable the IP address whitelists. Defaults to true.
               If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceWhitelistArgs']]]] whitelists: Specifies the IP addresses which can access the instance.
               This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["access_user"] = access_user
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["backup_ats"] = backup_ats
        __props__.__dict__["backup_policy"] = backup_policy
        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["begin_at"] = begin_at
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["enterprise_project_name"] = enterprise_project_name
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["internal_version"] = internal_version
        __props__.__dict__["ip"] = ip
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["max_memory"] = max_memory
        __props__.__dict__["name"] = name
        __props__.__dict__["order_id"] = order_id
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_type"] = period_type
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["region"] = region
        __props__.__dict__["rename_commands"] = rename_commands
        __props__.__dict__["save_days"] = save_days
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_name"] = security_group_name
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["subnet_name"] = subnet_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["used_memory"] = used_memory
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_name"] = vpc_name
        __props__.__dict__["whitelist_enable"] = whitelist_enable
        __props__.__dict__["whitelists"] = whitelists
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> pulumi.Output[str]:
        """
        Specifies the username used for accessing a DCS Memcached instance.
        If the cache engine is *Redis*, you do not need to set this parameter.
        The username starts with a letter, consists of 1 to 64 characters, and supports only letters, digits, and
        hyphens (-). Changing this creates a new instance.
        """
        return pulumi.get(self, "access_user")

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        The code of the AZ where the cache node resides.
        Master/Standby, Proxy Cluster, and Redis Cluster DCS instances support cross-AZ deployment.
        You can specify an AZ for the standby node. When specifying AZs for nodes, use commas (,) to separate AZs.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "available_zones")

    @property
    @pulumi.getter(name="backupAts")
    def backup_ats(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        Day in a week on which backup starts, the value ranges from 1 to 7.
        Where: 1 indicates Monday; 7 indicates Sunday.
        """
        return pulumi.get(self, "backup_ats")

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> pulumi.Output[Optional['outputs.InstanceBackupPolicy']]:
        """
        Specifies the backup configuration to be used with the instance.
        The structure is described below.
        """
        return pulumi.get(self, "backup_policy")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[Optional[str]]:
        """
        Backup type. Default value is `auto`. The valid values are as follows:
        + `auto`: automatic backup.
        + `manual`: manual backup.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="beginAt")
    def begin_at(self) -> pulumi.Output[Optional[str]]:
        """
        Time at which backup starts.
        Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        """
        return pulumi.get(self, "begin_at")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[float]:
        """
        Specifies the cache capacity. Unit: GB.
        + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values: `0.125`, `0.25`, `0.5`, `1`, `2`,
        `4`, `8`, `16`, `32` and `64`.
        Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
        `1024`.
        + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
        + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the redis instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Specifies the description of an instance.
        It is a string that contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Domain name of the instance. Usually, we use domain name and port to connect to the DCS instances.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Specifies a cache engine. Options: *Redis* and *Memcached*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the version of a cache engine.
        It is mandatory when the engine is *Redis*, the value can be 3.0, 4.0, or 5.0.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the dcs instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="enterpriseProjectName")
    def enterprise_project_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "enterprise_project_name")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        The flavor of the cache instance, which including the total memory, available memory,
        maximum number of connections allowed, maximum/assured bandwidth and reference performance.
        It also includes the modes of Redis instances. You can query the *flavor* as follows:
        + It can be obtained through this data source `_dcs.get_flavors`.
        + Query some flavors
        in [DCS Instance Specifications](https://support.huaweicloud.com/intl/en-us/productdesc-dcs/dcs-pd-200713003.html)
        + Log in to the DCS console, click *Buy DCS Instance*, and find the corresponding instance specification.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="internalVersion")
    def internal_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "internal_version")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[Optional[str]]:
        """
        Time at which the maintenance time window starts.
        The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
        Default value is `02:00:00`.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        + If parameter maintain_begin is left blank, parameter maintain_end is also blank.
        In this case, the system automatically allocates the default start time 02:00:00.
        """
        return pulumi.get(self, "maintain_begin")

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[Optional[str]]:
        """
        Time at which the maintenance time window ends.
        The valid values are `22:00:00`, `02:00:00`, `06:00:00`, `10:00:00`, `14:00:00` and `18:00:00`.
        Default value is `06:00:00`.
        + The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        + The end time is four hours later than the start time.
        For example, if the start time is 22:00:00, the end time is 02:00:00.
        + Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        + If parameter maintain_end is left blank, parameter maintain_begin is also blank.
        In this case, the system automatically allocates the default end time 06:00:00.
        """
        return pulumi.get(self, "maintain_end")

    @property
    @pulumi.getter(name="maxMemory")
    def max_memory(self) -> pulumi.Output[int]:
        """
        Total memory size. Unit: MB.
        """
        return pulumi.get(self, "max_memory")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of an instance.
        The name must be 4 to 64 characters and start with a letter.
        Only chinese, letters (case-insensitive), digits, underscores (_) ,and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> pulumi.Output[str]:
        """
        The ID of the order that created the instance.
        """
        return pulumi.get(self, "order_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the password of a DCS instance.
        Changing this creates a new instance.
        The password of a DCS instance must meet the following complexity requirements:
        + Must be a string of 8 to 32 bits in length.
        + Must contain three combinations of the following four characters: Lower case letters, uppercase letter, digital,
        Special characters include (`~!@#$^&*()-_=+\\\\|{}:,<.>/?).
        + The new password cannot be the same as the old password.
        Redis instance defaults to 6379. Memcached instance does not use this argument.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> pulumi.Output[Optional[str]]:
        """
        Interval at which backup is performed. Default value is `weekly`.
        Currently, only weekly backup is supported.
        """
        return pulumi.get(self, "period_type")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Port customization, which is supported only by Redis 4.0 and Redis 5.0 instances.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        The IP address of the DCS instance,
        which can only be the currently available IP address the selected subnet.
        You can specify an available IP for the Redis instance (except for the Redis Cluster type).
        If omitted, the system will automatically allocate an available IP address to the Redis instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the DCS instance resource.
        If omitted, the provider-level region will be used. Changing this creates a new DCS instance resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="renameCommands")
    def rename_commands(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Critical command renaming, which is supported only by Redis 4.0 and
        Redis 5.0 instances but not by Redis 3.0 instance.
        The valid commands that can be renamed are: *command*, *keys*, *flushdb*, *flushall* and *hgetall*.
        """
        return pulumi.get(self, "rename_commands")

    @property
    @pulumi.getter(name="saveDays")
    def save_days(self) -> pulumi.Output[Optional[int]]:
        """
        Retention time. Unit: day, the value ranges from 1 to 7.
        """
        return pulumi.get(self, "save_days")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the security group which the instance belongs to.
        This parameter is mandatory for Memcached and Redis 3.0 version.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> pulumi.Output[str]:
        """
        The name of security group which the instance belongs to.
        """
        return pulumi.get(self, "security_group_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Cache instance status. The valid values are as follows:
        + `RUNNING`: The instance is running properly.
        Only instances in the Running state can provide in-memory cache service.
        + `ERROR`: The instance is not running properly.
        + `RESTARTING`: The instance is being restarted.
        + `FROZEN`: The instance has been frozen due to low balance.
        You can unfreeze the instance by recharging your account in My Order.
        + `EXTENDING`: The instance is being scaled up.
        + `RESTORING`: The instance data is being restored.
        + `FLUSHING`: The DCS instance is being cleared.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The ID of subnet which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> pulumi.Output[str]:
        """
        The name of subnet which the instance belongs to.
        """
        return pulumi.get(self, "subnet_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the dcs instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="usedMemory")
    def used_memory(self) -> pulumi.Output[int]:
        """
        Size of the used memory. Unit: MB.
        """
        return pulumi.get(self, "used_memory")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of VPC which the instance belongs to.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> pulumi.Output[str]:
        """
        The name of VPC which the instance belongs to.
        """
        return pulumi.get(self, "vpc_name")

    @property
    @pulumi.getter(name="whitelistEnable")
    def whitelist_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable the IP address whitelists. Defaults to true.
        If the whitelist is disabled, all IP addresses connected to the VPC can access the instance.
        """
        return pulumi.get(self, "whitelist_enable")

    @property
    @pulumi.getter
    def whitelists(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceWhitelist']]]:
        """
        Specifies the IP addresses which can access the instance.
        This parameter is valid for Redis 4.0 and 5.0 versions. The structure is described below.
        """
        return pulumi.get(self, "whitelists")

