# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['StudioInstanceArgs', 'StudioInstance']

@pulumi.input_type
class StudioInstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 period: pulumi.Input[int],
                 period_unit: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 version: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a StudioInstance resource.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this creates a new instance.
        :param pulumi.Input[int] period: Specifies the charging period of the DataArts Studio instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               Changing this creates a new instance.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Changing this creates a new instance.
        :param pulumi.Input[str] subnet_id: Specifies the VPC subnet ID. Changing this creates a new instance.
        :param pulumi.Input[str] version: Specifies the DataArts Studio version version.
               The valid values are **dayu.starter**, **dayu.nb.professional** and **dayu.nb.enterprise**.
               Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] name: Specifies the DataArts Studio instance name. Changing this creates a new instance.
        :param pulumi.Input[str] region: Specifies the region in which to manage the DataArts Studio instance.
               Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DataArts Studio instance.
               Changing this creates a new instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "period_unit", period_unit)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the AZ name. Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[int]:
        """
        Specifies the charging period of the DataArts Studio instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[int]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Input[str]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the security group ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC subnet ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Specifies the DataArts Studio version version.
        The valid values are **dayu.starter**, **dayu.nb.professional** and **dayu.nb.enterprise**.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DataArts Studio instance name. Changing this creates a new instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to manage the DataArts Studio instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the DataArts Studio instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _StudioInstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 expire_days: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StudioInstance resources.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this creates a new instance.
        :param pulumi.Input[str] charging_mode: The charging mode. The value is `prePaid` indicates the yearly/monthly billing mode.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] expire_days: The expire days to renew.
        :param pulumi.Input[str] name: Specifies the DataArts Studio instance name. Changing this creates a new instance.
        :param pulumi.Input[str] order_id: The order ID of this DataArts Studio instance.
        :param pulumi.Input[int] period: Specifies the charging period of the DataArts Studio instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               Changing this creates a new instance.
        :param pulumi.Input[str] region: Specifies the region in which to manage the DataArts Studio instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Changing this creates a new instance.
        :param pulumi.Input[int] status: The status of this DataArts Studio instance.
        :param pulumi.Input[str] subnet_id: Specifies the VPC subnet ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DataArts Studio instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] version: Specifies the DataArts Studio version version.
               The valid values are **dayu.starter**, **dayu.nb.professional** and **dayu.nb.enterprise**.
               Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if expire_days is not None:
            pulumi.set(__self__, "expire_days", expire_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AZ name. Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The charging mode. The value is `prePaid` indicates the yearly/monthly billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="expireDays")
    def expire_days(self) -> Optional[pulumi.Input[str]]:
        """
        The expire days to renew.
        """
        return pulumi.get(self, "expire_days")

    @expire_days.setter
    def expire_days(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_days", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DataArts Studio instance name. Changing this creates a new instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[str]]:
        """
        The order ID of this DataArts Studio instance.
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_id", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the DataArts Studio instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to manage the DataArts Studio instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The status of this DataArts Studio instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC subnet ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the DataArts Studio instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DataArts Studio version version.
        The valid values are **dayu.starter**, **dayu.nb.professional** and **dayu.nb.enterprise**.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class StudioInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages DataArts Studio instance resource within HuaweiCloud.

        > Only **prePaid** charging mode is supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        my_demo = huaweicloud.data_arts_studio.StudioInstance("myDemo",
            version="dayu.starter",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zone=availability_zone,
            period_unit="month",
            period=1,
            enterprise_project_id="0",
            tags={
                "key": "value",
            })
        ```

        <!--markdownlint-disable MD033-->

        ## Import

        DataArts Studio instances can be imported using their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:DataArtsStudio/studioInstance:StudioInstance instance e60361de2cfd42d7a6b673f0ae58db82
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`tags`, `period_unit`, `period`, `auto_renew`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dataarts_studio_instance" "instance" {

         ...

         lifecycle {

         ignore_changes = [

         tags, period_unit, period, auto_renew,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] name: Specifies the DataArts Studio instance name. Changing this creates a new instance.
        :param pulumi.Input[int] period: Specifies the charging period of the DataArts Studio instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               Changing this creates a new instance.
        :param pulumi.Input[str] region: Specifies the region in which to manage the DataArts Studio instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Changing this creates a new instance.
        :param pulumi.Input[str] subnet_id: Specifies the VPC subnet ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DataArts Studio instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] version: Specifies the DataArts Studio version version.
               The valid values are **dayu.starter**, **dayu.nb.professional** and **dayu.nb.enterprise**.
               Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StudioInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DataArts Studio instance resource within HuaweiCloud.

        > Only **prePaid** charging mode is supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        my_demo = huaweicloud.data_arts_studio.StudioInstance("myDemo",
            version="dayu.starter",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zone=availability_zone,
            period_unit="month",
            period=1,
            enterprise_project_id="0",
            tags={
                "key": "value",
            })
        ```

        <!--markdownlint-disable MD033-->

        ## Import

        DataArts Studio instances can be imported using their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:DataArtsStudio/studioInstance:StudioInstance instance e60361de2cfd42d7a6b673f0ae58db82
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`tags`, `period_unit`, `period`, `auto_renew`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dataarts_studio_instance" "instance" {

         ...

         lifecycle {

         ignore_changes = [

         tags, period_unit, period, auto_renew,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param StudioInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StudioInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StudioInstanceArgs.__new__(StudioInstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            if period_unit is None and not opts.urn:
                raise TypeError("Missing required property 'period_unit'")
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["charging_mode"] = None
            __props__.__dict__["expire_days"] = None
            __props__.__dict__["order_id"] = None
            __props__.__dict__["status"] = None
        super(StudioInstance, __self__).__init__(
            'huaweicloud:DataArtsStudio/studioInstance:StudioInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            expire_days: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            order_id: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[int]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'StudioInstance':
        """
        Get an existing StudioInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this creates a new instance.
        :param pulumi.Input[str] charging_mode: The charging mode. The value is `prePaid` indicates the yearly/monthly billing mode.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] expire_days: The expire days to renew.
        :param pulumi.Input[str] name: Specifies the DataArts Studio instance name. Changing this creates a new instance.
        :param pulumi.Input[str] order_id: The order ID of this DataArts Studio instance.
        :param pulumi.Input[int] period: Specifies the charging period of the DataArts Studio instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               Changing this creates a new instance.
        :param pulumi.Input[str] region: Specifies the region in which to manage the DataArts Studio instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Changing this creates a new instance.
        :param pulumi.Input[int] status: The status of this DataArts Studio instance.
        :param pulumi.Input[str] subnet_id: Specifies the VPC subnet ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DataArts Studio instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] version: Specifies the DataArts Studio version version.
               The valid values are **dayu.starter**, **dayu.nb.professional** and **dayu.nb.enterprise**.
               Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StudioInstanceState.__new__(_StudioInstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["expire_days"] = expire_days
        __props__.__dict__["name"] = name
        __props__.__dict__["order_id"] = order_id
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        return StudioInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the AZ name. Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        The charging mode. The value is `prePaid` indicates the yearly/monthly billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="expireDays")
    def expire_days(self) -> pulumi.Output[str]:
        """
        The expire days to renew.
        """
        return pulumi.get(self, "expire_days")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the DataArts Studio instance name. Changing this creates a new instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> pulumi.Output[str]:
        """
        The order ID of this DataArts Studio instance.
        """
        return pulumi.get(self, "order_id")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[int]:
        """
        Specifies the charging period of the DataArts Studio instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[str]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to manage the DataArts Studio instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the security group ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        The status of this DataArts Studio instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC subnet ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the DataArts Studio instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Specifies the DataArts Studio version version.
        The valid values are **dayu.starter**, **dayu.nb.professional** and **dayu.nb.enterprise**.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

