# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, flavors=None, id=None, memory=None, name=None, region=None, type=None, vcpus=None, version=None):
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memory(self) -> Optional[int]:
        """
        The memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the CSS flavor. It is referenced by `node_config.flavor` in `Css.Cluster`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region where the node resides.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The node instance type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[int]:
        """
        The number of vCPUs.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The engine version.
        """
        return pulumi.get(self, "version")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            flavors=self.flavors,
            id=self.id,
            memory=self.memory,
            name=self.name,
            region=self.region,
            type=self.type,
            vcpus=self.vcpus,
            version=self.version)


def get_flavors(memory: Optional[int] = None,
                name: Optional[str] = None,
                region: Optional[str] = None,
                type: Optional[str] = None,
                vcpus: Optional[int] = None,
                version: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get available flavors of HuaweiCloud CSS node instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Css.get_flavors(memory=32,
        type="ess",
        vcpus=4,
        version="7.9.3")
    ```


    :param int memory: Specifies the memory size(GB) in the CSS flavor.
    :param str name: Specifies the name of the CSS flavor.
    :param str region: Specifies the region in which to obtain the CSS flavors. If omitted, the
           provider-level region will be used.
    :param str type: Specifies the node instance type. The options are `ess`, `ess-cold`, `ess-master`
           and `ess-client`.
    :param int vcpus: Specifies the number of vCPUs in the CSS flavor.
    :param str version: Specifies the engine version. The options are `5.5.1`, `6.2.3`, `6.5.4`, `7.1.1`,
           `7.6.2` and `7.9.3`.
    """
    __args__ = dict()
    __args__['memory'] = memory
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    __args__['vcpus'] = vcpus
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Css/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        flavors=__ret__.flavors,
        id=__ret__.id,
        memory=__ret__.memory,
        name=__ret__.name,
        region=__ret__.region,
        type=__ret__.type,
        vcpus=__ret__.vcpus,
        version=__ret__.version)


@_utilities.lift_output_func(get_flavors)
def get_flavors_output(memory: Optional[pulumi.Input[Optional[int]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       type: Optional[pulumi.Input[Optional[str]]] = None,
                       vcpus: Optional[pulumi.Input[Optional[int]]] = None,
                       version: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get available flavors of HuaweiCloud CSS node instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Css.get_flavors(memory=32,
        type="ess",
        vcpus=4,
        version="7.9.3")
    ```


    :param int memory: Specifies the memory size(GB) in the CSS flavor.
    :param str name: Specifies the name of the CSS flavor.
    :param str region: Specifies the region in which to obtain the CSS flavors. If omitted, the
           provider-level region will be used.
    :param str type: Specifies the node instance type. The options are `ess`, `ess-cold`, `ess-master`
           and `ess-client`.
    :param int vcpus: Specifies the number of vCPUs in the CSS flavor.
    :param str version: Specifies the engine version. The options are `5.5.1`, `6.2.3`, `6.5.4`, `7.1.1`,
           `7.6.2` and `7.9.3`.
    """
    ...
