# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 sources: pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]],
                 type: pulumi.Input[str],
                 cache_settings: Optional[pulumi.Input['DomainCacheSettingsArgs']] = None,
                 configs: Optional[pulumi.Input['DomainConfigsArgs']] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_area: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]] sources: An array of one or more objects specifies the domain name of the origin server.
               The sources object structure is documented below.
        :param pulumi.Input[str] type: Specifies the operation type for caching URL parameters. Posiible values are:
               **full_url**: cache all parameters
               **ignore_url_params**: ignore all parameters
               **del_args**: ignore specific URL parameters
               **reserve_args**: reserve specified URL parameters
        :param pulumi.Input['DomainCacheSettingsArgs'] cache_settings: Specifies the cache configuration. The object structure
               is documented below.
        :param pulumi.Input['DomainConfigsArgs'] configs: Specifies the domain configuration items. The object structure is
               documented below.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] name: Specifies the request or response header.
        :param pulumi.Input[str] service_area: The area covered by the acceleration service. Valid values are
               `mainland_china`, `outside_mainland_china`, and `global`. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the domain.
        """
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "type", type)
        if cache_settings is not None:
            pulumi.set(__self__, "cache_settings", cache_settings)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_area is not None:
            pulumi.set(__self__, "service_area", service_area)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]:
        """
        An array of one or more objects specifies the domain name of the origin server.
        The sources object structure is documented below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the operation type for caching URL parameters. Posiible values are:
        **full_url**: cache all parameters
        **ignore_url_params**: ignore all parameters
        **del_args**: ignore specific URL parameters
        **reserve_args**: reserve specified URL parameters
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cacheSettings")
    def cache_settings(self) -> Optional[pulumi.Input['DomainCacheSettingsArgs']]:
        """
        Specifies the cache configuration. The object structure
        is documented below.
        """
        return pulumi.get(self, "cache_settings")

    @cache_settings.setter
    def cache_settings(self, value: Optional[pulumi.Input['DomainCacheSettingsArgs']]):
        pulumi.set(self, "cache_settings", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input['DomainConfigsArgs']]:
        """
        Specifies the domain configuration items. The object structure is
        documented below.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input['DomainConfigsArgs']]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request or response header.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceArea")
    def service_area(self) -> Optional[pulumi.Input[str]]:
        """
        The area covered by the acceleration service. Valid values are
        `mainland_china`, `outside_mainland_china`, and `global`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "service_area")

    @service_area.setter
    def service_area(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_area", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the domain.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 cache_settings: Optional[pulumi.Input['DomainCacheSettingsArgs']] = None,
                 cname: Optional[pulumi.Input[str]] = None,
                 configs: Optional[pulumi.Input['DomainConfigsArgs']] = None,
                 domain_status: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_area: Optional[pulumi.Input[str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input['DomainCacheSettingsArgs'] cache_settings: Specifies the cache configuration. The object structure
               is documented below.
        :param pulumi.Input[str] cname: The CNAME of the acceleration domain name.
        :param pulumi.Input['DomainConfigsArgs'] configs: Specifies the domain configuration items. The object structure is
               documented below.
        :param pulumi.Input[str] domain_status: The status of the acceleration domain name. The available values are
               'online', 'offline', 'configuring', 'configure_failed', 'checking', 'check_failed' and 'deleting.'
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] name: Specifies the request or response header.
        :param pulumi.Input[str] service_area: The area covered by the acceleration service. Valid values are
               `mainland_china`, `outside_mainland_china`, and `global`. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]] sources: An array of one or more objects specifies the domain name of the origin server.
               The sources object structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the domain.
        :param pulumi.Input[str] type: Specifies the operation type for caching URL parameters. Posiible values are:
               **full_url**: cache all parameters
               **ignore_url_params**: ignore all parameters
               **del_args**: ignore specific URL parameters
               **reserve_args**: reserve specified URL parameters
        """
        if cache_settings is not None:
            pulumi.set(__self__, "cache_settings", cache_settings)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if domain_status is not None:
            pulumi.set(__self__, "domain_status", domain_status)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_area is not None:
            pulumi.set(__self__, "service_area", service_area)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cacheSettings")
    def cache_settings(self) -> Optional[pulumi.Input['DomainCacheSettingsArgs']]:
        """
        Specifies the cache configuration. The object structure
        is documented below.
        """
        return pulumi.get(self, "cache_settings")

    @cache_settings.setter
    def cache_settings(self, value: Optional[pulumi.Input['DomainCacheSettingsArgs']]):
        pulumi.set(self, "cache_settings", value)

    @property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[str]]:
        """
        The CNAME of the acceleration domain name.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input['DomainConfigsArgs']]:
        """
        Specifies the domain configuration items. The object structure is
        documented below.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input['DomainConfigsArgs']]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter(name="domainStatus")
    def domain_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the acceleration domain name. The available values are
        'online', 'offline', 'configuring', 'configure_failed', 'checking', 'check_failed' and 'deleting.'
        """
        return pulumi.get(self, "domain_status")

    @domain_status.setter
    def domain_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_status", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request or response header.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceArea")
    def service_area(self) -> Optional[pulumi.Input[str]]:
        """
        The area covered by the acceleration service. Valid values are
        `mainland_china`, `outside_mainland_china`, and `global`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "service_area")

    @service_area.setter
    def service_area(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_area", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]]:
        """
        An array of one or more objects specifies the domain name of the origin server.
        The sources object structure is documented below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the domain.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation type for caching URL parameters. Posiible values are:
        **full_url**: cache all parameters
        **ignore_url_params**: ignore all parameters
        **del_args**: ignore specific URL parameters
        **reserve_args**: reserve specified URL parameters
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_settings: Optional[pulumi.Input[pulumi.InputType['DomainCacheSettingsArgs']]] = None,
                 configs: Optional[pulumi.Input[pulumi.InputType['DomainConfigsArgs']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_area: Optional[pulumi.Input[str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainSourceArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        CDN domain management.

        ## Example Usage
        ### Create a cdn domain

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        domain_name = config.require_object("domainName")
        origin_server = config.require_object("originServer")
        domain1 = huaweicloud.cdn.Domain("domain1",
            type="web",
            sources=[huaweicloud.cdn.DomainSourceArgs(
                origin=origin_server,
                origin_type="ipaddr",
                active=1,
            )],
            tags={
                "key": "val",
                "foo": "bar",
            })
        ```
        ### Create a cdn domain with cache rules

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        domain_name = config.require_object("domainName")
        origin_server = config.require_object("originServer")
        domain1 = huaweicloud.cdn.Domain("domain1",
            type="web",
            sources=[huaweicloud.cdn.DomainSourceArgs(
                origin=origin_server,
                origin_type="ipaddr",
                active=1,
            )],
            cache_settings=huaweicloud.cdn.DomainCacheSettingsArgs(
                rules=[huaweicloud.cdn.DomainCacheSettingsRuleArgs(
                    rule_type=0,
                    ttl=180,
                    ttl_type=4,
                    priority=2,
                )],
            ))
        ```
        ### Create a cdn domain with configs

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        domain_name = config.require_object("domainName")
        origin_server = config.require_object("originServer")
        domain1 = huaweicloud.cdn.Domain("domain1",
            type="web",
            sources=[huaweicloud.cdn.DomainSourceArgs(
                origin=origin_server,
                origin_type="ipaddr",
                active=1,
            )],
            configs=huaweicloud.cdn.DomainConfigsArgs(
                origin_protocol="http",
                https_settings=huaweicloud.cdn.DomainConfigsHttpsSettingsArgs(
                    certificate_name="terraform-test",
                    certificate_body=(lambda path: open(path).read())("your_directory/chain.cer"),
                    http2_enabled=True,
                    https_enabled=True,
                    private_key=(lambda path: open(path).read())("your_directory/server_private.key"),
                ),
                cache_url_parameter_filter=huaweicloud.cdn.DomainConfigsCacheUrlParameterFilterArgs(
                    type="ignore_url_params",
                ),
                retrieval_request_headers=[huaweicloud.cdn.DomainConfigsRetrievalRequestHeaderArgs(
                    name="test-name",
                    value="test-val",
                    action="set",
                )],
                http_response_headers=[huaweicloud.cdn.DomainConfigsHttpResponseHeaderArgs(
                    name="test-name",
                    value="test-val",
                    action="set",
                )],
                url_signing=huaweicloud.cdn.DomainConfigsUrlSigningArgs(
                    enabled=False,
                ),
                compress=huaweicloud.cdn.DomainConfigsCompressArgs(
                    enabled=False,
                ),
                force_redirect=huaweicloud.cdn.DomainConfigsForceRedirectArgs(
                    enabled=True,
                    type="http",
                ),
            ))
        ```

        ## Import

        Domains can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cdn/domain:Domain domain_1 fe2462fac09a4a42a76ecc4a1ef542f1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DomainCacheSettingsArgs']] cache_settings: Specifies the cache configuration. The object structure
               is documented below.
        :param pulumi.Input[pulumi.InputType['DomainConfigsArgs']] configs: Specifies the domain configuration items. The object structure is
               documented below.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] name: Specifies the request or response header.
        :param pulumi.Input[str] service_area: The area covered by the acceleration service. Valid values are
               `mainland_china`, `outside_mainland_china`, and `global`. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainSourceArgs']]]] sources: An array of one or more objects specifies the domain name of the origin server.
               The sources object structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the domain.
        :param pulumi.Input[str] type: Specifies the operation type for caching URL parameters. Posiible values are:
               **full_url**: cache all parameters
               **ignore_url_params**: ignore all parameters
               **del_args**: ignore specific URL parameters
               **reserve_args**: reserve specified URL parameters
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        CDN domain management.

        ## Example Usage
        ### Create a cdn domain

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        domain_name = config.require_object("domainName")
        origin_server = config.require_object("originServer")
        domain1 = huaweicloud.cdn.Domain("domain1",
            type="web",
            sources=[huaweicloud.cdn.DomainSourceArgs(
                origin=origin_server,
                origin_type="ipaddr",
                active=1,
            )],
            tags={
                "key": "val",
                "foo": "bar",
            })
        ```
        ### Create a cdn domain with cache rules

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        domain_name = config.require_object("domainName")
        origin_server = config.require_object("originServer")
        domain1 = huaweicloud.cdn.Domain("domain1",
            type="web",
            sources=[huaweicloud.cdn.DomainSourceArgs(
                origin=origin_server,
                origin_type="ipaddr",
                active=1,
            )],
            cache_settings=huaweicloud.cdn.DomainCacheSettingsArgs(
                rules=[huaweicloud.cdn.DomainCacheSettingsRuleArgs(
                    rule_type=0,
                    ttl=180,
                    ttl_type=4,
                    priority=2,
                )],
            ))
        ```
        ### Create a cdn domain with configs

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        domain_name = config.require_object("domainName")
        origin_server = config.require_object("originServer")
        domain1 = huaweicloud.cdn.Domain("domain1",
            type="web",
            sources=[huaweicloud.cdn.DomainSourceArgs(
                origin=origin_server,
                origin_type="ipaddr",
                active=1,
            )],
            configs=huaweicloud.cdn.DomainConfigsArgs(
                origin_protocol="http",
                https_settings=huaweicloud.cdn.DomainConfigsHttpsSettingsArgs(
                    certificate_name="terraform-test",
                    certificate_body=(lambda path: open(path).read())("your_directory/chain.cer"),
                    http2_enabled=True,
                    https_enabled=True,
                    private_key=(lambda path: open(path).read())("your_directory/server_private.key"),
                ),
                cache_url_parameter_filter=huaweicloud.cdn.DomainConfigsCacheUrlParameterFilterArgs(
                    type="ignore_url_params",
                ),
                retrieval_request_headers=[huaweicloud.cdn.DomainConfigsRetrievalRequestHeaderArgs(
                    name="test-name",
                    value="test-val",
                    action="set",
                )],
                http_response_headers=[huaweicloud.cdn.DomainConfigsHttpResponseHeaderArgs(
                    name="test-name",
                    value="test-val",
                    action="set",
                )],
                url_signing=huaweicloud.cdn.DomainConfigsUrlSigningArgs(
                    enabled=False,
                ),
                compress=huaweicloud.cdn.DomainConfigsCompressArgs(
                    enabled=False,
                ),
                force_redirect=huaweicloud.cdn.DomainConfigsForceRedirectArgs(
                    enabled=True,
                    type="http",
                ),
            ))
        ```

        ## Import

        Domains can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cdn/domain:Domain domain_1 fe2462fac09a4a42a76ecc4a1ef542f1
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_settings: Optional[pulumi.Input[pulumi.InputType['DomainCacheSettingsArgs']]] = None,
                 configs: Optional[pulumi.Input[pulumi.InputType['DomainConfigsArgs']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_area: Optional[pulumi.Input[str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainSourceArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["cache_settings"] = cache_settings
            __props__.__dict__["configs"] = configs
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["service_area"] = service_area
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["cname"] = None
            __props__.__dict__["domain_status"] = None
        super(Domain, __self__).__init__(
            'huaweicloud:Cdn/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_settings: Optional[pulumi.Input[pulumi.InputType['DomainCacheSettingsArgs']]] = None,
            cname: Optional[pulumi.Input[str]] = None,
            configs: Optional[pulumi.Input[pulumi.InputType['DomainConfigsArgs']]] = None,
            domain_status: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service_area: Optional[pulumi.Input[str]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainSourceArgs']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DomainCacheSettingsArgs']] cache_settings: Specifies the cache configuration. The object structure
               is documented below.
        :param pulumi.Input[str] cname: The CNAME of the acceleration domain name.
        :param pulumi.Input[pulumi.InputType['DomainConfigsArgs']] configs: Specifies the domain configuration items. The object structure is
               documented below.
        :param pulumi.Input[str] domain_status: The status of the acceleration domain name. The available values are
               'online', 'offline', 'configuring', 'configure_failed', 'checking', 'check_failed' and 'deleting.'
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] name: Specifies the request or response header.
        :param pulumi.Input[str] service_area: The area covered by the acceleration service. Valid values are
               `mainland_china`, `outside_mainland_china`, and `global`. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainSourceArgs']]]] sources: An array of one or more objects specifies the domain name of the origin server.
               The sources object structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the domain.
        :param pulumi.Input[str] type: Specifies the operation type for caching URL parameters. Posiible values are:
               **full_url**: cache all parameters
               **ignore_url_params**: ignore all parameters
               **del_args**: ignore specific URL parameters
               **reserve_args**: reserve specified URL parameters
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["cache_settings"] = cache_settings
        __props__.__dict__["cname"] = cname
        __props__.__dict__["configs"] = configs
        __props__.__dict__["domain_status"] = domain_status
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["service_area"] = service_area
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cacheSettings")
    def cache_settings(self) -> pulumi.Output['outputs.DomainCacheSettings']:
        """
        Specifies the cache configuration. The object structure
        is documented below.
        """
        return pulumi.get(self, "cache_settings")

    @property
    @pulumi.getter
    def cname(self) -> pulumi.Output[str]:
        """
        The CNAME of the acceleration domain name.
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter
    def configs(self) -> pulumi.Output['outputs.DomainConfigs']:
        """
        Specifies the domain configuration items. The object structure is
        documented below.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter(name="domainStatus")
    def domain_status(self) -> pulumi.Output[str]:
        """
        The status of the acceleration domain name. The available values are
        'online', 'offline', 'configuring', 'configure_failed', 'checking', 'check_failed' and 'deleting.'
        """
        return pulumi.get(self, "domain_status")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[Optional[str]]:
        """
        The enterprise project id. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the request or response header.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceArea")
    def service_area(self) -> pulumi.Output[str]:
        """
        The area covered by the acceleration service. Valid values are
        `mainland_china`, `outside_mainland_china`, and `global`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "service_area")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence['outputs.DomainSource']]:
        """
        An array of one or more objects specifies the domain name of the origin server.
        The sources object structure is documented below.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the domain.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the operation type for caching URL parameters. Posiible values are:
        **full_url**: cache all parameters
        **ignore_url_params**: ignore all parameters
        **del_args**: ignore specific URL parameters
        **reserve_args**: reserve specified URL parameters
        """
        return pulumi.get(self, "type")

