# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DomainCacheSettingsArgs',
    'DomainCacheSettingsRuleArgs',
    'DomainConfigsArgs',
    'DomainConfigsCacheUrlParameterFilterArgs',
    'DomainConfigsCompressArgs',
    'DomainConfigsForceRedirectArgs',
    'DomainConfigsHttpResponseHeaderArgs',
    'DomainConfigsHttpsSettingsArgs',
    'DomainConfigsRetrievalRequestHeaderArgs',
    'DomainConfigsUrlSigningArgs',
    'DomainSourceArgs',
]

@pulumi.input_type
class DomainCacheSettingsArgs:
    def __init__(__self__, *,
                 follow_origin: Optional[pulumi.Input[bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['DomainCacheSettingsRuleArgs']]]] = None):
        """
        :param pulumi.Input[bool] follow_origin: Specifies whether to enable origin cache control.
        :param pulumi.Input[Sequence[pulumi.Input['DomainCacheSettingsRuleArgs']]] rules: Specifies the cache rules, which overwrite the previous rule configurations.
               Blank rules are reset to default rules. The object structure is documented below.
        """
        if follow_origin is not None:
            pulumi.set(__self__, "follow_origin", follow_origin)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="followOrigin")
    def follow_origin(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable origin cache control.
        """
        return pulumi.get(self, "follow_origin")

    @follow_origin.setter
    def follow_origin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "follow_origin", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainCacheSettingsRuleArgs']]]]:
        """
        Specifies the cache rules, which overwrite the previous rule configurations.
        Blank rules are reset to default rules. The object structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainCacheSettingsRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class DomainCacheSettingsRuleArgs:
    def __init__(__self__, *,
                 rule_type: pulumi.Input[int],
                 content: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 ttl_type: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] rule_type: Specifies the rule type. Possible value are:
               **0**: All types of files are matched. It is the default value.
               **1**: Files are matched based on their suffixes.
               **2**: Files are matched based on their directories.
               **3**: Files are matched based on their full paths.
        :param pulumi.Input[str] content: Specifies the content that matches `rule_type`. If `rule_type` is set to **0**,
               this parameter is empty. If `rule_type` is set to **1**, the value of this parameter is a list of file name
               extensions. A file name extension starts with a period (.). File name extensions are separated by semicolons (;),
               for example, .jpg;.zip;.exe. If `rule_type` is set to **2**, the value of this parameter is a list of directories.
               A directory starts with a slash (/). Directories are separated by semicolons (;), for example,
               /test/folder01;/test/folder02.
        :param pulumi.Input[int] priority: Specifies the priority weight of this rule. The default value is 1.
               A larger value indicates a higher priority. The value ranges from 1 to 100. The weight values must be unique.
        :param pulumi.Input[int] ttl: Specifies the cache age. The maximum cache age is 365 days.
        :param pulumi.Input[int] ttl_type: Specifies the unit of the cache age. Possible values: **1** (second), **2** (minute),
               **3** (hour), and **4** (day).
        """
        pulumi.set(__self__, "rule_type", rule_type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if ttl_type is not None:
            pulumi.set(__self__, "ttl_type", ttl_type)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[int]:
        """
        Specifies the rule type. Possible value are:
        **0**: All types of files are matched. It is the default value.
        **1**: Files are matched based on their suffixes.
        **2**: Files are matched based on their directories.
        **3**: Files are matched based on their full paths.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the content that matches `rule_type`. If `rule_type` is set to **0**,
        this parameter is empty. If `rule_type` is set to **1**, the value of this parameter is a list of file name
        extensions. A file name extension starts with a period (.). File name extensions are separated by semicolons (;),
        for example, .jpg;.zip;.exe. If `rule_type` is set to **2**, the value of this parameter is a list of directories.
        A directory starts with a slash (/). Directories are separated by semicolons (;), for example,
        /test/folder01;/test/folder02.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the priority weight of this rule. The default value is 1.
        A larger value indicates a higher priority. The value ranges from 1 to 100. The weight values must be unique.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the cache age. The maximum cache age is 365 days.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="ttlType")
    def ttl_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the unit of the cache age. Possible values: **1** (second), **2** (minute),
        **3** (hour), and **4** (day).
        """
        return pulumi.get(self, "ttl_type")

    @ttl_type.setter
    def ttl_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl_type", value)


@pulumi.input_type
class DomainConfigsArgs:
    def __init__(__self__, *,
                 cache_url_parameter_filter: Optional[pulumi.Input['DomainConfigsCacheUrlParameterFilterArgs']] = None,
                 compress: Optional[pulumi.Input['DomainConfigsCompressArgs']] = None,
                 force_redirect: Optional[pulumi.Input['DomainConfigsForceRedirectArgs']] = None,
                 http_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigsHttpResponseHeaderArgs']]]] = None,
                 https_settings: Optional[pulumi.Input['DomainConfigsHttpsSettingsArgs']] = None,
                 ipv6_enable: Optional[pulumi.Input[bool]] = None,
                 origin_protocol: Optional[pulumi.Input[str]] = None,
                 range_based_retrieval_enabled: Optional[pulumi.Input[bool]] = None,
                 retrieval_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigsRetrievalRequestHeaderArgs']]]] = None,
                 url_signing: Optional[pulumi.Input['DomainConfigsUrlSigningArgs']] = None):
        """
        :param pulumi.Input['DomainConfigsCacheUrlParameterFilterArgs'] cache_url_parameter_filter: Specifies the settings for caching URL parameters.
               The object structure is documented below.
        :param pulumi.Input['DomainConfigsCompressArgs'] compress: Specifies the smart compression. The object structure
               is documented below.
        :param pulumi.Input['DomainConfigsForceRedirectArgs'] force_redirect: Specifies the force redirect.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DomainConfigsHttpResponseHeaderArgs']]] http_response_headers: Specifies the HTTP response header settings.
               The object structure is documented below.
        :param pulumi.Input['DomainConfigsHttpsSettingsArgs'] https_settings: Specifies the certificate configuration. The object
               structure is documented below.
        :param pulumi.Input[bool] ipv6_enable: Specifies whether to enable IPv6.
        :param pulumi.Input[str] origin_protocol: Specifies the content retrieval protocol. Possible values:
               + **follow**: same as user requests.
               + **http**: HTTP, which is the default value.
               + **https**: HTTPS.
        :param pulumi.Input[bool] range_based_retrieval_enabled: Specifies whether to enable range-based retrieval.
        :param pulumi.Input[Sequence[pulumi.Input['DomainConfigsRetrievalRequestHeaderArgs']]] retrieval_request_headers: Specifies the retrieval request header settings.
               The object structure is documented below.
        :param pulumi.Input['DomainConfigsUrlSigningArgs'] url_signing: Specifies the URL signing.
               The object structure is documented below.
        """
        if cache_url_parameter_filter is not None:
            pulumi.set(__self__, "cache_url_parameter_filter", cache_url_parameter_filter)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if force_redirect is not None:
            pulumi.set(__self__, "force_redirect", force_redirect)
        if http_response_headers is not None:
            pulumi.set(__self__, "http_response_headers", http_response_headers)
        if https_settings is not None:
            pulumi.set(__self__, "https_settings", https_settings)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if origin_protocol is not None:
            pulumi.set(__self__, "origin_protocol", origin_protocol)
        if range_based_retrieval_enabled is not None:
            pulumi.set(__self__, "range_based_retrieval_enabled", range_based_retrieval_enabled)
        if retrieval_request_headers is not None:
            pulumi.set(__self__, "retrieval_request_headers", retrieval_request_headers)
        if url_signing is not None:
            pulumi.set(__self__, "url_signing", url_signing)

    @property
    @pulumi.getter(name="cacheUrlParameterFilter")
    def cache_url_parameter_filter(self) -> Optional[pulumi.Input['DomainConfigsCacheUrlParameterFilterArgs']]:
        """
        Specifies the settings for caching URL parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "cache_url_parameter_filter")

    @cache_url_parameter_filter.setter
    def cache_url_parameter_filter(self, value: Optional[pulumi.Input['DomainConfigsCacheUrlParameterFilterArgs']]):
        pulumi.set(self, "cache_url_parameter_filter", value)

    @property
    @pulumi.getter
    def compress(self) -> Optional[pulumi.Input['DomainConfigsCompressArgs']]:
        """
        Specifies the smart compression. The object structure
        is documented below.
        """
        return pulumi.get(self, "compress")

    @compress.setter
    def compress(self, value: Optional[pulumi.Input['DomainConfigsCompressArgs']]):
        pulumi.set(self, "compress", value)

    @property
    @pulumi.getter(name="forceRedirect")
    def force_redirect(self) -> Optional[pulumi.Input['DomainConfigsForceRedirectArgs']]:
        """
        Specifies the force redirect.
        The object structure is documented below.
        """
        return pulumi.get(self, "force_redirect")

    @force_redirect.setter
    def force_redirect(self, value: Optional[pulumi.Input['DomainConfigsForceRedirectArgs']]):
        pulumi.set(self, "force_redirect", value)

    @property
    @pulumi.getter(name="httpResponseHeaders")
    def http_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigsHttpResponseHeaderArgs']]]]:
        """
        Specifies the HTTP response header settings.
        The object structure is documented below.
        """
        return pulumi.get(self, "http_response_headers")

    @http_response_headers.setter
    def http_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigsHttpResponseHeaderArgs']]]]):
        pulumi.set(self, "http_response_headers", value)

    @property
    @pulumi.getter(name="httpsSettings")
    def https_settings(self) -> Optional[pulumi.Input['DomainConfigsHttpsSettingsArgs']]:
        """
        Specifies the certificate configuration. The object
        structure is documented below.
        """
        return pulumi.get(self, "https_settings")

    @https_settings.setter
    def https_settings(self, value: Optional[pulumi.Input['DomainConfigsHttpsSettingsArgs']]):
        pulumi.set(self, "https_settings", value)

    @property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable IPv6.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @property
    @pulumi.getter(name="originProtocol")
    def origin_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the content retrieval protocol. Possible values:
        + **follow**: same as user requests.
        + **http**: HTTP, which is the default value.
        + **https**: HTTPS.
        """
        return pulumi.get(self, "origin_protocol")

    @origin_protocol.setter
    def origin_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_protocol", value)

    @property
    @pulumi.getter(name="rangeBasedRetrievalEnabled")
    def range_based_retrieval_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable range-based retrieval.
        """
        return pulumi.get(self, "range_based_retrieval_enabled")

    @range_based_retrieval_enabled.setter
    def range_based_retrieval_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "range_based_retrieval_enabled", value)

    @property
    @pulumi.getter(name="retrievalRequestHeaders")
    def retrieval_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigsRetrievalRequestHeaderArgs']]]]:
        """
        Specifies the retrieval request header settings.
        The object structure is documented below.
        """
        return pulumi.get(self, "retrieval_request_headers")

    @retrieval_request_headers.setter
    def retrieval_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigsRetrievalRequestHeaderArgs']]]]):
        pulumi.set(self, "retrieval_request_headers", value)

    @property
    @pulumi.getter(name="urlSigning")
    def url_signing(self) -> Optional[pulumi.Input['DomainConfigsUrlSigningArgs']]:
        """
        Specifies the URL signing.
        The object structure is documented below.
        """
        return pulumi.get(self, "url_signing")

    @url_signing.setter
    def url_signing(self, value: Optional[pulumi.Input['DomainConfigsUrlSigningArgs']]):
        pulumi.set(self, "url_signing", value)


@pulumi.input_type
class DomainConfigsCacheUrlParameterFilterArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Specifies the operation type for caching URL parameters. Posiible values are:
               **full_url**: cache all parameters
               **ignore_url_params**: ignore all parameters
               **del_args**: ignore specific URL parameters
               **reserve_args**: reserve specified URL parameters
        :param pulumi.Input[str] value: Specifies the parameter values. Multiple values are separated by semicolons (;).
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation type for caching URL parameters. Posiible values are:
        **full_url**: cache all parameters
        **ignore_url_params**: ignore all parameters
        **del_args**: ignore specific URL parameters
        **reserve_args**: reserve specified URL parameters
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameter values. Multiple values are separated by semicolons (;).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DomainConfigsCompressArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies the whether to enable force redirect or smart compression.
        :param pulumi.Input[str] type: Specifies the operation type for caching URL parameters. Posiible values are:
               **full_url**: cache all parameters
               **ignore_url_params**: ignore all parameters
               **del_args**: ignore specific URL parameters
               **reserve_args**: reserve specified URL parameters
        """
        pulumi.set(__self__, "enabled", enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies the whether to enable force redirect or smart compression.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation type for caching URL parameters. Posiible values are:
        **full_url**: cache all parameters
        **ignore_url_params**: ignore all parameters
        **del_args**: ignore specific URL parameters
        **reserve_args**: reserve specified URL parameters
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DomainConfigsForceRedirectArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies the whether to enable force redirect or smart compression.
        :param pulumi.Input[str] type: Specifies the operation type for caching URL parameters. Posiible values are:
               **full_url**: cache all parameters
               **ignore_url_params**: ignore all parameters
               **del_args**: ignore specific URL parameters
               **reserve_args**: reserve specified URL parameters
        """
        pulumi.set(__self__, "enabled", enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies the whether to enable force redirect or smart compression.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation type for caching URL parameters. Posiible values are:
        **full_url**: cache all parameters
        **ignore_url_params**: ignore all parameters
        **del_args**: ignore specific URL parameters
        **reserve_args**: reserve specified URL parameters
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DomainConfigsHttpResponseHeaderArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Specifies the operation type of request or response
        :param pulumi.Input[str] name: Specifies the request or response header.
        :param pulumi.Input[str] value: Specifies the parameter values. Multiple values are separated by semicolons (;).
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Specifies the operation type of request or response
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the request or response header.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameter values. Multiple values are separated by semicolons (;).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DomainConfigsHttpsSettingsArgs:
    def __init__(__self__, *,
                 certificate_body: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 certificate_source: Optional[pulumi.Input[int]] = None,
                 http2_enabled: Optional[pulumi.Input[bool]] = None,
                 http2_status: Optional[pulumi.Input[str]] = None,
                 https_enabled: Optional[pulumi.Input[bool]] = None,
                 https_status: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 tls_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] certificate_body: Specifies the content of the certificate used by the HTTPS protocol.
               This parameter is mandatory when a certificate is configured. The value is in PEM format.
        :param pulumi.Input[str] certificate_name: Specifies the certificate name. The value contains 3 to 32 characters.
               This parameter is mandatory when a certificate is configured.
        :param pulumi.Input[int] certificate_source: Specifies the certificate type. Possible values are:
               + **1**: Huawei-managed certificate.
               + **0**: your own certificate.
        :param pulumi.Input[bool] http2_enabled: Specifies whether HTTP/2 is used.
        :param pulumi.Input[bool] https_enabled: Specifies whether to enable HTTPS.
        :param pulumi.Input[str] private_key: Specifies the private key used by the HTTPS protocol. This parameter is mandatory
               when a certificate is configured. The value is in PEM format.
        :param pulumi.Input[str] tls_version: Specifies the transport Layer Security (TLS). Currently, **TLSv1.0**,
               **TLSv1.1**, **TLSv1.2**, and **TLSv1.3** are supported. By default, all versions are enabled. You can enable
               a single version or consecutive versions. To enable multiple versions, use commas (,) to separate versions,
               for example, **TLSv1.1,TLSv1.2**.
        """
        if certificate_body is not None:
            pulumi.set(__self__, "certificate_body", certificate_body)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if http2_status is not None:
            pulumi.set(__self__, "http2_status", http2_status)
        if https_enabled is not None:
            pulumi.set(__self__, "https_enabled", https_enabled)
        if https_status is not None:
            pulumi.set(__self__, "https_status", https_status)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if tls_version is not None:
            pulumi.set(__self__, "tls_version", tls_version)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the content of the certificate used by the HTTPS protocol.
        This parameter is mandatory when a certificate is configured. The value is in PEM format.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the certificate name. The value contains 3 to 32 characters.
        This parameter is mandatory when a certificate is configured.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the certificate type. Possible values are:
        + **1**: Huawei-managed certificate.
        + **0**: your own certificate.
        """
        return pulumi.get(self, "certificate_source")

    @certificate_source.setter
    def certificate_source(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "certificate_source", value)

    @property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether HTTP/2 is used.
        """
        return pulumi.get(self, "http2_enabled")

    @http2_enabled.setter
    def http2_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http2_enabled", value)

    @property
    @pulumi.getter(name="http2Status")
    def http2_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http2_status")

    @http2_status.setter
    def http2_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http2_status", value)

    @property
    @pulumi.getter(name="httpsEnabled")
    def https_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable HTTPS.
        """
        return pulumi.get(self, "https_enabled")

    @https_enabled.setter
    def https_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_enabled", value)

    @property
    @pulumi.getter(name="httpsStatus")
    def https_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "https_status")

    @https_status.setter
    def https_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_status", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the private key used by the HTTPS protocol. This parameter is mandatory
        when a certificate is configured. The value is in PEM format.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="tlsVersion")
    def tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the transport Layer Security (TLS). Currently, **TLSv1.0**,
        **TLSv1.1**, **TLSv1.2**, and **TLSv1.3** are supported. By default, all versions are enabled. You can enable
        a single version or consecutive versions. To enable multiple versions, use commas (,) to separate versions,
        for example, **TLSv1.1,TLSv1.2**.
        """
        return pulumi.get(self, "tls_version")

    @tls_version.setter
    def tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_version", value)


@pulumi.input_type
class DomainConfigsRetrievalRequestHeaderArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Specifies the operation type of request or response
        :param pulumi.Input[str] name: Specifies the request or response header.
        :param pulumi.Input[str] value: Specifies the parameter values. Multiple values are separated by semicolons (;).
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Specifies the operation type of request or response
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the request or response header.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameter values. Multiple values are separated by semicolons (;).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DomainConfigsUrlSigningArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 expire_time: Optional[pulumi.Input[int]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies the whether to enable force redirect or smart compression.
        :param pulumi.Input[int] expire_time: Specifies the expiration time. The value ranges from **0** to **31536000**,
               in seconds.
        :param pulumi.Input[str] key: Specifies the authentication key contains 6 to 32 characters, including letters and digits.
        :param pulumi.Input[str] time_format: Specifies the time format. Possible values are:
               **dec**: Decimal, can be used in Method A, Method B and Method C2.
               **hex**: Hexadecimal, can be used in Method C1 and Method C2.
        :param pulumi.Input[str] type: Specifies the operation type for caching URL parameters. Posiible values are:
               **full_url**: cache all parameters
               **ignore_url_params**: ignore all parameters
               **del_args**: ignore specific URL parameters
               **reserve_args**: reserve specified URL parameters
        """
        pulumi.set(__self__, "enabled", enabled)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies the whether to enable force redirect or smart compression.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the expiration time. The value ranges from **0** to **31536000**,
        in seconds.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authentication key contains 6 to 32 characters, including letters and digits.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time format. Possible values are:
        **dec**: Decimal, can be used in Method A, Method B and Method C2.
        **hex**: Hexadecimal, can be used in Method C1 and Method C2.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation type for caching URL parameters. Posiible values are:
        **full_url**: cache all parameters
        **ignore_url_params**: ignore all parameters
        **del_args**: ignore specific URL parameters
        **reserve_args**: reserve specified URL parameters
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DomainSourceArgs:
    def __init__(__self__, *,
                 origin: pulumi.Input[str],
                 origin_type: pulumi.Input[str],
                 active: Optional[pulumi.Input[int]] = None,
                 http_port: Optional[pulumi.Input[int]] = None,
                 https_port: Optional[pulumi.Input[int]] = None,
                 obs_web_hosting_enabled: Optional[pulumi.Input[bool]] = None,
                 retrieval_host: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] origin: The domain name or IP address of the origin server.
        :param pulumi.Input[str] origin_type: The origin server type. The valid values are 'ipaddr', 'domain', and 'obs_bucket'.
        :param pulumi.Input[int] active: Whether an origin server is active or standby (1: active; 0: standby). The default value is
               1.
        :param pulumi.Input[int] http_port: Specifies the HTTP port. Default value: **80**.
        :param pulumi.Input[int] https_port: Specifies the HTTPS port. Default value: **443**.
        :param pulumi.Input[bool] obs_web_hosting_enabled: Whether to enable static website hosting for the OBS bucket.
               This parameter is mandatory when the `origin_type` is **obs_bucket**.
        :param pulumi.Input[str] retrieval_host: Specifies the retrieval host. The default value is the acceleration domain name.
        """
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "origin_type", origin_type)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if obs_web_hosting_enabled is not None:
            pulumi.set(__self__, "obs_web_hosting_enabled", obs_web_hosting_enabled)
        if retrieval_host is not None:
            pulumi.set(__self__, "retrieval_host", retrieval_host)

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Input[str]:
        """
        The domain name or IP address of the origin server.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="originType")
    def origin_type(self) -> pulumi.Input[str]:
        """
        The origin server type. The valid values are 'ipaddr', 'domain', and 'obs_bucket'.
        """
        return pulumi.get(self, "origin_type")

    @origin_type.setter
    def origin_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_type", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[int]]:
        """
        Whether an origin server is active or standby (1: active; 0: standby). The default value is
        1.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the HTTP port. Default value: **80**.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the HTTPS port. Default value: **443**.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "https_port", value)

    @property
    @pulumi.getter(name="obsWebHostingEnabled")
    def obs_web_hosting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable static website hosting for the OBS bucket.
        This parameter is mandatory when the `origin_type` is **obs_bucket**.
        """
        return pulumi.get(self, "obs_web_hosting_enabled")

    @obs_web_hosting_enabled.setter
    def obs_web_hosting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "obs_web_hosting_enabled", value)

    @property
    @pulumi.getter(name="retrievalHost")
    def retrieval_host(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the retrieval host. The default value is the acceleration domain name.
        """
        return pulumi.get(self, "retrieval_host")

    @retrieval_host.setter
    def retrieval_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retrieval_host", value)


