# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 destination_connector: pulumi.Input[str],
                 destination_job_config: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 destination_link_name: pulumi.Input[str],
                 job_type: pulumi.Input[str],
                 source_connector: pulumi.Input[str],
                 source_job_config: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 source_link_name: pulumi.Input[str],
                 config: Optional[pulumi.Input['JobConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of CDM cluster which this job run in.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] destination_connector: Specifies the connector name of destination link.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] destination_job_config: Specifies the destination job configuration parameters. Each type of the
               data source to be connected has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] destination_link_name: Specifies the destination link name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] job_type: Specifies type of job. Changing this parameter will create a new resource.
               The options are as follows:
        :param pulumi.Input[str] source_connector: Specifies the connector name of source link.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_job_config: Specifies the source job configuration parameters. Each type of the data source
               to be connected has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] source_link_name: Specifies the source link name.
               Changing this parameter will create a new resource.
        :param pulumi.Input['JobConfigArgs'] config: Specifies the job configuration. Structure is documented below.
        :param pulumi.Input[str] name: Specifies job name, which can contains of 1 to 240 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "destination_connector", destination_connector)
        pulumi.set(__self__, "destination_job_config", destination_job_config)
        pulumi.set(__self__, "destination_link_name", destination_link_name)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "source_connector", source_connector)
        pulumi.set(__self__, "source_job_config", source_job_config)
        pulumi.set(__self__, "source_link_name", source_link_name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of CDM cluster which this job run in.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="destinationConnector")
    def destination_connector(self) -> pulumi.Input[str]:
        """
        Specifies the connector name of destination link.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_connector")

    @destination_connector.setter
    def destination_connector(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_connector", value)

    @property
    @pulumi.getter(name="destinationJobConfig")
    def destination_job_config(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Specifies the destination job configuration parameters. Each type of the
        data source to be connected has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "destination_job_config")

    @destination_job_config.setter
    def destination_job_config(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "destination_job_config", value)

    @property
    @pulumi.getter(name="destinationLinkName")
    def destination_link_name(self) -> pulumi.Input[str]:
        """
        Specifies the destination link name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_link_name")

    @destination_link_name.setter
    def destination_link_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_link_name", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Specifies type of job. Changing this parameter will create a new resource.
        The options are as follows:
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter(name="sourceConnector")
    def source_connector(self) -> pulumi.Input[str]:
        """
        Specifies the connector name of source link.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_connector")

    @source_connector.setter
    def source_connector(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_connector", value)

    @property
    @pulumi.getter(name="sourceJobConfig")
    def source_job_config(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Specifies the source job configuration parameters. Each type of the data source
        to be connected has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "source_job_config")

    @source_job_config.setter
    def source_job_config(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "source_job_config", value)

    @property
    @pulumi.getter(name="sourceLinkName")
    def source_link_name(self) -> pulumi.Input[str]:
        """
        Specifies the source link name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_link_name")

    @source_link_name.setter
    def source_link_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_link_name", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['JobConfigArgs']]:
        """
        Specifies the job configuration. Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['JobConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job name, which can contains of 1 to 240 characters, starting with a
        letter. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input['JobConfigArgs']] = None,
                 destination_connector: Optional[pulumi.Input[str]] = None,
                 destination_job_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 destination_link_name: Optional[pulumi.Input[str]] = None,
                 job_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_connector: Optional[pulumi.Input[str]] = None,
                 source_job_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_link_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[str] cluster_id: Specifies the ID of CDM cluster which this job run in.
               Changing this parameter will create a new resource.
        :param pulumi.Input['JobConfigArgs'] config: Specifies the job configuration. Structure is documented below.
        :param pulumi.Input[str] destination_connector: Specifies the connector name of destination link.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] destination_job_config: Specifies the destination job configuration parameters. Each type of the
               data source to be connected has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] destination_link_name: Specifies the destination link name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] job_type: Specifies type of job. Changing this parameter will create a new resource.
               The options are as follows:
        :param pulumi.Input[str] name: Specifies job name, which can contains of 1 to 240 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source_connector: Specifies the connector name of source link.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_job_config: Specifies the source job configuration parameters. Each type of the data source
               to be connected has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] source_link_name: Specifies the source link name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: Job status. The options are as follows:
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if destination_connector is not None:
            pulumi.set(__self__, "destination_connector", destination_connector)
        if destination_job_config is not None:
            pulumi.set(__self__, "destination_job_config", destination_job_config)
        if destination_link_name is not None:
            pulumi.set(__self__, "destination_link_name", destination_link_name)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_connector is not None:
            pulumi.set(__self__, "source_connector", source_connector)
        if source_job_config is not None:
            pulumi.set(__self__, "source_job_config", source_job_config)
        if source_link_name is not None:
            pulumi.set(__self__, "source_link_name", source_link_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of CDM cluster which this job run in.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['JobConfigArgs']]:
        """
        Specifies the job configuration. Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['JobConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="destinationConnector")
    def destination_connector(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the connector name of destination link.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_connector")

    @destination_connector.setter
    def destination_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_connector", value)

    @property
    @pulumi.getter(name="destinationJobConfig")
    def destination_job_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the destination job configuration parameters. Each type of the
        data source to be connected has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "destination_job_config")

    @destination_job_config.setter
    def destination_job_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "destination_job_config", value)

    @property
    @pulumi.getter(name="destinationLinkName")
    def destination_link_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the destination link name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_link_name")

    @destination_link_name.setter
    def destination_link_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_link_name", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies type of job. Changing this parameter will create a new resource.
        The options are as follows:
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job name, which can contains of 1 to 240 characters, starting with a
        letter. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sourceConnector")
    def source_connector(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the connector name of source link.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_connector")

    @source_connector.setter
    def source_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_connector", value)

    @property
    @pulumi.getter(name="sourceJobConfig")
    def source_job_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the source job configuration parameters. Each type of the data source
        to be connected has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "source_job_config")

    @source_job_config.setter
    def source_job_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_job_config", value)

    @property
    @pulumi.getter(name="sourceLinkName")
    def source_link_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the source link name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_link_name")

    @source_link_name.setter
    def source_link_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_link_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Job status. The options are as follows:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['JobConfigArgs']]] = None,
                 destination_connector: Optional[pulumi.Input[str]] = None,
                 destination_job_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 destination_link_name: Optional[pulumi.Input[str]] = None,
                 job_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_connector: Optional[pulumi.Input[str]] = None,
                 source_job_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_link_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages CDM job resource within HuaweiCloud.

        ## Example Usage

        ## Import

        Jobs can be imported by `id`. It is composed of the ID of CDM cluster which this job run in and the name of job,

        separated by a slash. For example,

        ```sh
         $ pulumi import huaweicloud:Cdm/job:Job test b11b407c-e604-4e8d-8bc4-92398320b847/jobName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of CDM cluster which this job run in.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['JobConfigArgs']] config: Specifies the job configuration. Structure is documented below.
        :param pulumi.Input[str] destination_connector: Specifies the connector name of destination link.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] destination_job_config: Specifies the destination job configuration parameters. Each type of the
               data source to be connected has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] destination_link_name: Specifies the destination link name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] job_type: Specifies type of job. Changing this parameter will create a new resource.
               The options are as follows:
        :param pulumi.Input[str] name: Specifies job name, which can contains of 1 to 240 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source_connector: Specifies the connector name of source link.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_job_config: Specifies the source job configuration parameters. Each type of the data source
               to be connected has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] source_link_name: Specifies the source link name.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CDM job resource within HuaweiCloud.

        ## Example Usage

        ## Import

        Jobs can be imported by `id`. It is composed of the ID of CDM cluster which this job run in and the name of job,

        separated by a slash. For example,

        ```sh
         $ pulumi import huaweicloud:Cdm/job:Job test b11b407c-e604-4e8d-8bc4-92398320b847/jobName
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['JobConfigArgs']]] = None,
                 destination_connector: Optional[pulumi.Input[str]] = None,
                 destination_job_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 destination_link_name: Optional[pulumi.Input[str]] = None,
                 job_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_connector: Optional[pulumi.Input[str]] = None,
                 source_job_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_link_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["config"] = config
            if destination_connector is None and not opts.urn:
                raise TypeError("Missing required property 'destination_connector'")
            __props__.__dict__["destination_connector"] = destination_connector
            if destination_job_config is None and not opts.urn:
                raise TypeError("Missing required property 'destination_job_config'")
            __props__.__dict__["destination_job_config"] = destination_job_config
            if destination_link_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_link_name'")
            __props__.__dict__["destination_link_name"] = destination_link_name
            if job_type is None and not opts.urn:
                raise TypeError("Missing required property 'job_type'")
            __props__.__dict__["job_type"] = job_type
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if source_connector is None and not opts.urn:
                raise TypeError("Missing required property 'source_connector'")
            __props__.__dict__["source_connector"] = source_connector
            if source_job_config is None and not opts.urn:
                raise TypeError("Missing required property 'source_job_config'")
            __props__.__dict__["source_job_config"] = source_job_config
            if source_link_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_link_name'")
            __props__.__dict__["source_link_name"] = source_link_name
            __props__.__dict__["status"] = None
        super(Job, __self__).__init__(
            'huaweicloud:Cdm/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            config: Optional[pulumi.Input[pulumi.InputType['JobConfigArgs']]] = None,
            destination_connector: Optional[pulumi.Input[str]] = None,
            destination_job_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            destination_link_name: Optional[pulumi.Input[str]] = None,
            job_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            source_connector: Optional[pulumi.Input[str]] = None,
            source_job_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            source_link_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of CDM cluster which this job run in.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['JobConfigArgs']] config: Specifies the job configuration. Structure is documented below.
        :param pulumi.Input[str] destination_connector: Specifies the connector name of destination link.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] destination_job_config: Specifies the destination job configuration parameters. Each type of the
               data source to be connected has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] destination_link_name: Specifies the destination link name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] job_type: Specifies type of job. Changing this parameter will create a new resource.
               The options are as follows:
        :param pulumi.Input[str] name: Specifies job name, which can contains of 1 to 240 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        :param pulumi.Input[str] region: The region in which to create the job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source_connector: Specifies the connector name of source link.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_job_config: Specifies the source job configuration parameters. Each type of the data source
               to be connected has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] source_link_name: Specifies the source link name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: Job status. The options are as follows:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["config"] = config
        __props__.__dict__["destination_connector"] = destination_connector
        __props__.__dict__["destination_job_config"] = destination_job_config
        __props__.__dict__["destination_link_name"] = destination_link_name
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["source_connector"] = source_connector
        __props__.__dict__["source_job_config"] = source_job_config
        __props__.__dict__["source_link_name"] = source_link_name
        __props__.__dict__["status"] = status
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of CDM cluster which this job run in.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.JobConfig']]:
        """
        Specifies the job configuration. Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="destinationConnector")
    def destination_connector(self) -> pulumi.Output[str]:
        """
        Specifies the connector name of destination link.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_connector")

    @property
    @pulumi.getter(name="destinationJobConfig")
    def destination_job_config(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Specifies the destination job configuration parameters. Each type of the
        data source to be connected has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "destination_job_config")

    @property
    @pulumi.getter(name="destinationLinkName")
    def destination_link_name(self) -> pulumi.Output[str]:
        """
        Specifies the destination link name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_link_name")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[str]:
        """
        Specifies type of job. Changing this parameter will create a new resource.
        The options are as follows:
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies job name, which can contains of 1 to 240 characters, starting with a
        letter. Only letters, digits, hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sourceConnector")
    def source_connector(self) -> pulumi.Output[str]:
        """
        Specifies the connector name of source link.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_connector")

    @property
    @pulumi.getter(name="sourceJobConfig")
    def source_job_config(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Specifies the source job configuration parameters. Each type of the data source
        to be connected has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "source_job_config")

    @property
    @pulumi.getter(name="sourceLinkName")
    def source_link_name(self) -> pulumi.Output[str]:
        """
        Specifies the source link name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_link_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Job status. The options are as follows:
        """
        return pulumi.get(self, "status")

