# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PvcArgs', 'Pvc']

@pulumi.input_type
class PvcArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 volume_id: pulumi.Input[str],
                 device_mount_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Pvc resource.
        :param pulumi.Input[str] namespace: Specifies the namespace to logically divide your cloud container instances
               into different group. Changing this will create a new PVC resource.
        :param pulumi.Input[str] volume_id: Specifies the ID of the storage bound to the CCI Namespace. Changing this
               will create a new PVC resource.
        :param pulumi.Input[str] device_mount_path: Specifies the share path of the SFS storage bound to the CCI
               Namespace. Required if `volume_type` is *nfs-rw*, *efs-standard* or *efs-performance*. Changing this will create a new
               PVC resource.
        :param pulumi.Input[str] name: Specifies the unique name of the PVC resource. This parameter can contain a
               maximum of 63 characters, which may consist of lowercase letters, digits and hyphens, and must start and end with
               lowercase letters and digits. Changing this will create a new PVC resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the PVC resource. If omitted, the
               provider-level region will be used. Changing this will create a new PVC resource.
        :param pulumi.Input[str] volume_type: Specifies the type of the storage bound to the CCI Namespace. The valid
               values are *sas*, *ssd*, *sata*, *obs*, *nfs-rw*, *efs-standard* and *efs-performance*, Defalut to *sas*. Changing
               this will create a new PVC resource.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "volume_id", volume_id)
        if device_mount_path is not None:
            pulumi.set(__self__, "device_mount_path", device_mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Specifies the namespace to logically divide your cloud container instances
        into different group. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the storage bound to the CCI Namespace. Changing this
        will create a new PVC resource.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="deviceMountPath")
    def device_mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the share path of the SFS storage bound to the CCI
        Namespace. Required if `volume_type` is *nfs-rw*, *efs-standard* or *efs-performance*. Changing this will create a new
        PVC resource.
        """
        return pulumi.get(self, "device_mount_path")

    @device_mount_path.setter
    def device_mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unique name of the PVC resource. This parameter can contain a
        maximum of 63 characters, which may consist of lowercase letters, digits and hyphens, and must start and end with
        lowercase letters and digits. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the PVC resource. If omitted, the
        provider-level region will be used. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the storage bound to the CCI Namespace. The valid
        values are *sas*, *ssd*, *sata*, *obs*, *nfs-rw*, *efs-standard* and *efs-performance*, Defalut to *sas*. Changing
        this will create a new PVC resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _PvcState:
    def __init__(__self__, *,
                 access_modes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 device_mount_path: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Pvc resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] access_modes: The access mode the volume should have.
        :param pulumi.Input[str] creation_timestamp: The server time when PVC was created.
        :param pulumi.Input[str] device_mount_path: Specifies the share path of the SFS storage bound to the CCI
               Namespace. Required if `volume_type` is *nfs-rw*, *efs-standard* or *efs-performance*. Changing this will create a new
               PVC resource.
        :param pulumi.Input[bool] enable: Whether the PVC is available.
        :param pulumi.Input[str] name: Specifies the unique name of the PVC resource. This parameter can contain a
               maximum of 63 characters, which may consist of lowercase letters, digits and hyphens, and must start and end with
               lowercase letters and digits. Changing this will create a new PVC resource.
        :param pulumi.Input[str] namespace: Specifies the namespace to logically divide your cloud container instances
               into different group. Changing this will create a new PVC resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the PVC resource. If omitted, the
               provider-level region will be used. Changing this will create a new PVC resource.
        :param pulumi.Input[str] status: The current phase of the PVC.
        :param pulumi.Input[str] volume_id: Specifies the ID of the storage bound to the CCI Namespace. Changing this
               will create a new PVC resource.
        :param pulumi.Input[str] volume_type: Specifies the type of the storage bound to the CCI Namespace. The valid
               values are *sas*, *ssd*, *sata*, *obs*, *nfs-rw*, *efs-standard* and *efs-performance*, Defalut to *sas*. Changing
               this will create a new PVC resource.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if device_mount_path is not None:
            pulumi.set(__self__, "device_mount_path", device_mount_path)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The access mode the volume should have.
        """
        return pulumi.get(self, "access_modes")

    @access_modes.setter
    def access_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "access_modes", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The server time when PVC was created.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="deviceMountPath")
    def device_mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the share path of the SFS storage bound to the CCI
        Namespace. Required if `volume_type` is *nfs-rw*, *efs-standard* or *efs-performance*. Changing this will create a new
        PVC resource.
        """
        return pulumi.get(self, "device_mount_path")

    @device_mount_path.setter
    def device_mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_mount_path", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the PVC is available.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unique name of the PVC resource. This parameter can contain a
        maximum of 63 characters, which may consist of lowercase letters, digits and hyphens, and must start and end with
        lowercase letters and digits. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the namespace to logically divide your cloud container instances
        into different group. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the PVC resource. If omitted, the
        provider-level region will be used. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current phase of the PVC.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the storage bound to the CCI Namespace. Changing this
        will create a new PVC resource.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the storage bound to the CCI Namespace. The valid
        values are *sas*, *ssd*, *sata*, *obs*, *nfs-rw*, *efs-standard* and *efs-performance*, Defalut to *sas*. Changing
        this will create a new PVC resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


class Pvc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_mount_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a CCI Persistent Volume Claim resource within HuaweiCloud.

        ## Example Usage
        ### Import an EVS volume

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        volume_id = config.require_object("volumeId")
        namespace = config.require_object("namespace")
        pvc_name = config.require_object("pvcName")
        test = huaweicloud.cci.Pvc("test",
            namespace=namespace,
            volume_type="ssd",
            volume_id=volume_id)
        ```
        ### Import an OBS bucket

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        obs_bucket_name = config.require_object("obsBucketName")
        namespace = config.require_object("namespace")
        pvc_name = config.require_object("pvcName")
        test = huaweicloud.cci.Pvc("test",
            namespace=namespace,
            volume_type="obs",
            volume_id=obs_bucket_name)
        ```
        ### Import an SFS

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        sfs_id = config.require_object("sfsId")
        namespace = config.require_object("namespace")
        pvc_name = config.require_object("pvcName")
        export_location = config.require_object("exportLocation")
        test = huaweicloud.cci.Pvc("test",
            namespace=namespace,
            volume_type="nfs-rw",
            volume_id=sfs_id,
            device_mount_path=export_location)
        ```
        ### Import an SFS Turbo

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        sfs_turbo_id = config.require_object("sfsTurboId")
        namespace = config.require_object("namespace")
        pvc_name = config.require_object("pvcName")
        export_location = config.require_object("exportLocation")
        test = huaweicloud.cci.Pvc("test",
            namespace=namespace,
            volume_type="efs-standard",
            volume_id=sfs_turbo_id,
            device_mount_path=export_location)
        ```

        ## Import

        PVCs can be imported using the `namespace`, `volume_type` and `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cci/pvc:Pvc test <namespace>/<volume_type>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] device_mount_path: Specifies the share path of the SFS storage bound to the CCI
               Namespace. Required if `volume_type` is *nfs-rw*, *efs-standard* or *efs-performance*. Changing this will create a new
               PVC resource.
        :param pulumi.Input[str] name: Specifies the unique name of the PVC resource. This parameter can contain a
               maximum of 63 characters, which may consist of lowercase letters, digits and hyphens, and must start and end with
               lowercase letters and digits. Changing this will create a new PVC resource.
        :param pulumi.Input[str] namespace: Specifies the namespace to logically divide your cloud container instances
               into different group. Changing this will create a new PVC resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the PVC resource. If omitted, the
               provider-level region will be used. Changing this will create a new PVC resource.
        :param pulumi.Input[str] volume_id: Specifies the ID of the storage bound to the CCI Namespace. Changing this
               will create a new PVC resource.
        :param pulumi.Input[str] volume_type: Specifies the type of the storage bound to the CCI Namespace. The valid
               values are *sas*, *ssd*, *sata*, *obs*, *nfs-rw*, *efs-standard* and *efs-performance*, Defalut to *sas*. Changing
               this will create a new PVC resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PvcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CCI Persistent Volume Claim resource within HuaweiCloud.

        ## Example Usage
        ### Import an EVS volume

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        volume_id = config.require_object("volumeId")
        namespace = config.require_object("namespace")
        pvc_name = config.require_object("pvcName")
        test = huaweicloud.cci.Pvc("test",
            namespace=namespace,
            volume_type="ssd",
            volume_id=volume_id)
        ```
        ### Import an OBS bucket

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        obs_bucket_name = config.require_object("obsBucketName")
        namespace = config.require_object("namespace")
        pvc_name = config.require_object("pvcName")
        test = huaweicloud.cci.Pvc("test",
            namespace=namespace,
            volume_type="obs",
            volume_id=obs_bucket_name)
        ```
        ### Import an SFS

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        sfs_id = config.require_object("sfsId")
        namespace = config.require_object("namespace")
        pvc_name = config.require_object("pvcName")
        export_location = config.require_object("exportLocation")
        test = huaweicloud.cci.Pvc("test",
            namespace=namespace,
            volume_type="nfs-rw",
            volume_id=sfs_id,
            device_mount_path=export_location)
        ```
        ### Import an SFS Turbo

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        sfs_turbo_id = config.require_object("sfsTurboId")
        namespace = config.require_object("namespace")
        pvc_name = config.require_object("pvcName")
        export_location = config.require_object("exportLocation")
        test = huaweicloud.cci.Pvc("test",
            namespace=namespace,
            volume_type="efs-standard",
            volume_id=sfs_turbo_id,
            device_mount_path=export_location)
        ```

        ## Import

        PVCs can be imported using the `namespace`, `volume_type` and `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cci/pvc:Pvc test <namespace>/<volume_type>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param PvcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PvcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device_mount_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PvcArgs.__new__(PvcArgs)

            __props__.__dict__["device_mount_path"] = device_mount_path
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["region"] = region
            if volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_id'")
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["access_modes"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["enable"] = None
            __props__.__dict__["status"] = None
        super(Pvc, __self__).__init__(
            'huaweicloud:Cci/pvc:Pvc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_modes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            device_mount_path: Optional[pulumi.Input[str]] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            volume_id: Optional[pulumi.Input[str]] = None,
            volume_type: Optional[pulumi.Input[str]] = None) -> 'Pvc':
        """
        Get an existing Pvc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] access_modes: The access mode the volume should have.
        :param pulumi.Input[str] creation_timestamp: The server time when PVC was created.
        :param pulumi.Input[str] device_mount_path: Specifies the share path of the SFS storage bound to the CCI
               Namespace. Required if `volume_type` is *nfs-rw*, *efs-standard* or *efs-performance*. Changing this will create a new
               PVC resource.
        :param pulumi.Input[bool] enable: Whether the PVC is available.
        :param pulumi.Input[str] name: Specifies the unique name of the PVC resource. This parameter can contain a
               maximum of 63 characters, which may consist of lowercase letters, digits and hyphens, and must start and end with
               lowercase letters and digits. Changing this will create a new PVC resource.
        :param pulumi.Input[str] namespace: Specifies the namespace to logically divide your cloud container instances
               into different group. Changing this will create a new PVC resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the PVC resource. If omitted, the
               provider-level region will be used. Changing this will create a new PVC resource.
        :param pulumi.Input[str] status: The current phase of the PVC.
        :param pulumi.Input[str] volume_id: Specifies the ID of the storage bound to the CCI Namespace. Changing this
               will create a new PVC resource.
        :param pulumi.Input[str] volume_type: Specifies the type of the storage bound to the CCI Namespace. The valid
               values are *sas*, *ssd*, *sata*, *obs*, *nfs-rw*, *efs-standard* and *efs-performance*, Defalut to *sas*. Changing
               this will create a new PVC resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PvcState.__new__(_PvcState)

        __props__.__dict__["access_modes"] = access_modes
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["device_mount_path"] = device_mount_path
        __props__.__dict__["enable"] = enable
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["volume_id"] = volume_id
        __props__.__dict__["volume_type"] = volume_type
        return Pvc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> pulumi.Output[Sequence[str]]:
        """
        The access mode the volume should have.
        """
        return pulumi.get(self, "access_modes")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        The server time when PVC was created.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="deviceMountPath")
    def device_mount_path(self) -> pulumi.Output[str]:
        """
        Specifies the share path of the SFS storage bound to the CCI
        Namespace. Required if `volume_type` is *nfs-rw*, *efs-standard* or *efs-performance*. Changing this will create a new
        PVC resource.
        """
        return pulumi.get(self, "device_mount_path")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[bool]:
        """
        Whether the PVC is available.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the unique name of the PVC resource. This parameter can contain a
        maximum of 63 characters, which may consist of lowercase letters, digits and hyphens, and must start and end with
        lowercase letters and digits. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        Specifies the namespace to logically divide your cloud container instances
        into different group. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the PVC resource. If omitted, the
        provider-level region will be used. Changing this will create a new PVC resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current phase of the PVC.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the storage bound to the CCI Namespace. Changing this
        will create a new PVC resource.
        """
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the storage bound to the CCI Namespace. The valid
        values are *sas*, *ssd*, *sata*, *obs*, *nfs-rw*, *efs-standard* and *efs-performance*, Defalut to *sas*. Changing
        this will create a new PVC resource.
        """
        return pulumi.get(self, "volume_type")

