# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 network_id: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone (AZ) to which the CCI network
               belongs. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] namespace: Specifies the namespace to logically divide your cloud container instances
               into different group. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] network_id: Specifies a network ID of the VPC subnet which the CCI network belongs to.
               Changing this will create a new CCI network resource.
        :param pulumi.Input[str] security_group_id: Specifies a security group ID to which the CCI network belongs to.
               Changing this will create a new CCI network resource.
        :param pulumi.Input[str] name: Specifies an unique name of the CCI network resource.
               The name can contain a maximum of 200 characters, which may consist of lowercase letters, digits and hyphens (-).
               The name must start and end with a lowercase letter or digit. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCI network.
               If omitted, the provider-level region will be used. Changing this will create a new CCI network resource.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the availability zone (AZ) to which the CCI network
        belongs. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Specifies the namespace to logically divide your cloud container instances
        into different group. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        Specifies a network ID of the VPC subnet which the CCI network belongs to.
        Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies a security group ID to which the CCI network belongs to.
        Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an unique name of the CCI network resource.
        The name can contain a maximum of 200 characters, which may consist of lowercase letters, digits and hyphens (-).
        The name must start and end with a lowercase letter or digit. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the CCI network.
        If omitted, the provider-level region will be used. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone (AZ) to which the CCI network
               belongs. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] cidr: The network segment on which the subnet resides.
        :param pulumi.Input[str] name: Specifies an unique name of the CCI network resource.
               The name can contain a maximum of 200 characters, which may consist of lowercase letters, digits and hyphens (-).
               The name must start and end with a lowercase letter or digit. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] namespace: Specifies the namespace to logically divide your cloud container instances
               into different group. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] network_id: Specifies a network ID of the VPC subnet which the CCI network belongs to.
               Changing this will create a new CCI network resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCI network.
               If omitted, the provider-level region will be used. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] security_group_id: Specifies a security group ID to which the CCI network belongs to.
               Changing this will create a new CCI network resource.
        :param pulumi.Input[str] status: The CCI network status, including **Initializing**, **Pending** and **Active**.
        :param pulumi.Input[str] subnet_id: IPv4 subnet ID.
        :param pulumi.Input[str] vpc_id: VPC ID which the subnet and CCI network belongs to.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone (AZ) to which the CCI network
        belongs. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The network segment on which the subnet resides.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an unique name of the CCI network resource.
        The name can contain a maximum of 200 characters, which may consist of lowercase letters, digits and hyphens (-).
        The name must start and end with a lowercase letter or digit. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the namespace to logically divide your cloud container instances
        into different group. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a network ID of the VPC subnet which the CCI network belongs to.
        Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the CCI network.
        If omitted, the provider-level region will be used. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a security group ID to which the CCI network belongs to.
        Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The CCI network status, including **Initializing**, **Pending** and **Active**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 subnet ID.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC ID which the subnet and CCI network belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a CCI Network resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        namespace_name = config.require_object("namespaceName")
        network_name = config.require_object("networkName")
        vpc_network_id = config.require_object("vpcNetworkId")
        security_group_id = config.require_object("securityGroupId")
        test_availability_zones = huaweicloud.get_availability_zones()
        test_network = huaweicloud.cci.Network("testNetwork",
            availability_zone=test_availability_zones.names[0],
            namespace=namespace_name,
            network_id=vpc_network_id,
            security_group_id=security_group_id)
        ```

        ## Import

        Networks can be imported using their `namespace` and `id`, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Cci/network:Network test <namespace>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone (AZ) to which the CCI network
               belongs. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] name: Specifies an unique name of the CCI network resource.
               The name can contain a maximum of 200 characters, which may consist of lowercase letters, digits and hyphens (-).
               The name must start and end with a lowercase letter or digit. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] namespace: Specifies the namespace to logically divide your cloud container instances
               into different group. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] network_id: Specifies a network ID of the VPC subnet which the CCI network belongs to.
               Changing this will create a new CCI network resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCI network.
               If omitted, the provider-level region will be used. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] security_group_id: Specifies a security group ID to which the CCI network belongs to.
               Changing this will create a new CCI network resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CCI Network resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        namespace_name = config.require_object("namespaceName")
        network_name = config.require_object("networkName")
        vpc_network_id = config.require_object("vpcNetworkId")
        security_group_id = config.require_object("securityGroupId")
        test_availability_zones = huaweicloud.get_availability_zones()
        test_network = huaweicloud.cci.Network("testNetwork",
            availability_zone=test_availability_zones.names[0],
            namespace=namespace_name,
            network_id=vpc_network_id,
            security_group_id=security_group_id)
        ```

        ## Import

        Networks can be imported using their `namespace` and `id`, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Cci/network:Network test <namespace>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["cidr"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_id"] = None
            __props__.__dict__["vpc_id"] = None
        super(Network, __self__).__init__(
            'huaweicloud:Cci/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone (AZ) to which the CCI network
               belongs. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] cidr: The network segment on which the subnet resides.
        :param pulumi.Input[str] name: Specifies an unique name of the CCI network resource.
               The name can contain a maximum of 200 characters, which may consist of lowercase letters, digits and hyphens (-).
               The name must start and end with a lowercase letter or digit. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] namespace: Specifies the namespace to logically divide your cloud container instances
               into different group. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] network_id: Specifies a network ID of the VPC subnet which the CCI network belongs to.
               Changing this will create a new CCI network resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCI network.
               If omitted, the provider-level region will be used. Changing this will create a new CCI network resource.
        :param pulumi.Input[str] security_group_id: Specifies a security group ID to which the CCI network belongs to.
               Changing this will create a new CCI network resource.
        :param pulumi.Input[str] status: The CCI network status, including **Initializing**, **Pending** and **Active**.
        :param pulumi.Input[str] subnet_id: IPv4 subnet ID.
        :param pulumi.Input[str] vpc_id: VPC ID which the subnet and CCI network belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["vpc_id"] = vpc_id
        return Network(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone (AZ) to which the CCI network
        belongs. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[str]:
        """
        The network segment on which the subnet resides.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies an unique name of the CCI network resource.
        The name can contain a maximum of 200 characters, which may consist of lowercase letters, digits and hyphens (-).
        The name must start and end with a lowercase letter or digit. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        Specifies the namespace to logically divide your cloud container instances
        into different group. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        Specifies a network ID of the VPC subnet which the CCI network belongs to.
        Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the CCI network.
        If omitted, the provider-level region will be used. Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies a security group ID to which the CCI network belongs to.
        Changing this will create a new CCI network resource.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The CCI network status, including **Initializing**, **Pending** and **Active**.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        IPv4 subnet ID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC ID which the subnet and CCI network belongs to.
        """
        return pulumi.get(self, "vpc_id")

