# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 auto_expend_enabled: Optional[pulumi.Input[bool]] = None,
                 container_network_enabled: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rbac_enabled: Optional[pulumi.Input[bool]] = None,
                 recycling_interval: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 warmup_pool_size: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[str] type: Specifies the CCI namespace type.
               The valid values are **general-computing** and **gpu-accelerated**.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] auto_expend_enabled: Specifies whether elastic scheduling is enabled.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] container_network_enabled: Specifies whether container network is enabled.
               Enable this option if you want CCI to start the container network in advance so that containers can connect to the
               network as soon as they are started. Default to **false**.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] name: Specifies the unique name of the CCI namespace.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
               and must start and end with lowercase letters and digits.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] rbac_enabled: Specifies whether Role-based access control is enabled.
               After the RBAC permission is enabled, the user's use of resources under the namespace will be controlled by the RBAC
               permission. Changing this will create a new CCI namespace resource.
        :param pulumi.Input[int] recycling_interval: Specifies the IP address recycling interval, in hour.
               The idle IP resources from the elastic expansion of the IP resource pool can be recycled within this time.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCI namespace resource.
               If omitted, the provider-level region will be used. Changing this will create a new CCI namespace resource.
        :param pulumi.Input[int] warmup_pool_size: Specifies the size of IP pool to warm-up.
               Changing this will create a new CCI namespace resource.
        """
        pulumi.set(__self__, "type", type)
        if auto_expend_enabled is not None:
            pulumi.set(__self__, "auto_expend_enabled", auto_expend_enabled)
        if container_network_enabled is not None:
            pulumi.set(__self__, "container_network_enabled", container_network_enabled)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rbac_enabled is not None:
            pulumi.set(__self__, "rbac_enabled", rbac_enabled)
        if recycling_interval is not None:
            pulumi.set(__self__, "recycling_interval", recycling_interval)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if warmup_pool_size is not None:
            pulumi.set(__self__, "warmup_pool_size", warmup_pool_size)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the CCI namespace type.
        The valid values are **general-computing** and **gpu-accelerated**.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="autoExpendEnabled")
    def auto_expend_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether elastic scheduling is enabled.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "auto_expend_enabled")

    @auto_expend_enabled.setter
    def auto_expend_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_expend_enabled", value)

    @property
    @pulumi.getter(name="containerNetworkEnabled")
    def container_network_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether container network is enabled.
        Enable this option if you want CCI to start the container network in advance so that containers can connect to the
        network as soon as they are started. Default to **false**.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "container_network_enabled")

    @container_network_enabled.setter
    def container_network_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "container_network_enabled", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unique name of the CCI namespace.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
        and must start and end with lowercase letters and digits.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rbacEnabled")
    def rbac_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether Role-based access control is enabled.
        After the RBAC permission is enabled, the user's use of resources under the namespace will be controlled by the RBAC
        permission. Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "rbac_enabled")

    @rbac_enabled.setter
    def rbac_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rbac_enabled", value)

    @property
    @pulumi.getter(name="recyclingInterval")
    def recycling_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the IP address recycling interval, in hour.
        The idle IP resources from the elastic expansion of the IP resource pool can be recycled within this time.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "recycling_interval")

    @recycling_interval.setter
    def recycling_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recycling_interval", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the CCI namespace resource.
        If omitted, the provider-level region will be used. Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="warmupPoolSize")
    def warmup_pool_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of IP pool to warm-up.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "warmup_pool_size")

    @warmup_pool_size.setter
    def warmup_pool_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warmup_pool_size", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 auto_expend_enabled: Optional[pulumi.Input[bool]] = None,
                 container_network_enabled: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rbac_enabled: Optional[pulumi.Input[bool]] = None,
                 recycling_interval: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 warmup_pool_size: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[bool] auto_expend_enabled: Specifies whether elastic scheduling is enabled.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] container_network_enabled: Specifies whether container network is enabled.
               Enable this option if you want CCI to start the container network in advance so that containers can connect to the
               network as soon as they are started. Default to **false**.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] created_at: The time when the namespace was created, in UTC format, e.g., **2021-09-27T01:30:39Z**.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] name: Specifies the unique name of the CCI namespace.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
               and must start and end with lowercase letters and digits.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] rbac_enabled: Specifies whether Role-based access control is enabled.
               After the RBAC permission is enabled, the user's use of resources under the namespace will be controlled by the RBAC
               permission. Changing this will create a new CCI namespace resource.
        :param pulumi.Input[int] recycling_interval: Specifies the IP address recycling interval, in hour.
               The idle IP resources from the elastic expansion of the IP resource pool can be recycled within this time.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCI namespace resource.
               If omitted, the provider-level region will be used. Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] status: Namespace status.
        :param pulumi.Input[str] type: Specifies the CCI namespace type.
               The valid values are **general-computing** and **gpu-accelerated**.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[int] warmup_pool_size: Specifies the size of IP pool to warm-up.
               Changing this will create a new CCI namespace resource.
        """
        if auto_expend_enabled is not None:
            pulumi.set(__self__, "auto_expend_enabled", auto_expend_enabled)
        if container_network_enabled is not None:
            pulumi.set(__self__, "container_network_enabled", container_network_enabled)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rbac_enabled is not None:
            pulumi.set(__self__, "rbac_enabled", rbac_enabled)
        if recycling_interval is not None:
            pulumi.set(__self__, "recycling_interval", recycling_interval)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if warmup_pool_size is not None:
            pulumi.set(__self__, "warmup_pool_size", warmup_pool_size)

    @property
    @pulumi.getter(name="autoExpendEnabled")
    def auto_expend_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether elastic scheduling is enabled.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "auto_expend_enabled")

    @auto_expend_enabled.setter
    def auto_expend_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_expend_enabled", value)

    @property
    @pulumi.getter(name="containerNetworkEnabled")
    def container_network_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether container network is enabled.
        Enable this option if you want CCI to start the container network in advance so that containers can connect to the
        network as soon as they are started. Default to **false**.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "container_network_enabled")

    @container_network_enabled.setter
    def container_network_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "container_network_enabled", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the namespace was created, in UTC format, e.g., **2021-09-27T01:30:39Z**.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unique name of the CCI namespace.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
        and must start and end with lowercase letters and digits.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rbacEnabled")
    def rbac_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether Role-based access control is enabled.
        After the RBAC permission is enabled, the user's use of resources under the namespace will be controlled by the RBAC
        permission. Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "rbac_enabled")

    @rbac_enabled.setter
    def rbac_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rbac_enabled", value)

    @property
    @pulumi.getter(name="recyclingInterval")
    def recycling_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the IP address recycling interval, in hour.
        The idle IP resources from the elastic expansion of the IP resource pool can be recycled within this time.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "recycling_interval")

    @recycling_interval.setter
    def recycling_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recycling_interval", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the CCI namespace resource.
        If omitted, the provider-level region will be used. Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the CCI namespace type.
        The valid values are **general-computing** and **gpu-accelerated**.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="warmupPoolSize")
    def warmup_pool_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of IP pool to warm-up.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "warmup_pool_size")

    @warmup_pool_size.setter
    def warmup_pool_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warmup_pool_size", value)


class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_expend_enabled: Optional[pulumi.Input[bool]] = None,
                 container_network_enabled: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rbac_enabled: Optional[pulumi.Input[bool]] = None,
                 recycling_interval: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 warmup_pool_size: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a CCI namespace resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        namespace_name = config.require_object("namespaceName")
        test = huaweicloud.cci.Namespace("test",
            type="gpu-accelerated",
            rbac_enabled=True)
        ```

        ## Import

        CCI Namespaces can be imported using their `name`, e.g.,

        ```sh
         $ pulumi import huaweicloud:Cci/namespace:Namespace test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_expend_enabled: Specifies whether elastic scheduling is enabled.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] container_network_enabled: Specifies whether container network is enabled.
               Enable this option if you want CCI to start the container network in advance so that containers can connect to the
               network as soon as they are started. Default to **false**.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] name: Specifies the unique name of the CCI namespace.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
               and must start and end with lowercase letters and digits.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] rbac_enabled: Specifies whether Role-based access control is enabled.
               After the RBAC permission is enabled, the user's use of resources under the namespace will be controlled by the RBAC
               permission. Changing this will create a new CCI namespace resource.
        :param pulumi.Input[int] recycling_interval: Specifies the IP address recycling interval, in hour.
               The idle IP resources from the elastic expansion of the IP resource pool can be recycled within this time.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCI namespace resource.
               If omitted, the provider-level region will be used. Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] type: Specifies the CCI namespace type.
               The valid values are **general-computing** and **gpu-accelerated**.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[int] warmup_pool_size: Specifies the size of IP pool to warm-up.
               Changing this will create a new CCI namespace resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CCI namespace resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        namespace_name = config.require_object("namespaceName")
        test = huaweicloud.cci.Namespace("test",
            type="gpu-accelerated",
            rbac_enabled=True)
        ```

        ## Import

        CCI Namespaces can be imported using their `name`, e.g.,

        ```sh
         $ pulumi import huaweicloud:Cci/namespace:Namespace test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_expend_enabled: Optional[pulumi.Input[bool]] = None,
                 container_network_enabled: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rbac_enabled: Optional[pulumi.Input[bool]] = None,
                 recycling_interval: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 warmup_pool_size: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            __props__.__dict__["auto_expend_enabled"] = auto_expend_enabled
            __props__.__dict__["container_network_enabled"] = container_network_enabled
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["rbac_enabled"] = rbac_enabled
            __props__.__dict__["recycling_interval"] = recycling_interval
            __props__.__dict__["region"] = region
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["warmup_pool_size"] = warmup_pool_size
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(Namespace, __self__).__init__(
            'huaweicloud:Cci/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_expend_enabled: Optional[pulumi.Input[bool]] = None,
            container_network_enabled: Optional[pulumi.Input[bool]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rbac_enabled: Optional[pulumi.Input[bool]] = None,
            recycling_interval: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            warmup_pool_size: Optional[pulumi.Input[int]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_expend_enabled: Specifies whether elastic scheduling is enabled.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] container_network_enabled: Specifies whether container network is enabled.
               Enable this option if you want CCI to start the container network in advance so that containers can connect to the
               network as soon as they are started. Default to **false**.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] created_at: The time when the namespace was created, in UTC format, e.g., **2021-09-27T01:30:39Z**.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] name: Specifies the unique name of the CCI namespace.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
               and must start and end with lowercase letters and digits.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[bool] rbac_enabled: Specifies whether Role-based access control is enabled.
               After the RBAC permission is enabled, the user's use of resources under the namespace will be controlled by the RBAC
               permission. Changing this will create a new CCI namespace resource.
        :param pulumi.Input[int] recycling_interval: Specifies the IP address recycling interval, in hour.
               The idle IP resources from the elastic expansion of the IP resource pool can be recycled within this time.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCI namespace resource.
               If omitted, the provider-level region will be used. Changing this will create a new CCI namespace resource.
        :param pulumi.Input[str] status: Namespace status.
        :param pulumi.Input[str] type: Specifies the CCI namespace type.
               The valid values are **general-computing** and **gpu-accelerated**.
               Changing this will create a new CCI namespace resource.
        :param pulumi.Input[int] warmup_pool_size: Specifies the size of IP pool to warm-up.
               Changing this will create a new CCI namespace resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["auto_expend_enabled"] = auto_expend_enabled
        __props__.__dict__["container_network_enabled"] = container_network_enabled
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["rbac_enabled"] = rbac_enabled
        __props__.__dict__["recycling_interval"] = recycling_interval
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["warmup_pool_size"] = warmup_pool_size
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoExpendEnabled")
    def auto_expend_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether elastic scheduling is enabled.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "auto_expend_enabled")

    @property
    @pulumi.getter(name="containerNetworkEnabled")
    def container_network_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether container network is enabled.
        Enable this option if you want CCI to start the container network in advance so that containers can connect to the
        network as soon as they are started. Default to **false**.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "container_network_enabled")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The time when the namespace was created, in UTC format, e.g., **2021-09-27T01:30:39Z**.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the unique name of the CCI namespace.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
        and must start and end with lowercase letters and digits.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rbacEnabled")
    def rbac_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether Role-based access control is enabled.
        After the RBAC permission is enabled, the user's use of resources under the namespace will be controlled by the RBAC
        permission. Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "rbac_enabled")

    @property
    @pulumi.getter(name="recyclingInterval")
    def recycling_interval(self) -> pulumi.Output[int]:
        """
        Specifies the IP address recycling interval, in hour.
        The idle IP resources from the elastic expansion of the IP resource pool can be recycled within this time.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "recycling_interval")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the CCI namespace resource.
        If omitted, the provider-level region will be used. Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Namespace status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the CCI namespace type.
        The valid values are **general-computing** and **gpu-accelerated**.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="warmupPoolSize")
    def warmup_pool_size(self) -> pulumi.Output[int]:
        """
        Specifies the size of IP pool to warm-up.
        Changing this will create a new CCI namespace resource.
        """
        return pulumi.get(self, "warmup_pool_size")

