# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNodesResult',
    'AwaitableGetNodesResult',
    'get_nodes',
    'get_nodes_output',
]

@pulumi.output_type
class GetNodesResult:
    """
    A collection of values returned by getNodes.
    """
    def __init__(__self__, cluster_id=None, id=None, ids=None, name=None, node_id=None, nodes=None, region=None, status=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        Indicates a list of IDs of all CCE nodes found.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the node.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetNodesNodeResult']:
        """
        Indicates a list of CCE nodes found. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The state of the node.
        """
        return pulumi.get(self, "status")


class AwaitableGetNodesResult(GetNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodesResult(
            cluster_id=self.cluster_id,
            id=self.id,
            ids=self.ids,
            name=self.name,
            node_id=self.node_id,
            nodes=self.nodes,
            region=self.region,
            status=self.status)


def get_nodes(cluster_id: Optional[str] = None,
              name: Optional[str] = None,
              node_id: Optional[str] = None,
              region: Optional[str] = None,
              status: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodesResult:
    """
    Use this data source to get a list of CCE nodes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_name = config.require_object("nodeName")
    node = huaweicloud.Cce.get_nodes(cluster_id=cluster_id,
        name=node_name)
    ```


    :param str cluster_id: Specifies the ID of CCE cluster.
    :param str name: Specifies the of the node.
    :param str node_id: Specifies the ID of the node.
    :param str region: Specifies the region in which to obtain the CCE nodes. If omitted, the provider-level
           region will be used.
    :param str status: Specifies the status of the node.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['nodeId'] = node_id
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Cce/getNodes:getNodes', __args__, opts=opts, typ=GetNodesResult).value

    return AwaitableGetNodesResult(
        cluster_id=__ret__.cluster_id,
        id=__ret__.id,
        ids=__ret__.ids,
        name=__ret__.name,
        node_id=__ret__.node_id,
        nodes=__ret__.nodes,
        region=__ret__.region,
        status=__ret__.status)


@_utilities.lift_output_func(get_nodes)
def get_nodes_output(cluster_id: Optional[pulumi.Input[str]] = None,
                     name: Optional[pulumi.Input[Optional[str]]] = None,
                     node_id: Optional[pulumi.Input[Optional[str]]] = None,
                     region: Optional[pulumi.Input[Optional[str]]] = None,
                     status: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNodesResult]:
    """
    Use this data source to get a list of CCE nodes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_name = config.require_object("nodeName")
    node = huaweicloud.Cce.get_nodes(cluster_id=cluster_id,
        name=node_name)
    ```


    :param str cluster_id: Specifies the ID of CCE cluster.
    :param str name: Specifies the of the node.
    :param str node_id: Specifies the ID of the node.
    :param str region: Specifies the region in which to obtain the CCE nodes. If omitted, the provider-level
           region will be used.
    :param str status: Specifies the status of the node.
    """
    ...
