# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VaultArgs', 'Vault']

@pulumi.input_type
class VaultArgs:
    def __init__(__self__, *,
                 protection_type: pulumi.Input[str],
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 auto_bind: Optional[pulumi.Input[bool]] = None,
                 auto_expand: Optional[pulumi.Input[bool]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 consistent_level: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Vault resource.
        :param pulumi.Input[str] protection_type: Specifies the protection type of the CBR vault.
               The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
               Changing this will create a new vault.
        :param pulumi.Input[int] size: Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
        :param pulumi.Input[str] type: Specifies the object type of the CBR vault.
               Changing this will create a new vault. Vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        :param pulumi.Input[bool] auto_bind: Specifies whether automatic association is enabled. Defaults to **false**.
        :param pulumi.Input[bool] auto_expand: Specifies to enable auto capacity expansion for the backup protection type vault.
               Defaults to **false**.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**. Changing this will create a new vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] bind_rules: Specifies the tags to filter resources for automatic association with **auto_bind**.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the vault.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
        :param pulumi.Input[str] consistent_level: Specifies the backup specifications.
               The valid values are as follows:
               + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
               + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new vault.
        :param pulumi.Input[str] name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param pulumi.Input[int] period: Specifies the charging period of the vault.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the vault.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[str] policy_id: Specifies a policy to associate with the CBR vault.
               `policy_id` cannot be used with the vault of replicate protection type.
        :param pulumi.Input[str] region: Specifies the region in which to create the CBR vault. If omitted, the
               provider-level region will be used. Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]] resources: Specifies an array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the CBR vault.
        """
        pulumi.set(__self__, "protection_type", protection_type)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if auto_bind is not None:
            pulumi.set(__self__, "auto_bind", auto_bind)
        if auto_expand is not None:
            pulumi.set(__self__, "auto_expand", auto_expand)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bind_rules is not None:
            pulumi.set(__self__, "bind_rules", bind_rules)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if consistent_level is not None:
            pulumi.set(__self__, "consistent_level", consistent_level)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> pulumi.Input[str]:
        """
        Specifies the protection type of the CBR vault.
        The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "protection_type")

    @protection_type.setter
    def protection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protection_type", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the object type of the CBR vault.
        Changing this will create a new vault. Vaild values are as follows:
        + **server** (Cloud Servers)
        + **disk** (EVS Disks)
        + **turbo** (SFS Turbo file systems)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="autoBind")
    def auto_bind(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether automatic association is enabled. Defaults to **false**.
        """
        return pulumi.get(self, "auto_bind")

    @auto_bind.setter
    def auto_bind(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_bind", value)

    @property
    @pulumi.getter(name="autoExpand")
    def auto_expand(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies to enable auto capacity expansion for the backup protection type vault.
        Defaults to **false**.
        """
        return pulumi.get(self, "auto_expand")

    @auto_expand.setter
    def auto_expand(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_expand", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**. Changing this will create a new vault.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="bindRules")
    def bind_rules(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags to filter resources for automatic association with **auto_bind**.
        """
        return pulumi.get(self, "bind_rules")

    @bind_rules.setter
    def bind_rules(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "bind_rules", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the vault.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backup specifications.
        The valid values are as follows:
        + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        """
        return pulumi.get(self, "consistent_level")

    @consistent_level.setter
    def consistent_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consistent_level", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the vault.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the vault.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a policy to associate with the CBR vault.
        `policy_id` cannot be used with the vault of replicate protection type.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the CBR vault. If omitted, the
        provider-level region will be used. Changing this will create a new vault.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]]:
        """
        Specifies an array of one or more resources to attach to the CBR vault.
        The object structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the CBR vault.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VaultState:
    def __init__(__self__, *,
                 allocated: Optional[pulumi.Input[float]] = None,
                 auto_bind: Optional[pulumi.Input[bool]] = None,
                 auto_expand: Optional[pulumi.Input[bool]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 consistent_level: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 spec_code: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 used: Optional[pulumi.Input[float]] = None):
        """
        Input properties used for looking up and filtering Vault resources.
        :param pulumi.Input[float] allocated: The allocated capacity of the vault, in GB.
        :param pulumi.Input[bool] auto_bind: Specifies whether automatic association is enabled. Defaults to **false**.
        :param pulumi.Input[bool] auto_expand: Specifies to enable auto capacity expansion for the backup protection type vault.
               Defaults to **false**.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**. Changing this will create a new vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] bind_rules: Specifies the tags to filter resources for automatic association with **auto_bind**.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the vault.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
        :param pulumi.Input[str] consistent_level: Specifies the backup specifications.
               The valid values are as follows:
               + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
               + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new vault.
        :param pulumi.Input[str] name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param pulumi.Input[int] period: Specifies the charging period of the vault.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the vault.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[str] policy_id: Specifies a policy to associate with the CBR vault.
               `policy_id` cannot be used with the vault of replicate protection type.
        :param pulumi.Input[str] protection_type: Specifies the protection type of the CBR vault.
               The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
               Changing this will create a new vault.
        :param pulumi.Input[str] region: Specifies the region in which to create the CBR vault. If omitted, the
               provider-level region will be used. Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]] resources: Specifies an array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param pulumi.Input[int] size: Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
        :param pulumi.Input[str] spec_code: The specification code.
        :param pulumi.Input[str] status: The vault status.
        :param pulumi.Input[str] storage: The name of the bucket for the vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the CBR vault.
        :param pulumi.Input[str] type: Specifies the object type of the CBR vault.
               Changing this will create a new vault. Vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        :param pulumi.Input[float] used: The used capacity, in GB.
        """
        if allocated is not None:
            pulumi.set(__self__, "allocated", allocated)
        if auto_bind is not None:
            pulumi.set(__self__, "auto_bind", auto_bind)
        if auto_expand is not None:
            pulumi.set(__self__, "auto_expand", auto_expand)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bind_rules is not None:
            pulumi.set(__self__, "bind_rules", bind_rules)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if consistent_level is not None:
            pulumi.set(__self__, "consistent_level", consistent_level)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_type is not None:
            pulumi.set(__self__, "protection_type", protection_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if spec_code is not None:
            pulumi.set(__self__, "spec_code", spec_code)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used is not None:
            pulumi.set(__self__, "used", used)

    @property
    @pulumi.getter
    def allocated(self) -> Optional[pulumi.Input[float]]:
        """
        The allocated capacity of the vault, in GB.
        """
        return pulumi.get(self, "allocated")

    @allocated.setter
    def allocated(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "allocated", value)

    @property
    @pulumi.getter(name="autoBind")
    def auto_bind(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether automatic association is enabled. Defaults to **false**.
        """
        return pulumi.get(self, "auto_bind")

    @auto_bind.setter
    def auto_bind(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_bind", value)

    @property
    @pulumi.getter(name="autoExpand")
    def auto_expand(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies to enable auto capacity expansion for the backup protection type vault.
        Defaults to **false**.
        """
        return pulumi.get(self, "auto_expand")

    @auto_expand.setter
    def auto_expand(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_expand", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**. Changing this will create a new vault.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="bindRules")
    def bind_rules(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags to filter resources for automatic association with **auto_bind**.
        """
        return pulumi.get(self, "bind_rules")

    @bind_rules.setter
    def bind_rules(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "bind_rules", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the vault.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the backup specifications.
        The valid values are as follows:
        + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        """
        return pulumi.get(self, "consistent_level")

    @consistent_level.setter
    def consistent_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consistent_level", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the vault.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the vault.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a policy to associate with the CBR vault.
        `policy_id` cannot be used with the vault of replicate protection type.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protection type of the CBR vault.
        The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "protection_type")

    @protection_type.setter
    def protection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the CBR vault. If omitted, the
        provider-level region will be used. Changing this will create a new vault.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]]:
        """
        Specifies an array of one or more resources to attach to the CBR vault.
        The object structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> Optional[pulumi.Input[str]]:
        """
        The specification code.
        """
        return pulumi.get(self, "spec_code")

    @spec_code.setter
    def spec_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spec_code", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The vault status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket for the vault.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the CBR vault.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the object type of the CBR vault.
        Changing this will create a new vault. Vaild values are as follows:
        + **server** (Cloud Servers)
        + **disk** (EVS Disks)
        + **turbo** (SFS Turbo file systems)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def used(self) -> Optional[pulumi.Input[float]]:
        """
        The used capacity, in GB.
        """
        return pulumi.get(self, "used")

    @used.setter
    def used(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "used", value)


class Vault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_bind: Optional[pulumi.Input[bool]] = None,
                 auto_expand: Optional[pulumi.Input[bool]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 consistent_level: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VaultResourceArgs']]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a CBR Vault resource within Huaweicloud.

        ## Example Usage
        ### Create a disk type vault

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        evs_volume_id = config.require_object("evsVolumeId")
        test = huaweicloud.cbr.Vault("test",
            type="disk",
            protection_type="backup",
            size=50,
            auto_expand=True,
            resources=[huaweicloud.cbr.VaultResourceArgs(
                includes=[evs_volume_id],
            )],
            tags={
                "foo": "bar",
            })
        ```
        ### Create an SFS turbo type vault

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        sfs_turbo_id = config.require_object("sfsTurboId")
        test = huaweicloud.cbr.Vault("test",
            type="turbo",
            protection_type="backup",
            size=1000,
            resources=[huaweicloud.cbr.VaultResourceArgs(
                includes=[sfs_turbo_id],
            )],
            tags={
                "foo": "bar",
            })
        ```
        ### Create an SFS turbo type vault with replicate protection type

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        test = huaweicloud.cbr.Vault("test",
            type="turbo",
            protection_type="replication",
            size=1000)
        ```

        ## Import

        Vaults can be imported by their `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Cbr/vault:Vault test 01c33779-7c83-4182-8b6b-24a671fcedf8
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`period_unit`, `period`, `auto_renew`. It is generally recommended running `terraform plan` after importing a vault. You can then decide if changes should be applied to the vault, or the resource definition should be updated to align with the vault. Also you can ignore changes as below. resource "huaweicloud_cbr_vault" "test" {

         ...

         lifecycle {

         ignore_changes = [

         period_unit, period, auto_renew,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_bind: Specifies whether automatic association is enabled. Defaults to **false**.
        :param pulumi.Input[bool] auto_expand: Specifies to enable auto capacity expansion for the backup protection type vault.
               Defaults to **false**.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**. Changing this will create a new vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] bind_rules: Specifies the tags to filter resources for automatic association with **auto_bind**.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the vault.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
        :param pulumi.Input[str] consistent_level: Specifies the backup specifications.
               The valid values are as follows:
               + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
               + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new vault.
        :param pulumi.Input[str] name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param pulumi.Input[int] period: Specifies the charging period of the vault.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the vault.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[str] policy_id: Specifies a policy to associate with the CBR vault.
               `policy_id` cannot be used with the vault of replicate protection type.
        :param pulumi.Input[str] protection_type: Specifies the protection type of the CBR vault.
               The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
               Changing this will create a new vault.
        :param pulumi.Input[str] region: Specifies the region in which to create the CBR vault. If omitted, the
               provider-level region will be used. Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VaultResourceArgs']]]] resources: Specifies an array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param pulumi.Input[int] size: Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the CBR vault.
        :param pulumi.Input[str] type: Specifies the object type of the CBR vault.
               Changing this will create a new vault. Vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CBR Vault resource within Huaweicloud.

        ## Example Usage
        ### Create a disk type vault

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        evs_volume_id = config.require_object("evsVolumeId")
        test = huaweicloud.cbr.Vault("test",
            type="disk",
            protection_type="backup",
            size=50,
            auto_expand=True,
            resources=[huaweicloud.cbr.VaultResourceArgs(
                includes=[evs_volume_id],
            )],
            tags={
                "foo": "bar",
            })
        ```
        ### Create an SFS turbo type vault

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        sfs_turbo_id = config.require_object("sfsTurboId")
        test = huaweicloud.cbr.Vault("test",
            type="turbo",
            protection_type="backup",
            size=1000,
            resources=[huaweicloud.cbr.VaultResourceArgs(
                includes=[sfs_turbo_id],
            )],
            tags={
                "foo": "bar",
            })
        ```
        ### Create an SFS turbo type vault with replicate protection type

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        test = huaweicloud.cbr.Vault("test",
            type="turbo",
            protection_type="replication",
            size=1000)
        ```

        ## Import

        Vaults can be imported by their `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Cbr/vault:Vault test 01c33779-7c83-4182-8b6b-24a671fcedf8
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`period_unit`, `period`, `auto_renew`. It is generally recommended running `terraform plan` after importing a vault. You can then decide if changes should be applied to the vault, or the resource definition should be updated to align with the vault. Also you can ignore changes as below. resource "huaweicloud_cbr_vault" "test" {

         ...

         lifecycle {

         ignore_changes = [

         period_unit, period, auto_renew,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param VaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_bind: Optional[pulumi.Input[bool]] = None,
                 auto_expand: Optional[pulumi.Input[bool]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 consistent_level: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VaultResourceArgs']]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultArgs.__new__(VaultArgs)

            __props__.__dict__["auto_bind"] = auto_bind
            __props__.__dict__["auto_expand"] = auto_expand
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["bind_rules"] = bind_rules
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["consistent_level"] = consistent_level
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["policy_id"] = policy_id
            if protection_type is None and not opts.urn:
                raise TypeError("Missing required property 'protection_type'")
            __props__.__dict__["protection_type"] = protection_type
            __props__.__dict__["region"] = region
            __props__.__dict__["resources"] = resources
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["allocated"] = None
            __props__.__dict__["spec_code"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["storage"] = None
            __props__.__dict__["used"] = None
        super(Vault, __self__).__init__(
            'huaweicloud:Cbr/vault:Vault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocated: Optional[pulumi.Input[float]] = None,
            auto_bind: Optional[pulumi.Input[bool]] = None,
            auto_expand: Optional[pulumi.Input[bool]] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            consistent_level: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            protection_type: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VaultResourceArgs']]]]] = None,
            size: Optional[pulumi.Input[int]] = None,
            spec_code: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            used: Optional[pulumi.Input[float]] = None) -> 'Vault':
        """
        Get an existing Vault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] allocated: The allocated capacity of the vault, in GB.
        :param pulumi.Input[bool] auto_bind: Specifies whether automatic association is enabled. Defaults to **false**.
        :param pulumi.Input[bool] auto_expand: Specifies to enable auto capacity expansion for the backup protection type vault.
               Defaults to **false**.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**. Changing this will create a new vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] bind_rules: Specifies the tags to filter resources for automatic association with **auto_bind**.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the vault.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
        :param pulumi.Input[str] consistent_level: Specifies the backup specifications.
               The valid values are as follows:
               + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
               + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new vault.
        :param pulumi.Input[str] name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param pulumi.Input[int] period: Specifies the charging period of the vault.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the vault.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[str] policy_id: Specifies a policy to associate with the CBR vault.
               `policy_id` cannot be used with the vault of replicate protection type.
        :param pulumi.Input[str] protection_type: Specifies the protection type of the CBR vault.
               The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
               Changing this will create a new vault.
        :param pulumi.Input[str] region: Specifies the region in which to create the CBR vault. If omitted, the
               provider-level region will be used. Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VaultResourceArgs']]]] resources: Specifies an array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param pulumi.Input[int] size: Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
        :param pulumi.Input[str] spec_code: The specification code.
        :param pulumi.Input[str] status: The vault status.
        :param pulumi.Input[str] storage: The name of the bucket for the vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the CBR vault.
        :param pulumi.Input[str] type: Specifies the object type of the CBR vault.
               Changing this will create a new vault. Vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        :param pulumi.Input[float] used: The used capacity, in GB.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultState.__new__(_VaultState)

        __props__.__dict__["allocated"] = allocated
        __props__.__dict__["auto_bind"] = auto_bind
        __props__.__dict__["auto_expand"] = auto_expand
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["bind_rules"] = bind_rules
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["consistent_level"] = consistent_level
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["protection_type"] = protection_type
        __props__.__dict__["region"] = region
        __props__.__dict__["resources"] = resources
        __props__.__dict__["size"] = size
        __props__.__dict__["spec_code"] = spec_code
        __props__.__dict__["status"] = status
        __props__.__dict__["storage"] = storage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["used"] = used
        return Vault(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def allocated(self) -> pulumi.Output[float]:
        """
        The allocated capacity of the vault, in GB.
        """
        return pulumi.get(self, "allocated")

    @property
    @pulumi.getter(name="autoBind")
    def auto_bind(self) -> pulumi.Output[bool]:
        """
        Specifies whether automatic association is enabled. Defaults to **false**.
        """
        return pulumi.get(self, "auto_bind")

    @property
    @pulumi.getter(name="autoExpand")
    def auto_expand(self) -> pulumi.Output[bool]:
        """
        Specifies to enable auto capacity expansion for the backup protection type vault.
        Defaults to **false**.
        """
        return pulumi.get(self, "auto_expand")

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**. Changing this will create a new vault.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="bindRules")
    def bind_rules(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the tags to filter resources for automatic association with **auto_bind**.
        """
        return pulumi.get(self, "bind_rules")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the vault.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the backup specifications.
        The valid values are as follows:
        + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
        """
        return pulumi.get(self, "consistent_level")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the vault.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the vault.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a policy to associate with the CBR vault.
        `policy_id` cannot be used with the vault of replicate protection type.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> pulumi.Output[str]:
        """
        Specifies the protection type of the CBR vault.
        The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "protection_type")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the CBR vault. If omitted, the
        provider-level region will be used. Changing this will create a new vault.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence['outputs.VaultResource']]:
        """
        Specifies an array of one or more resources to attach to the CBR vault.
        The object structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> pulumi.Output[str]:
        """
        The specification code.
        """
        return pulumi.get(self, "spec_code")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The vault status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output[str]:
        """
        The name of the bucket for the vault.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the CBR vault.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the object type of the CBR vault.
        Changing this will create a new vault. Vaild values are as follows:
        + **server** (Cloud Servers)
        + **disk** (EVS Disks)
        + **turbo** (SFS Turbo file systems)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def used(self) -> pulumi.Output[float]:
        """
        The used capacity, in GB.
        """
        return pulumi.get(self, "used")

