# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 flavor_id: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 nics: pulumi.Input[Sequence[pulumi.Input['InstanceNicArgs']]],
                 user_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 agency_name: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 eip_charge_mode: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the instance.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?BMS)
               for the values. Changing this creates a new instance.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of the desired flavor for the instance. Changing
               this creates a new instance.
        :param pulumi.Input[str] image_id: Specifies the image ID of the desired image for the instance. Changing this
               creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNicArgs']]] nics: Specifies an array of one or more networks to attach to the instance. The network
               object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[str] user_id: Specifies the user ID. You can obtain the user ID from My Credential on the
               management console. Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies id of vpc in which to create the instance. Changing this creates a
               new instance.
        :param pulumi.Input[str] admin_pass: Specifies the administrative password to assign to the instance. Changing
               this creates a new instance.
        :param pulumi.Input[str] agency_name: Specifies the IAM agency name which is created on IAM to provide
               temporary credentials for BMS to access cloud services. Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false", defaults to *false*. Changing this creates a new instance.
        :param pulumi.Input[str] bandwidth_charge_mode: Bandwidth billing type. Available options are:
               + `traffic`: billing mode is traffic.
               + `bandwidth`: billing mode is bandwidth.
        :param pulumi.Input[int] bandwidth_size: Bandwidth size. Changing this creates a new instance.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid value is *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: Specifies an array of one or more data disks to attach to the instance. The
               data_disks object structure is documented below. A maximum of 59 disks can be mounted. Changing this creates a new
               instance.
        :param pulumi.Input[str] eip_charge_mode: Elastic IP billing type. If the bandwidth billing mode is bandwidth,
               both prePaid and postPaid are supported. If the bandwidth billing mode is traffic, only postPaid is supported.
               Changing this creates a new instance. Available options are:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
        :param pulumi.Input[str] eip_id: The ID of the EIP. Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique id in UUID format of enterprise project .
               Changing this creates a new instance.
        :param pulumi.Input[str] iptype: Elastic IP type. Changing this creates a new instance.
               Available options are:
               + `5_bgp`: dynamic BGP.
               + `5_sbgp`: static BGP.
        :param pulumi.Input[str] key_pair: Specifies the name of a key pair to put on the instance. The key pair must
               already be created and associated with the tenant's account. Changing this creates a new instance.
        :param pulumi.Input[str] name: Specifies a unique name for the instance. The name consists of 1 to 63 characters,
               including letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value is 1. This parameter is mandatory
               if `charging_mode` is set to *prePaid*. Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance. Valid values are *
               month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
               instance.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance. If omitted, the
               provider-level region will be used. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies an array of one or more security group IDs to associate with
               the instance. Changing this creates a new instance.
        :param pulumi.Input[str] sharetype: Bandwidth sharing type. Changing this creates a new instance. Available
               options are:
               + `PER`: indicates dedicated bandwidth.
               + `WHOLE`: indicates shared bandwidth.
        :param pulumi.Input[int] system_disk_size: Specifies the system disk size in GB. The value ranges from 40 to 1024.
               The system disk size must be greater than or equal to the minimum system disk size of the image. Changing this creates
               a new instance.
        :param pulumi.Input[str] system_disk_type: Specifies the system disk type of the instance. For details about
               disk types, see
               [Disk Types and Disk Performance](https://support.huaweicloud.com/intl/en-us/productdesc-evs/en-us_topic_0014580744.html)
               . Changing this creates a new instance. Available options are:
               + `SSD`: ultra-high I/O disk type.
               + `GPSSD`: general purpose SSD disk type.
               + `SAS`: high I/O disk type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the instance. Changing this creates
               a new instance.
        :param pulumi.Input[str] user_data: Specifies the user data to be injected during the instance creation. Text
               and text files can be injected. `user_data` can come from a variety of sources: inline, read in from the
               *file* function. Changing this creates a new instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "nics", nics)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bandwidth_charge_mode is not None:
            pulumi.set(__self__, "bandwidth_charge_mode", bandwidth_charge_mode)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if eip_charge_mode is not None:
            pulumi.set(__self__, "eip_charge_mode", eip_charge_mode)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if iptype is not None:
            pulumi.set(__self__, "iptype", iptype)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if sharetype is not None:
            pulumi.set(__self__, "sharetype", sharetype)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_type is not None:
            pulumi.set(__self__, "system_disk_type", system_disk_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the availability zone in which to create the instance.
        Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?BMS)
        for the values. Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[str]:
        """
        Specifies the flavor ID of the desired flavor for the instance. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        Specifies the image ID of the desired image for the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def nics(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceNicArgs']]]:
        """
        Specifies an array of one or more networks to attach to the instance. The network
        object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceNicArgs']]]):
        pulumi.set(self, "nics", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        Specifies the user ID. You can obtain the user ID from My Credential on the
        management console. Changing this creates a new instance.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies id of vpc in which to create the instance. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the administrative password to assign to the instance. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IAM agency name which is created on IAM to provide
        temporary credentials for BMS to access cloud services. Changing this creates a new instance.
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agency_name", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false", defaults to *false*. Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth billing type. Available options are:
        + `traffic`: billing mode is traffic.
        + `bandwidth`: billing mode is bandwidth.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @bandwidth_charge_mode.setter
    def bandwidth_charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_charge_mode", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        """
        Bandwidth size. Changing this creates a new instance.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the instance. Valid value is *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        Specifies an array of one or more data disks to attach to the instance. The
        data_disks object structure is documented below. A maximum of 59 disks can be mounted. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="eipChargeMode")
    def eip_charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic IP billing type. If the bandwidth billing mode is bandwidth,
        both prePaid and postPaid are supported. If the bandwidth billing mode is traffic, only postPaid is supported.
        Changing this creates a new instance. Available options are:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        """
        return pulumi.get(self, "eip_charge_mode")

    @eip_charge_mode.setter
    def eip_charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_charge_mode", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the EIP. Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique id in UUID format of enterprise project .
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def iptype(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic IP type. Changing this creates a new instance.
        Available options are:
        + `5_bgp`: dynamic BGP.
        + `5_sbgp`: static BGP.
        """
        return pulumi.get(self, "iptype")

    @iptype.setter
    def iptype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iptype", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a key pair to put on the instance. The key pair must
        already be created and associated with the tenant's account. Changing this creates a new instance.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique name for the instance. The name consists of 1 to 63 characters,
        including letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value is 1. This parameter is mandatory
        if `charging_mode` is set to *prePaid*. Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance. Valid values are *
        month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the instance. If omitted, the
        provider-level region will be used. Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of one or more security group IDs to associate with
        the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def sharetype(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth sharing type. Changing this creates a new instance. Available
        options are:
        + `PER`: indicates dedicated bandwidth.
        + `WHOLE`: indicates shared bandwidth.
        """
        return pulumi.get(self, "sharetype")

    @sharetype.setter
    def sharetype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharetype", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the system disk size in GB. The value ranges from 40 to 1024.
        The system disk size must be greater than or equal to the minimum system disk size of the image. Changing this creates
        a new instance.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the system disk type of the instance. For details about
        disk types, see
        [Disk Types and Disk Performance](https://support.huaweicloud.com/intl/en-us/productdesc-evs/en-us_topic_0014580744.html)
        . Changing this creates a new instance. Available options are:
        + `SSD`: ultra-high I/O disk type.
        + `GPSSD`: general purpose SSD disk type.
        + `SAS`: high I/O disk type.
        """
        return pulumi.get(self, "system_disk_type")

    @system_disk_type.setter
    def system_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the instance. Changing this creates
        a new instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user data to be injected during the instance creation. Text
        and text files can be injected. `user_data` can come from a variety of sources: inline, read in from the
        *file* function. Changing this creates a new instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 agency_name: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 eip_charge_mode: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNicArgs']]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] admin_pass: Specifies the administrative password to assign to the instance. Changing
               this creates a new instance.
        :param pulumi.Input[str] agency_name: Specifies the IAM agency name which is created on IAM to provide
               temporary credentials for BMS to access cloud services. Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false", defaults to *false*. Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the instance.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?BMS)
               for the values. Changing this creates a new instance.
        :param pulumi.Input[str] bandwidth_charge_mode: Bandwidth billing type. Available options are:
               + `traffic`: billing mode is traffic.
               + `bandwidth`: billing mode is bandwidth.
        :param pulumi.Input[int] bandwidth_size: Bandwidth size. Changing this creates a new instance.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid value is *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: Specifies an array of one or more data disks to attach to the instance. The
               data_disks object structure is documented below. A maximum of 59 disks can be mounted. Changing this creates a new
               instance.
        :param pulumi.Input[str] description: The description of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_ids: The ID of disks attached.
        :param pulumi.Input[str] eip_charge_mode: Elastic IP billing type. If the bandwidth billing mode is bandwidth,
               both prePaid and postPaid are supported. If the bandwidth billing mode is traffic, only postPaid is supported.
               Changing this creates a new instance. Available options are:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
        :param pulumi.Input[str] eip_id: The ID of the EIP. Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique id in UUID format of enterprise project .
               Changing this creates a new instance.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of the desired flavor for the instance. Changing
               this creates a new instance.
        :param pulumi.Input[str] host_id: The host ID of the instance.
        :param pulumi.Input[str] image_id: Specifies the image ID of the desired image for the instance. Changing this
               creates a new instance.
        :param pulumi.Input[str] image_name: The image_name of the instance.
        :param pulumi.Input[str] iptype: Elastic IP type. Changing this creates a new instance.
               Available options are:
               + `5_bgp`: dynamic BGP.
               + `5_sbgp`: static BGP.
        :param pulumi.Input[str] key_pair: Specifies the name of a key pair to put on the instance. The key pair must
               already be created and associated with the tenant's account. Changing this creates a new instance.
        :param pulumi.Input[str] name: Specifies a unique name for the instance. The name consists of 1 to 63 characters,
               including letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNicArgs']]] nics: Specifies an array of one or more networks to attach to the instance. The network
               object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value is 1. This parameter is mandatory
               if `charging_mode` is set to *prePaid*. Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance. Valid values are *
               month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
               instance.
        :param pulumi.Input[str] public_ip: The EIP address that is associted to the instance.
               * `nics/mac_address` - The MAC address of the nic.
               * `nics/port_id` - The port ID corresponding to the IP address.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance. If omitted, the
               provider-level region will be used. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies an array of one or more security group IDs to associate with
               the instance. Changing this creates a new instance.
        :param pulumi.Input[str] sharetype: Bandwidth sharing type. Changing this creates a new instance. Available
               options are:
               + `PER`: indicates dedicated bandwidth.
               + `WHOLE`: indicates shared bandwidth.
        :param pulumi.Input[str] status: The status of the instance.
        :param pulumi.Input[int] system_disk_size: Specifies the system disk size in GB. The value ranges from 40 to 1024.
               The system disk size must be greater than or equal to the minimum system disk size of the image. Changing this creates
               a new instance.
        :param pulumi.Input[str] system_disk_type: Specifies the system disk type of the instance. For details about
               disk types, see
               [Disk Types and Disk Performance](https://support.huaweicloud.com/intl/en-us/productdesc-evs/en-us_topic_0014580744.html)
               . Changing this creates a new instance. Available options are:
               + `SSD`: ultra-high I/O disk type.
               + `GPSSD`: general purpose SSD disk type.
               + `SAS`: high I/O disk type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the instance. Changing this creates
               a new instance.
        :param pulumi.Input[str] user_data: Specifies the user data to be injected during the instance creation. Text
               and text files can be injected. `user_data` can come from a variety of sources: inline, read in from the
               *file* function. Changing this creates a new instance.
        :param pulumi.Input[str] user_id: Specifies the user ID. You can obtain the user ID from My Credential on the
               management console. Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies id of vpc in which to create the instance. Changing this creates a
               new instance.
        """
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bandwidth_charge_mode is not None:
            pulumi.set(__self__, "bandwidth_charge_mode", bandwidth_charge_mode)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_ids is not None:
            pulumi.set(__self__, "disk_ids", disk_ids)
        if eip_charge_mode is not None:
            pulumi.set(__self__, "eip_charge_mode", eip_charge_mode)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if iptype is not None:
            pulumi.set(__self__, "iptype", iptype)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if sharetype is not None:
            pulumi.set(__self__, "sharetype", sharetype)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_type is not None:
            pulumi.set(__self__, "system_disk_type", system_disk_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the administrative password to assign to the instance. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IAM agency name which is created on IAM to provide
        temporary credentials for BMS to access cloud services. Changing this creates a new instance.
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agency_name", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false", defaults to *false*. Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone in which to create the instance.
        Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?BMS)
        for the values. Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth billing type. Available options are:
        + `traffic`: billing mode is traffic.
        + `bandwidth`: billing mode is bandwidth.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @bandwidth_charge_mode.setter
    def bandwidth_charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_charge_mode", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        """
        Bandwidth size. Changing this creates a new instance.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the instance. Valid value is *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        Specifies an array of one or more data disks to attach to the instance. The
        data_disks object structure is documented below. A maximum of 59 disks can be mounted. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of disks attached.
        """
        return pulumi.get(self, "disk_ids")

    @disk_ids.setter
    def disk_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disk_ids", value)

    @property
    @pulumi.getter(name="eipChargeMode")
    def eip_charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic IP billing type. If the bandwidth billing mode is bandwidth,
        both prePaid and postPaid are supported. If the bandwidth billing mode is traffic, only postPaid is supported.
        Changing this creates a new instance. Available options are:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        """
        return pulumi.get(self, "eip_charge_mode")

    @eip_charge_mode.setter
    def eip_charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_charge_mode", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the EIP. Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique id in UUID format of enterprise project .
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor ID of the desired flavor for the instance. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The host ID of the instance.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image ID of the desired image for the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The image_name of the instance.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter
    def iptype(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic IP type. Changing this creates a new instance.
        Available options are:
        + `5_bgp`: dynamic BGP.
        + `5_sbgp`: static BGP.
        """
        return pulumi.get(self, "iptype")

    @iptype.setter
    def iptype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iptype", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a key pair to put on the instance. The key pair must
        already be created and associated with the tenant's account. Changing this creates a new instance.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique name for the instance. The name consists of 1 to 63 characters,
        including letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNicArgs']]]]:
        """
        Specifies an array of one or more networks to attach to the instance. The network
        object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNicArgs']]]]):
        pulumi.set(self, "nics", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value is 1. This parameter is mandatory
        if `charging_mode` is set to *prePaid*. Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance. Valid values are *
        month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP address that is associted to the instance.
        * `nics/mac_address` - The MAC address of the nic.
        * `nics/port_id` - The port ID corresponding to the IP address.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the instance. If omitted, the
        provider-level region will be used. Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of one or more security group IDs to associate with
        the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def sharetype(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth sharing type. Changing this creates a new instance. Available
        options are:
        + `PER`: indicates dedicated bandwidth.
        + `WHOLE`: indicates shared bandwidth.
        """
        return pulumi.get(self, "sharetype")

    @sharetype.setter
    def sharetype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharetype", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the system disk size in GB. The value ranges from 40 to 1024.
        The system disk size must be greater than or equal to the minimum system disk size of the image. Changing this creates
        a new instance.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the system disk type of the instance. For details about
        disk types, see
        [Disk Types and Disk Performance](https://support.huaweicloud.com/intl/en-us/productdesc-evs/en-us_topic_0014580744.html)
        . Changing this creates a new instance. Available options are:
        + `SSD`: ultra-high I/O disk type.
        + `GPSSD`: general purpose SSD disk type.
        + `SAS`: high I/O disk type.
        """
        return pulumi.get(self, "system_disk_type")

    @system_disk_type.setter
    def system_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the instance. Changing this creates
        a new instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user data to be injected during the instance creation. Text
        and text files can be injected. `user_data` can come from a variety of sources: inline, read in from the
        *file* function. Changing this creates a new instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user ID. You can obtain the user ID from My Credential on the
        management console. Changing this creates a new instance.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies id of vpc in which to create the instance. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 agency_name: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]]] = None,
                 eip_charge_mode: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNicArgs']]]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a BMS instance resource within HuaweiCloud.

        ## Example Usage
        ### Basic Instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_name = config.require_object("instanceName")
        image_id = config.require_object("imageId")
        flavor_id = config.require_object("flavorId")
        user_id = config.require_object("userId")
        key_pair = config.require_object("keyPair")
        eip_id = config.require_object("eipId")
        enterprise_project_id = config.require_object("enterpriseProjectId")
        myaz = huaweicloud.get_availability_zones()
        myvpc = huaweicloud.Vpc.get_vpc(name="vpc-default")
        mynet = huaweicloud.Vpc.get_subnet(name="subnet-default")
        mysecgroup = huaweicloud.Vpc.get_secgroup(name="default")
        test = huaweicloud.bms.Instance("test",
            image_id=image_id,
            flavor_id=flavor_id,
            user_id=user_id,
            security_groups=[mysecgroup.id],
            availability_zone=myaz.names[0],
            vpc_id=myvpc.id,
            eip_id=huaweicloud_vpc_eip["myeip"]["id"],
            charging_mode="prePaid",
            period_unit="month",
            period=1,
            key_pair=key_pair,
            enterprise_project_id=enterprise_project_id,
            system_disk_size=150,
            system_disk_type="SSD",
            data_disks=[huaweicloud.bms.InstanceDataDiskArgs(
                type="SSD",
                size=100,
            )],
            nics=[huaweicloud.bms.InstanceNicArgs(
                subnet_id=mynet.id,
                ip_address="192.168.0.123",
            )],
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the administrative password to assign to the instance. Changing
               this creates a new instance.
        :param pulumi.Input[str] agency_name: Specifies the IAM agency name which is created on IAM to provide
               temporary credentials for BMS to access cloud services. Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false", defaults to *false*. Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the instance.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?BMS)
               for the values. Changing this creates a new instance.
        :param pulumi.Input[str] bandwidth_charge_mode: Bandwidth billing type. Available options are:
               + `traffic`: billing mode is traffic.
               + `bandwidth`: billing mode is bandwidth.
        :param pulumi.Input[int] bandwidth_size: Bandwidth size. Changing this creates a new instance.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid value is *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]] data_disks: Specifies an array of one or more data disks to attach to the instance. The
               data_disks object structure is documented below. A maximum of 59 disks can be mounted. Changing this creates a new
               instance.
        :param pulumi.Input[str] eip_charge_mode: Elastic IP billing type. If the bandwidth billing mode is bandwidth,
               both prePaid and postPaid are supported. If the bandwidth billing mode is traffic, only postPaid is supported.
               Changing this creates a new instance. Available options are:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
        :param pulumi.Input[str] eip_id: The ID of the EIP. Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique id in UUID format of enterprise project .
               Changing this creates a new instance.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of the desired flavor for the instance. Changing
               this creates a new instance.
        :param pulumi.Input[str] image_id: Specifies the image ID of the desired image for the instance. Changing this
               creates a new instance.
        :param pulumi.Input[str] iptype: Elastic IP type. Changing this creates a new instance.
               Available options are:
               + `5_bgp`: dynamic BGP.
               + `5_sbgp`: static BGP.
        :param pulumi.Input[str] key_pair: Specifies the name of a key pair to put on the instance. The key pair must
               already be created and associated with the tenant's account. Changing this creates a new instance.
        :param pulumi.Input[str] name: Specifies a unique name for the instance. The name consists of 1 to 63 characters,
               including letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNicArgs']]]] nics: Specifies an array of one or more networks to attach to the instance. The network
               object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value is 1. This parameter is mandatory
               if `charging_mode` is set to *prePaid*. Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance. Valid values are *
               month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
               instance.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance. If omitted, the
               provider-level region will be used. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies an array of one or more security group IDs to associate with
               the instance. Changing this creates a new instance.
        :param pulumi.Input[str] sharetype: Bandwidth sharing type. Changing this creates a new instance. Available
               options are:
               + `PER`: indicates dedicated bandwidth.
               + `WHOLE`: indicates shared bandwidth.
        :param pulumi.Input[int] system_disk_size: Specifies the system disk size in GB. The value ranges from 40 to 1024.
               The system disk size must be greater than or equal to the minimum system disk size of the image. Changing this creates
               a new instance.
        :param pulumi.Input[str] system_disk_type: Specifies the system disk type of the instance. For details about
               disk types, see
               [Disk Types and Disk Performance](https://support.huaweicloud.com/intl/en-us/productdesc-evs/en-us_topic_0014580744.html)
               . Changing this creates a new instance. Available options are:
               + `SSD`: ultra-high I/O disk type.
               + `GPSSD`: general purpose SSD disk type.
               + `SAS`: high I/O disk type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the instance. Changing this creates
               a new instance.
        :param pulumi.Input[str] user_data: Specifies the user data to be injected during the instance creation. Text
               and text files can be injected. `user_data` can come from a variety of sources: inline, read in from the
               *file* function. Changing this creates a new instance.
        :param pulumi.Input[str] user_id: Specifies the user ID. You can obtain the user ID from My Credential on the
               management console. Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies id of vpc in which to create the instance. Changing this creates a
               new instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a BMS instance resource within HuaweiCloud.

        ## Example Usage
        ### Basic Instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_name = config.require_object("instanceName")
        image_id = config.require_object("imageId")
        flavor_id = config.require_object("flavorId")
        user_id = config.require_object("userId")
        key_pair = config.require_object("keyPair")
        eip_id = config.require_object("eipId")
        enterprise_project_id = config.require_object("enterpriseProjectId")
        myaz = huaweicloud.get_availability_zones()
        myvpc = huaweicloud.Vpc.get_vpc(name="vpc-default")
        mynet = huaweicloud.Vpc.get_subnet(name="subnet-default")
        mysecgroup = huaweicloud.Vpc.get_secgroup(name="default")
        test = huaweicloud.bms.Instance("test",
            image_id=image_id,
            flavor_id=flavor_id,
            user_id=user_id,
            security_groups=[mysecgroup.id],
            availability_zone=myaz.names[0],
            vpc_id=myvpc.id,
            eip_id=huaweicloud_vpc_eip["myeip"]["id"],
            charging_mode="prePaid",
            period_unit="month",
            period=1,
            key_pair=key_pair,
            enterprise_project_id=enterprise_project_id,
            system_disk_size=150,
            system_disk_type="SSD",
            data_disks=[huaweicloud.bms.InstanceDataDiskArgs(
                type="SSD",
                size=100,
            )],
            nics=[huaweicloud.bms.InstanceNicArgs(
                subnet_id=mynet.id,
                ip_address="192.168.0.123",
            )],
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 agency_name: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]]] = None,
                 eip_charge_mode: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNicArgs']]]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 system_disk_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["admin_pass"] = admin_pass
            __props__.__dict__["agency_name"] = agency_name
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["bandwidth_charge_mode"] = bandwidth_charge_mode
            __props__.__dict__["bandwidth_size"] = bandwidth_size
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["eip_charge_mode"] = eip_charge_mode
            __props__.__dict__["eip_id"] = eip_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["iptype"] = iptype
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["name"] = name
            if nics is None and not opts.urn:
                raise TypeError("Missing required property 'nics'")
            __props__.__dict__["nics"] = nics
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["sharetype"] = sharetype
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["system_disk_type"] = system_disk_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["description"] = None
            __props__.__dict__["disk_ids"] = None
            __props__.__dict__["host_id"] = None
            __props__.__dict__["image_name"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'huaweicloud:Bms/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_pass: Optional[pulumi.Input[str]] = None,
            agency_name: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
            bandwidth_size: Optional[pulumi.Input[int]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            eip_charge_mode: Optional[pulumi.Input[str]] = None,
            eip_id: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            host_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            image_name: Optional[pulumi.Input[str]] = None,
            iptype: Optional[pulumi.Input[str]] = None,
            key_pair: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNicArgs']]]]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sharetype: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_disk_size: Optional[pulumi.Input[int]] = None,
            system_disk_type: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the administrative password to assign to the instance. Changing
               this creates a new instance.
        :param pulumi.Input[str] agency_name: Specifies the IAM agency name which is created on IAM to provide
               temporary credentials for BMS to access cloud services. Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false", defaults to *false*. Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the instance.
               Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?BMS)
               for the values. Changing this creates a new instance.
        :param pulumi.Input[str] bandwidth_charge_mode: Bandwidth billing type. Available options are:
               + `traffic`: billing mode is traffic.
               + `bandwidth`: billing mode is bandwidth.
        :param pulumi.Input[int] bandwidth_size: Bandwidth size. Changing this creates a new instance.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid value is *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]] data_disks: Specifies an array of one or more data disks to attach to the instance. The
               data_disks object structure is documented below. A maximum of 59 disks can be mounted. Changing this creates a new
               instance.
        :param pulumi.Input[str] description: The description of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_ids: The ID of disks attached.
        :param pulumi.Input[str] eip_charge_mode: Elastic IP billing type. If the bandwidth billing mode is bandwidth,
               both prePaid and postPaid are supported. If the bandwidth billing mode is traffic, only postPaid is supported.
               Changing this creates a new instance. Available options are:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
        :param pulumi.Input[str] eip_id: The ID of the EIP. Changing this creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies a unique id in UUID format of enterprise project .
               Changing this creates a new instance.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of the desired flavor for the instance. Changing
               this creates a new instance.
        :param pulumi.Input[str] host_id: The host ID of the instance.
        :param pulumi.Input[str] image_id: Specifies the image ID of the desired image for the instance. Changing this
               creates a new instance.
        :param pulumi.Input[str] image_name: The image_name of the instance.
        :param pulumi.Input[str] iptype: Elastic IP type. Changing this creates a new instance.
               Available options are:
               + `5_bgp`: dynamic BGP.
               + `5_sbgp`: static BGP.
        :param pulumi.Input[str] key_pair: Specifies the name of a key pair to put on the instance. The key pair must
               already be created and associated with the tenant's account. Changing this creates a new instance.
        :param pulumi.Input[str] name: Specifies a unique name for the instance. The name consists of 1 to 63 characters,
               including letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNicArgs']]]] nics: Specifies an array of one or more networks to attach to the instance. The network
               object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value is 1. This parameter is mandatory
               if `charging_mode` is set to *prePaid*. Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance. Valid values are *
               month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
               instance.
        :param pulumi.Input[str] public_ip: The EIP address that is associted to the instance.
               * `nics/mac_address` - The MAC address of the nic.
               * `nics/port_id` - The port ID corresponding to the IP address.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance. If omitted, the
               provider-level region will be used. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies an array of one or more security group IDs to associate with
               the instance. Changing this creates a new instance.
        :param pulumi.Input[str] sharetype: Bandwidth sharing type. Changing this creates a new instance. Available
               options are:
               + `PER`: indicates dedicated bandwidth.
               + `WHOLE`: indicates shared bandwidth.
        :param pulumi.Input[str] status: The status of the instance.
        :param pulumi.Input[int] system_disk_size: Specifies the system disk size in GB. The value ranges from 40 to 1024.
               The system disk size must be greater than or equal to the minimum system disk size of the image. Changing this creates
               a new instance.
        :param pulumi.Input[str] system_disk_type: Specifies the system disk type of the instance. For details about
               disk types, see
               [Disk Types and Disk Performance](https://support.huaweicloud.com/intl/en-us/productdesc-evs/en-us_topic_0014580744.html)
               . Changing this creates a new instance. Available options are:
               + `SSD`: ultra-high I/O disk type.
               + `GPSSD`: general purpose SSD disk type.
               + `SAS`: high I/O disk type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the instance. Changing this creates
               a new instance.
        :param pulumi.Input[str] user_data: Specifies the user data to be injected during the instance creation. Text
               and text files can be injected. `user_data` can come from a variety of sources: inline, read in from the
               *file* function. Changing this creates a new instance.
        :param pulumi.Input[str] user_id: Specifies the user ID. You can obtain the user ID from My Credential on the
               management console. Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies id of vpc in which to create the instance. Changing this creates a
               new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["admin_pass"] = admin_pass
        __props__.__dict__["agency_name"] = agency_name
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["bandwidth_charge_mode"] = bandwidth_charge_mode
        __props__.__dict__["bandwidth_size"] = bandwidth_size
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_ids"] = disk_ids
        __props__.__dict__["eip_charge_mode"] = eip_charge_mode
        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["host_id"] = host_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["iptype"] = iptype
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["name"] = name
        __props__.__dict__["nics"] = nics
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["sharetype"] = sharetype
        __props__.__dict__["status"] = status
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["system_disk_type"] = system_disk_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["vpc_id"] = vpc_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the administrative password to assign to the instance. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "admin_pass")

    @property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the IAM agency name which is created on IAM to provide
        temporary credentials for BMS to access cloud services. Changing this creates a new instance.
        """
        return pulumi.get(self, "agency_name")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false", defaults to *false*. Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone in which to create the instance.
        Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?BMS)
        for the values. Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Bandwidth billing type. Available options are:
        + `traffic`: billing mode is traffic.
        + `bandwidth`: billing mode is bandwidth.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> pulumi.Output[Optional[int]]:
        """
        Bandwidth size. Changing this creates a new instance.
        """
        return pulumi.get(self, "bandwidth_size")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the instance. Valid value is *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceDataDisk']]]:
        """
        Specifies an array of one or more data disks to attach to the instance. The
        data_disks object structure is documented below. A maximum of 59 disks can be mounted. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The ID of disks attached.
        """
        return pulumi.get(self, "disk_ids")

    @property
    @pulumi.getter(name="eipChargeMode")
    def eip_charge_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Elastic IP billing type. If the bandwidth billing mode is bandwidth,
        both prePaid and postPaid are supported. If the bandwidth billing mode is traffic, only postPaid is supported.
        Changing this creates a new instance. Available options are:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        """
        return pulumi.get(self, "eip_charge_mode")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the EIP. Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies a unique id in UUID format of enterprise project .
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        Specifies the flavor ID of the desired flavor for the instance. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[str]:
        """
        The host ID of the instance.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        Specifies the image ID of the desired image for the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[str]:
        """
        The image_name of the instance.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter
    def iptype(self) -> pulumi.Output[Optional[str]]:
        """
        Elastic IP type. Changing this creates a new instance.
        Available options are:
        + `5_bgp`: dynamic BGP.
        + `5_sbgp`: static BGP.
        """
        return pulumi.get(self, "iptype")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the name of a key pair to put on the instance. The key pair must
        already be created and associated with the tenant's account. Changing this creates a new instance.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies a unique name for the instance. The name consists of 1 to 63 characters,
        including letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nics(self) -> pulumi.Output[Sequence['outputs.InstanceNic']]:
        """
        Specifies an array of one or more networks to attach to the instance. The network
        object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "nics")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value is 1. This parameter is mandatory
        if `charging_mode` is set to *prePaid*. Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the instance. Valid values are *
        month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The EIP address that is associted to the instance.
        * `nics/mac_address` - The MAC address of the nic.
        * `nics/port_id` - The port ID corresponding to the IP address.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the instance. If omitted, the
        provider-level region will be used. Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies an array of one or more security group IDs to associate with
        the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def sharetype(self) -> pulumi.Output[Optional[str]]:
        """
        Bandwidth sharing type. Changing this creates a new instance. Available
        options are:
        + `PER`: indicates dedicated bandwidth.
        + `WHOLE`: indicates shared bandwidth.
        """
        return pulumi.get(self, "sharetype")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the system disk size in GB. The value ranges from 40 to 1024.
        The system disk size must be greater than or equal to the minimum system disk size of the image. Changing this creates
        a new instance.
        """
        return pulumi.get(self, "system_disk_size")

    @property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the system disk type of the instance. For details about
        disk types, see
        [Disk Types and Disk Performance](https://support.huaweicloud.com/intl/en-us/productdesc-evs/en-us_topic_0014580744.html)
        . Changing this creates a new instance. Available options are:
        + `SSD`: ultra-high I/O disk type.
        + `GPSSD`: general purpose SSD disk type.
        + `SAS`: high I/O disk type.
        """
        return pulumi.get(self, "system_disk_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the instance. Changing this creates
        a new instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the user data to be injected during the instance creation. Text
        and text files can be injected. `user_data` can come from a variety of sources: inline, read in from the
        *file* function. Changing this creates a new instance.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        Specifies the user ID. You can obtain the user ID from My Credential on the
        management console. Changing this creates a new instance.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies id of vpc in which to create the instance. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "vpc_id")

