# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LifecycleHookArgs', 'LifecycleHook']

@pulumi.input_type
class LifecycleHookArgs:
    def __init__(__self__, *,
                 notification_topic_urn: pulumi.Input[str],
                 scaling_group_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 default_result: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_message: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a LifecycleHook resource.
        :param pulumi.Input[str] notification_topic_urn: Specifies a unique topic in SMN.
        :param pulumi.Input[str] scaling_group_id: Specifies the ID of the AS group in UUID format. Changing this
               creates a new AS lifecycle hook.
        :param pulumi.Input[str] type: Specifies the lifecycle hook type. The valid values are following strings:
               + `ADD`: The hook suspends the instance when the instance is started.
               + `REMOVE`: The hook suspends the instance when the instance is terminated.
        :param pulumi.Input[str] default_result: Specifies the default lifecycle hook callback operation. This operation is
               performed when the timeout duration expires. The valid values are *ABANDON* and *CONTINUE*, default to *ABANDON*.
        :param pulumi.Input[str] name: Specifies the lifecycle hook name. This parameter can contain a maximum of 32 characters,
               which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] notification_message: Specifies a customized notification. This parameter can contains a maximum
               of 256 characters, which cannot contain the following characters: <>&'().
        :param pulumi.Input[str] region: The region in which to create the AS lifecycle hook. If omitted, the `region`
               argument of the provider is used. Changing this creates a new AS lifecycle hook.
        :param pulumi.Input[int] timeout: Specifies the lifecycle hook timeout duration, which ranges from 300 to 86400 in the unit
               of second, default to 3600.
        """
        pulumi.set(__self__, "notification_topic_urn", notification_topic_urn)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "type", type)
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_message is not None:
            pulumi.set(__self__, "notification_message", notification_message)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="notificationTopicUrn")
    def notification_topic_urn(self) -> pulumi.Input[str]:
        """
        Specifies a unique topic in SMN.
        """
        return pulumi.get(self, "notification_topic_urn")

    @notification_topic_urn.setter
    def notification_topic_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "notification_topic_urn", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the AS group in UUID format. Changing this
        creates a new AS lifecycle hook.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the lifecycle hook type. The valid values are following strings:
        + `ADD`: The hook suspends the instance when the instance is started.
        + `REMOVE`: The hook suspends the instance when the instance is terminated.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default lifecycle hook callback operation. This operation is
        performed when the timeout duration expires. The valid values are *ABANDON* and *CONTINUE*, default to *ABANDON*.
        """
        return pulumi.get(self, "default_result")

    @default_result.setter
    def default_result(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_result", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the lifecycle hook name. This parameter can contain a maximum of 32 characters,
        which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationMessage")
    def notification_message(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a customized notification. This parameter can contains a maximum
        of 256 characters, which cannot contain the following characters: <>&'().
        """
        return pulumi.get(self, "notification_message")

    @notification_message.setter
    def notification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_message", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the AS lifecycle hook. If omitted, the `region`
        argument of the provider is used. Changing this creates a new AS lifecycle hook.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the lifecycle hook timeout duration, which ranges from 300 to 86400 in the unit
        of second, default to 3600.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _LifecycleHookState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 default_result: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_message: Optional[pulumi.Input[str]] = None,
                 notification_topic_name: Optional[pulumi.Input[str]] = None,
                 notification_topic_urn: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LifecycleHook resources.
        :param pulumi.Input[str] create_time: The server time in UTC format when the lifecycle hook is created.
        :param pulumi.Input[str] default_result: Specifies the default lifecycle hook callback operation. This operation is
               performed when the timeout duration expires. The valid values are *ABANDON* and *CONTINUE*, default to *ABANDON*.
        :param pulumi.Input[str] name: Specifies the lifecycle hook name. This parameter can contain a maximum of 32 characters,
               which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] notification_message: Specifies a customized notification. This parameter can contains a maximum
               of 256 characters, which cannot contain the following characters: <>&'().
        :param pulumi.Input[str] notification_topic_name: The topic name in SMN.
        :param pulumi.Input[str] notification_topic_urn: Specifies a unique topic in SMN.
        :param pulumi.Input[str] region: The region in which to create the AS lifecycle hook. If omitted, the `region`
               argument of the provider is used. Changing this creates a new AS lifecycle hook.
        :param pulumi.Input[str] scaling_group_id: Specifies the ID of the AS group in UUID format. Changing this
               creates a new AS lifecycle hook.
        :param pulumi.Input[int] timeout: Specifies the lifecycle hook timeout duration, which ranges from 300 to 86400 in the unit
               of second, default to 3600.
        :param pulumi.Input[str] type: Specifies the lifecycle hook type. The valid values are following strings:
               + `ADD`: The hook suspends the instance when the instance is started.
               + `REMOVE`: The hook suspends the instance when the instance is terminated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_message is not None:
            pulumi.set(__self__, "notification_message", notification_message)
        if notification_topic_name is not None:
            pulumi.set(__self__, "notification_topic_name", notification_topic_name)
        if notification_topic_urn is not None:
            pulumi.set(__self__, "notification_topic_urn", notification_topic_urn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The server time in UTC format when the lifecycle hook is created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default lifecycle hook callback operation. This operation is
        performed when the timeout duration expires. The valid values are *ABANDON* and *CONTINUE*, default to *ABANDON*.
        """
        return pulumi.get(self, "default_result")

    @default_result.setter
    def default_result(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_result", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the lifecycle hook name. This parameter can contain a maximum of 32 characters,
        which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationMessage")
    def notification_message(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a customized notification. This parameter can contains a maximum
        of 256 characters, which cannot contain the following characters: <>&'().
        """
        return pulumi.get(self, "notification_message")

    @notification_message.setter
    def notification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_message", value)

    @property
    @pulumi.getter(name="notificationTopicName")
    def notification_topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        The topic name in SMN.
        """
        return pulumi.get(self, "notification_topic_name")

    @notification_topic_name.setter
    def notification_topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_topic_name", value)

    @property
    @pulumi.getter(name="notificationTopicUrn")
    def notification_topic_urn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique topic in SMN.
        """
        return pulumi.get(self, "notification_topic_urn")

    @notification_topic_urn.setter
    def notification_topic_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_topic_urn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the AS lifecycle hook. If omitted, the `region`
        argument of the provider is used. Changing this creates a new AS lifecycle hook.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the AS group in UUID format. Changing this
        creates a new AS lifecycle hook.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the lifecycle hook timeout duration, which ranges from 300 to 86400 in the unit
        of second, default to 3600.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the lifecycle hook type. The valid values are following strings:
        + `ADD`: The hook suspends the instance when the instance is started.
        + `REMOVE`: The hook suspends the instance when the instance is terminated.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class LifecycleHook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_result: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_message: Optional[pulumi.Input[str]] = None,
                 notification_topic_urn: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an AS Lifecycle Hook resource within HuaweiCloud.

        ## Example Usage
        ### Basic Lifecycle Hook

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        hook_name = config.require_object("hookName")
        as_group_id = config.require_object("asGroupId")
        smn_topic_urn = config.require_object("smnTopicUrn")
        test = huaweicloud.as_.LifecycleHook("test",
            type="ADD",
            scaling_group_id=as_group_id,
            default_result="ABANDON",
            notification_topic_urn=smn_topic_urn,
            notification_message="This is a test message")
        ```

        ## Import

        Lifecycle hooks can be imported using the AS group ID and hook ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:As/lifecycleHook:LifecycleHook test <AS group ID>/<Lifecycle hook ID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_result: Specifies the default lifecycle hook callback operation. This operation is
               performed when the timeout duration expires. The valid values are *ABANDON* and *CONTINUE*, default to *ABANDON*.
        :param pulumi.Input[str] name: Specifies the lifecycle hook name. This parameter can contain a maximum of 32 characters,
               which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] notification_message: Specifies a customized notification. This parameter can contains a maximum
               of 256 characters, which cannot contain the following characters: <>&'().
        :param pulumi.Input[str] notification_topic_urn: Specifies a unique topic in SMN.
        :param pulumi.Input[str] region: The region in which to create the AS lifecycle hook. If omitted, the `region`
               argument of the provider is used. Changing this creates a new AS lifecycle hook.
        :param pulumi.Input[str] scaling_group_id: Specifies the ID of the AS group in UUID format. Changing this
               creates a new AS lifecycle hook.
        :param pulumi.Input[int] timeout: Specifies the lifecycle hook timeout duration, which ranges from 300 to 86400 in the unit
               of second, default to 3600.
        :param pulumi.Input[str] type: Specifies the lifecycle hook type. The valid values are following strings:
               + `ADD`: The hook suspends the instance when the instance is started.
               + `REMOVE`: The hook suspends the instance when the instance is terminated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LifecycleHookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AS Lifecycle Hook resource within HuaweiCloud.

        ## Example Usage
        ### Basic Lifecycle Hook

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        hook_name = config.require_object("hookName")
        as_group_id = config.require_object("asGroupId")
        smn_topic_urn = config.require_object("smnTopicUrn")
        test = huaweicloud.as_.LifecycleHook("test",
            type="ADD",
            scaling_group_id=as_group_id,
            default_result="ABANDON",
            notification_topic_urn=smn_topic_urn,
            notification_message="This is a test message")
        ```

        ## Import

        Lifecycle hooks can be imported using the AS group ID and hook ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:As/lifecycleHook:LifecycleHook test <AS group ID>/<Lifecycle hook ID>
        ```

        :param str resource_name: The name of the resource.
        :param LifecycleHookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LifecycleHookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_result: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_message: Optional[pulumi.Input[str]] = None,
                 notification_topic_urn: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LifecycleHookArgs.__new__(LifecycleHookArgs)

            __props__.__dict__["default_result"] = default_result
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_message"] = notification_message
            if notification_topic_urn is None and not opts.urn:
                raise TypeError("Missing required property 'notification_topic_urn'")
            __props__.__dict__["notification_topic_urn"] = notification_topic_urn
            __props__.__dict__["region"] = region
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["timeout"] = timeout
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["notification_topic_name"] = None
        super(LifecycleHook, __self__).__init__(
            'huaweicloud:As/lifecycleHook:LifecycleHook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            default_result: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_message: Optional[pulumi.Input[str]] = None,
            notification_topic_name: Optional[pulumi.Input[str]] = None,
            notification_topic_urn: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'LifecycleHook':
        """
        Get an existing LifecycleHook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The server time in UTC format when the lifecycle hook is created.
        :param pulumi.Input[str] default_result: Specifies the default lifecycle hook callback operation. This operation is
               performed when the timeout duration expires. The valid values are *ABANDON* and *CONTINUE*, default to *ABANDON*.
        :param pulumi.Input[str] name: Specifies the lifecycle hook name. This parameter can contain a maximum of 32 characters,
               which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] notification_message: Specifies a customized notification. This parameter can contains a maximum
               of 256 characters, which cannot contain the following characters: <>&'().
        :param pulumi.Input[str] notification_topic_name: The topic name in SMN.
        :param pulumi.Input[str] notification_topic_urn: Specifies a unique topic in SMN.
        :param pulumi.Input[str] region: The region in which to create the AS lifecycle hook. If omitted, the `region`
               argument of the provider is used. Changing this creates a new AS lifecycle hook.
        :param pulumi.Input[str] scaling_group_id: Specifies the ID of the AS group in UUID format. Changing this
               creates a new AS lifecycle hook.
        :param pulumi.Input[int] timeout: Specifies the lifecycle hook timeout duration, which ranges from 300 to 86400 in the unit
               of second, default to 3600.
        :param pulumi.Input[str] type: Specifies the lifecycle hook type. The valid values are following strings:
               + `ADD`: The hook suspends the instance when the instance is started.
               + `REMOVE`: The hook suspends the instance when the instance is terminated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LifecycleHookState.__new__(_LifecycleHookState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["default_result"] = default_result
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_message"] = notification_message
        __props__.__dict__["notification_topic_name"] = notification_topic_name
        __props__.__dict__["notification_topic_urn"] = notification_topic_urn
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        return LifecycleHook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The server time in UTC format when the lifecycle hook is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the default lifecycle hook callback operation. This operation is
        performed when the timeout duration expires. The valid values are *ABANDON* and *CONTINUE*, default to *ABANDON*.
        """
        return pulumi.get(self, "default_result")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the lifecycle hook name. This parameter can contain a maximum of 32 characters,
        which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationMessage")
    def notification_message(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a customized notification. This parameter can contains a maximum
        of 256 characters, which cannot contain the following characters: <>&'().
        """
        return pulumi.get(self, "notification_message")

    @property
    @pulumi.getter(name="notificationTopicName")
    def notification_topic_name(self) -> pulumi.Output[str]:
        """
        The topic name in SMN.
        """
        return pulumi.get(self, "notification_topic_name")

    @property
    @pulumi.getter(name="notificationTopicUrn")
    def notification_topic_urn(self) -> pulumi.Output[str]:
        """
        Specifies a unique topic in SMN.
        """
        return pulumi.get(self, "notification_topic_urn")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the AS lifecycle hook. If omitted, the `region`
        argument of the provider is used. Changing this creates a new AS lifecycle hook.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the AS group in UUID format. Changing this
        creates a new AS lifecycle hook.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the lifecycle hook timeout duration, which ranges from 300 to 86400 in the unit
        of second, default to 3600.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the lifecycle hook type. The valid values are following strings:
        + `ADD`: The hook suspends the instance when the instance is started.
        + `REMOVE`: The hook suspends the instance when the instance is terminated.
        """
        return pulumi.get(self, "type")

