# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ForwardRuleArgs', 'ForwardRule']

@pulumi.input_type
class ForwardRuleArgs:
    def __init__(__self__, *,
                 forward_port: pulumi.Input[int],
                 forward_protocol: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 ip: pulumi.Input[str],
                 source_ip: pulumi.Input[str],
                 source_port: pulumi.Input[int]):
        """
        The set of arguments for constructing a ForwardRule resource.
        :param pulumi.Input[int] forward_port: Specifies the forward port.
               The valid value is range from **1** to **65535**.
        :param pulumi.Input[str] forward_protocol: Specifies the forward protocol.
               The valid values are **tcp** and **udp**.
        :param pulumi.Input[str] instance_id: Specifies the ID of advanced Anti-DDoS instance.
               Changing this will create a new rule resource.
        :param pulumi.Input[str] ip: Specifies the public IP addresss to which Advanced Anti-DDoS instance
               belongs. Changing this will create a new rule resource.
        :param pulumi.Input[str] source_ip: Specifies the source IP addresses, separated by commas (,).
        :param pulumi.Input[int] source_port: Specifies the source port.
               The valid value is range from **1** to **65535**.
        """
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "forward_protocol", forward_protocol)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "source_ip", source_ip)
        pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> pulumi.Input[int]:
        """
        Specifies the forward port.
        The valid value is range from **1** to **65535**.
        """
        return pulumi.get(self, "forward_port")

    @forward_port.setter
    def forward_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "forward_port", value)

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> pulumi.Input[str]:
        """
        Specifies the forward protocol.
        The valid values are **tcp** and **udp**.
        """
        return pulumi.get(self, "forward_protocol")

    @forward_protocol.setter
    def forward_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "forward_protocol", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of advanced Anti-DDoS instance.
        Changing this will create a new rule resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        Specifies the public IP addresss to which Advanced Anti-DDoS instance
        belongs. Changing this will create a new rule resource.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Input[str]:
        """
        Specifies the source IP addresses, separated by commas (,).
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_ip", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Input[int]:
        """
        Specifies the source port.
        The valid value is range from **1** to **65535**.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "source_port", value)


@pulumi.input_type
class _ForwardRuleState:
    def __init__(__self__, *,
                 forward_port: Optional[pulumi.Input[int]] = None,
                 forward_protocol: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 lb_method: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ForwardRule resources.
        :param pulumi.Input[int] forward_port: Specifies the forward port.
               The valid value is range from **1** to **65535**.
        :param pulumi.Input[str] forward_protocol: Specifies the forward protocol.
               The valid values are **tcp** and **udp**.
        :param pulumi.Input[str] instance_id: Specifies the ID of advanced Anti-DDoS instance.
               Changing this will create a new rule resource.
        :param pulumi.Input[str] ip: Specifies the public IP addresss to which Advanced Anti-DDoS instance
               belongs. Changing this will create a new rule resource.
        :param pulumi.Input[str] lb_method: The LVS forward policy.
        :param pulumi.Input[str] rule_id: schema: Deprecated
        :param pulumi.Input[str] source_ip: Specifies the source IP addresses, separated by commas (,).
        :param pulumi.Input[int] source_port: Specifies the source port.
               The valid value is range from **1** to **65535**.
        :param pulumi.Input[int] status: The status of forward rule.
        """
        if forward_port is not None:
            pulumi.set(__self__, "forward_port", forward_port)
        if forward_protocol is not None:
            pulumi.set(__self__, "forward_protocol", forward_protocol)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if lb_method is not None:
            pulumi.set(__self__, "lb_method", lb_method)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the forward port.
        The valid value is range from **1** to **65535**.
        """
        return pulumi.get(self, "forward_port")

    @forward_port.setter
    def forward_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "forward_port", value)

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the forward protocol.
        The valid values are **tcp** and **udp**.
        """
        return pulumi.get(self, "forward_protocol")

    @forward_protocol.setter
    def forward_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forward_protocol", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of advanced Anti-DDoS instance.
        Changing this will create a new rule resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the public IP addresss to which Advanced Anti-DDoS instance
        belongs. Changing this will create a new rule resource.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> Optional[pulumi.Input[str]]:
        """
        The LVS forward policy.
        """
        return pulumi.get(self, "lb_method")

    @lb_method.setter
    def lb_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lb_method", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the source IP addresses, separated by commas (,).
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the source port.
        The valid value is range from **1** to **65535**.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_port", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The status of forward rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)


class ForwardRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 forward_port: Optional[pulumi.Input[int]] = None,
                 forward_protocol: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a forward rule resource of Advanced Anti-DDos service within HuaweiCloud.

        ## Import

        Rule can be imported using the `id` (combination of `instance_id`, `ip`, `forward_protocol` and `forward_port`), separated by slashes (/), e.g.

        ```sh
         $ pulumi import huaweicloud:AdvancedAntiDDos/forwardRule:ForwardRule test &ltinstance_id&gt/&ltip&gt/&ltforward_protocol&gt/&ltforward_port&gt
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] forward_port: Specifies the forward port.
               The valid value is range from **1** to **65535**.
        :param pulumi.Input[str] forward_protocol: Specifies the forward protocol.
               The valid values are **tcp** and **udp**.
        :param pulumi.Input[str] instance_id: Specifies the ID of advanced Anti-DDoS instance.
               Changing this will create a new rule resource.
        :param pulumi.Input[str] ip: Specifies the public IP addresss to which Advanced Anti-DDoS instance
               belongs. Changing this will create a new rule resource.
        :param pulumi.Input[str] source_ip: Specifies the source IP addresses, separated by commas (,).
        :param pulumi.Input[int] source_port: Specifies the source port.
               The valid value is range from **1** to **65535**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ForwardRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a forward rule resource of Advanced Anti-DDos service within HuaweiCloud.

        ## Import

        Rule can be imported using the `id` (combination of `instance_id`, `ip`, `forward_protocol` and `forward_port`), separated by slashes (/), e.g.

        ```sh
         $ pulumi import huaweicloud:AdvancedAntiDDos/forwardRule:ForwardRule test &ltinstance_id&gt/&ltip&gt/&ltforward_protocol&gt/&ltforward_port&gt
        ```

        :param str resource_name: The name of the resource.
        :param ForwardRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ForwardRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 forward_port: Optional[pulumi.Input[int]] = None,
                 forward_protocol: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ForwardRuleArgs.__new__(ForwardRuleArgs)

            if forward_port is None and not opts.urn:
                raise TypeError("Missing required property 'forward_port'")
            __props__.__dict__["forward_port"] = forward_port
            if forward_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'forward_protocol'")
            __props__.__dict__["forward_protocol"] = forward_protocol
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if ip is None and not opts.urn:
                raise TypeError("Missing required property 'ip'")
            __props__.__dict__["ip"] = ip
            if source_ip is None and not opts.urn:
                raise TypeError("Missing required property 'source_ip'")
            __props__.__dict__["source_ip"] = source_ip
            if source_port is None and not opts.urn:
                raise TypeError("Missing required property 'source_port'")
            __props__.__dict__["source_port"] = source_port
            __props__.__dict__["lb_method"] = None
            __props__.__dict__["rule_id"] = None
            __props__.__dict__["status"] = None
        super(ForwardRule, __self__).__init__(
            'huaweicloud:AdvancedAntiDDos/forwardRule:ForwardRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            forward_port: Optional[pulumi.Input[int]] = None,
            forward_protocol: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            ip: Optional[pulumi.Input[str]] = None,
            lb_method: Optional[pulumi.Input[str]] = None,
            rule_id: Optional[pulumi.Input[str]] = None,
            source_ip: Optional[pulumi.Input[str]] = None,
            source_port: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[int]] = None) -> 'ForwardRule':
        """
        Get an existing ForwardRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] forward_port: Specifies the forward port.
               The valid value is range from **1** to **65535**.
        :param pulumi.Input[str] forward_protocol: Specifies the forward protocol.
               The valid values are **tcp** and **udp**.
        :param pulumi.Input[str] instance_id: Specifies the ID of advanced Anti-DDoS instance.
               Changing this will create a new rule resource.
        :param pulumi.Input[str] ip: Specifies the public IP addresss to which Advanced Anti-DDoS instance
               belongs. Changing this will create a new rule resource.
        :param pulumi.Input[str] lb_method: The LVS forward policy.
        :param pulumi.Input[str] rule_id: schema: Deprecated
        :param pulumi.Input[str] source_ip: Specifies the source IP addresses, separated by commas (,).
        :param pulumi.Input[int] source_port: Specifies the source port.
               The valid value is range from **1** to **65535**.
        :param pulumi.Input[int] status: The status of forward rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ForwardRuleState.__new__(_ForwardRuleState)

        __props__.__dict__["forward_port"] = forward_port
        __props__.__dict__["forward_protocol"] = forward_protocol
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["ip"] = ip
        __props__.__dict__["lb_method"] = lb_method
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["source_ip"] = source_ip
        __props__.__dict__["source_port"] = source_port
        __props__.__dict__["status"] = status
        return ForwardRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> pulumi.Output[int]:
        """
        Specifies the forward port.
        The valid value is range from **1** to **65535**.
        """
        return pulumi.get(self, "forward_port")

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> pulumi.Output[str]:
        """
        Specifies the forward protocol.
        The valid values are **tcp** and **udp**.
        """
        return pulumi.get(self, "forward_protocol")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of advanced Anti-DDoS instance.
        Changing this will create a new rule resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[str]:
        """
        Specifies the public IP addresss to which Advanced Anti-DDoS instance
        belongs. Changing this will create a new rule resource.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> pulumi.Output[str]:
        """
        The LVS forward policy.
        """
        return pulumi.get(self, "lb_method")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[str]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Output[str]:
        """
        Specifies the source IP addresses, separated by commas (,).
        """
        return pulumi.get(self, "source_ip")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Output[int]:
        """
        Specifies the source port.
        The valid value is range from **1** to **65535**.
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        The status of forward rule.
        """
        return pulumi.get(self, "status")

