This first ever python library that can function as a simple 3D engine for the usage of displaying and rotating of Objects. This library allows for you to use any library in addition to this one and display whatever object any way that you want. The purpose of this library is allow the user to quickly and efficiently display 3D objects without the use of complex libraries. This library is still in its alpha stages and is being rapidly updated/altered with new features, improved efficiency, less bugs and more stability.

# Installation 

    pip install Lobster

# Dependencies

```
python (built-in) math library :: sin, cos, tan, sqrt, pi
```

# Usage

**IMPORTING**

```python
from Lobster import Object, Camera, init, display
```

**Displaying a Rotating Cube using the Pygame Library**

```python
from Lobster import Object, Camera, init, display
import pygame

pygame.init()
clock = pygame.time.Clock()
screen_width, screen_height = 600, 600
displayScreen = True
screen = pygame.display.set_mode((screen_width, screen_height))
init(screen_width, screen_height, 3.141592653 / 2, 0.1, 50)

cube = Object(
    vertices=((1, 1, 1), (1, 1, -1), (1, -1, 1), (1, -1, -1), 
              (-1, 1, 1), (-1, 1, -1), (-1, -1, 1), (-1, -1, -1)),
    position=[0, 0, 5],
    faces=((0, 4, 6, 2), (3, 2, 6, 7), (7, 6, 4, 5), (5, 1, 3, 7), (1, 0, 2, 3), (5, 4, 0, 1)),
    colors=((255, 0, 255), (255, 0, 0), (100, 150, 1), (233, 223, 15), (13, 150, 225), (13, 223, 125))
)
player = Camera(position=[0, 0, 0], rotation=[0, 0, 0])

while displayScreen:
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            displayScreen = False

    screen.fill((255, 255, 255))

    player.rotation[0] += 0.03
    player.rotation[1] += 0.01
    player.rotation[2] += 0.02

    for (points, z_len, color) in display(cube, player):
        pygame.draw.polygon(screen, color, points)

    pygame.display.set_caption(str(clock.get_fps()))
    clock.tick(60)
    pygame.display.update()
```

# Uninstallation

    pip uninstall Lobster
