# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_token: Optional[pulumi.Input[str]] = None,
                 graphql_url: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 rest_url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] api_token: API token with GraphQL access and `write_pipelines, read_pipelines` scopes
        :param pulumi.Input[str] graphql_url: Base URL for the GraphQL API to use
        :param pulumi.Input[str] organization: The Buildkite organization ID
        :param pulumi.Input[str] rest_url: Base URL for the REST API to use
        """
        if api_token is None:
            api_token = _utilities.get_env('BUILDKITE_API_TOKEN')
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if graphql_url is not None:
            pulumi.set(__self__, "graphql_url", graphql_url)
        if organization is None:
            organization = _utilities.get_env('BUILDKITE_ORGANIZATION')
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if rest_url is not None:
            pulumi.set(__self__, "rest_url", rest_url)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[str]]:
        """
        API token with GraphQL access and `write_pipelines, read_pipelines` scopes
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_token", value)

    @property
    @pulumi.getter(name="graphqlUrl")
    def graphql_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL for the GraphQL API to use
        """
        return pulumi.get(self, "graphql_url")

    @graphql_url.setter
    def graphql_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graphql_url", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The Buildkite organization ID
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="restUrl")
    def rest_url(self) -> Optional[pulumi.Input[str]]:
        """
        Base URL for the REST API to use
        """
        return pulumi.get(self, "rest_url")

    @rest_url.setter
    def rest_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rest_url", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 graphql_url: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 rest_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the buildkite package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_token: API token with GraphQL access and `write_pipelines, read_pipelines` scopes
        :param pulumi.Input[str] graphql_url: Base URL for the GraphQL API to use
        :param pulumi.Input[str] organization: The Buildkite organization ID
        :param pulumi.Input[str] rest_url: Base URL for the REST API to use
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the buildkite package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 graphql_url: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 rest_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if api_token is None:
                api_token = _utilities.get_env('BUILDKITE_API_TOKEN')
            __props__.__dict__["api_token"] = None if api_token is None else pulumi.Output.secret(api_token)
            __props__.__dict__["graphql_url"] = graphql_url
            if organization is None:
                organization = _utilities.get_env('BUILDKITE_ORGANIZATION')
            __props__.__dict__["organization"] = organization
            __props__.__dict__["rest_url"] = rest_url
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'buildkite',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Output[Optional[str]]:
        """
        API token with GraphQL access and `write_pipelines, read_pipelines` scopes
        """
        return pulumi.get(self, "api_token")

    @property
    @pulumi.getter(name="graphqlUrl")
    def graphql_url(self) -> pulumi.Output[Optional[str]]:
        """
        Base URL for the GraphQL API to use
        """
        return pulumi.get(self, "graphql_url")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[Optional[str]]:
        """
        The Buildkite organization ID
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="restUrl")
    def rest_url(self) -> pulumi.Output[Optional[str]]:
        """
        Base URL for the REST API to use
        """
        return pulumi.get(self, "rest_url")

