"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceType = exports.InstanceSize = exports.InstanceArchitecture = exports.InstanceClass = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * What class and generation of instance to use.
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 *
 * @stability stable
 */
var InstanceClass;
(function (InstanceClass) {
    InstanceClass["STANDARD3"] = "m3";
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["M3"] = "m3";
    InstanceClass["STANDARD4"] = "m4";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["M4"] = "m4";
    InstanceClass["STANDARD5"] = "m5";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["M5"] = "m5";
    InstanceClass["STANDARD5_NVME_DRIVE"] = "m5d";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["M5D"] = "m5d";
    InstanceClass["STANDARD5_AMD"] = "m5a";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["M5A"] = "m5a";
    InstanceClass["STANDARD5_AMD_NVME_DRIVE"] = "m5ad";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["M5AD"] = "m5ad";
    InstanceClass["STANDARD5_HIGH_PERFORMANCE"] = "m5n";
    /**
     * Standard instances for high performance computing, 5th generation
     */
    InstanceClass["M5N"] = "m5n";
    InstanceClass["STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE"] = "m5dn";
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["M5DN"] = "m5dn";
    InstanceClass["STANDARD5_HIGH_COMPUTE"] = "m5zn";
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation
     */
    InstanceClass["M5ZN"] = "m5zn";
    InstanceClass["MEMORY3"] = "r3";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["R3"] = "r3";
    InstanceClass["MEMORY4"] = "r4";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["R4"] = "r4";
    InstanceClass["MEMORY5"] = "r5";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["R5"] = "r5";
    InstanceClass["MEMORY6_INTEL"] = "r6i";
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake)
     */
    InstanceClass["R6I"] = "r6i";
    InstanceClass["MEMORY5_HIGH_PERFORMANCE"] = "r5n";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["R5N"] = "r5n";
    InstanceClass["MEMORY5_NVME_DRIVE"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["R5D"] = "r5d";
    InstanceClass["MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE"] = "r5dn";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["R5DN"] = "r5dn";
    InstanceClass["MEMORY5_AMD"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["R5A"] = "r5a";
    InstanceClass["MEMORY5_AMD_NVME_DRIVE"] = "r5ad";
    InstanceClass["HIGH_MEMORY_6TB_1"] = "u-6tb1";
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_6TB1"] = "u-6tb1";
    InstanceClass["HIGH_MEMORY_9TB_1"] = "u-9tb1";
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_9TB1"] = "u-9tb1";
    InstanceClass["HIGH_MEMORY_12TB_1"] = "u-12tb1";
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_12TB1"] = "u-12tb1";
    InstanceClass["HIGH_MEMORY_18TB_1"] = "u-18tb1";
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["U_18TB1"] = "u-18tb1";
    InstanceClass["HIGH_MEMORY_24TB_1"] = "u-24tb1";
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["U_24TB1"] = "u-24tb1";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["R5AD"] = "r5ad";
    InstanceClass["MEMORY5_EBS_OPTIMIZED"] = "r5b";
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation
     */
    InstanceClass["R5B"] = "r5b";
    InstanceClass["MEMORY6_GRAVITON"] = "r6g";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors
     */
    InstanceClass["R6G"] = "r6g";
    InstanceClass["MEMORY6_GRAVITON2_NVME_DRIVE"] = "r6gd";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["R6GD"] = "r6gd";
    InstanceClass["COMPUTE3"] = "c3";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["C3"] = "c3";
    InstanceClass["COMPUTE4"] = "c4";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["C4"] = "c4";
    InstanceClass["COMPUTE5"] = "c5";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["C5"] = "c5";
    InstanceClass["COMPUTE6_INTEL"] = "c6i";
    /**
     * Compute optimized instances, 6th generation
     */
    InstanceClass["C6I"] = "c6i";
    InstanceClass["COMPUTE5_NVME_DRIVE"] = "c5d";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["C5D"] = "c5d";
    InstanceClass["COMPUTE5_AMD"] = "c5a";
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["C5A"] = "c5a";
    InstanceClass["COMPUTE5_AMD_NVME_DRIVE"] = "c5ad";
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation.
     */
    InstanceClass["C5AD"] = "c5ad";
    InstanceClass["COMPUTE5_HIGH_PERFORMANCE"] = "c5n";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["C5N"] = "c5n";
    InstanceClass["COMPUTE6_GRAVITON2"] = "c6g";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     */
    InstanceClass["C6G"] = "c6g";
    InstanceClass["COMPUTE6_GRAVITON2_NVME_DRIVE"] = "c6gd";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and local NVME drive
     */
    InstanceClass["C6GD"] = "c6gd";
    InstanceClass["COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH"] = "c6gn";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and high network bandwidth capabilities
     */
    InstanceClass["C6GN"] = "c6gn";
    InstanceClass["STORAGE2"] = "d2";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["D2"] = "d2";
    InstanceClass["STORAGE3"] = "d3";
    /**
     * Storage-optimized instances, 3rd generation
     */
    InstanceClass["D3"] = "d3";
    InstanceClass["STORAGE3_ENHANCED_NETWORK"] = "d3en";
    /**
    * Storage-optimized instances, 3rd generation
    */
    InstanceClass["D3EN"] = "d3en";
    InstanceClass["STORAGE_COMPUTE_1"] = "h1";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["H1"] = "h1";
    InstanceClass["IO3"] = "i3";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["I3"] = "i3";
    InstanceClass["IO3_DENSE_NVME_DRIVE"] = "i3en";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["I3EN"] = "i3en";
    InstanceClass["STORAGE4_GRAVITON_NETWORK_OPTIMIZED"] = "im4gn";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["IM4GN"] = "im4gn";
    InstanceClass["STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED"] = "is4gen";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["IS4GEN"] = "is4gen";
    InstanceClass["BURSTABLE2"] = "t2";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["T2"] = "t2";
    InstanceClass["BURSTABLE3"] = "t3";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["T3"] = "t3";
    InstanceClass["BURSTABLE3_AMD"] = "t3a";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["T3A"] = "t3a";
    InstanceClass["BURSTABLE4_GRAVITON"] = "t4g";
    /**
     * Burstable instances, 4th generation with Graviton2 processors
     */
    InstanceClass["T4G"] = "t4g";
    InstanceClass["MEMORY_INTENSIVE_1"] = "x1";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1"] = "x1";
    InstanceClass["MEMORY_INTENSIVE_1_EXTENDED"] = "x1e";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1E"] = "x1e";
    InstanceClass["MEMORY_INTENSIVE_2_GRAVITON2"] = "x2g";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors
     *
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    InstanceClass["X2G"] = "x2g";
    InstanceClass["MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE"] = "x2gd";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["X2GD"] = "x2gd";
    InstanceClass["FPGA1"] = "f1";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["F1"] = "f1";
    InstanceClass["GRAPHICS3"] = "g3";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["G3"] = "g3";
    InstanceClass["GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE"] = "g4dn";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["G4DN"] = "g4dn";
    InstanceClass["GRAPHICS4_AMD_NVME_DRIVE"] = "g4ad";
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation
     */
    InstanceClass["G4AD"] = "g4ad";
    InstanceClass["GRAPHICS5"] = "g5";
    /**
     * Graphics-optimized instances, 5th generation
     */
    InstanceClass["G5"] = "g5";
    InstanceClass["GRAPHICS5_GRAVITON2"] = "g5g";
    /**
    * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation
    */
    InstanceClass["G5G"] = "g5g";
    InstanceClass["PARALLEL2"] = "p2";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["P2"] = "p2";
    InstanceClass["PARALLEL3"] = "p3";
    /**
     * Parallel-processing optimized instances, 3rd generation
     */
    InstanceClass["P3"] = "p3";
    InstanceClass["PARALLEL4"] = "p4d";
    /**
     * Parallel-processing optimized instances, 4th generation
     */
    InstanceClass["P4D"] = "p4d";
    InstanceClass["ARM1"] = "a1";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["A1"] = "a1";
    InstanceClass["STANDARD6_GRAVITON"] = "m6g";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["M6G"] = "m6g";
    InstanceClass["STANDARD6_INTEL"] = "m6i";
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    InstanceClass["M6I"] = "m6i";
    InstanceClass["STANDARD6_AMD"] = "m6a";
    /**
    * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
    */
    InstanceClass["M6A"] = "m6a";
    InstanceClass["STANDARD6_GRAVITON2_NVME_DRIVE"] = "m6gd";
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["M6GD"] = "m6gd";
    InstanceClass["HIGH_COMPUTE_MEMORY1"] = "z1d";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["Z1D"] = "z1d";
    InstanceClass["INFERENCE1"] = "inf1";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INF1"] = "inf1";
    InstanceClass["MACINTOSH1_INTEL"] = "mac1";
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors
     */
    InstanceClass["MAC1"] = "mac1";
    InstanceClass["VIDEO_TRANSCODING1"] = "vt1";
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation
     */
    InstanceClass["VT1"] = "vt1";
})(InstanceClass = exports.InstanceClass || (exports.InstanceClass = {}));
/**
 * Identifies an instance's CPU architecture.
 *
 * @stability stable
 */
var InstanceArchitecture;
(function (InstanceArchitecture) {
    InstanceArchitecture["ARM_64"] = "arm64";
    InstanceArchitecture["X86_64"] = "x86_64";
})(InstanceArchitecture = exports.InstanceArchitecture || (exports.InstanceArchitecture = {}));
/**
 * What size of instance to use.
 *
 * @stability stable
 */
var InstanceSize;
(function (InstanceSize) {
    InstanceSize["NANO"] = "nano";
    InstanceSize["MICRO"] = "micro";
    InstanceSize["SMALL"] = "small";
    InstanceSize["MEDIUM"] = "medium";
    InstanceSize["LARGE"] = "large";
    InstanceSize["XLARGE"] = "xlarge";
    InstanceSize["XLARGE2"] = "2xlarge";
    InstanceSize["XLARGE3"] = "3xlarge";
    InstanceSize["XLARGE4"] = "4xlarge";
    InstanceSize["XLARGE6"] = "6xlarge";
    InstanceSize["XLARGE8"] = "8xlarge";
    InstanceSize["XLARGE9"] = "9xlarge";
    InstanceSize["XLARGE10"] = "10xlarge";
    InstanceSize["XLARGE12"] = "12xlarge";
    InstanceSize["XLARGE16"] = "16xlarge";
    InstanceSize["XLARGE18"] = "18xlarge";
    InstanceSize["XLARGE24"] = "24xlarge";
    InstanceSize["XLARGE32"] = "32xlarge";
    InstanceSize["XLARGE48"] = "48xlarge";
    InstanceSize["XLARGE56"] = "56xlarge";
    InstanceSize["XLARGE112"] = "112xlarge";
    InstanceSize["METAL"] = "metal";
})(InstanceSize = exports.InstanceSize || (exports.InstanceSize = {}));
/**
 * Instance type for EC2 instances.
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 *
 * @stability stable
 */
class InstanceType {
    /**
     * @stability stable
     */
    constructor(instanceTypeIdentifier) {
        this.instanceTypeIdentifier = instanceTypeIdentifier;
    }
    /**
     * Instance type for EC2 instances.
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     *
     * @stability stable
     */
    static of(instanceClass, instanceSize) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceClass(instanceClass);
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceSize(instanceSize);
        return new InstanceType(`${instanceClass}.${instanceSize}`);
    }
    /**
     * Return the instance type as a dotted string.
     *
     * @stability stable
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
    /**
     * The instance's CPU architecture.
     *
     * @stability stable
     */
    get architecture() {
        // capture the family, generation, capabilities, and size portions of the instance type id
        const instanceTypeComponents = this.instanceTypeIdentifier.match(/^([a-z]+)(\d{1,2})([a-z]*)\.([a-z0-9]+)$/);
        if (instanceTypeComponents == null) {
            throw new Error('Malformed instance type identifier');
        }
        const family = instanceTypeComponents[1];
        const capabilities = instanceTypeComponents[3];
        // Instance family `a` are first-gen Graviton instances
        // Capability `g` indicates the instance is Graviton2 powered
        if (family === 'a' || capabilities.includes('g')) {
            return InstanceArchitecture.ARM_64;
        }
        return InstanceArchitecture.X86_64;
    }
}
exports.InstanceType = InstanceType;
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "@aws-cdk/aws-ec2.InstanceType", version: "1.138.0" };
//# sourceMappingURL=data:application/json;base64,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