function(target_link_libraries_system target)
  set(libs ${ARGN})
  foreach(lib ${libs})
    get_target_property(lib_include_dirs ${lib} INTERFACE_INCLUDE_DIRECTORIES)
    target_include_directories(${target} SYSTEM PRIVATE ${lib_include_dirs})
    target_link_libraries(${target} ${lib})
  endforeach(lib)
endfunction(target_link_libraries_system)

function(dump_cmake_variables)
    get_cmake_property(_variableNames VARIABLES)
    list (SORT _variableNames)
    foreach (_variableName ${_variableNames})
        if (ARGV0)
            unset(MATCHED)
            string(REGEX MATCH ${ARGV0} MATCHED ${_variableName})
            if (NOT MATCHED)
                continue()
            endif()
        endif()
        message(STATUS "${_variableName}=${${_variableName}}")
    endforeach()
endfunction()

# This is not used anymore, using FetchContent now....
macro(add_subdirectory_if_not_exists LIBRARY SUB_DIR)
  if(NOT TARGET ${LIBRARY})
      message("-- INFO - Trying to add ${LIBRARY} from thirdparty submodule")
      add_subdirectory("${CMAKE_CURRENT_SOURCE_DIR}/${SUB_DIR}")
  else()
      message("-- INFO - Skipping add_subdirectory(${LIBRARY}) because it has already been added")
  endif()
endmacro(add_subdirectory_if_not_exists)
