# mypy-boto3-appsync<a id="mypy-boto3-appsync"></a>

[![PyPI - mypy-boto3-appsync](https://img.shields.io/pypi/v/mypy-boto3-appsync.svg?color=blue)](https://pypi.org/project/mypy-boto3-appsync)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-appsync.svg?color=blue)](https://pypi.org/project/mypy-boto3-appsync)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-appsync?color=blue)](https://pypistats.org/packages/mypy-boto3-appsync)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.AppSync 1.17.80](https://boto3.amazonaws.com/v1/documentation/api/1.17.80/reference/services/appsync.html#AppSync)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-appsync docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appsync/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-appsync](#mypy-boto3-appsync)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `AppSync` service.

```bash
python -m pip install boto3-stubs[appsync]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[appsync]` in your environment:
  `python -m pip install 'boto3-stubs[appsync]'`

Both type checking and auto-complete should work for `AppSync` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[appsync]` in your environment:
  `python -m pip install 'boto3-stubs[appsync]'`

Both type checking and auto-complete should work for `AppSync` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[appsync]` in your environment:
  `python -m pip install 'boto3-stubs[appsync]'`
- Run `mypy` as usual

Type checking should work for `AppSync` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[appsync]` in your environment:
  `python -m pip install 'boto3-stubs[appsync]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `AppSync` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`AppSyncClient` provides annotations for `boto3.client("appsync")`.

```python
import boto3

from mypy_boto3_appsync import AppSyncClient

client: AppSyncClient = boto3.client("appsync")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AppSyncClient = session.client("appsync")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_appsync.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_appsync import AppSyncClient
from mypy_boto3_appsync.paginator import (
    ListApiKeysPaginator,
    ListDataSourcesPaginator,
    ListFunctionsPaginator,
    ListGraphqlApisPaginator,
    ListResolversPaginator,
    ListResolversByFunctionPaginator,
    ListTypesPaginator,
)

client: AppSyncClient = boto3.client("appsync")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_api_keys_paginator: ListApiKeysPaginator = client.get_paginator("list_api_keys")
list_data_sources_paginator: ListDataSourcesPaginator = client.get_paginator("list_data_sources")
list_functions_paginator: ListFunctionsPaginator = client.get_paginator("list_functions")
list_graphql_apis_paginator: ListGraphqlApisPaginator = client.get_paginator("list_graphql_apis")
list_resolvers_paginator: ListResolversPaginator = client.get_paginator("list_resolvers")
list_resolvers_by_function_paginator: ListResolversByFunctionPaginator = client.get_paginator("list_resolvers_by_function")
list_types_paginator: ListTypesPaginator = client.get_paginator("list_types")
```

### Literals<a id="literals"></a>

`mypy_boto3_appsync.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_appsync.literals import (
    ApiCacheStatusType,
    ApiCacheTypeType,
    ApiCachingBehaviorType,
    AuthenticationTypeType,
    AuthorizationTypeType,
    ConflictDetectionTypeType,
    ConflictHandlerTypeType,
    DataSourceTypeType,
    DefaultActionType,
    FieldLogLevelType,
    ListApiKeysPaginatorName,
    ListDataSourcesPaginatorName,
    ListFunctionsPaginatorName,
    ListGraphqlApisPaginatorName,
    ListResolversByFunctionPaginatorName,
    ListResolversPaginatorName,
    ListTypesPaginatorName,
    OutputTypeType,
    RelationalDatabaseSourceTypeType,
    ResolverKindType,
    SchemaStatusType,
    TypeDefinitionFormatType,
)

def check_value(value: ApiCacheStatusType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_appsync.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_appsync.type_defs import (
    AdditionalAuthenticationProviderTypeDef,
    ApiCacheTypeDef,
    ApiKeyTypeDef,
    AuthorizationConfigTypeDef,
    AwsIamConfigTypeDef,
    CachingConfigTypeDef,
    CognitoUserPoolConfigTypeDef,
    CreateApiCacheResponseTypeDef,
    CreateApiKeyResponseTypeDef,
    CreateDataSourceResponseTypeDef,
    CreateFunctionResponseTypeDef,
    CreateGraphqlApiResponseTypeDef,
    CreateResolverResponseTypeDef,
    CreateTypeResponseTypeDef,
    DataSourceTypeDef,
    DeltaSyncConfigTypeDef,
    DynamodbDataSourceConfigTypeDef,
    ElasticsearchDataSourceConfigTypeDef,
    FunctionConfigurationTypeDef,
    GetApiCacheResponseTypeDef,
    GetDataSourceResponseTypeDef,
    GetFunctionResponseTypeDef,
    GetGraphqlApiResponseTypeDef,
    GetIntrospectionSchemaResponseTypeDef,
    GetResolverResponseTypeDef,
    GetSchemaCreationStatusResponseTypeDef,
    GetTypeResponseTypeDef,
    GraphqlApiTypeDef,
    HttpDataSourceConfigTypeDef,
    LambdaConflictHandlerConfigTypeDef,
    LambdaDataSourceConfigTypeDef,
    ListApiKeysResponseTypeDef,
    ListDataSourcesResponseTypeDef,
    ListFunctionsResponseTypeDef,
    ListGraphqlApisResponseTypeDef,
    ListResolversByFunctionResponseTypeDef,
    ListResolversResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTypesResponseTypeDef,
    LogConfigTypeDef,
    OpenIDConnectConfigTypeDef,
    PaginatorConfigTypeDef,
    PipelineConfigTypeDef,
    RdsHttpEndpointConfigTypeDef,
    RelationalDatabaseDataSourceConfigTypeDef,
    ResolverTypeDef,
    StartSchemaCreationResponseTypeDef,
    SyncConfigTypeDef,
    TypeTypeDef,
    UpdateApiCacheResponseTypeDef,
    UpdateApiKeyResponseTypeDef,
    UpdateDataSourceResponseTypeDef,
    UpdateFunctionResponseTypeDef,
    UpdateGraphqlApiResponseTypeDef,
    UpdateResolverResponseTypeDef,
    UpdateTypeResponseTypeDef,
    UserPoolConfigTypeDef,
)

def get_structure() -> AdditionalAuthenticationProviderTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-appsync` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-appsync docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_appsync/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
