# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetBoundaryClusterResult',
    'AwaitableGetBoundaryClusterResult',
    'get_boundary_cluster',
    'get_boundary_cluster_output',
]

@pulumi.output_type
class GetBoundaryClusterResult:
    """
    A collection of values returned by getBoundaryCluster.
    """
    def __init__(__self__, cluster_id=None, cluster_url=None, created_at=None, id=None, state=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_url and not isinstance(cluster_url, str):
            raise TypeError("Expected argument 'cluster_url' to be a str")
        pulumi.set(__self__, "cluster_url", cluster_url)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The ID of the Boundary cluster
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterUrl")
    def cluster_url(self) -> str:
        """
        A unique URL identifying the Boundary cluster.
        """
        return pulumi.get(self, "cluster_url")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The time that the Boundary cluster was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the Boundary cluster.
        """
        return pulumi.get(self, "state")


class AwaitableGetBoundaryClusterResult(GetBoundaryClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBoundaryClusterResult(
            cluster_id=self.cluster_id,
            cluster_url=self.cluster_url,
            created_at=self.created_at,
            id=self.id,
            state=self.state)


def get_boundary_cluster(cluster_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBoundaryClusterResult:
    """
    The Boundary cluster data source provides information about an existing HCP Boundary cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcp as hcp

    example = hcp.get_boundary_cluster(cluster_id=var["cluster_id"])
    ```


    :param str cluster_id: The ID of the Boundary cluster
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcp:index/getBoundaryCluster:getBoundaryCluster', __args__, opts=opts, typ=GetBoundaryClusterResult).value

    return AwaitableGetBoundaryClusterResult(
        cluster_id=__ret__.cluster_id,
        cluster_url=__ret__.cluster_url,
        created_at=__ret__.created_at,
        id=__ret__.id,
        state=__ret__.state)


@_utilities.lift_output_func(get_boundary_cluster)
def get_boundary_cluster_output(cluster_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBoundaryClusterResult]:
    """
    The Boundary cluster data source provides information about an existing HCP Boundary cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcp as hcp

    example = hcp.get_boundary_cluster(cluster_id=var["cluster_id"])
    ```


    :param str cluster_id: The ID of the Boundary cluster
    """
    ...
