# SemrushApp MCP Server

An MCP Server for the SemrushApp API.

## 🛠️ Tool List

This is automatically generated from OpenAPI schema for the SemrushApp API.


| Tool | Description |
|------|-------------|
| `domain_ad_history` | Get domain ad history data showing past ad copies, landing pages, and performance metrics over time. |
| `domain_organic_pages` | Get unique pages of a domain that rank in Google's top 100 organic search results. |
| `domain_organic_search_keywords` | Get keywords that bring organic traffic to a domain via Google's top 100 search results. |
| `domain_organic_subdomains` | Get subdomains of a domain that rank in Google's top 100 organic search results. |
| `domain_paid_search_keywords` | Get keywords that bring paid traffic to a domain via Google's paid search results. |
| `domain_pla_search_keywords` | Get keywords that trigger a domain's product listing ads (PLA) in Google's paid search results. |
| `domain_vs_domain` | Compare up to five domains by common keywords, unique keywords, or search terms unique to the first domain. |
| `backlinks` | Get backlinks data for a domain, root domain, or URL. |
| `backlinks_overview` | Get backlinks overview summary including type, referring domains, and IP addresses. |
| `keyword_difficulty` | Get keyword difficulty data to estimate ranking difficulty for organic search terms. |
| `ads_copies` | Get unique ad copies that appeared when a domain ranked in Google's paid search results. |
| `anchors` | Get anchor texts used in backlinks leading to a domain, root domain, or URL. |
| `authority_score_profile` | Get distribution of referring domains by Authority Score from 0 to 100. |
| `batch_comparison` | Compare backlink profiles and link-building progress across multiple competitors. |
| `batch_keyword_overview` | Get summary of up to 100 keywords including volume, CPC, competition level, and results count. |
| `broad_match_keyword` | Get broad matches and alternate search queries for a keyword or keyword expression. |
| `categories` | Get list of categories that the queried domain belongs to with confidence ratings. |
| `categories_profile` | Get categories that referring domains belong to with domain counts for the queried domain. |
| `competitors` | Get domains that share a similar backlink profile with the analyzed domain. |
| `competitors_organic_search` | Get domain's competitors in organic search results with common keywords analysis. |
| `competitors_paid_search` | Get domain's competitors in paid search results with common keywords analysis. |
| `indexed_pages` | Get indexed pages of the queried domain with backlink and response data. |
| `keyword_ads_history` | Get domains that have bid on a keyword in the last 12 months with their paid search positions. |
| `keyword_overview_all_databases` | Get keyword summary including volume, CPC, competition level, and results across all regional databases. |
| `keyword_overview_one_database` | Get keyword summary including volume, CPC, competition level, and results for a specific database. |
| `organic_results` | Get domains ranking in Google's top 100 organic search results for a keyword. |
| `paid_results` | Get domains ranking in Google's paid search results for a keyword. |
| `phrase_questions` | Get phrase questions relevant to a queried term in a chosen database. |
| `pla_competitors` | Get domains competing against the requested domain in Google's Product Listing Ads (PLA). |
| `pla_copies` | Get product listing ad (PLA) copies that appeared when a domain ranked in Google's paid search results. |
| `referring_domains` | Get domains pointing to the queried domain, root domain, or URL. |
| `referring_domains_by_country` | Get referring domain distribution by country based on IP addresses. |
| `related_keywords` | Get extended list of related keywords, synonyms, and variations relevant to a queried term. |
| `tlds_distribution` | Get referring domain distribution by top-level domain (e.g., .com, .org, .net). |
| `url_organic_search_keywords` | Get keywords that bring users to a URL via Google's top 100 organic search results. |
| `url_paid_search_keywords` | Get keywords that bring users to a URL via Google's paid search results. |
