# MsTeamsApp MCP Server

An MCP Server for the MsTeamsApp API.

## 🛠️ Tool List

This is automatically generated from OpenAPI schema for the MsTeamsApp API.


| Tool | Description |
|------|-------------|
| `get_user_chats` | Retrieves a collection of chats the authenticated user is participating in. Supports optional OData query parameters for advanced filtering, sorting, pagination, and field selection, enabling customized data retrieval from the Microsoft Graph API. |
| `get_joined_teams` | Fetches all Microsoft Teams the authenticated user belongs to by querying the `/me/joinedTeams` Graph API endpoint. It returns a list of dictionaries, where each dictionary represents a single team's details, unlike functions that list channels or chats for a specific team. |
| `list_channels_for_team` | Retrieves the collection of channels for a specified Microsoft Teams team by its ID. It supports advanced OData query parameters for filtering, sorting, and pagination, distinguishing it from functions that fetch single channels like `get_channel_details`. |
| `send_chat_message` | Posts a new message to a specific Microsoft Teams chat using its unique ID. This function targets direct or group chats, distinguishing it from `send_channel_message`, which posts to public team channels, and `reply_to_chat_message`, which responds to existing messages. |
| `send_channel_message` | Posts a new message to a specified team channel, initiating a new conversation thread. Unlike `reply_to_channel_message`, which replies to a message, this function starts a new topic. It's distinct from `send_chat_message`, which is for private or group chats, not team channels. |
| `reply_to_channel_message` | Posts a reply to a specific message within a Microsoft Teams channel. It uses the team, channel, and original message IDs to target an existing conversation thread, distinguishing it from `send_channel_message` which starts a new one. |
| `create_chat` | Creates a new one-on-one or group chat in Microsoft Teams. This function provisions a new conversation using optional parameters like chatType and members, distinguishing it from functions that create teams (`create_team`) or send messages to existing chats (`send_chat_message`). |
| `get_chat_details` | Retrieves the properties and relationships of a specific chat conversation by its unique ID. Unlike `get_user_chats` which lists all chats, this targets one chat. Optional parameters can select specific fields or expand related entities like members or apps to customize the returned data. |
| `update_chat_details` | Updates properties of a specific chat, such as its topic, using its unique ID. This function performs a partial update (PATCH), distinguishing it from `get_chat_details` which only retrieves data, and `create_chat` which creates an entirely new chat conversation. |
| `list_installed_chat_apps` | Retrieves applications installed in a specific chat, identified by `chat_id`. Differentiating from `list_user_installed_apps`, which targets a user's personal scope, this function queries a single conversation. It supports optional parameters for advanced filtering, sorting, and pagination to customize the returned collection. |
| `list_chat_members` | Retrieves a collection of all members in a specific chat using its ID. It supports OData query parameters for pagination, filtering, and sorting. Unlike `get_chat_member`, which fetches a single individual, this function returns the entire collection of members for the specified chat. |
| `add_member_to_chat` | Adds a new member to a specific Microsoft Teams chat using its `chat_id`. This function allows for configuring member roles and chat history visibility. It is the direct counterpart to `delete_chat_member`, performing the 'create' action for a chat's membership. |
| `get_chat_member` | Retrieves detailed information for a specific member within a chat using their unique ID. This function targets a single individual, distinguishing it from `list_chat_members` which returns all members. The response can be customized by selecting specific properties or expanding related entities. |
| `delete_chat_member` | Removes a specific member from a chat using their unique ID and the chat's ID. This function sends a DELETE request to the Microsoft Graph API to permanently remove the user from the conversation, acting as the counterpart to `add_member_to_chat`. |
| `list_chat_messages` | Retrieves messages from a specific chat using its ID. Unlike `get_chat_message`, which fetches a single message, this function returns a collection and supports advanced querying for filtering, sorting, and pagination to refine the results. |
| `get_chat_message` | Retrieves the full details of a single message from a specific chat using both chat and message IDs. This function targets an individual message, differentiating it from `list_chat_messages`, which retrieves a collection. Optional parameters can customize the response by selecting specific properties or expanding entities. |
| `list_chat_message_replies` | Retrieves all replies for a specific message within a chat, using the parent message's ID. This function, unlike `get_chat_reply_details`, returns a collection and supports OData query parameters for advanced filtering, sorting, and pagination of the results. |
| `reply_to_chat_message` | Posts a reply to a specific message within a chat. This comprehensive function allows for detailed configuration of the reply's properties, like its body and attachments. It differs from `reply_to_channel_message`, which sends simpler replies to messages within team channels. |
| `get_chat_reply_details` | Retrieves a specific reply from a chat message thread using the chat, parent message, and reply IDs. Unlike `list_chat_message_replies`, which fetches all replies, this function targets a single reply for detailed information, allowing for customized field selection. |
| `create_team_from_group` | Enables Microsoft Teams functionality for a pre-existing Microsoft 365 group using its ID. This 'team-ifies' the group, allowing optional configuration of team properties. It differs from `create_team`, which provisions both a new team and its associated group simultaneously. |
| `create_team` | Creates a new Microsoft Team and its associated Microsoft 365 group. This method builds a team from scratch, allowing specification of initial properties like display name, description, and members. It differs from `create_team_from_group`, which enables team functionality for an existing group. |
| `get_channel_details` | Retrieves detailed information for a specific channel within a Microsoft Teams team, identified by both team and channel IDs. Optional parameters can select specific properties or expand related entities in the response, distinguishing it from list_channels_for_team, which retrieves a collection of channels. |
| `update_channel_message` | Updates an existing message within a Microsoft Teams channel, identified by team, channel, and message IDs. This function modifies the original message's properties, like its body, via a PATCH request, distinguishing it from functions that create new messages or update replies. |
| `update_channel_message_reply` | Updates an existing reply to a specific message within a Microsoft Teams channel. It identifies the target reply using team, channel, parent message, and reply IDs, modifying its properties (e.g., body content, attachments) via a PATCH request. |
| `list_channel_tabs` | Retrieves a collection of tabs from a specified channel within a Microsoft Teams team. Unlike `get_channel_tab_details`, which fetches a single tab, this function lists all tabs and supports advanced OData query parameters for filtering, sorting, and pagination of the entire collection. |
| `create_channel_tab` | Creates a new tab in a specified Microsoft Teams channel using team and channel IDs. This function configures the tab's initial properties, such as display name and application, distinguishing it from functions that list (`list_channel_tabs`) or modify (`update_channel_tab`) existing tabs. |
| `get_channel_tab_details` | Fetches properties for a single tab within a specific Microsoft Teams channel, identified by its team, channel, and tab IDs. Unlike `list_channel_tabs` which gets all tabs, this targets a specific one, with options to select fields or expand related entities in the response. |
| `update_channel_tab` | Modifies properties of an existing tab within a specific Microsoft Teams channel. It uses the team, channel, and tab IDs to target the tab, allowing for partial updates to its configuration or display name via a PATCH request, differentiating it from tab creation or deletion functions. |
| `delete_channel_tab` | Permanently removes a specific tab from a Microsoft Teams channel using its unique ID, along with the parent team and channel IDs. This function is the destructive counterpart to `create_channel_tab`, designed to delete a tab rather than create, list, or update one. |
| `get_primary_team_channel` | Retrieves the primary channel (usually 'General') for a specified team using its ID. Unlike `get_channel_details`, this function directly accesses the team's default channel without requiring a specific channel ID. Optional parameters can select or expand properties in the returned data. |
| `list_user_installed_apps` | Retrieves applications installed in a user's personal Microsoft Teams scope, identified by their ID. Unlike `list_installed_chat_apps` which targets chat installations, this focuses on the user's scope. It supports optional OData parameters for filtering, sorting, and pagination to customize the returned app collection. |
