# GoogleSheetApp MCP Server

An MCP Server for the GoogleSheetApp API.

## 🛠️ Tool List

This is automatically generated from OpenAPI schema for the GoogleSheetApp API.


| Tool | Description |
|------|-------------|
| `create_spreadsheet` | Creates a new, blank Google Spreadsheet file with a specified title. This function generates a completely new document, unlike `add_sheet` which adds a worksheet (tab) to an existing spreadsheet. It returns the API response containing the new spreadsheet's metadata. |
| `get_spreadsheet_metadata` | Retrieves a spreadsheet's metadata and structural properties, such as sheet names, IDs, and named ranges, using its unique ID. This function intentionally excludes cell data, distinguishing it from `get_values` which fetches the actual content within cells. |
| `get_values` | Retrieves cell values from a single, specified A1 notation range. Unlike `batch_get_values_by_range` which fetches multiple ranges, this function is for a singular query and provides options to control the data's output format (e.g., rows vs. columns, formatted vs. raw values). |
| `batch_get_values_by_range` | Efficiently retrieves values from multiple predefined A1 notation ranges in a single API request. Unlike `get_values`, which fetches a single range, or `batch_get_values_by_data_filter`, which uses dynamic filtering criteria, this function operates on a simple list of range strings for bulk data retrieval. |
| `insert_dimensions` | Inserts a specified number of empty rows or columns at a given index, shifting existing content. Distinct from `append_dimensions`, which only adds to the end, this function creates space within the sheet's data grid, preserving surrounding data and formatting. |
| `append_dimensions` | Adds a specified number of empty rows or columns to the end of a designated sheet. Unlike `insert_dimensions`, which adds space at a specific index, this function exclusively extends the sheet's boundaries at the bottom or to the right without affecting existing content. |
| `delete_dimensions` | Deletes a specified range of rows or columns, permanently removing them and shifting subsequent cells. This alters the sheet's structure, unlike `clear_values` which only removes cell content. It is the direct counterpart to `insert_dimensions`, which adds space within the data grid. |
| `add_sheet` | Adds a new worksheet (tab) to an existing Google Spreadsheet. It allows extensive customization of the new sheet's properties, such as its title, position, and dimensions. This is distinct from `create_spreadsheet`, which generates a completely new spreadsheet file instead of modifying an existing one. |
| `add_basic_chart` | Adds various axis-based charts (e.g., column, bar, line, area) to a spreadsheet from specified data ranges. The chart can be placed on a new sheet or positioned on an existing one. This is distinct from `add_pie_chart`, which creates proportional visualizations instead of axis-based charts. |
| `add_pie_chart` | Adds a pie or donut chart to a Google Spreadsheet from a specified data range. Unlike the more general `add_basic_chart`, this is specialized for visualizing data as proportions of a whole and supports pie-specific options like creating a donut chart via the `pie_hole` parameter. |
| `add_table` | Creates a structured table within a specified range on a Google Sheet. Defines the table's name, ID, and dimensions, and can optionally configure column properties like data types and validation rules. This action creates a formal table object, distinct from functions that only write cell values. |
| `update_table` | Modifies properties of an existing table within a Google Sheet, such as its name, data range, or column specifications. This function updates the table's structural metadata, distinguishing it from `update_values` which alters the cell data within the table's range. |
| `clear_values` | Clears data from a single, specified cell range while preserving all formatting. Unlike `delete_dimensions`, it only removes content, not the cells themselves. For clearing multiple ranges simultaneously, use the `batch_clear_values` function. |
| `update_values` | Overwrites cell values within a specific A1 notation range using a provided 2D list. This function replaces existing data in a predefined area, distinguishing it from `append_values`, which adds new rows after a table instead of overwriting a specific block of cells. |
| `batch_clear_values` | Clears cell values from multiple specified ranges in a single batch operation, preserving existing formatting. Unlike `clear_values`, which handles a single range, this method efficiently processes a list of ranges at once, removing only the content and not the cells themselves. |
| `batch_get_values_by_data_filter` | Retrieves values from spreadsheet ranges matching a list of data filters. This method provides dynamic, criteria-based selection using A1 notation or grid coordinates, unlike `batch_get_values_by_range` which uses a simple list of range strings. It is ideal for fetching multiple, specific datasets in one request. |
| `copy_sheet_to_spreadsheet` | Copies a specific sheet, including all its data and formatting, from a source spreadsheet to a different destination spreadsheet. This action duplicates an entire worksheet into another workbook, returning properties of the newly created sheet. |
| `write_values_to_sheet` | Writes a 2D list of values to a sheet, overwriting existing data. Data is written starting from a specified cell, or defaults to cell A1 if no location is provided. This differs from `append_values`, which adds new rows after existing data without replacing content. |
| `append_values` | Appends rows of data after a specified table in a Google Sheet. Distinct from `update_values` which overwrites data, this function adds new rows at the end of the table. It can also insert rows, shifting existing cells down, offering finer control over data addition. |
| `clear_basic_filter` | Removes the basic filter from a specified sheet, clearing active sorting and filtering criteria to restore the default data view. As the direct counterpart to `set_basic_filter`, this function removes the entire filter object, not just the cell content. |
| `delete_sheet` | Permanently deletes a specific sheet (worksheet) from a Google Spreadsheet using its sheet ID. This operation removes the target sheet and all its contents, acting as the direct counterpart to the `add_sheet` function which creates new sheets within a spreadsheet. |
| `discover_tables` | Heuristically analyzes a spreadsheet to discover and list all table-like data structures, identifying headers and data boundaries. It returns informal data blocks meeting specified size criteria, distinguishing it from functions like `add_table` that manage formally defined tables. |
| `analyze_table_schema` | Infers a specified table's schema by analyzing a data sample. After locating the table by name (a value discovered via `discover_tables`), this function determines the most likely data type and properties for each column, providing a detailed structural breakdown of its content. |
| `set_basic_filter` | Sets or updates a basic filter on a specified range within a sheet, enabling data sorting and filtering. The filter's target range and optional sort specifications are defined in a dictionary argument. It is the counterpart to `clear_basic_filter`, which removes an existing filter. |
| `format_cells` | Applies comprehensive formatting to a specified cell range in a worksheet. It modifies visual properties like text style, color, alignment, borders, and can merge cells, without altering the underlying cell values, distinguishing it from data-modification functions like `update_values`. |
