# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_filters_groups', 'django_filters_groups.templatetags']

package_data = \
{'': ['*'],
 'django_filters_groups': ['static/django_filters_groups/*',
                           'templates/django_filters_groups/*']}

install_requires = \
['Django>=2', 'django-filter>=2.4.0']

setup_kwargs = {
    'name': 'django-filter-groups',
    'version': '0.4.2',
    'description': '',
    'long_description': '# django filter groups\n\nThis package groups filters generated by django-filter.\n\nThe main reason to use it - show only selected filters.\n\nIt groups filters by their `field_name`. \nThe filter lookup will be subtracted from `filter_name`. \nThat\'s why `int_field` and `int_field__isnull` in example above, will be placed in ine group\n\n```python\nclass MyFilterSet(django_filters.FilterSet):\n    int_field = django_filters.NumberFilter()\n    int_field__isnull = django_filters.NumberFilter(lookup_expr="isnull")\n```\n\nA group name resolution goes the next way:\n- finding `filter_group_label` in any filter in current group\n- if multiple were found, the first would be selected\n  - it\'s not good idea to add multiple `filter_group_label`\'s\n  - the ways to add `filter_group_label` you can find [here](#change_group_name)\n- if `filter_group_label` wasn\'t added, it\'s finding label declared in a filter with `exact` lookup expression\n- if it isn\'t presented, it\'ll get the first declared filter for this group and take its label\n- if no label is found, it\'ll get the field verbose_name from model\n- otherwise, it\'ll set `"[invalid name]"` group name, and it won\'t be able to choose such group \n\n## how to use\n```\npip install django-filter-groups\n```\nadd to your `INSTALLED_APPS` after `django-filter`\n```python\nINSTALLED_APPS = [\n  ...\n  "django_filters",\n  "django_filters_groups",\n  ...\n]\n```\n\nuse it in your template:\n- add `{% add_select_filter_form_to_context %}` to the top of your template. \n  It allows you to place `{{ select_filter_form.media }}` anywhere you want\n- add `{% filters_by_groups %}`\n- add `{{ select_filter_form.media }}`\n\nIf FilterSet name is not \'filter\' -> add filterset to both tags \\\n`{% add_select_filter_form_to_context my_custom_filterset %}`\\\n`{% filters_by_groups my_custom_filterset %}`\nor filterset name\n`{% filters_by_groups "my_custom_filterset" %}`\n`{% add_select_filter_form_to_context "my_custom_filterset" %}`\n\n## warning\nIt\'s necessary to add values to `exact` and `iexact` [VERBOSE_LOOKUPS](https://django-filter.readthedocs.io/en/stable/ref/settings.html?highlight=verbose_lookups#filters-verbose-lookups).\n\nFilter choice will be empty if the lookups isn\'t presented\n\n## default settings\n\n```\n# django settings\nFILTERS_GROUPS_SELECT_FILTER_FORM_LABEL = "Select a label"\n```\n```js\n// static/django_filters_groups/filter-defaults.js\nlet filterDefaults = {\n  filterWrapperSelector: "p", // p is necessary when you use {{ form.as_p }}\n  submitOnFilterDelete: false,\n};\n```\n\n## <a name="change_group_name"></a> change group name\nYou can set group name directly in 2 ways:\n- add `filter_group_label` to your filter\n```python\nclass FFieldCountFilter(django_filters.NumberFilter):\n    filter_group_label = "custom_group_label"\n```\n- use `get_filter_class_with_custom_label`\n```python\nfrom django_filters_groups.utils import get_filter_class_with_group_label\n\nclass MyFilterSet(django_filters.FilterSet):\n  custom_filter = get_filter_class_with_group_label(django_filters.NumberFilter, "custom_group_label")(method="custom_filter_method")\n```\n',
    'author': 'pnoryk',
    'author_email': 'pnoryk@mail.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/PNoryk/django-filter-groups',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
