# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['prometheus_ecs_discoverer']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.14.23,<2.0.0',
 'dynaconf>=3.0.0,<4.0.0',
 'loguru>=0.5.1,<0.6.0',
 'prettyprinter>=0.18.0,<0.19.0',
 'prometheus-client>=0.8.0,<0.9.0']

setup_kwargs = {
    'name': 'prometheus-ecs-discoverer',
    'version': '3.2.1',
    'description': 'Prometheus Service Discovery for AWS ECS',
    'long_description': '# Prometheus ECS Discoverer\n\n[![PyPI version](https://badge.fury.io/py/prometheus-ecs-discoverer.svg)](https://pypi.python.org/pypi/prometheus-ecs-discoverer/)\n[![Maintenance](https://img.shields.io/badge/maintained%3F-yes-green.svg)](https://GitHub.com/Naereen/StrapDown.js/graphs/commit-activity)\n[![downloads](https://img.shields.io/pypi/dm/prometheus-ecs-discoverer)](https://pypi.org/project/prometheus-ecs-discoverer/)\n\n![release](https://github.com/trallnag/prometheus-ecs-discoverer/workflows/release/badge.svg)\n![test branches](https://github.com/trallnag/prometheus-ecs-discoverer/workflows/test%20branches/badge.svg)\n[![codecov](https://codecov.io/gh/trallnag/prometheus-ecs-discoverer/branch/master/graph/badge.svg)](https://codecov.io/gh/trallnag/prometheus-ecs-discoverer)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\nBased on [prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd), \nthis project enables your Prometheus to **dynamically scrape targets** deployed \nin AWS ECS. The discoverer is perfect if you don\'t have \na service discovery system like Consul in-place. It provides an easy-to-use \nalternative and can be used in low- to mid-sized environments with **hundreds \nof tasks** running in parallel.\n\nOnce the discoverer is up and running, any task can be made visible to \nPrometheus.\n\n![diagram](https://raw.githubusercontent.com/trallnag/prometheus-ecs-discoverer/master/documents/drawio-diagram.png)\n\nWhat are the advantages of using this project over [prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd\n)?\n\n* Modified throttling in combination with the already existing caching allows \n    the usage in environments with hundreds of tasks.\n* Every target can expose custom labels via its environment variables. This way \n    you can provide more ways to aggregate metrics. For example by type of API.\n* Deploy as container (provided and can be used directly) or Python package.\n    No need to manually install boto3 and so on.\n* Instrumented with Prometheus. Allows more insights into the discoverer. You \n    can monitor how long discovery rounds take and stuff like used memory. \n    Dashboard already included and ready to use.\n* Extensive testing with high coverage ensures functionality.\n* More configuration options. For example structured logs.\n\n---\n\nContents: **[Setup](#setup)** |\n[Prepare targets](#perpare-targets) | \n[Deploy PromED](#deploy-promed) |\n[Configure Prometheus](#configure-prometheus) | \n**[Configuration](#configuration)** |\n**[Grafana Dashboard](#grafana-dashboard)** |\n**[Prerequesites](#prerequesites)** |\n**[Development](#development)**\n\n---\n\n## Setup\n\nAs this project is based on \n[prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd), the setup \nis very similar / exactly the same. The setup consists out of three parts. \nThe targets must be prepared by adding environment variables. Next, PromED \nitself must be deployed. And finally, the Prometheus configuration must be \nupdated.\n\n### Prepare targets\n\nTargets are setup via setting environment variables in the task definitions.\n\n#### Mark container as target\n\nSet `PROMETHEUS_TARGET` to `true` to make PromED consider the container. This \nby itself is already enough to make it work with the configured defaults.\n\n#### Specify metrics endpoint(s)\n\nIf your metrics are not exposed on the default `/metrics` endpoint, you can \nspecifiy the endpoint with `PROMETHEUS_ENDPOINT`.\n\nYou can also declare multiple endpoints and different intervals. The supported \nintervals are `15s`, `30s`, `1m` and `5m`. Based on the interval, targets will \nend up in different files. The default interval is "generic". Examples for this:\n\n* `5m:/mymetrics,30s:/mymetrics2`\n* `/mymetrics`\n* `/mymetrics,30s:/mymetrics2`\n\nBy default, all targets will end up in a single file called `tasks.json` in the \nconfigured directory (defaults to `/tmp`).\n\n#### Set custom labels for container\n\nSometimes you might want to add additonal labels to targets to group them. \nFor example by the used API type (REST vs. GraphQL). This can be done by adding \nenvironment variables to the container definition in the respective task \ndefinition with the  `PROMETHEUS_LABEL_` prefix. For example \n`PROMETHEUS_LABEL_api_type` or `PROMETHEUS_LABEL_foo`.\n\nEnvironment variables set from within the container are not visible to PromED \nand are ignored.\n\n#### Customize networking\n\nRegarding networking, all network modes are supported (`bridge`, `host` \nand `awsvpc`).\n\nIf `PROMETHEUS_PORT` and `PROMETHEUS_CONTAINER_PORT` are not set, the script \nwill pick the first port from the container definition (in awsvpc and host \nnetwork mode) or the container host network bindings in bridge mode. On \nFargate, if `PROMETHEUS_PORT` is not set, it will default to port `80`.\n \nIf `PROMETHEUS_CONTAINER_PORT` is set, it will look at the container host \nnetwork bindings, and find the entry with a matching `containerPort`. It will \nthen use the `hostPort` found there as target port. This is useful when the \ncontainer port is known, but the `hostPort` is randomly picked by ECS (by \nsetting `hostPort` to `0` in the task definition).\n\nIf your container uses multiple ports, it\'s recommended to specify \n`PROMETHEUS_PORT` (`awsvpc`, `host`) or `PROMETHEUS_CONTAINER_PORT` (`bridge`).\n\n*Quoted from \n[prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd) \ncommit `ece6ca2`.*\n\n### Deploy PromED\n\nYou can either use the Python package directly or go for the Docker image. \nPlease note that just running the package / image is not enough. The enviornment\nmust be ready for boto3. This includes credentials and approbiate rights.\n\n#### Using package from PyPI\n\nAvailable under the name `prometheus_ecs_discoverer`. To start PromED:\n\n```sh\npython -m prometheus_ecs_discoverer.run\n```\n\nTo configure PromED you can either provide a settings file or use plain \nenvironment variables.  Please see [Configuration](#configuration) for more \ninfo. Please see [Configuration](#configuration) for more info.\n\n#### Using Docker image\n\nThe image `trallnag/prometheus_ecs_discoverer` can be found \n[here](https://hub.docker.com/repository/docker/trallnag/prometheus_ecs_discoverer).\nThe recommended way for configuring the image is to use environment variables.\n\nYou will probably want to run the discoverer in ECS. Here, you don\'t have to \nprovide credentials assuming everything is set up correctly. Boto3 will \nautomatically detect relative credentials URI and retrieve them from AWS.\nNevertheless, the region must be set by you.\n\n#### AWS IAM\n\nThe actions that PromED is performing on the AWS API can be found in \n[aws-iam-policy.json](https://github.com/trallnag/prometheus-ecs-discoverer/blob/master/documents/aws-iam-policy.json).\nThe allowed actions must be attached to an approbiate role. If you deploy \nPromED in ECS, this should look like in [aws-iam-ecs-role.json](https://github.com/trallnag/prometheus-ecs-discoverer/blob/master/documents/aws-iam-ecs-role.json).\n\n### Configure Prometheus\n\nIf you want all your targets to be scraped in the same interval, the following \njob is enough.\n\n```txt\n- job_name: \'ecs\'\n  file_sd_configs:\n    - files:\n        - /tmp/tasks.json\n  relabel_configs:\n    - source_labels: [metrics_path]\n      action: replace\n      target_label: __metrics_path__\n      regex: (.+)\n```\n\nBy default, PromED exposes an `/metrics` endpoint.\n\n```txt\n- job_name: discovery\n  static_configs: \n    - targets: ["discovery:8080"]\n```\n\n## Configuration\n\nAs this project is based on \n[prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd), \nthe configuration is mostly compatible.\n\nPromED uses [Dynconf](https://www.dynaconf.com/) for config management. There \nare two main ways you can configure the application. Either by providing a \ncustom settings file with the env var `SETTINGS_FILES_FOR_DYNACONF` (see \n[here](https://www.dynaconf.com/configuration/#on-environment-options)) \nor directly setting the respective values via env vars with the `DYNACONF_` \nprefix. All supported settings together with their default values can be found \n[`settings.toml` (click me)](https://github.com/trallnag/prometheus-ecs-discoverer/blob/master/prometheus_ecs_discoverer/settings.toml).\n\n## Grafana Dashboard\n\nYou can find the Grafana dashboards for PromED in the documents folder.\n\n![dashboard-screenshot](https://raw.githubusercontent.com/trallnag/prometheus-ecs-discoverer/master/documents/screenshot-dashboard-PromED.png)\n\nA second dashboard contains panels with Grafana Alerts enabled.\n\n![dashboard-screenshot](https://raw.githubusercontent.com/trallnag/prometheus-ecs-discoverer/master/documents/screenshot-dashboard-PromED-Alerting.png)\n\n## Prerequesites\n\nSee [pyproject.toml](https://github.com/trallnag/prometheus-ecs-discoverer/blob/master/pyproject.toml).\n\n## Development\n\nDeveloping and building this package on a local machine requires \n[Python Poetry](https://python-poetry.org/). I recommend to run Poetry in \ntandem with [Pyenv](https://github.com/pyenv/pyenv). Once the repository is \ncloned, run `poetry install` and `poetry shell`. From here you may start the \nIDE of your choice.\n',
    'author': 'Tim Schwenke',
    'author_email': 'tim.and.trallnag+promed@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/trallnag/prometheus-ecs-discoverer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
