# MIT LICENSE
#
# Copyright 1997 - 2020 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
import sys
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files
if sys.version_info >= (3, 5):
    from typing import List, Any, Union


class LdpAggregatedStatistics(Base):
    """Represents stats of LDP Aggregated Statistics
    The LdpAggregatedStatistics class encapsulates a required ldpAggregatedStatistics resource which will be retrieved from the server every time the property is accessed.
    """

    __slots__ = ()
    _SDM_NAME = 'ldpAggregatedStatistics'
    _SDM_ATT_MAP = {
        'BasicSessUp': 'basicSessUp',
        'EstablishedLSPEgress': 'establishedLSPEgress',
        'EstablishedLSPIngress': 'establishedLSPIngress',
        'EstablishedP2MPLSPEgress': 'establishedP2MPLSPEgress',
        'EstablishedP2MPLSPIngress': 'establishedP2MPLSPIngress',
        'InitializedStateCount': 'initializedStateCount',
        'LabelAbortRx': 'labelAbortRx',
        'LabelAbortTx': 'labelAbortTx',
        'LabelMappingRx': 'labelMappingRx',
        'LabelMappingTx': 'labelMappingTx',
        'LabelNotificationRx': 'labelNotificationRx',
        'LabelNotificationTx': 'labelNotificationTx',
        'LabelReleaseRx': 'labelReleaseRx',
        'LabelReleaseTx': 'labelReleaseTx',
        'LabelRequestRx': 'labelRequestRx',
        'LabelRequestTx': 'labelRequestTx',
        'LabelWithdrawRx': 'labelWithdrawRx',
        'LabelWithdrawTx': 'labelWithdrawTx',
        'NonExistentStateCount': 'nonExistentStateCount',
        'OpenRecvStateCount': 'openRecvStateCount',
        'OpenSentStateCount': 'openSentStateCount',
        'OperationalStateCount': 'operationalStateCount',
        'PortName': 'portName',
        'PwStatusClearedRx': 'pwStatusClearedRx',
        'PwStatusClearedTx': 'pwStatusClearedTx',
        'PwStatusDown': 'pwStatusDown',
        'PwStatusNotificationRx': 'pwStatusNotificationRx',
        'PwStatusNotificationTx': 'pwStatusNotificationTx',
        'SessionFlapCount': 'sessionFlapCount',
        'TargetedSessConfigured': 'targetedSessConfigured',
        'TargetedSessUp': 'targetedSessUp',
    }
    _SDM_ENUM_MAP = {
    }

    def __init__(self, parent, list_op=False):
        super(LdpAggregatedStatistics, self).__init__(parent, list_op)

    @property
    def BasicSessUp(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Basic Sess. Up
        """
        return self._get_attribute(self._SDM_ATT_MAP['BasicSessUp'])
    @BasicSessUp.setter
    def BasicSessUp(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['BasicSessUp'], value)

    @property
    def EstablishedLSPEgress(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Established LSP Egress
        """
        return self._get_attribute(self._SDM_ATT_MAP['EstablishedLSPEgress'])
    @EstablishedLSPEgress.setter
    def EstablishedLSPEgress(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['EstablishedLSPEgress'], value)

    @property
    def EstablishedLSPIngress(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Established LSP Ingress
        """
        return self._get_attribute(self._SDM_ATT_MAP['EstablishedLSPIngress'])
    @EstablishedLSPIngress.setter
    def EstablishedLSPIngress(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['EstablishedLSPIngress'], value)

    @property
    def EstablishedP2MPLSPEgress(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Established P2MP LSP Egress
        """
        return self._get_attribute(self._SDM_ATT_MAP['EstablishedP2MPLSPEgress'])
    @EstablishedP2MPLSPEgress.setter
    def EstablishedP2MPLSPEgress(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['EstablishedP2MPLSPEgress'], value)

    @property
    def EstablishedP2MPLSPIngress(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Established P2MP LSP Ingress
        """
        return self._get_attribute(self._SDM_ATT_MAP['EstablishedP2MPLSPIngress'])
    @EstablishedP2MPLSPIngress.setter
    def EstablishedP2MPLSPIngress(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['EstablishedP2MPLSPIngress'], value)

    @property
    def InitializedStateCount(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Initialized State Count
        """
        return self._get_attribute(self._SDM_ATT_MAP['InitializedStateCount'])
    @InitializedStateCount.setter
    def InitializedStateCount(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['InitializedStateCount'], value)

    @property
    def LabelAbortRx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Abort Rx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelAbortRx'])
    @LabelAbortRx.setter
    def LabelAbortRx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelAbortRx'], value)

    @property
    def LabelAbortTx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Abort Tx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelAbortTx'])
    @LabelAbortTx.setter
    def LabelAbortTx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelAbortTx'], value)

    @property
    def LabelMappingRx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Mapping Rx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelMappingRx'])
    @LabelMappingRx.setter
    def LabelMappingRx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelMappingRx'], value)

    @property
    def LabelMappingTx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Mapping Tx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelMappingTx'])
    @LabelMappingTx.setter
    def LabelMappingTx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelMappingTx'], value)

    @property
    def LabelNotificationRx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Notification Rx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelNotificationRx'])
    @LabelNotificationRx.setter
    def LabelNotificationRx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelNotificationRx'], value)

    @property
    def LabelNotificationTx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Notification Tx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelNotificationTx'])
    @LabelNotificationTx.setter
    def LabelNotificationTx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelNotificationTx'], value)

    @property
    def LabelReleaseRx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Release Rx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelReleaseRx'])
    @LabelReleaseRx.setter
    def LabelReleaseRx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelReleaseRx'], value)

    @property
    def LabelReleaseTx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Release Tx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelReleaseTx'])
    @LabelReleaseTx.setter
    def LabelReleaseTx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelReleaseTx'], value)

    @property
    def LabelRequestRx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Request Rx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelRequestRx'])
    @LabelRequestRx.setter
    def LabelRequestRx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelRequestRx'], value)

    @property
    def LabelRequestTx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Request Tx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelRequestTx'])
    @LabelRequestTx.setter
    def LabelRequestTx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelRequestTx'], value)

    @property
    def LabelWithdrawRx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Withdraw Rx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelWithdrawRx'])
    @LabelWithdrawRx.setter
    def LabelWithdrawRx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelWithdrawRx'], value)

    @property
    def LabelWithdrawTx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Label Withdraw Tx
        """
        return self._get_attribute(self._SDM_ATT_MAP['LabelWithdrawTx'])
    @LabelWithdrawTx.setter
    def LabelWithdrawTx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['LabelWithdrawTx'], value)

    @property
    def NonExistentStateCount(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Non Existent State Count
        """
        return self._get_attribute(self._SDM_ATT_MAP['NonExistentStateCount'])
    @NonExistentStateCount.setter
    def NonExistentStateCount(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['NonExistentStateCount'], value)

    @property
    def OpenRecvStateCount(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Open Recv State Count
        """
        return self._get_attribute(self._SDM_ATT_MAP['OpenRecvStateCount'])
    @OpenRecvStateCount.setter
    def OpenRecvStateCount(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['OpenRecvStateCount'], value)

    @property
    def OpenSentStateCount(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Open Sent State Count
        """
        return self._get_attribute(self._SDM_ATT_MAP['OpenSentStateCount'])
    @OpenSentStateCount.setter
    def OpenSentStateCount(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['OpenSentStateCount'], value)

    @property
    def OperationalStateCount(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Operational State Count
        """
        return self._get_attribute(self._SDM_ATT_MAP['OperationalStateCount'])
    @OperationalStateCount.setter
    def OperationalStateCount(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['OperationalStateCount'], value)

    @property
    def PortName(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Port Name
        """
        return self._get_attribute(self._SDM_ATT_MAP['PortName'])
    @PortName.setter
    def PortName(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['PortName'], value)

    @property
    def PwStatusClearedRx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: PW Status Cleared Rx
        """
        return self._get_attribute(self._SDM_ATT_MAP['PwStatusClearedRx'])
    @PwStatusClearedRx.setter
    def PwStatusClearedRx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['PwStatusClearedRx'], value)

    @property
    def PwStatusClearedTx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: PW Status Cleared Tx
        """
        return self._get_attribute(self._SDM_ATT_MAP['PwStatusClearedTx'])
    @PwStatusClearedTx.setter
    def PwStatusClearedTx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['PwStatusClearedTx'], value)

    @property
    def PwStatusDown(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: PW Status Down
        """
        return self._get_attribute(self._SDM_ATT_MAP['PwStatusDown'])
    @PwStatusDown.setter
    def PwStatusDown(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['PwStatusDown'], value)

    @property
    def PwStatusNotificationRx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: PW Status Notification Rx
        """
        return self._get_attribute(self._SDM_ATT_MAP['PwStatusNotificationRx'])
    @PwStatusNotificationRx.setter
    def PwStatusNotificationRx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['PwStatusNotificationRx'], value)

    @property
    def PwStatusNotificationTx(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: PW Status Notification Tx
        """
        return self._get_attribute(self._SDM_ATT_MAP['PwStatusNotificationTx'])
    @PwStatusNotificationTx.setter
    def PwStatusNotificationTx(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['PwStatusNotificationTx'], value)

    @property
    def SessionFlapCount(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Session Flap Count
        """
        return self._get_attribute(self._SDM_ATT_MAP['SessionFlapCount'])
    @SessionFlapCount.setter
    def SessionFlapCount(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['SessionFlapCount'], value)

    @property
    def TargetedSessConfigured(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Targeted Sess. Configured
        """
        return self._get_attribute(self._SDM_ATT_MAP['TargetedSessConfigured'])
    @TargetedSessConfigured.setter
    def TargetedSessConfigured(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['TargetedSessConfigured'], value)

    @property
    def TargetedSessUp(self):
        # type: () -> bool
        """
        Returns
        -------
        - bool: Targeted Sess. Up
        """
        return self._get_attribute(self._SDM_ATT_MAP['TargetedSessUp'])
    @TargetedSessUp.setter
    def TargetedSessUp(self, value):
        # type: (bool) -> None
        self._set_attribute(self._SDM_ATT_MAP['TargetedSessUp'], value)

    def update(self, BasicSessUp=None, EstablishedLSPEgress=None, EstablishedLSPIngress=None, EstablishedP2MPLSPEgress=None, EstablishedP2MPLSPIngress=None, InitializedStateCount=None, LabelAbortRx=None, LabelAbortTx=None, LabelMappingRx=None, LabelMappingTx=None, LabelNotificationRx=None, LabelNotificationTx=None, LabelReleaseRx=None, LabelReleaseTx=None, LabelRequestRx=None, LabelRequestTx=None, LabelWithdrawRx=None, LabelWithdrawTx=None, NonExistentStateCount=None, OpenRecvStateCount=None, OpenSentStateCount=None, OperationalStateCount=None, PortName=None, PwStatusClearedRx=None, PwStatusClearedTx=None, PwStatusDown=None, PwStatusNotificationRx=None, PwStatusNotificationTx=None, SessionFlapCount=None, TargetedSessConfigured=None, TargetedSessUp=None):
        # type: (bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool) -> LdpAggregatedStatistics
        """Updates ldpAggregatedStatistics resource on the server.

        Args
        ----
        - BasicSessUp (bool): Basic Sess. Up
        - EstablishedLSPEgress (bool): Established LSP Egress
        - EstablishedLSPIngress (bool): Established LSP Ingress
        - EstablishedP2MPLSPEgress (bool): Established P2MP LSP Egress
        - EstablishedP2MPLSPIngress (bool): Established P2MP LSP Ingress
        - InitializedStateCount (bool): Initialized State Count
        - LabelAbortRx (bool): Label Abort Rx
        - LabelAbortTx (bool): Label Abort Tx
        - LabelMappingRx (bool): Label Mapping Rx
        - LabelMappingTx (bool): Label Mapping Tx
        - LabelNotificationRx (bool): Label Notification Rx
        - LabelNotificationTx (bool): Label Notification Tx
        - LabelReleaseRx (bool): Label Release Rx
        - LabelReleaseTx (bool): Label Release Tx
        - LabelRequestRx (bool): Label Request Rx
        - LabelRequestTx (bool): Label Request Tx
        - LabelWithdrawRx (bool): Label Withdraw Rx
        - LabelWithdrawTx (bool): Label Withdraw Tx
        - NonExistentStateCount (bool): Non Existent State Count
        - OpenRecvStateCount (bool): Open Recv State Count
        - OpenSentStateCount (bool): Open Sent State Count
        - OperationalStateCount (bool): Operational State Count
        - PortName (bool): Port Name
        - PwStatusClearedRx (bool): PW Status Cleared Rx
        - PwStatusClearedTx (bool): PW Status Cleared Tx
        - PwStatusDown (bool): PW Status Down
        - PwStatusNotificationRx (bool): PW Status Notification Rx
        - PwStatusNotificationTx (bool): PW Status Notification Tx
        - SessionFlapCount (bool): Session Flap Count
        - TargetedSessConfigured (bool): Targeted Sess. Configured
        - TargetedSessUp (bool): Targeted Sess. Up

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._update(self._map_locals(self._SDM_ATT_MAP, locals()))

    def find(self, BasicSessUp=None, EstablishedLSPEgress=None, EstablishedLSPIngress=None, EstablishedP2MPLSPEgress=None, EstablishedP2MPLSPIngress=None, InitializedStateCount=None, LabelAbortRx=None, LabelAbortTx=None, LabelMappingRx=None, LabelMappingTx=None, LabelNotificationRx=None, LabelNotificationTx=None, LabelReleaseRx=None, LabelReleaseTx=None, LabelRequestRx=None, LabelRequestTx=None, LabelWithdrawRx=None, LabelWithdrawTx=None, NonExistentStateCount=None, OpenRecvStateCount=None, OpenSentStateCount=None, OperationalStateCount=None, PortName=None, PwStatusClearedRx=None, PwStatusClearedTx=None, PwStatusDown=None, PwStatusNotificationRx=None, PwStatusNotificationTx=None, SessionFlapCount=None, TargetedSessConfigured=None, TargetedSessUp=None):
        # type: (bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool) -> LdpAggregatedStatistics
        """Finds and retrieves ldpAggregatedStatistics resources from the server.

        All named parameters are evaluated on the server using regex. The named parameters can be used to selectively retrieve ldpAggregatedStatistics resources from the server.
        To retrieve an exact match ensure the parameter value starts with ^ and ends with $
        By default the find method takes no parameters and will retrieve all ldpAggregatedStatistics resources from the server.

        Args
        ----
        - BasicSessUp (bool): Basic Sess. Up
        - EstablishedLSPEgress (bool): Established LSP Egress
        - EstablishedLSPIngress (bool): Established LSP Ingress
        - EstablishedP2MPLSPEgress (bool): Established P2MP LSP Egress
        - EstablishedP2MPLSPIngress (bool): Established P2MP LSP Ingress
        - InitializedStateCount (bool): Initialized State Count
        - LabelAbortRx (bool): Label Abort Rx
        - LabelAbortTx (bool): Label Abort Tx
        - LabelMappingRx (bool): Label Mapping Rx
        - LabelMappingTx (bool): Label Mapping Tx
        - LabelNotificationRx (bool): Label Notification Rx
        - LabelNotificationTx (bool): Label Notification Tx
        - LabelReleaseRx (bool): Label Release Rx
        - LabelReleaseTx (bool): Label Release Tx
        - LabelRequestRx (bool): Label Request Rx
        - LabelRequestTx (bool): Label Request Tx
        - LabelWithdrawRx (bool): Label Withdraw Rx
        - LabelWithdrawTx (bool): Label Withdraw Tx
        - NonExistentStateCount (bool): Non Existent State Count
        - OpenRecvStateCount (bool): Open Recv State Count
        - OpenSentStateCount (bool): Open Sent State Count
        - OperationalStateCount (bool): Operational State Count
        - PortName (bool): Port Name
        - PwStatusClearedRx (bool): PW Status Cleared Rx
        - PwStatusClearedTx (bool): PW Status Cleared Tx
        - PwStatusDown (bool): PW Status Down
        - PwStatusNotificationRx (bool): PW Status Notification Rx
        - PwStatusNotificationTx (bool): PW Status Notification Tx
        - SessionFlapCount (bool): Session Flap Count
        - TargetedSessConfigured (bool): Targeted Sess. Configured
        - TargetedSessUp (bool): Targeted Sess. Up

        Returns
        -------
        - self: This instance with matching ldpAggregatedStatistics resources retrieved from the server available through an iterator or index

        Raises
        ------
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(self._map_locals(self._SDM_ATT_MAP, locals()))

    def read(self, href):
        """Retrieves a single instance of ldpAggregatedStatistics data from the server.

        Args
        ----
        - href (str): An href to the instance to be retrieved

        Returns
        -------
        - self: This instance with the ldpAggregatedStatistics resources from the server available through an iterator or index

        Raises
        ------
        - NotFoundError: The requested resource does not exist on the server
        - ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
